/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.CapacityReservationTopology;
import software.amazon.awssdk.services.ec2.model.CapacityReservationTopologySetCopier;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeCapacityReservationTopologyResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeCapacityReservationTopologyResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeCapacityReservationTopologyResponse.getter(DescribeCapacityReservationTopologyResponse::nextToken)).setter(DescribeCapacityReservationTopologyResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final SdkField<List<CapacityReservationTopology>> CAPACITY_RESERVATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CapacityReservations").getter(DescribeCapacityReservationTopologyResponse.getter(DescribeCapacityReservationTopologyResponse::capacityReservations)).setter(DescribeCapacityReservationTopologyResponse.setter(Builder::capacityReservations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityReservationSet").unmarshallLocationName("capacityReservationSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CapacityReservationTopology::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, CAPACITY_RESERVATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeCapacityReservationTopologyResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<CapacityReservationTopology> capacityReservations;

    private DescribeCapacityReservationTopologyResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.capacityReservations = builder.capacityReservations;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasCapacityReservations() {
        return this.capacityReservations != null && !(this.capacityReservations instanceof SdkAutoConstructList);
    }

    public final List<CapacityReservationTopology> capacityReservations() {
        return this.capacityReservations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCapacityReservations() ? this.capacityReservations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCapacityReservationTopologyResponse)) {
            return false;
        }
        DescribeCapacityReservationTopologyResponse other = (DescribeCapacityReservationTopologyResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasCapacityReservations() == other.hasCapacityReservations() && Objects.equals(this.capacityReservations(), other.capacityReservations());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeCapacityReservationTopologyResponse").add("NextToken", (Object)this.nextToken()).add("CapacityReservations", this.hasCapacityReservations() ? this.capacityReservations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "CapacityReservations": {
                return Optional.ofNullable(clazz.cast(this.capacityReservations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("CapacityReservationSet", CAPACITY_RESERVATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeCapacityReservationTopologyResponse, T> g) {
        return obj -> g.apply((DescribeCapacityReservationTopologyResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<CapacityReservationTopology> capacityReservations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCapacityReservationTopologyResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.capacityReservations(model.capacityReservations);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<CapacityReservationTopology.Builder> getCapacityReservations() {
            List<CapacityReservationTopology.Builder> result = CapacityReservationTopologySetCopier.copyToBuilder(this.capacityReservations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCapacityReservations(Collection<CapacityReservationTopology.BuilderImpl> capacityReservations) {
            this.capacityReservations = CapacityReservationTopologySetCopier.copyFromBuilder(capacityReservations);
        }

        @Override
        public final Builder capacityReservations(Collection<CapacityReservationTopology> capacityReservations) {
            this.capacityReservations = CapacityReservationTopologySetCopier.copy(capacityReservations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityReservations(CapacityReservationTopology ... capacityReservations) {
            this.capacityReservations(Arrays.asList(capacityReservations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityReservations(Consumer<CapacityReservationTopology.Builder> ... capacityReservations) {
            this.capacityReservations(Stream.of(capacityReservations).map(c -> (CapacityReservationTopology)((CapacityReservationTopology.Builder)CapacityReservationTopology.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeCapacityReservationTopologyResponse build() {
            return new DescribeCapacityReservationTopologyResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeCapacityReservationTopologyResponse> {
        public Builder nextToken(String var1);

        public Builder capacityReservations(Collection<CapacityReservationTopology> var1);

        public Builder capacityReservations(CapacityReservationTopology ... var1);

        public Builder capacityReservations(Consumer<CapacityReservationTopology.Builder> ... var1);
    }
}

