/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AcceleratorName {
    A100("a100"),
    INFERENTIA("inferentia"),
    K520("k520"),
    K80("k80"),
    M60("m60"),
    RADEON_PRO_V520("radeon-pro-v520"),
    T4("t4"),
    VU9_P("vu9p"),
    V100("v100"),
    A10_G("a10g"),
    H100("h100"),
    T4_G("t4g"),
    L40_S("l40s"),
    L4("l4"),
    GAUDI_HL_205("gaudi-hl-205"),
    INFERENTIA2("inferentia2"),
    TRAINIUM("trainium"),
    TRAINIUM2("trainium2"),
    U30("u30"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AcceleratorName> VALUE_MAP;
    private final String value;

    private AcceleratorName(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AcceleratorName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AcceleratorName> knownValues() {
        EnumSet<AcceleratorName> knownValues = EnumSet.allOf(AcceleratorName.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AcceleratorName.class, AcceleratorName::toString);
    }
}

