/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the DNS options for an endpoint.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DnsOptions implements SdkPojo, Serializable, ToCopyableBuilder<DnsOptions.Builder, DnsOptions> {
    private static final SdkField<String> DNS_RECORD_IP_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DnsRecordIpType")
            .getter(getter(DnsOptions::dnsRecordIpTypeAsString))
            .setter(setter(Builder::dnsRecordIpType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsRecordIpType")
                    .unmarshallLocationName("dnsRecordIpType").build()).build();

    private static final SdkField<Boolean> PRIVATE_DNS_ONLY_FOR_INBOUND_RESOLVER_ENDPOINT_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("PrivateDnsOnlyForInboundResolverEndpoint")
            .getter(getter(DnsOptions::privateDnsOnlyForInboundResolverEndpoint))
            .setter(setter(Builder::privateDnsOnlyForInboundResolverEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("PrivateDnsOnlyForInboundResolverEndpoint")
                    .unmarshallLocationName("privateDnsOnlyForInboundResolverEndpoint").build()).build();

    private static final SdkField<String> PRIVATE_DNS_PREFERENCE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PrivateDnsPreference")
            .getter(getter(DnsOptions::privateDnsPreference))
            .setter(setter(Builder::privateDnsPreference))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateDnsPreference")
                    .unmarshallLocationName("privateDnsPreference").build()).build();

    private static final SdkField<List<String>> PRIVATE_DNS_SPECIFIED_DOMAINS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("PrivateDnsSpecifiedDomains")
            .getter(getter(DnsOptions::privateDnsSpecifiedDomains))
            .setter(setter(Builder::privateDnsSpecifiedDomains))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateDnsSpecifiedDomainSet")
                    .unmarshallLocationName("privateDnsSpecifiedDomainSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DNS_RECORD_IP_TYPE_FIELD,
            PRIVATE_DNS_ONLY_FOR_INBOUND_RESOLVER_ENDPOINT_FIELD, PRIVATE_DNS_PREFERENCE_FIELD,
            PRIVATE_DNS_SPECIFIED_DOMAINS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String dnsRecordIpType;

    private final Boolean privateDnsOnlyForInboundResolverEndpoint;

    private final String privateDnsPreference;

    private final List<String> privateDnsSpecifiedDomains;

    private DnsOptions(BuilderImpl builder) {
        this.dnsRecordIpType = builder.dnsRecordIpType;
        this.privateDnsOnlyForInboundResolverEndpoint = builder.privateDnsOnlyForInboundResolverEndpoint;
        this.privateDnsPreference = builder.privateDnsPreference;
        this.privateDnsSpecifiedDomains = builder.privateDnsSpecifiedDomains;
    }

    /**
     * <p>
     * The DNS records created for the endpoint.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dnsRecordIpType}
     * will return {@link DnsRecordIpType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #dnsRecordIpTypeAsString}.
     * </p>
     * 
     * @return The DNS records created for the endpoint.
     * @see DnsRecordIpType
     */
    public final DnsRecordIpType dnsRecordIpType() {
        return DnsRecordIpType.fromValue(dnsRecordIpType);
    }

    /**
     * <p>
     * The DNS records created for the endpoint.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dnsRecordIpType}
     * will return {@link DnsRecordIpType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #dnsRecordIpTypeAsString}.
     * </p>
     * 
     * @return The DNS records created for the endpoint.
     * @see DnsRecordIpType
     */
    public final String dnsRecordIpTypeAsString() {
        return dnsRecordIpType;
    }

    /**
     * <p>
     * Indicates whether to enable private DNS only for inbound endpoints.
     * </p>
     * 
     * @return Indicates whether to enable private DNS only for inbound endpoints.
     */
    public final Boolean privateDnsOnlyForInboundResolverEndpoint() {
        return privateDnsOnlyForInboundResolverEndpoint;
    }

    /**
     * <p>
     * The preference for which private domains have a private hosted zone created for and associated with the specified
     * VPC. Only supported when private DNS is enabled and when the VPC endpoint type is ServiceNetwork or Resource.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ALL_DOMAINS</code> - VPC Lattice provisions private hosted zones for all custom domain names.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>VERIFIED_DOMAINS_ONLY</code> - VPC Lattice provisions a private hosted zone only if custom domain name has
     * been verified by the provider.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>VERIFIED_DOMAINS_AND_SPECIFIED_DOMAINS</code> - VPC Lattice provisions private hosted zones for all
     * verified custom domain names and other domain names that the resource consumer specifies. The resource consumer
     * specifies the domain names in the PrivateDnsSpecifiedDomains parameter.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SPECIFIED_DOMAINS_ONLY</code> - VPC Lattice provisions a private hosted zone for domain names specified by
     * the resource consumer. The resource consumer specifies the domain names in the PrivateDnsSpecifiedDomains
     * parameter.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The preference for which private domains have a private hosted zone created for and associated with the
     *         specified VPC. Only supported when private DNS is enabled and when the VPC endpoint type is
     *         ServiceNetwork or Resource. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ALL_DOMAINS</code> - VPC Lattice provisions private hosted zones for all custom domain names.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>VERIFIED_DOMAINS_ONLY</code> - VPC Lattice provisions a private hosted zone only if custom domain
     *         name has been verified by the provider.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>VERIFIED_DOMAINS_AND_SPECIFIED_DOMAINS</code> - VPC Lattice provisions private hosted zones for all
     *         verified custom domain names and other domain names that the resource consumer specifies. The resource
     *         consumer specifies the domain names in the PrivateDnsSpecifiedDomains parameter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SPECIFIED_DOMAINS_ONLY</code> - VPC Lattice provisions a private hosted zone for domain names
     *         specified by the resource consumer. The resource consumer specifies the domain names in the
     *         PrivateDnsSpecifiedDomains parameter.
     *         </p>
     *         </li>
     */
    public final String privateDnsPreference() {
        return privateDnsPreference;
    }

    /**
     * For responses, this returns true if the service returned a value for the PrivateDnsSpecifiedDomains property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasPrivateDnsSpecifiedDomains() {
        return privateDnsSpecifiedDomains != null && !(privateDnsSpecifiedDomains instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Indicates which of the private domains to create private hosted zones for and associate with the specified VPC.
     * Only supported when private DNS is enabled and the private DNS preference is
     * <code>VERIFIED_DOMAINS_AND_SPECIFIED_DOMAINS</code> or <code>SPECIFIED_DOMAINS_ONLY</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPrivateDnsSpecifiedDomains} method.
     * </p>
     * 
     * @return Indicates which of the private domains to create private hosted zones for and associate with the
     *         specified VPC. Only supported when private DNS is enabled and the private DNS preference is
     *         <code>VERIFIED_DOMAINS_AND_SPECIFIED_DOMAINS</code> or <code>SPECIFIED_DOMAINS_ONLY</code>.
     */
    public final List<String> privateDnsSpecifiedDomains() {
        return privateDnsSpecifiedDomains;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dnsRecordIpTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(privateDnsOnlyForInboundResolverEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(privateDnsPreference());
        hashCode = 31 * hashCode + Objects.hashCode(hasPrivateDnsSpecifiedDomains() ? privateDnsSpecifiedDomains() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DnsOptions)) {
            return false;
        }
        DnsOptions other = (DnsOptions) obj;
        return Objects.equals(dnsRecordIpTypeAsString(), other.dnsRecordIpTypeAsString())
                && Objects.equals(privateDnsOnlyForInboundResolverEndpoint(), other.privateDnsOnlyForInboundResolverEndpoint())
                && Objects.equals(privateDnsPreference(), other.privateDnsPreference())
                && hasPrivateDnsSpecifiedDomains() == other.hasPrivateDnsSpecifiedDomains()
                && Objects.equals(privateDnsSpecifiedDomains(), other.privateDnsSpecifiedDomains());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DnsOptions").add("DnsRecordIpType", dnsRecordIpTypeAsString())
                .add("PrivateDnsOnlyForInboundResolverEndpoint", privateDnsOnlyForInboundResolverEndpoint())
                .add("PrivateDnsPreference", privateDnsPreference())
                .add("PrivateDnsSpecifiedDomains", hasPrivateDnsSpecifiedDomains() ? privateDnsSpecifiedDomains() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DnsRecordIpType":
            return Optional.ofNullable(clazz.cast(dnsRecordIpTypeAsString()));
        case "PrivateDnsOnlyForInboundResolverEndpoint":
            return Optional.ofNullable(clazz.cast(privateDnsOnlyForInboundResolverEndpoint()));
        case "PrivateDnsPreference":
            return Optional.ofNullable(clazz.cast(privateDnsPreference()));
        case "PrivateDnsSpecifiedDomains":
            return Optional.ofNullable(clazz.cast(privateDnsSpecifiedDomains()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DnsRecordIpType", DNS_RECORD_IP_TYPE_FIELD);
        map.put("PrivateDnsOnlyForInboundResolverEndpoint", PRIVATE_DNS_ONLY_FOR_INBOUND_RESOLVER_ENDPOINT_FIELD);
        map.put("PrivateDnsPreference", PRIVATE_DNS_PREFERENCE_FIELD);
        map.put("PrivateDnsSpecifiedDomainSet", PRIVATE_DNS_SPECIFIED_DOMAINS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DnsOptions, T> g) {
        return obj -> g.apply((DnsOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DnsOptions> {
        /**
         * <p>
         * The DNS records created for the endpoint.
         * </p>
         * 
         * @param dnsRecordIpType
         *        The DNS records created for the endpoint.
         * @see DnsRecordIpType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DnsRecordIpType
         */
        Builder dnsRecordIpType(String dnsRecordIpType);

        /**
         * <p>
         * The DNS records created for the endpoint.
         * </p>
         * 
         * @param dnsRecordIpType
         *        The DNS records created for the endpoint.
         * @see DnsRecordIpType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DnsRecordIpType
         */
        Builder dnsRecordIpType(DnsRecordIpType dnsRecordIpType);

        /**
         * <p>
         * Indicates whether to enable private DNS only for inbound endpoints.
         * </p>
         * 
         * @param privateDnsOnlyForInboundResolverEndpoint
         *        Indicates whether to enable private DNS only for inbound endpoints.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateDnsOnlyForInboundResolverEndpoint(Boolean privateDnsOnlyForInboundResolverEndpoint);

        /**
         * <p>
         * The preference for which private domains have a private hosted zone created for and associated with the
         * specified VPC. Only supported when private DNS is enabled and when the VPC endpoint type is ServiceNetwork or
         * Resource.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ALL_DOMAINS</code> - VPC Lattice provisions private hosted zones for all custom domain names.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>VERIFIED_DOMAINS_ONLY</code> - VPC Lattice provisions a private hosted zone only if custom domain name
         * has been verified by the provider.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>VERIFIED_DOMAINS_AND_SPECIFIED_DOMAINS</code> - VPC Lattice provisions private hosted zones for all
         * verified custom domain names and other domain names that the resource consumer specifies. The resource
         * consumer specifies the domain names in the PrivateDnsSpecifiedDomains parameter.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SPECIFIED_DOMAINS_ONLY</code> - VPC Lattice provisions a private hosted zone for domain names specified
         * by the resource consumer. The resource consumer specifies the domain names in the PrivateDnsSpecifiedDomains
         * parameter.
         * </p>
         * </li>
         * </ul>
         * 
         * @param privateDnsPreference
         *        The preference for which private domains have a private hosted zone created for and associated with
         *        the specified VPC. Only supported when private DNS is enabled and when the VPC endpoint type is
         *        ServiceNetwork or Resource. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ALL_DOMAINS</code> - VPC Lattice provisions private hosted zones for all custom domain names.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>VERIFIED_DOMAINS_ONLY</code> - VPC Lattice provisions a private hosted zone only if custom
         *        domain name has been verified by the provider.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>VERIFIED_DOMAINS_AND_SPECIFIED_DOMAINS</code> - VPC Lattice provisions private hosted zones for
         *        all verified custom domain names and other domain names that the resource consumer specifies. The
         *        resource consumer specifies the domain names in the PrivateDnsSpecifiedDomains parameter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SPECIFIED_DOMAINS_ONLY</code> - VPC Lattice provisions a private hosted zone for domain names
         *        specified by the resource consumer. The resource consumer specifies the domain names in the
         *        PrivateDnsSpecifiedDomains parameter.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateDnsPreference(String privateDnsPreference);

        /**
         * <p>
         * Indicates which of the private domains to create private hosted zones for and associate with the specified
         * VPC. Only supported when private DNS is enabled and the private DNS preference is
         * <code>VERIFIED_DOMAINS_AND_SPECIFIED_DOMAINS</code> or <code>SPECIFIED_DOMAINS_ONLY</code>.
         * </p>
         * 
         * @param privateDnsSpecifiedDomains
         *        Indicates which of the private domains to create private hosted zones for and associate with the
         *        specified VPC. Only supported when private DNS is enabled and the private DNS preference is
         *        <code>VERIFIED_DOMAINS_AND_SPECIFIED_DOMAINS</code> or <code>SPECIFIED_DOMAINS_ONLY</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateDnsSpecifiedDomains(Collection<String> privateDnsSpecifiedDomains);

        /**
         * <p>
         * Indicates which of the private domains to create private hosted zones for and associate with the specified
         * VPC. Only supported when private DNS is enabled and the private DNS preference is
         * <code>VERIFIED_DOMAINS_AND_SPECIFIED_DOMAINS</code> or <code>SPECIFIED_DOMAINS_ONLY</code>.
         * </p>
         * 
         * @param privateDnsSpecifiedDomains
         *        Indicates which of the private domains to create private hosted zones for and associate with the
         *        specified VPC. Only supported when private DNS is enabled and the private DNS preference is
         *        <code>VERIFIED_DOMAINS_AND_SPECIFIED_DOMAINS</code> or <code>SPECIFIED_DOMAINS_ONLY</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateDnsSpecifiedDomains(String... privateDnsSpecifiedDomains);
    }

    static final class BuilderImpl implements Builder {
        private String dnsRecordIpType;

        private Boolean privateDnsOnlyForInboundResolverEndpoint;

        private String privateDnsPreference;

        private List<String> privateDnsSpecifiedDomains = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DnsOptions model) {
            dnsRecordIpType(model.dnsRecordIpType);
            privateDnsOnlyForInboundResolverEndpoint(model.privateDnsOnlyForInboundResolverEndpoint);
            privateDnsPreference(model.privateDnsPreference);
            privateDnsSpecifiedDomains(model.privateDnsSpecifiedDomains);
        }

        public final String getDnsRecordIpType() {
            return dnsRecordIpType;
        }

        public final void setDnsRecordIpType(String dnsRecordIpType) {
            this.dnsRecordIpType = dnsRecordIpType;
        }

        @Override
        public final Builder dnsRecordIpType(String dnsRecordIpType) {
            this.dnsRecordIpType = dnsRecordIpType;
            return this;
        }

        @Override
        public final Builder dnsRecordIpType(DnsRecordIpType dnsRecordIpType) {
            this.dnsRecordIpType(dnsRecordIpType == null ? null : dnsRecordIpType.toString());
            return this;
        }

        public final Boolean getPrivateDnsOnlyForInboundResolverEndpoint() {
            return privateDnsOnlyForInboundResolverEndpoint;
        }

        public final void setPrivateDnsOnlyForInboundResolverEndpoint(Boolean privateDnsOnlyForInboundResolverEndpoint) {
            this.privateDnsOnlyForInboundResolverEndpoint = privateDnsOnlyForInboundResolverEndpoint;
        }

        @Override
        public final Builder privateDnsOnlyForInboundResolverEndpoint(Boolean privateDnsOnlyForInboundResolverEndpoint) {
            this.privateDnsOnlyForInboundResolverEndpoint = privateDnsOnlyForInboundResolverEndpoint;
            return this;
        }

        public final String getPrivateDnsPreference() {
            return privateDnsPreference;
        }

        public final void setPrivateDnsPreference(String privateDnsPreference) {
            this.privateDnsPreference = privateDnsPreference;
        }

        @Override
        public final Builder privateDnsPreference(String privateDnsPreference) {
            this.privateDnsPreference = privateDnsPreference;
            return this;
        }

        public final Collection<String> getPrivateDnsSpecifiedDomains() {
            if (privateDnsSpecifiedDomains instanceof SdkAutoConstructList) {
                return null;
            }
            return privateDnsSpecifiedDomains;
        }

        public final void setPrivateDnsSpecifiedDomains(Collection<String> privateDnsSpecifiedDomains) {
            this.privateDnsSpecifiedDomains = PrivateDnsSpecifiedDomainSetCopier.copy(privateDnsSpecifiedDomains);
        }

        @Override
        public final Builder privateDnsSpecifiedDomains(Collection<String> privateDnsSpecifiedDomains) {
            this.privateDnsSpecifiedDomains = PrivateDnsSpecifiedDomainSetCopier.copy(privateDnsSpecifiedDomains);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder privateDnsSpecifiedDomains(String... privateDnsSpecifiedDomains) {
            privateDnsSpecifiedDomains(Arrays.asList(privateDnsSpecifiedDomains));
            return this;
        }

        @Override
        public DnsOptions build() {
            return new DnsOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
