/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateTransitGatewayMeteringPolicyEntryResponse extends Ec2Response
        implements
        ToCopyableBuilder<CreateTransitGatewayMeteringPolicyEntryResponse.Builder, CreateTransitGatewayMeteringPolicyEntryResponse> {
    private static final SdkField<TransitGatewayMeteringPolicyEntry> TRANSIT_GATEWAY_METERING_POLICY_ENTRY_FIELD = SdkField
            .<TransitGatewayMeteringPolicyEntry> builder(MarshallingType.SDK_POJO)
            .memberName("TransitGatewayMeteringPolicyEntry")
            .getter(getter(CreateTransitGatewayMeteringPolicyEntryResponse::transitGatewayMeteringPolicyEntry))
            .setter(setter(Builder::transitGatewayMeteringPolicyEntry))
            .constructor(TransitGatewayMeteringPolicyEntry::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayMeteringPolicyEntry")
                    .unmarshallLocationName("transitGatewayMeteringPolicyEntry").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(TRANSIT_GATEWAY_METERING_POLICY_ENTRY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final TransitGatewayMeteringPolicyEntry transitGatewayMeteringPolicyEntry;

    private CreateTransitGatewayMeteringPolicyEntryResponse(BuilderImpl builder) {
        super(builder);
        this.transitGatewayMeteringPolicyEntry = builder.transitGatewayMeteringPolicyEntry;
    }

    /**
     * <p>
     * Information about the created transit gateway metering policy entry.
     * </p>
     * 
     * @return Information about the created transit gateway metering policy entry.
     */
    public final TransitGatewayMeteringPolicyEntry transitGatewayMeteringPolicyEntry() {
        return transitGatewayMeteringPolicyEntry;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(transitGatewayMeteringPolicyEntry());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTransitGatewayMeteringPolicyEntryResponse)) {
            return false;
        }
        CreateTransitGatewayMeteringPolicyEntryResponse other = (CreateTransitGatewayMeteringPolicyEntryResponse) obj;
        return Objects.equals(transitGatewayMeteringPolicyEntry(), other.transitGatewayMeteringPolicyEntry());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateTransitGatewayMeteringPolicyEntryResponse")
                .add("TransitGatewayMeteringPolicyEntry", transitGatewayMeteringPolicyEntry()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TransitGatewayMeteringPolicyEntry":
            return Optional.ofNullable(clazz.cast(transitGatewayMeteringPolicyEntry()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TransitGatewayMeteringPolicyEntry", TRANSIT_GATEWAY_METERING_POLICY_ENTRY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateTransitGatewayMeteringPolicyEntryResponse, T> g) {
        return obj -> g.apply((CreateTransitGatewayMeteringPolicyEntryResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Ec2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateTransitGatewayMeteringPolicyEntryResponse> {
        /**
         * <p>
         * Information about the created transit gateway metering policy entry.
         * </p>
         * 
         * @param transitGatewayMeteringPolicyEntry
         *        Information about the created transit gateway metering policy entry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitGatewayMeteringPolicyEntry(TransitGatewayMeteringPolicyEntry transitGatewayMeteringPolicyEntry);

        /**
         * <p>
         * Information about the created transit gateway metering policy entry.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link TransitGatewayMeteringPolicyEntry.Builder} avoiding the need to create one manually via
         * {@link TransitGatewayMeteringPolicyEntry#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TransitGatewayMeteringPolicyEntry.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #transitGatewayMeteringPolicyEntry(TransitGatewayMeteringPolicyEntry)}.
         * 
         * @param transitGatewayMeteringPolicyEntry
         *        a consumer that will call methods on {@link TransitGatewayMeteringPolicyEntry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #transitGatewayMeteringPolicyEntry(TransitGatewayMeteringPolicyEntry)
         */
        default Builder transitGatewayMeteringPolicyEntry(
                Consumer<TransitGatewayMeteringPolicyEntry.Builder> transitGatewayMeteringPolicyEntry) {
            return transitGatewayMeteringPolicyEntry(TransitGatewayMeteringPolicyEntry.builder()
                    .applyMutation(transitGatewayMeteringPolicyEntry).build());
        }
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private TransitGatewayMeteringPolicyEntry transitGatewayMeteringPolicyEntry;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTransitGatewayMeteringPolicyEntryResponse model) {
            super(model);
            transitGatewayMeteringPolicyEntry(model.transitGatewayMeteringPolicyEntry);
        }

        public final TransitGatewayMeteringPolicyEntry.Builder getTransitGatewayMeteringPolicyEntry() {
            return transitGatewayMeteringPolicyEntry != null ? transitGatewayMeteringPolicyEntry.toBuilder() : null;
        }

        public final void setTransitGatewayMeteringPolicyEntry(
                TransitGatewayMeteringPolicyEntry.BuilderImpl transitGatewayMeteringPolicyEntry) {
            this.transitGatewayMeteringPolicyEntry = transitGatewayMeteringPolicyEntry != null ? transitGatewayMeteringPolicyEntry
                    .build() : null;
        }

        @Override
        public final Builder transitGatewayMeteringPolicyEntry(TransitGatewayMeteringPolicyEntry transitGatewayMeteringPolicyEntry) {
            this.transitGatewayMeteringPolicyEntry = transitGatewayMeteringPolicyEntry;
            return this;
        }

        @Override
        public CreateTransitGatewayMeteringPolicyEntryResponse build() {
            return new CreateTransitGatewayMeteringPolicyEntryResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
