/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateCapacityReservationRequest extends Ec2Request implements
        ToCopyableBuilder<CreateCapacityReservationRequest.Builder, CreateCapacityReservationRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreateCapacityReservationRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken")
                    .unmarshallLocationName("ClientToken").build()).build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InstanceType")
            .getter(getter(CreateCapacityReservationRequest::instanceType))
            .setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType")
                    .unmarshallLocationName("InstanceType").build()).build();

    private static final SdkField<String> INSTANCE_PLATFORM_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InstancePlatform")
            .getter(getter(CreateCapacityReservationRequest::instancePlatformAsString))
            .setter(setter(Builder::instancePlatform))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstancePlatform")
                    .unmarshallLocationName("InstancePlatform").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZone")
            .getter(getter(CreateCapacityReservationRequest::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone")
                    .unmarshallLocationName("AvailabilityZone").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZoneId")
            .getter(getter(CreateCapacityReservationRequest::availabilityZoneId))
            .setter(setter(Builder::availabilityZoneId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZoneId")
                    .unmarshallLocationName("AvailabilityZoneId").build()).build();

    private static final SdkField<String> TENANCY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Tenancy")
            .getter(getter(CreateCapacityReservationRequest::tenancyAsString))
            .setter(setter(Builder::tenancy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tenancy")
                    .unmarshallLocationName("Tenancy").build()).build();

    private static final SdkField<Integer> INSTANCE_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("InstanceCount")
            .getter(getter(CreateCapacityReservationRequest::instanceCount))
            .setter(setter(Builder::instanceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceCount")
                    .unmarshallLocationName("InstanceCount").build()).build();

    private static final SdkField<Boolean> EBS_OPTIMIZED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EbsOptimized")
            .getter(getter(CreateCapacityReservationRequest::ebsOptimized))
            .setter(setter(Builder::ebsOptimized))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EbsOptimized")
                    .unmarshallLocationName("EbsOptimized").build()).build();

    private static final SdkField<Boolean> EPHEMERAL_STORAGE_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EphemeralStorage")
            .getter(getter(CreateCapacityReservationRequest::ephemeralStorage))
            .setter(setter(Builder::ephemeralStorage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EphemeralStorage")
                    .unmarshallLocationName("EphemeralStorage").build()).build();

    private static final SdkField<Instant> END_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndDate")
            .getter(getter(CreateCapacityReservationRequest::endDate))
            .setter(setter(Builder::endDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndDate")
                    .unmarshallLocationName("EndDate").build()).build();

    private static final SdkField<String> END_DATE_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("EndDateType")
            .getter(getter(CreateCapacityReservationRequest::endDateTypeAsString))
            .setter(setter(Builder::endDateType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndDateType")
                    .unmarshallLocationName("EndDateType").build()).build();

    private static final SdkField<String> INSTANCE_MATCH_CRITERIA_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InstanceMatchCriteria")
            .getter(getter(CreateCapacityReservationRequest::instanceMatchCriteriaAsString))
            .setter(setter(Builder::instanceMatchCriteria))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceMatchCriteria")
                    .unmarshallLocationName("InstanceMatchCriteria").build()).build();

    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField
            .<List<TagSpecification>> builder(MarshallingType.LIST)
            .memberName("TagSpecifications")
            .getter(getter(CreateCapacityReservationRequest::tagSpecifications))
            .setter(setter(Builder::tagSpecifications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecifications")
                    .unmarshallLocationName("TagSpecifications").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<TagSpecification> builder(MarshallingType.SDK_POJO)
                                            .constructor(TagSpecification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(CreateCapacityReservationRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("DryRun").build()).build();

    private static final SdkField<String> OUTPOST_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OutpostArn")
            .getter(getter(CreateCapacityReservationRequest::outpostArn))
            .setter(setter(Builder::outpostArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutpostArn")
                    .unmarshallLocationName("OutpostArn").build()).build();

    private static final SdkField<String> PLACEMENT_GROUP_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PlacementGroupArn")
            .getter(getter(CreateCapacityReservationRequest::placementGroupArn))
            .setter(setter(Builder::placementGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlacementGroupArn")
                    .unmarshallLocationName("PlacementGroupArn").build()).build();

    private static final SdkField<Instant> START_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartDate")
            .getter(getter(CreateCapacityReservationRequest::startDate))
            .setter(setter(Builder::startDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartDate")
                    .unmarshallLocationName("StartDate").build()).build();

    private static final SdkField<Long> COMMITMENT_DURATION_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("CommitmentDuration")
            .getter(getter(CreateCapacityReservationRequest::commitmentDuration))
            .setter(setter(Builder::commitmentDuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CommitmentDuration")
                    .unmarshallLocationName("CommitmentDuration").build()).build();

    private static final SdkField<String> DELIVERY_PREFERENCE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DeliveryPreference")
            .getter(getter(CreateCapacityReservationRequest::deliveryPreferenceAsString))
            .setter(setter(Builder::deliveryPreference))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryPreference")
                    .unmarshallLocationName("DeliveryPreference").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            INSTANCE_TYPE_FIELD, INSTANCE_PLATFORM_FIELD, AVAILABILITY_ZONE_FIELD, AVAILABILITY_ZONE_ID_FIELD, TENANCY_FIELD,
            INSTANCE_COUNT_FIELD, EBS_OPTIMIZED_FIELD, EPHEMERAL_STORAGE_FIELD, END_DATE_FIELD, END_DATE_TYPE_FIELD,
            INSTANCE_MATCH_CRITERIA_FIELD, TAG_SPECIFICATIONS_FIELD, DRY_RUN_FIELD, OUTPOST_ARN_FIELD, PLACEMENT_GROUP_ARN_FIELD,
            START_DATE_FIELD, COMMITMENT_DURATION_FIELD, DELIVERY_PREFERENCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clientToken;

    private final String instanceType;

    private final String instancePlatform;

    private final String availabilityZone;

    private final String availabilityZoneId;

    private final String tenancy;

    private final Integer instanceCount;

    private final Boolean ebsOptimized;

    private final Boolean ephemeralStorage;

    private final Instant endDate;

    private final String endDateType;

    private final String instanceMatchCriteria;

    private final List<TagSpecification> tagSpecifications;

    private final Boolean dryRun;

    private final String outpostArn;

    private final String placementGroupArn;

    private final Instant startDate;

    private final Long commitmentDuration;

    private final String deliveryPreference;

    private CreateCapacityReservationRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.instanceType = builder.instanceType;
        this.instancePlatform = builder.instancePlatform;
        this.availabilityZone = builder.availabilityZone;
        this.availabilityZoneId = builder.availabilityZoneId;
        this.tenancy = builder.tenancy;
        this.instanceCount = builder.instanceCount;
        this.ebsOptimized = builder.ebsOptimized;
        this.ephemeralStorage = builder.ephemeralStorage;
        this.endDate = builder.endDate;
        this.endDateType = builder.endDateType;
        this.instanceMatchCriteria = builder.instanceMatchCriteria;
        this.tagSpecifications = builder.tagSpecifications;
        this.dryRun = builder.dryRun;
        this.outpostArn = builder.outpostArn;
        this.placementGroupArn = builder.placementGroupArn;
        this.startDate = builder.startDate;
        this.commitmentDuration = builder.commitmentDuration;
        this.deliveryPreference = builder.deliveryPreference;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensure
     * Idempotency</a>.
     * </p>
     * 
     * @return Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensure
     *         Idempotency</a>.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The instance type for which to reserve capacity.
     * </p>
     * <note>
     * <p>
     * You can request future-dated Capacity Reservations for instance types in the C, M, R, I, T, and G instance
     * families only.
     * </p>
     * </note>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance types</a> in the
     * <i>Amazon EC2 User Guide</i>.
     * </p>
     * 
     * @return The instance type for which to reserve capacity.</p> <note>
     *         <p>
     *         You can request future-dated Capacity Reservations for instance types in the C, M, R, I, T, and G
     *         instance families only.
     *         </p>
     *         </note>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance types</a> in the
     *         <i>Amazon EC2 User Guide</i>.
     */
    public final String instanceType() {
        return instanceType;
    }

    /**
     * <p>
     * The type of operating system for which to reserve capacity.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instancePlatform}
     * will return {@link CapacityReservationInstancePlatform#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #instancePlatformAsString}.
     * </p>
     * 
     * @return The type of operating system for which to reserve capacity.
     * @see CapacityReservationInstancePlatform
     */
    public final CapacityReservationInstancePlatform instancePlatform() {
        return CapacityReservationInstancePlatform.fromValue(instancePlatform);
    }

    /**
     * <p>
     * The type of operating system for which to reserve capacity.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instancePlatform}
     * will return {@link CapacityReservationInstancePlatform#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #instancePlatformAsString}.
     * </p>
     * 
     * @return The type of operating system for which to reserve capacity.
     * @see CapacityReservationInstancePlatform
     */
    public final String instancePlatformAsString() {
        return instancePlatform;
    }

    /**
     * <p>
     * The Availability Zone in which to create the Capacity Reservation.
     * </p>
     * 
     * @return The Availability Zone in which to create the Capacity Reservation.
     */
    public final String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The ID of the Availability Zone in which to create the Capacity Reservation.
     * </p>
     * 
     * @return The ID of the Availability Zone in which to create the Capacity Reservation.
     */
    public final String availabilityZoneId() {
        return availabilityZoneId;
    }

    /**
     * <p>
     * Indicates the tenancy of the Capacity Reservation. A Capacity Reservation can have one of the following tenancy
     * settings:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>default</code> - The Capacity Reservation is created on hardware that is shared with other Amazon Web
     * Services accounts.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>dedicated</code> - The Capacity Reservation is created on single-tenant hardware that is dedicated to a
     * single Amazon Web Services account.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tenancy} will
     * return {@link CapacityReservationTenancy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #tenancyAsString}.
     * </p>
     * 
     * @return Indicates the tenancy of the Capacity Reservation. A Capacity Reservation can have one of the following
     *         tenancy settings:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>default</code> - The Capacity Reservation is created on hardware that is shared with other Amazon
     *         Web Services accounts.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>dedicated</code> - The Capacity Reservation is created on single-tenant hardware that is dedicated
     *         to a single Amazon Web Services account.
     *         </p>
     *         </li>
     * @see CapacityReservationTenancy
     */
    public final CapacityReservationTenancy tenancy() {
        return CapacityReservationTenancy.fromValue(tenancy);
    }

    /**
     * <p>
     * Indicates the tenancy of the Capacity Reservation. A Capacity Reservation can have one of the following tenancy
     * settings:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>default</code> - The Capacity Reservation is created on hardware that is shared with other Amazon Web
     * Services accounts.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>dedicated</code> - The Capacity Reservation is created on single-tenant hardware that is dedicated to a
     * single Amazon Web Services account.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tenancy} will
     * return {@link CapacityReservationTenancy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #tenancyAsString}.
     * </p>
     * 
     * @return Indicates the tenancy of the Capacity Reservation. A Capacity Reservation can have one of the following
     *         tenancy settings:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>default</code> - The Capacity Reservation is created on hardware that is shared with other Amazon
     *         Web Services accounts.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>dedicated</code> - The Capacity Reservation is created on single-tenant hardware that is dedicated
     *         to a single Amazon Web Services account.
     *         </p>
     *         </li>
     * @see CapacityReservationTenancy
     */
    public final String tenancyAsString() {
        return tenancy;
    }

    /**
     * <p>
     * The number of instances for which to reserve capacity.
     * </p>
     * <note>
     * <p>
     * You can request future-dated Capacity Reservations for an instance count with a minimum of 32 vCPUs. For example,
     * if you request a future-dated Capacity Reservation for <code>m5.xlarge</code> instances, you must request at
     * least 8 instances (<i>8 * m5.xlarge = 32 vCPUs</i>).
     * </p>
     * </note>
     * <p>
     * Valid range: 1 - 1000
     * </p>
     * 
     * @return The number of instances for which to reserve capacity.</p> <note>
     *         <p>
     *         You can request future-dated Capacity Reservations for an instance count with a minimum of 32 vCPUs. For
     *         example, if you request a future-dated Capacity Reservation for <code>m5.xlarge</code> instances, you
     *         must request at least 8 instances (<i>8 * m5.xlarge = 32 vCPUs</i>).
     *         </p>
     *         </note>
     *         <p>
     *         Valid range: 1 - 1000
     */
    public final Integer instanceCount() {
        return instanceCount;
    }

    /**
     * <p>
     * Indicates whether the Capacity Reservation supports EBS-optimized instances. This optimization provides dedicated
     * throughput to Amazon EBS and an optimized configuration stack to provide optimal I/O performance. This
     * optimization isn't available with all instance types. Additional usage charges apply when using an EBS- optimized
     * instance.
     * </p>
     * 
     * @return Indicates whether the Capacity Reservation supports EBS-optimized instances. This optimization provides
     *         dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal I/O
     *         performance. This optimization isn't available with all instance types. Additional usage charges apply
     *         when using an EBS- optimized instance.
     */
    public final Boolean ebsOptimized() {
        return ebsOptimized;
    }

    /**
     * <p>
     * <i>Deprecated.</i>
     * </p>
     * 
     * @return <i>Deprecated.</i>
     */
    public final Boolean ephemeralStorage() {
        return ephemeralStorage;
    }

    /**
     * <p>
     * The date and time at which the Capacity Reservation expires. When a Capacity Reservation expires, the reserved
     * capacity is released and you can no longer launch instances into it. The Capacity Reservation's state changes to
     * <code>expired</code> when it reaches its end date and time.
     * </p>
     * <p>
     * You must provide an <code>EndDate</code> value if <code>EndDateType</code> is <code>limited</code>. Omit
     * <code>EndDate</code> if <code>EndDateType</code> is <code>unlimited</code>.
     * </p>
     * <p>
     * If the <code>EndDateType</code> is <code>limited</code>, the Capacity Reservation is cancelled within an hour
     * from the specified time. For example, if you specify 5/31/2019, 13:30:55, the Capacity Reservation is guaranteed
     * to end between 13:30:55 and 14:30:55 on 5/31/2019.
     * </p>
     * <p>
     * If you are requesting a future-dated Capacity Reservation, you can't specify an end date and time that is within
     * the commitment duration.
     * </p>
     * 
     * @return The date and time at which the Capacity Reservation expires. When a Capacity Reservation expires, the
     *         reserved capacity is released and you can no longer launch instances into it. The Capacity Reservation's
     *         state changes to <code>expired</code> when it reaches its end date and time.</p>
     *         <p>
     *         You must provide an <code>EndDate</code> value if <code>EndDateType</code> is <code>limited</code>. Omit
     *         <code>EndDate</code> if <code>EndDateType</code> is <code>unlimited</code>.
     *         </p>
     *         <p>
     *         If the <code>EndDateType</code> is <code>limited</code>, the Capacity Reservation is cancelled within an
     *         hour from the specified time. For example, if you specify 5/31/2019, 13:30:55, the Capacity Reservation
     *         is guaranteed to end between 13:30:55 and 14:30:55 on 5/31/2019.
     *         </p>
     *         <p>
     *         If you are requesting a future-dated Capacity Reservation, you can't specify an end date and time that is
     *         within the commitment duration.
     */
    public final Instant endDate() {
        return endDate;
    }

    /**
     * <p>
     * Indicates the way in which the Capacity Reservation ends. A Capacity Reservation can have one of the following
     * end types:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>unlimited</code> - The Capacity Reservation remains active until you explicitly cancel it. Do not provide
     * an <code>EndDate</code> if the <code>EndDateType</code> is <code>unlimited</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>limited</code> - The Capacity Reservation expires automatically at a specified date and time. You must
     * provide an <code>EndDate</code> value if the <code>EndDateType</code> value is <code>limited</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #endDateType} will
     * return {@link EndDateType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #endDateTypeAsString}.
     * </p>
     * 
     * @return Indicates the way in which the Capacity Reservation ends. A Capacity Reservation can have one of the
     *         following end types:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>unlimited</code> - The Capacity Reservation remains active until you explicitly cancel it. Do not
     *         provide an <code>EndDate</code> if the <code>EndDateType</code> is <code>unlimited</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>limited</code> - The Capacity Reservation expires automatically at a specified date and time. You
     *         must provide an <code>EndDate</code> value if the <code>EndDateType</code> value is <code>limited</code>.
     *         </p>
     *         </li>
     * @see EndDateType
     */
    public final EndDateType endDateType() {
        return EndDateType.fromValue(endDateType);
    }

    /**
     * <p>
     * Indicates the way in which the Capacity Reservation ends. A Capacity Reservation can have one of the following
     * end types:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>unlimited</code> - The Capacity Reservation remains active until you explicitly cancel it. Do not provide
     * an <code>EndDate</code> if the <code>EndDateType</code> is <code>unlimited</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>limited</code> - The Capacity Reservation expires automatically at a specified date and time. You must
     * provide an <code>EndDate</code> value if the <code>EndDateType</code> value is <code>limited</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #endDateType} will
     * return {@link EndDateType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #endDateTypeAsString}.
     * </p>
     * 
     * @return Indicates the way in which the Capacity Reservation ends. A Capacity Reservation can have one of the
     *         following end types:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>unlimited</code> - The Capacity Reservation remains active until you explicitly cancel it. Do not
     *         provide an <code>EndDate</code> if the <code>EndDateType</code> is <code>unlimited</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>limited</code> - The Capacity Reservation expires automatically at a specified date and time. You
     *         must provide an <code>EndDate</code> value if the <code>EndDateType</code> value is <code>limited</code>.
     *         </p>
     *         </li>
     * @see EndDateType
     */
    public final String endDateTypeAsString() {
        return endDateType;
    }

    /**
     * <p>
     * Indicates the type of instance launches that the Capacity Reservation accepts. The options include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>open</code> - The Capacity Reservation automatically matches all instances that have matching attributes
     * (instance type, platform, and Availability Zone). Instances that have matching attributes run in the Capacity
     * Reservation automatically without specifying any additional parameters.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>targeted</code> - The Capacity Reservation only accepts instances that have matching attributes (instance
     * type, platform, and Availability Zone), and explicitly target the Capacity Reservation. This ensures that only
     * permitted instances can use the reserved capacity.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * If you are requesting a future-dated Capacity Reservation, you must specify <code>targeted</code>.
     * </p>
     * </note>
     * <p>
     * Default: <code>open</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #instanceMatchCriteria} will return {@link InstanceMatchCriteria#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #instanceMatchCriteriaAsString}.
     * </p>
     * 
     * @return Indicates the type of instance launches that the Capacity Reservation accepts. The options include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>open</code> - The Capacity Reservation automatically matches all instances that have matching
     *         attributes (instance type, platform, and Availability Zone). Instances that have matching attributes run
     *         in the Capacity Reservation automatically without specifying any additional parameters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>targeted</code> - The Capacity Reservation only accepts instances that have matching attributes
     *         (instance type, platform, and Availability Zone), and explicitly target the Capacity Reservation. This
     *         ensures that only permitted instances can use the reserved capacity.
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         If you are requesting a future-dated Capacity Reservation, you must specify <code>targeted</code>.
     *         </p>
     *         </note>
     *         <p>
     *         Default: <code>open</code>
     * @see InstanceMatchCriteria
     */
    public final InstanceMatchCriteria instanceMatchCriteria() {
        return InstanceMatchCriteria.fromValue(instanceMatchCriteria);
    }

    /**
     * <p>
     * Indicates the type of instance launches that the Capacity Reservation accepts. The options include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>open</code> - The Capacity Reservation automatically matches all instances that have matching attributes
     * (instance type, platform, and Availability Zone). Instances that have matching attributes run in the Capacity
     * Reservation automatically without specifying any additional parameters.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>targeted</code> - The Capacity Reservation only accepts instances that have matching attributes (instance
     * type, platform, and Availability Zone), and explicitly target the Capacity Reservation. This ensures that only
     * permitted instances can use the reserved capacity.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * If you are requesting a future-dated Capacity Reservation, you must specify <code>targeted</code>.
     * </p>
     * </note>
     * <p>
     * Default: <code>open</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #instanceMatchCriteria} will return {@link InstanceMatchCriteria#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #instanceMatchCriteriaAsString}.
     * </p>
     * 
     * @return Indicates the type of instance launches that the Capacity Reservation accepts. The options include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>open</code> - The Capacity Reservation automatically matches all instances that have matching
     *         attributes (instance type, platform, and Availability Zone). Instances that have matching attributes run
     *         in the Capacity Reservation automatically without specifying any additional parameters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>targeted</code> - The Capacity Reservation only accepts instances that have matching attributes
     *         (instance type, platform, and Availability Zone), and explicitly target the Capacity Reservation. This
     *         ensures that only permitted instances can use the reserved capacity.
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         If you are requesting a future-dated Capacity Reservation, you must specify <code>targeted</code>.
     *         </p>
     *         </note>
     *         <p>
     *         Default: <code>open</code>
     * @see InstanceMatchCriteria
     */
    public final String instanceMatchCriteriaAsString() {
        return instanceMatchCriteria;
    }

    /**
     * For responses, this returns true if the service returned a value for the TagSpecifications property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTagSpecifications() {
        return tagSpecifications != null && !(tagSpecifications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags to apply to the Capacity Reservation during launch.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTagSpecifications} method.
     * </p>
     * 
     * @return The tags to apply to the Capacity Reservation during launch.
     */
    public final List<TagSpecification> tagSpecifications() {
        return tagSpecifications;
    }

    /**
     * <p>
     * Checks whether you have the required permissions for the action, without actually making the request, and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return Checks whether you have the required permissions for the action, without actually making the request, and
     *         provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    /**
     * <note>
     * <p>
     * Not supported for future-dated Capacity Reservations.
     * </p>
     * </note>
     * <p>
     * The Amazon Resource Name (ARN) of the Outpost on which to create the Capacity Reservation.
     * </p>
     * 
     * @return <p>
     *         Not supported for future-dated Capacity Reservations.
     *         </p>
     *         </note>
     *         <p>
     *         The Amazon Resource Name (ARN) of the Outpost on which to create the Capacity Reservation.
     */
    public final String outpostArn() {
        return outpostArn;
    }

    /**
     * <note>
     * <p>
     * Not supported for future-dated Capacity Reservations.
     * </p>
     * </note>
     * <p>
     * The Amazon Resource Name (ARN) of the cluster placement group in which to create the Capacity Reservation. For
     * more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/cr-cpg.html"> Capacity
     * Reservations for cluster placement groups</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * 
     * @return <p>
     *         Not supported for future-dated Capacity Reservations.
     *         </p>
     *         </note>
     *         <p>
     *         The Amazon Resource Name (ARN) of the cluster placement group in which to create the Capacity
     *         Reservation. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/cr-cpg.html"> Capacity Reservations for cluster
     *         placement groups</a> in the <i>Amazon EC2 User Guide</i>.
     */
    public final String placementGroupArn() {
        return placementGroupArn;
    }

    /**
     * <note>
     * <p>
     * Required for future-dated Capacity Reservations only. To create a Capacity Reservation for immediate use, omit
     * this parameter.
     * </p>
     * </note>
     * <p>
     * The date and time at which the future-dated Capacity Reservation should become available for use, in the ISO8601
     * format in the UTC time zone (<code>YYYY-MM-DDThh:mm:ss.sssZ</code>).
     * </p>
     * <p>
     * You can request a future-dated Capacity Reservation between 5 and 120 days in advance.
     * </p>
     * 
     * @return <p>
     *         Required for future-dated Capacity Reservations only. To create a Capacity Reservation for immediate use,
     *         omit this parameter.
     *         </p>
     *         </note>
     *         <p>
     *         The date and time at which the future-dated Capacity Reservation should become available for use, in the
     *         ISO8601 format in the UTC time zone (<code>YYYY-MM-DDThh:mm:ss.sssZ</code>).
     *         </p>
     *         <p>
     *         You can request a future-dated Capacity Reservation between 5 and 120 days in advance.
     */
    public final Instant startDate() {
        return startDate;
    }

    /**
     * <note>
     * <p>
     * Required for future-dated Capacity Reservations only. To create a Capacity Reservation for immediate use, omit
     * this parameter.
     * </p>
     * </note>
     * <p>
     * Specify a commitment duration, in seconds, for the future-dated Capacity Reservation.
     * </p>
     * <p>
     * The commitment duration is a minimum duration for which you commit to having the future-dated Capacity
     * Reservation in the <code>active</code> state in your account after it has been delivered.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/cr-concepts.html#cr-commitment-duration"> Commitment
     * duration</a>.
     * </p>
     * 
     * @return <p>
     *         Required for future-dated Capacity Reservations only. To create a Capacity Reservation for immediate use,
     *         omit this parameter.
     *         </p>
     *         </note>
     *         <p>
     *         Specify a commitment duration, in seconds, for the future-dated Capacity Reservation.
     *         </p>
     *         <p>
     *         The commitment duration is a minimum duration for which you commit to having the future-dated Capacity
     *         Reservation in the <code>active</code> state in your account after it has been delivered.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/cr-concepts.html#cr-commitment-duration">
     *         Commitment duration</a>.
     */
    public final Long commitmentDuration() {
        return commitmentDuration;
    }

    /**
     * <note>
     * <p>
     * Required for future-dated Capacity Reservations only. To create a Capacity Reservation for immediate use, omit
     * this parameter.
     * </p>
     * </note>
     * <p>
     * Indicates that the requested capacity will be delivered in addition to any running instances or reserved capacity
     * that you have in your account at the requested date and time.
     * </p>
     * <p>
     * The only supported value is <code>incremental</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #deliveryPreference} will return {@link CapacityReservationDeliveryPreference#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #deliveryPreferenceAsString}.
     * </p>
     * 
     * @return <p>
     *         Required for future-dated Capacity Reservations only. To create a Capacity Reservation for immediate use,
     *         omit this parameter.
     *         </p>
     *         </note>
     *         <p>
     *         Indicates that the requested capacity will be delivered in addition to any running instances or reserved
     *         capacity that you have in your account at the requested date and time.
     *         </p>
     *         <p>
     *         The only supported value is <code>incremental</code>.
     * @see CapacityReservationDeliveryPreference
     */
    public final CapacityReservationDeliveryPreference deliveryPreference() {
        return CapacityReservationDeliveryPreference.fromValue(deliveryPreference);
    }

    /**
     * <note>
     * <p>
     * Required for future-dated Capacity Reservations only. To create a Capacity Reservation for immediate use, omit
     * this parameter.
     * </p>
     * </note>
     * <p>
     * Indicates that the requested capacity will be delivered in addition to any running instances or reserved capacity
     * that you have in your account at the requested date and time.
     * </p>
     * <p>
     * The only supported value is <code>incremental</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #deliveryPreference} will return {@link CapacityReservationDeliveryPreference#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #deliveryPreferenceAsString}.
     * </p>
     * 
     * @return <p>
     *         Required for future-dated Capacity Reservations only. To create a Capacity Reservation for immediate use,
     *         omit this parameter.
     *         </p>
     *         </note>
     *         <p>
     *         Indicates that the requested capacity will be delivered in addition to any running instances or reserved
     *         capacity that you have in your account at the requested date and time.
     *         </p>
     *         <p>
     *         The only supported value is <code>incremental</code>.
     * @see CapacityReservationDeliveryPreference
     */
    public final String deliveryPreferenceAsString() {
        return deliveryPreference;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(instancePlatformAsString());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(tenancyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(instanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(ebsOptimized());
        hashCode = 31 * hashCode + Objects.hashCode(ephemeralStorage());
        hashCode = 31 * hashCode + Objects.hashCode(endDate());
        hashCode = 31 * hashCode + Objects.hashCode(endDateTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(instanceMatchCriteriaAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTagSpecifications() ? tagSpecifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(outpostArn());
        hashCode = 31 * hashCode + Objects.hashCode(placementGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(startDate());
        hashCode = 31 * hashCode + Objects.hashCode(commitmentDuration());
        hashCode = 31 * hashCode + Objects.hashCode(deliveryPreferenceAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCapacityReservationRequest)) {
            return false;
        }
        CreateCapacityReservationRequest other = (CreateCapacityReservationRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(instanceType(), other.instanceType())
                && Objects.equals(instancePlatformAsString(), other.instancePlatformAsString())
                && Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(availabilityZoneId(), other.availabilityZoneId())
                && Objects.equals(tenancyAsString(), other.tenancyAsString())
                && Objects.equals(instanceCount(), other.instanceCount()) && Objects.equals(ebsOptimized(), other.ebsOptimized())
                && Objects.equals(ephemeralStorage(), other.ephemeralStorage()) && Objects.equals(endDate(), other.endDate())
                && Objects.equals(endDateTypeAsString(), other.endDateTypeAsString())
                && Objects.equals(instanceMatchCriteriaAsString(), other.instanceMatchCriteriaAsString())
                && hasTagSpecifications() == other.hasTagSpecifications()
                && Objects.equals(tagSpecifications(), other.tagSpecifications()) && Objects.equals(dryRun(), other.dryRun())
                && Objects.equals(outpostArn(), other.outpostArn())
                && Objects.equals(placementGroupArn(), other.placementGroupArn())
                && Objects.equals(startDate(), other.startDate())
                && Objects.equals(commitmentDuration(), other.commitmentDuration())
                && Objects.equals(deliveryPreferenceAsString(), other.deliveryPreferenceAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateCapacityReservationRequest").add("ClientToken", clientToken())
                .add("InstanceType", instanceType()).add("InstancePlatform", instancePlatformAsString())
                .add("AvailabilityZone", availabilityZone()).add("AvailabilityZoneId", availabilityZoneId())
                .add("Tenancy", tenancyAsString()).add("InstanceCount", instanceCount()).add("EbsOptimized", ebsOptimized())
                .add("EphemeralStorage", ephemeralStorage()).add("EndDate", endDate()).add("EndDateType", endDateTypeAsString())
                .add("InstanceMatchCriteria", instanceMatchCriteriaAsString())
                .add("TagSpecifications", hasTagSpecifications() ? tagSpecifications() : null).add("DryRun", dryRun())
                .add("OutpostArn", outpostArn()).add("PlacementGroupArn", placementGroupArn()).add("StartDate", startDate())
                .add("CommitmentDuration", commitmentDuration()).add("DeliveryPreference", deliveryPreferenceAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceType()));
        case "InstancePlatform":
            return Optional.ofNullable(clazz.cast(instancePlatformAsString()));
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "AvailabilityZoneId":
            return Optional.ofNullable(clazz.cast(availabilityZoneId()));
        case "Tenancy":
            return Optional.ofNullable(clazz.cast(tenancyAsString()));
        case "InstanceCount":
            return Optional.ofNullable(clazz.cast(instanceCount()));
        case "EbsOptimized":
            return Optional.ofNullable(clazz.cast(ebsOptimized()));
        case "EphemeralStorage":
            return Optional.ofNullable(clazz.cast(ephemeralStorage()));
        case "EndDate":
            return Optional.ofNullable(clazz.cast(endDate()));
        case "EndDateType":
            return Optional.ofNullable(clazz.cast(endDateTypeAsString()));
        case "InstanceMatchCriteria":
            return Optional.ofNullable(clazz.cast(instanceMatchCriteriaAsString()));
        case "TagSpecifications":
            return Optional.ofNullable(clazz.cast(tagSpecifications()));
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        case "OutpostArn":
            return Optional.ofNullable(clazz.cast(outpostArn()));
        case "PlacementGroupArn":
            return Optional.ofNullable(clazz.cast(placementGroupArn()));
        case "StartDate":
            return Optional.ofNullable(clazz.cast(startDate()));
        case "CommitmentDuration":
            return Optional.ofNullable(clazz.cast(commitmentDuration()));
        case "DeliveryPreference":
            return Optional.ofNullable(clazz.cast(deliveryPreferenceAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("InstanceType", INSTANCE_TYPE_FIELD);
        map.put("InstancePlatform", INSTANCE_PLATFORM_FIELD);
        map.put("AvailabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("AvailabilityZoneId", AVAILABILITY_ZONE_ID_FIELD);
        map.put("Tenancy", TENANCY_FIELD);
        map.put("InstanceCount", INSTANCE_COUNT_FIELD);
        map.put("EbsOptimized", EBS_OPTIMIZED_FIELD);
        map.put("EphemeralStorage", EPHEMERAL_STORAGE_FIELD);
        map.put("EndDate", END_DATE_FIELD);
        map.put("EndDateType", END_DATE_TYPE_FIELD);
        map.put("InstanceMatchCriteria", INSTANCE_MATCH_CRITERIA_FIELD);
        map.put("TagSpecifications", TAG_SPECIFICATIONS_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("OutpostArn", OUTPOST_ARN_FIELD);
        map.put("PlacementGroupArn", PLACEMENT_GROUP_ARN_FIELD);
        map.put("StartDate", START_DATE_FIELD);
        map.put("CommitmentDuration", COMMITMENT_DURATION_FIELD);
        map.put("DeliveryPreference", DELIVERY_PREFERENCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateCapacityReservationRequest, T> g) {
        return obj -> g.apply((CreateCapacityReservationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, CreateCapacityReservationRequest> {
        /**
         * <p>
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensure
         * Idempotency</a>.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensure
         *        Idempotency</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The instance type for which to reserve capacity.
         * </p>
         * <note>
         * <p>
         * You can request future-dated Capacity Reservations for instance types in the C, M, R, I, T, and G instance
         * families only.
         * </p>
         * </note>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance types</a> in the
         * <i>Amazon EC2 User Guide</i>.
         * </p>
         * 
         * @param instanceType
         *        The instance type for which to reserve capacity.</p> <note>
         *        <p>
         *        You can request future-dated Capacity Reservations for instance types in the C, M, R, I, T, and G
         *        instance families only.
         *        </p>
         *        </note>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance types</a> in
         *        the <i>Amazon EC2 User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The type of operating system for which to reserve capacity.
         * </p>
         * 
         * @param instancePlatform
         *        The type of operating system for which to reserve capacity.
         * @see CapacityReservationInstancePlatform
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapacityReservationInstancePlatform
         */
        Builder instancePlatform(String instancePlatform);

        /**
         * <p>
         * The type of operating system for which to reserve capacity.
         * </p>
         * 
         * @param instancePlatform
         *        The type of operating system for which to reserve capacity.
         * @see CapacityReservationInstancePlatform
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapacityReservationInstancePlatform
         */
        Builder instancePlatform(CapacityReservationInstancePlatform instancePlatform);

        /**
         * <p>
         * The Availability Zone in which to create the Capacity Reservation.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone in which to create the Capacity Reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The ID of the Availability Zone in which to create the Capacity Reservation.
         * </p>
         * 
         * @param availabilityZoneId
         *        The ID of the Availability Zone in which to create the Capacity Reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZoneId(String availabilityZoneId);

        /**
         * <p>
         * Indicates the tenancy of the Capacity Reservation. A Capacity Reservation can have one of the following
         * tenancy settings:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>default</code> - The Capacity Reservation is created on hardware that is shared with other Amazon Web
         * Services accounts.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>dedicated</code> - The Capacity Reservation is created on single-tenant hardware that is dedicated to a
         * single Amazon Web Services account.
         * </p>
         * </li>
         * </ul>
         * 
         * @param tenancy
         *        Indicates the tenancy of the Capacity Reservation. A Capacity Reservation can have one of the
         *        following tenancy settings:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>default</code> - The Capacity Reservation is created on hardware that is shared with other
         *        Amazon Web Services accounts.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>dedicated</code> - The Capacity Reservation is created on single-tenant hardware that is
         *        dedicated to a single Amazon Web Services account.
         *        </p>
         *        </li>
         * @see CapacityReservationTenancy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapacityReservationTenancy
         */
        Builder tenancy(String tenancy);

        /**
         * <p>
         * Indicates the tenancy of the Capacity Reservation. A Capacity Reservation can have one of the following
         * tenancy settings:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>default</code> - The Capacity Reservation is created on hardware that is shared with other Amazon Web
         * Services accounts.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>dedicated</code> - The Capacity Reservation is created on single-tenant hardware that is dedicated to a
         * single Amazon Web Services account.
         * </p>
         * </li>
         * </ul>
         * 
         * @param tenancy
         *        Indicates the tenancy of the Capacity Reservation. A Capacity Reservation can have one of the
         *        following tenancy settings:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>default</code> - The Capacity Reservation is created on hardware that is shared with other
         *        Amazon Web Services accounts.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>dedicated</code> - The Capacity Reservation is created on single-tenant hardware that is
         *        dedicated to a single Amazon Web Services account.
         *        </p>
         *        </li>
         * @see CapacityReservationTenancy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapacityReservationTenancy
         */
        Builder tenancy(CapacityReservationTenancy tenancy);

        /**
         * <p>
         * The number of instances for which to reserve capacity.
         * </p>
         * <note>
         * <p>
         * You can request future-dated Capacity Reservations for an instance count with a minimum of 32 vCPUs. For
         * example, if you request a future-dated Capacity Reservation for <code>m5.xlarge</code> instances, you must
         * request at least 8 instances (<i>8 * m5.xlarge = 32 vCPUs</i>).
         * </p>
         * </note>
         * <p>
         * Valid range: 1 - 1000
         * </p>
         * 
         * @param instanceCount
         *        The number of instances for which to reserve capacity.</p> <note>
         *        <p>
         *        You can request future-dated Capacity Reservations for an instance count with a minimum of 32 vCPUs.
         *        For example, if you request a future-dated Capacity Reservation for <code>m5.xlarge</code> instances,
         *        you must request at least 8 instances (<i>8 * m5.xlarge = 32 vCPUs</i>).
         *        </p>
         *        </note>
         *        <p>
         *        Valid range: 1 - 1000
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceCount(Integer instanceCount);

        /**
         * <p>
         * Indicates whether the Capacity Reservation supports EBS-optimized instances. This optimization provides
         * dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal I/O performance.
         * This optimization isn't available with all instance types. Additional usage charges apply when using an EBS-
         * optimized instance.
         * </p>
         * 
         * @param ebsOptimized
         *        Indicates whether the Capacity Reservation supports EBS-optimized instances. This optimization
         *        provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal
         *        I/O performance. This optimization isn't available with all instance types. Additional usage charges
         *        apply when using an EBS- optimized instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ebsOptimized(Boolean ebsOptimized);

        /**
         * <p>
         * <i>Deprecated.</i>
         * </p>
         * 
         * @param ephemeralStorage
         *        <i>Deprecated.</i>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ephemeralStorage(Boolean ephemeralStorage);

        /**
         * <p>
         * The date and time at which the Capacity Reservation expires. When a Capacity Reservation expires, the
         * reserved capacity is released and you can no longer launch instances into it. The Capacity Reservation's
         * state changes to <code>expired</code> when it reaches its end date and time.
         * </p>
         * <p>
         * You must provide an <code>EndDate</code> value if <code>EndDateType</code> is <code>limited</code>. Omit
         * <code>EndDate</code> if <code>EndDateType</code> is <code>unlimited</code>.
         * </p>
         * <p>
         * If the <code>EndDateType</code> is <code>limited</code>, the Capacity Reservation is cancelled within an hour
         * from the specified time. For example, if you specify 5/31/2019, 13:30:55, the Capacity Reservation is
         * guaranteed to end between 13:30:55 and 14:30:55 on 5/31/2019.
         * </p>
         * <p>
         * If you are requesting a future-dated Capacity Reservation, you can't specify an end date and time that is
         * within the commitment duration.
         * </p>
         * 
         * @param endDate
         *        The date and time at which the Capacity Reservation expires. When a Capacity Reservation expires, the
         *        reserved capacity is released and you can no longer launch instances into it. The Capacity
         *        Reservation's state changes to <code>expired</code> when it reaches its end date and time.</p>
         *        <p>
         *        You must provide an <code>EndDate</code> value if <code>EndDateType</code> is <code>limited</code>.
         *        Omit <code>EndDate</code> if <code>EndDateType</code> is <code>unlimited</code>.
         *        </p>
         *        <p>
         *        If the <code>EndDateType</code> is <code>limited</code>, the Capacity Reservation is cancelled within
         *        an hour from the specified time. For example, if you specify 5/31/2019, 13:30:55, the Capacity
         *        Reservation is guaranteed to end between 13:30:55 and 14:30:55 on 5/31/2019.
         *        </p>
         *        <p>
         *        If you are requesting a future-dated Capacity Reservation, you can't specify an end date and time that
         *        is within the commitment duration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endDate(Instant endDate);

        /**
         * <p>
         * Indicates the way in which the Capacity Reservation ends. A Capacity Reservation can have one of the
         * following end types:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>unlimited</code> - The Capacity Reservation remains active until you explicitly cancel it. Do not
         * provide an <code>EndDate</code> if the <code>EndDateType</code> is <code>unlimited</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>limited</code> - The Capacity Reservation expires automatically at a specified date and time. You must
         * provide an <code>EndDate</code> value if the <code>EndDateType</code> value is <code>limited</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param endDateType
         *        Indicates the way in which the Capacity Reservation ends. A Capacity Reservation can have one of the
         *        following end types:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>unlimited</code> - The Capacity Reservation remains active until you explicitly cancel it. Do
         *        not provide an <code>EndDate</code> if the <code>EndDateType</code> is <code>unlimited</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>limited</code> - The Capacity Reservation expires automatically at a specified date and time.
         *        You must provide an <code>EndDate</code> value if the <code>EndDateType</code> value is
         *        <code>limited</code>.
         *        </p>
         *        </li>
         * @see EndDateType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EndDateType
         */
        Builder endDateType(String endDateType);

        /**
         * <p>
         * Indicates the way in which the Capacity Reservation ends. A Capacity Reservation can have one of the
         * following end types:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>unlimited</code> - The Capacity Reservation remains active until you explicitly cancel it. Do not
         * provide an <code>EndDate</code> if the <code>EndDateType</code> is <code>unlimited</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>limited</code> - The Capacity Reservation expires automatically at a specified date and time. You must
         * provide an <code>EndDate</code> value if the <code>EndDateType</code> value is <code>limited</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param endDateType
         *        Indicates the way in which the Capacity Reservation ends. A Capacity Reservation can have one of the
         *        following end types:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>unlimited</code> - The Capacity Reservation remains active until you explicitly cancel it. Do
         *        not provide an <code>EndDate</code> if the <code>EndDateType</code> is <code>unlimited</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>limited</code> - The Capacity Reservation expires automatically at a specified date and time.
         *        You must provide an <code>EndDate</code> value if the <code>EndDateType</code> value is
         *        <code>limited</code>.
         *        </p>
         *        </li>
         * @see EndDateType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EndDateType
         */
        Builder endDateType(EndDateType endDateType);

        /**
         * <p>
         * Indicates the type of instance launches that the Capacity Reservation accepts. The options include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>open</code> - The Capacity Reservation automatically matches all instances that have matching
         * attributes (instance type, platform, and Availability Zone). Instances that have matching attributes run in
         * the Capacity Reservation automatically without specifying any additional parameters.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>targeted</code> - The Capacity Reservation only accepts instances that have matching attributes
         * (instance type, platform, and Availability Zone), and explicitly target the Capacity Reservation. This
         * ensures that only permitted instances can use the reserved capacity.
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * If you are requesting a future-dated Capacity Reservation, you must specify <code>targeted</code>.
         * </p>
         * </note>
         * <p>
         * Default: <code>open</code>
         * </p>
         * 
         * @param instanceMatchCriteria
         *        Indicates the type of instance launches that the Capacity Reservation accepts. The options
         *        include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>open</code> - The Capacity Reservation automatically matches all instances that have matching
         *        attributes (instance type, platform, and Availability Zone). Instances that have matching attributes
         *        run in the Capacity Reservation automatically without specifying any additional parameters.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>targeted</code> - The Capacity Reservation only accepts instances that have matching attributes
         *        (instance type, platform, and Availability Zone), and explicitly target the Capacity Reservation. This
         *        ensures that only permitted instances can use the reserved capacity.
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        If you are requesting a future-dated Capacity Reservation, you must specify <code>targeted</code>.
         *        </p>
         *        </note>
         *        <p>
         *        Default: <code>open</code>
         * @see InstanceMatchCriteria
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceMatchCriteria
         */
        Builder instanceMatchCriteria(String instanceMatchCriteria);

        /**
         * <p>
         * Indicates the type of instance launches that the Capacity Reservation accepts. The options include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>open</code> - The Capacity Reservation automatically matches all instances that have matching
         * attributes (instance type, platform, and Availability Zone). Instances that have matching attributes run in
         * the Capacity Reservation automatically without specifying any additional parameters.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>targeted</code> - The Capacity Reservation only accepts instances that have matching attributes
         * (instance type, platform, and Availability Zone), and explicitly target the Capacity Reservation. This
         * ensures that only permitted instances can use the reserved capacity.
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * If you are requesting a future-dated Capacity Reservation, you must specify <code>targeted</code>.
         * </p>
         * </note>
         * <p>
         * Default: <code>open</code>
         * </p>
         * 
         * @param instanceMatchCriteria
         *        Indicates the type of instance launches that the Capacity Reservation accepts. The options
         *        include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>open</code> - The Capacity Reservation automatically matches all instances that have matching
         *        attributes (instance type, platform, and Availability Zone). Instances that have matching attributes
         *        run in the Capacity Reservation automatically without specifying any additional parameters.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>targeted</code> - The Capacity Reservation only accepts instances that have matching attributes
         *        (instance type, platform, and Availability Zone), and explicitly target the Capacity Reservation. This
         *        ensures that only permitted instances can use the reserved capacity.
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        If you are requesting a future-dated Capacity Reservation, you must specify <code>targeted</code>.
         *        </p>
         *        </note>
         *        <p>
         *        Default: <code>open</code>
         * @see InstanceMatchCriteria
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceMatchCriteria
         */
        Builder instanceMatchCriteria(InstanceMatchCriteria instanceMatchCriteria);

        /**
         * <p>
         * The tags to apply to the Capacity Reservation during launch.
         * </p>
         * 
         * @param tagSpecifications
         *        The tags to apply to the Capacity Reservation during launch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(Collection<TagSpecification> tagSpecifications);

        /**
         * <p>
         * The tags to apply to the Capacity Reservation during launch.
         * </p>
         * 
         * @param tagSpecifications
         *        The tags to apply to the Capacity Reservation during launch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(TagSpecification... tagSpecifications);

        /**
         * <p>
         * The tags to apply to the Capacity Reservation during launch.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.TagSpecification.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.TagSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.TagSpecification.Builder#build()} is called immediately and
         * its result is passed to {@link #tagSpecifications(List<TagSpecification>)}.
         * 
         * @param tagSpecifications
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.TagSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagSpecifications(java.util.Collection<TagSpecification>)
         */
        Builder tagSpecifications(Consumer<TagSpecification.Builder>... tagSpecifications);

        /**
         * <p>
         * Checks whether you have the required permissions for the action, without actually making the request, and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        Checks whether you have the required permissions for the action, without actually making the request,
         *        and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        /**
         * <note>
         * <p>
         * Not supported for future-dated Capacity Reservations.
         * </p>
         * </note>
         * <p>
         * The Amazon Resource Name (ARN) of the Outpost on which to create the Capacity Reservation.
         * </p>
         * 
         * @param outpostArn
         *        <p>
         *        Not supported for future-dated Capacity Reservations.
         *        </p>
         *        </note>
         *        <p>
         *        The Amazon Resource Name (ARN) of the Outpost on which to create the Capacity Reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outpostArn(String outpostArn);

        /**
         * <note>
         * <p>
         * Not supported for future-dated Capacity Reservations.
         * </p>
         * </note>
         * <p>
         * The Amazon Resource Name (ARN) of the cluster placement group in which to create the Capacity Reservation.
         * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/cr-cpg.html"> Capacity
         * Reservations for cluster placement groups</a> in the <i>Amazon EC2 User Guide</i>.
         * </p>
         * 
         * @param placementGroupArn
         *        <p>
         *        Not supported for future-dated Capacity Reservations.
         *        </p>
         *        </note>
         *        <p>
         *        The Amazon Resource Name (ARN) of the cluster placement group in which to create the Capacity
         *        Reservation. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/cr-cpg.html"> Capacity Reservations for
         *        cluster placement groups</a> in the <i>Amazon EC2 User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placementGroupArn(String placementGroupArn);

        /**
         * <note>
         * <p>
         * Required for future-dated Capacity Reservations only. To create a Capacity Reservation for immediate use,
         * omit this parameter.
         * </p>
         * </note>
         * <p>
         * The date and time at which the future-dated Capacity Reservation should become available for use, in the
         * ISO8601 format in the UTC time zone (<code>YYYY-MM-DDThh:mm:ss.sssZ</code>).
         * </p>
         * <p>
         * You can request a future-dated Capacity Reservation between 5 and 120 days in advance.
         * </p>
         * 
         * @param startDate
         *        <p>
         *        Required for future-dated Capacity Reservations only. To create a Capacity Reservation for immediate
         *        use, omit this parameter.
         *        </p>
         *        </note>
         *        <p>
         *        The date and time at which the future-dated Capacity Reservation should become available for use, in
         *        the ISO8601 format in the UTC time zone (<code>YYYY-MM-DDThh:mm:ss.sssZ</code>).
         *        </p>
         *        <p>
         *        You can request a future-dated Capacity Reservation between 5 and 120 days in advance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startDate(Instant startDate);

        /**
         * <note>
         * <p>
         * Required for future-dated Capacity Reservations only. To create a Capacity Reservation for immediate use,
         * omit this parameter.
         * </p>
         * </note>
         * <p>
         * Specify a commitment duration, in seconds, for the future-dated Capacity Reservation.
         * </p>
         * <p>
         * The commitment duration is a minimum duration for which you commit to having the future-dated Capacity
         * Reservation in the <code>active</code> state in your account after it has been delivered.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/cr-concepts.html#cr-commitment-duration">
         * Commitment duration</a>.
         * </p>
         * 
         * @param commitmentDuration
         *        <p>
         *        Required for future-dated Capacity Reservations only. To create a Capacity Reservation for immediate
         *        use, omit this parameter.
         *        </p>
         *        </note>
         *        <p>
         *        Specify a commitment duration, in seconds, for the future-dated Capacity Reservation.
         *        </p>
         *        <p>
         *        The commitment duration is a minimum duration for which you commit to having the future-dated Capacity
         *        Reservation in the <code>active</code> state in your account after it has been delivered.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/cr-concepts.html#cr-commitment-duration">
         *        Commitment duration</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commitmentDuration(Long commitmentDuration);

        /**
         * <note>
         * <p>
         * Required for future-dated Capacity Reservations only. To create a Capacity Reservation for immediate use,
         * omit this parameter.
         * </p>
         * </note>
         * <p>
         * Indicates that the requested capacity will be delivered in addition to any running instances or reserved
         * capacity that you have in your account at the requested date and time.
         * </p>
         * <p>
         * The only supported value is <code>incremental</code>.
         * </p>
         * 
         * @param deliveryPreference
         *        <p>
         *        Required for future-dated Capacity Reservations only. To create a Capacity Reservation for immediate
         *        use, omit this parameter.
         *        </p>
         *        </note>
         *        <p>
         *        Indicates that the requested capacity will be delivered in addition to any running instances or
         *        reserved capacity that you have in your account at the requested date and time.
         *        </p>
         *        <p>
         *        The only supported value is <code>incremental</code>.
         * @see CapacityReservationDeliveryPreference
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapacityReservationDeliveryPreference
         */
        Builder deliveryPreference(String deliveryPreference);

        /**
         * <note>
         * <p>
         * Required for future-dated Capacity Reservations only. To create a Capacity Reservation for immediate use,
         * omit this parameter.
         * </p>
         * </note>
         * <p>
         * Indicates that the requested capacity will be delivered in addition to any running instances or reserved
         * capacity that you have in your account at the requested date and time.
         * </p>
         * <p>
         * The only supported value is <code>incremental</code>.
         * </p>
         * 
         * @param deliveryPreference
         *        <p>
         *        Required for future-dated Capacity Reservations only. To create a Capacity Reservation for immediate
         *        use, omit this parameter.
         *        </p>
         *        </note>
         *        <p>
         *        Indicates that the requested capacity will be delivered in addition to any running instances or
         *        reserved capacity that you have in your account at the requested date and time.
         *        </p>
         *        <p>
         *        The only supported value is <code>incremental</code>.
         * @see CapacityReservationDeliveryPreference
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapacityReservationDeliveryPreference
         */
        Builder deliveryPreference(CapacityReservationDeliveryPreference deliveryPreference);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String clientToken;

        private String instanceType;

        private String instancePlatform;

        private String availabilityZone;

        private String availabilityZoneId;

        private String tenancy;

        private Integer instanceCount;

        private Boolean ebsOptimized;

        private Boolean ephemeralStorage;

        private Instant endDate;

        private String endDateType;

        private String instanceMatchCriteria;

        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();

        private Boolean dryRun;

        private String outpostArn;

        private String placementGroupArn;

        private Instant startDate;

        private Long commitmentDuration;

        private String deliveryPreference;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCapacityReservationRequest model) {
            super(model);
            clientToken(model.clientToken);
            instanceType(model.instanceType);
            instancePlatform(model.instancePlatform);
            availabilityZone(model.availabilityZone);
            availabilityZoneId(model.availabilityZoneId);
            tenancy(model.tenancy);
            instanceCount(model.instanceCount);
            ebsOptimized(model.ebsOptimized);
            ephemeralStorage(model.ephemeralStorage);
            endDate(model.endDate);
            endDateType(model.endDateType);
            instanceMatchCriteria(model.instanceMatchCriteria);
            tagSpecifications(model.tagSpecifications);
            dryRun(model.dryRun);
            outpostArn(model.outpostArn);
            placementGroupArn(model.placementGroupArn);
            startDate(model.startDate);
            commitmentDuration(model.commitmentDuration);
            deliveryPreference(model.deliveryPreference);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final String getInstancePlatform() {
            return instancePlatform;
        }

        public final void setInstancePlatform(String instancePlatform) {
            this.instancePlatform = instancePlatform;
        }

        @Override
        public final Builder instancePlatform(String instancePlatform) {
            this.instancePlatform = instancePlatform;
            return this;
        }

        @Override
        public final Builder instancePlatform(CapacityReservationInstancePlatform instancePlatform) {
            this.instancePlatform(instancePlatform == null ? null : instancePlatform.toString());
            return this;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final String getAvailabilityZoneId() {
            return availabilityZoneId;
        }

        public final void setAvailabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
        }

        @Override
        public final Builder availabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
            return this;
        }

        public final String getTenancy() {
            return tenancy;
        }

        public final void setTenancy(String tenancy) {
            this.tenancy = tenancy;
        }

        @Override
        public final Builder tenancy(String tenancy) {
            this.tenancy = tenancy;
            return this;
        }

        @Override
        public final Builder tenancy(CapacityReservationTenancy tenancy) {
            this.tenancy(tenancy == null ? null : tenancy.toString());
            return this;
        }

        public final Integer getInstanceCount() {
            return instanceCount;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final Boolean getEbsOptimized() {
            return ebsOptimized;
        }

        public final void setEbsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
        }

        @Override
        public final Builder ebsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
            return this;
        }

        public final Boolean getEphemeralStorage() {
            return ephemeralStorage;
        }

        public final void setEphemeralStorage(Boolean ephemeralStorage) {
            this.ephemeralStorage = ephemeralStorage;
        }

        @Override
        public final Builder ephemeralStorage(Boolean ephemeralStorage) {
            this.ephemeralStorage = ephemeralStorage;
            return this;
        }

        public final Instant getEndDate() {
            return endDate;
        }

        public final void setEndDate(Instant endDate) {
            this.endDate = endDate;
        }

        @Override
        public final Builder endDate(Instant endDate) {
            this.endDate = endDate;
            return this;
        }

        public final String getEndDateType() {
            return endDateType;
        }

        public final void setEndDateType(String endDateType) {
            this.endDateType = endDateType;
        }

        @Override
        public final Builder endDateType(String endDateType) {
            this.endDateType = endDateType;
            return this;
        }

        @Override
        public final Builder endDateType(EndDateType endDateType) {
            this.endDateType(endDateType == null ? null : endDateType.toString());
            return this;
        }

        public final String getInstanceMatchCriteria() {
            return instanceMatchCriteria;
        }

        public final void setInstanceMatchCriteria(String instanceMatchCriteria) {
            this.instanceMatchCriteria = instanceMatchCriteria;
        }

        @Override
        public final Builder instanceMatchCriteria(String instanceMatchCriteria) {
            this.instanceMatchCriteria = instanceMatchCriteria;
            return this;
        }

        @Override
        public final Builder instanceMatchCriteria(InstanceMatchCriteria instanceMatchCriteria) {
            this.instanceMatchCriteria(instanceMatchCriteria == null ? null : instanceMatchCriteria.toString());
            return this;
        }

        public final List<TagSpecification.Builder> getTagSpecifications() {
            List<TagSpecification.Builder> result = TagSpecificationListCopier.copyToBuilder(this.tagSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification... tagSpecifications) {
            tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder>... tagSpecifications) {
            tagSpecifications(Stream.of(tagSpecifications).map(c -> TagSpecification.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getOutpostArn() {
            return outpostArn;
        }

        public final void setOutpostArn(String outpostArn) {
            this.outpostArn = outpostArn;
        }

        @Override
        public final Builder outpostArn(String outpostArn) {
            this.outpostArn = outpostArn;
            return this;
        }

        public final String getPlacementGroupArn() {
            return placementGroupArn;
        }

        public final void setPlacementGroupArn(String placementGroupArn) {
            this.placementGroupArn = placementGroupArn;
        }

        @Override
        public final Builder placementGroupArn(String placementGroupArn) {
            this.placementGroupArn = placementGroupArn;
            return this;
        }

        public final Instant getStartDate() {
            return startDate;
        }

        public final void setStartDate(Instant startDate) {
            this.startDate = startDate;
        }

        @Override
        public final Builder startDate(Instant startDate) {
            this.startDate = startDate;
            return this;
        }

        public final Long getCommitmentDuration() {
            return commitmentDuration;
        }

        public final void setCommitmentDuration(Long commitmentDuration) {
            this.commitmentDuration = commitmentDuration;
        }

        @Override
        public final Builder commitmentDuration(Long commitmentDuration) {
            this.commitmentDuration = commitmentDuration;
            return this;
        }

        public final String getDeliveryPreference() {
            return deliveryPreference;
        }

        public final void setDeliveryPreference(String deliveryPreference) {
            this.deliveryPreference = deliveryPreference;
        }

        @Override
        public final Builder deliveryPreference(String deliveryPreference) {
            this.deliveryPreference = deliveryPreference;
            return this;
        }

        @Override
        public final Builder deliveryPreference(CapacityReservationDeliveryPreference deliveryPreference) {
            this.deliveryPreference(deliveryPreference == null ? null : deliveryPreference.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCapacityReservationRequest build() {
            return new CreateCapacityReservationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
