/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CopyVolumesRequest extends Ec2Request implements
        ToCopyableBuilder<CopyVolumesRequest.Builder, CopyVolumesRequest> {
    private static final SdkField<String> SOURCE_VOLUME_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SourceVolumeId")
            .getter(getter(CopyVolumesRequest::sourceVolumeId))
            .setter(setter(Builder::sourceVolumeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceVolumeId")
                    .unmarshallLocationName("SourceVolumeId").build()).build();

    private static final SdkField<Integer> IOPS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("Iops")
            .getter(getter(CopyVolumesRequest::iops))
            .setter(setter(Builder::iops))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Iops")
                    .unmarshallLocationName("Iops").build()).build();

    private static final SdkField<Integer> SIZE_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("Size")
            .getter(getter(CopyVolumesRequest::size))
            .setter(setter(Builder::size))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Size")
                    .unmarshallLocationName("Size").build()).build();

    private static final SdkField<String> VOLUME_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VolumeType")
            .getter(getter(CopyVolumesRequest::volumeTypeAsString))
            .setter(setter(Builder::volumeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeType")
                    .unmarshallLocationName("VolumeType").build()).build();

    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(CopyVolumesRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("DryRun").build()).build();

    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField
            .<List<TagSpecification>> builder(MarshallingType.LIST)
            .memberName("TagSpecifications")
            .getter(getter(CopyVolumesRequest::tagSpecifications))
            .setter(setter(Builder::tagSpecifications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification")
                    .unmarshallLocationName("TagSpecification").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<TagSpecification> builder(MarshallingType.SDK_POJO)
                                            .constructor(TagSpecification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<Boolean> MULTI_ATTACH_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("MultiAttachEnabled")
            .getter(getter(CopyVolumesRequest::multiAttachEnabled))
            .setter(setter(Builder::multiAttachEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiAttachEnabled")
                    .unmarshallLocationName("MultiAttachEnabled").build()).build();

    private static final SdkField<Integer> THROUGHPUT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("Throughput")
            .getter(getter(CopyVolumesRequest::throughput))
            .setter(setter(Builder::throughput))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Throughput")
                    .unmarshallLocationName("Throughput").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CopyVolumesRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken")
                    .unmarshallLocationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_VOLUME_ID_FIELD,
            IOPS_FIELD, SIZE_FIELD, VOLUME_TYPE_FIELD, DRY_RUN_FIELD, TAG_SPECIFICATIONS_FIELD, MULTI_ATTACH_ENABLED_FIELD,
            THROUGHPUT_FIELD, CLIENT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String sourceVolumeId;

    private final Integer iops;

    private final Integer size;

    private final String volumeType;

    private final Boolean dryRun;

    private final List<TagSpecification> tagSpecifications;

    private final Boolean multiAttachEnabled;

    private final Integer throughput;

    private final String clientToken;

    private CopyVolumesRequest(BuilderImpl builder) {
        super(builder);
        this.sourceVolumeId = builder.sourceVolumeId;
        this.iops = builder.iops;
        this.size = builder.size;
        this.volumeType = builder.volumeType;
        this.dryRun = builder.dryRun;
        this.tagSpecifications = builder.tagSpecifications;
        this.multiAttachEnabled = builder.multiAttachEnabled;
        this.throughput = builder.throughput;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The ID of the source EBS volume to copy.
     * </p>
     * 
     * @return The ID of the source EBS volume to copy.
     */
    public final String sourceVolumeId() {
        return sourceVolumeId;
    }

    /**
     * <p>
     * The number of I/O operations per second (IOPS) to provision for the volume copy. Required for <code>io1</code>
     * and <code>io2</code> volumes. Optional for <code>gp3</code> volumes. Omit for all other volume types. Full
     * provisioned IOPS performance can be achieved only once the volume copy is fully initialized.
     * </p>
     * <p>
     * Valid ranges:
     * </p>
     * <ul>
     * <li>
     * <p>
     * gp3: <code>3,000 </code>(<i>default</i>)<code> - 80,000</code> IOPS
     * </p>
     * </li>
     * <li>
     * <p>
     * io1: <code>100 - 64,000</code> IOPS
     * </p>
     * </li>
     * <li>
     * <p>
     * io2: <code>100 - 256,000</code> IOPS
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * <a href="https://docs.aws.amazon.com/ec2/latest/instancetypes/ec2-nitro-instances.html"> Instances built on the
     * Nitro System</a> can support up to 256,000 IOPS. Other instances can support up to 32,000 IOPS.
     * </p>
     * </note>
     * 
     * @return The number of I/O operations per second (IOPS) to provision for the volume copy. Required for
     *         <code>io1</code> and <code>io2</code> volumes. Optional for <code>gp3</code> volumes. Omit for all other
     *         volume types. Full provisioned IOPS performance can be achieved only once the volume copy is fully
     *         initialized. </p>
     *         <p>
     *         Valid ranges:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         gp3: <code>3,000 </code>(<i>default</i>)<code> - 80,000</code> IOPS
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         io1: <code>100 - 64,000</code> IOPS
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         io2: <code>100 - 256,000</code> IOPS
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         <a href="https://docs.aws.amazon.com/ec2/latest/instancetypes/ec2-nitro-instances.html"> Instances built
     *         on the Nitro System</a> can support up to 256,000 IOPS. Other instances can support up to 32,000 IOPS.
     *         </p>
     */
    public final Integer iops() {
        return iops;
    }

    /**
     * <p>
     * The size of the volume copy, in GiBs. The size must be equal to or greater than the size of the source volume. If
     * not specified, the size defaults to the size of the source volume.
     * </p>
     * <p>
     * Maximum supported sizes:
     * </p>
     * <ul>
     * <li>
     * <p>
     * gp2: <code>16,384</code> GiB
     * </p>
     * </li>
     * <li>
     * <p>
     * gp3: <code>65,536</code> GiB
     * </p>
     * </li>
     * <li>
     * <p>
     * io1: <code>16,384</code> GiB
     * </p>
     * </li>
     * <li>
     * <p>
     * io2: <code>65,536</code> GiB
     * </p>
     * </li>
     * <li>
     * <p>
     * st1 and sc1: <code>16,384</code> GiB
     * </p>
     * </li>
     * <li>
     * <p>
     * standard: <code>1024</code> GiB
     * </p>
     * </li>
     * </ul>
     * 
     * @return The size of the volume copy, in GiBs. The size must be equal to or greater than the size of the source
     *         volume. If not specified, the size defaults to the size of the source volume.</p>
     *         <p>
     *         Maximum supported sizes:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         gp2: <code>16,384</code> GiB
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         gp3: <code>65,536</code> GiB
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         io1: <code>16,384</code> GiB
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         io2: <code>65,536</code> GiB
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         st1 and sc1: <code>16,384</code> GiB
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         standard: <code>1024</code> GiB
     *         </p>
     *         </li>
     */
    public final Integer size() {
        return size;
    }

    /**
     * <p>
     * The volume type for the volume copy. If not specified, the volume type defaults to <code>gp2</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #volumeType} will
     * return {@link VolumeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #volumeTypeAsString}.
     * </p>
     * 
     * @return The volume type for the volume copy. If not specified, the volume type defaults to <code>gp2</code>.
     * @see VolumeType
     */
    public final VolumeType volumeType() {
        return VolumeType.fromValue(volumeType);
    }

    /**
     * <p>
     * The volume type for the volume copy. If not specified, the volume type defaults to <code>gp2</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #volumeType} will
     * return {@link VolumeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #volumeTypeAsString}.
     * </p>
     * 
     * @return The volume type for the volume copy. If not specified, the volume type defaults to <code>gp2</code>.
     * @see VolumeType
     */
    public final String volumeTypeAsString() {
        return volumeType;
    }

    /**
     * <p>
     * Checks whether you have the required permissions for the action, without actually making the request, and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return Checks whether you have the required permissions for the action, without actually making the request, and
     *         provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    /**
     * For responses, this returns true if the service returned a value for the TagSpecifications property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTagSpecifications() {
        return tagSpecifications != null && !(tagSpecifications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags to apply to the volume copy during creation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTagSpecifications} method.
     * </p>
     * 
     * @return The tags to apply to the volume copy during creation.
     */
    public final List<TagSpecification> tagSpecifications() {
        return tagSpecifications;
    }

    /**
     * <p>
     * Indicates whether to enable Amazon EBS Multi-Attach for the volume copy. If you enable Multi-Attach, you can
     * attach the volume to up to 16 Nitro instances in the same Availability Zone simultaneously. Supported with
     * <code>io1</code> and <code>io2</code> volumes only. For more information, see <a
     * href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-volumes-multi.html"> Amazon EBS Multi-Attach</a>.
     * </p>
     * 
     * @return Indicates whether to enable Amazon EBS Multi-Attach for the volume copy. If you enable Multi-Attach, you
     *         can attach the volume to up to 16 Nitro instances in the same Availability Zone simultaneously. Supported
     *         with <code>io1</code> and <code>io2</code> volumes only. For more information, see <a
     *         href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-volumes-multi.html"> Amazon EBS
     *         Multi-Attach</a>.
     */
    public final Boolean multiAttachEnabled() {
        return multiAttachEnabled;
    }

    /**
     * <p>
     * The throughput to provision for the volume copy, in MiB/s. Supported for <code>gp3</code> volumes only. Omit for
     * all other volume types. Full provisioned throughput performance can be achieved only once the volume copy is
     * fully initialized.
     * </p>
     * <p>
     * Valid Range: <code>125 - 2000</code> MiB/s
     * </p>
     * <p/>
     * 
     * @return The throughput to provision for the volume copy, in MiB/s. Supported for <code>gp3</code> volumes only.
     *         Omit for all other volume types. Full provisioned throughput performance can be achieved only once the
     *         volume copy is fully initialized.
     *         </p>
     *         <p>
     *         Valid Range: <code>125 - 2000</code> MiB/s
     *         </p>
     */
    public final Integer throughput() {
        return throughput;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
     * information, see <a href="https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html"> Ensure
     * Idempotency</a>.
     * </p>
     * 
     * @return Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
     *         information, see <a href="https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html">
     *         Ensure Idempotency</a>.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(sourceVolumeId());
        hashCode = 31 * hashCode + Objects.hashCode(iops());
        hashCode = 31 * hashCode + Objects.hashCode(size());
        hashCode = 31 * hashCode + Objects.hashCode(volumeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(hasTagSpecifications() ? tagSpecifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(multiAttachEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(throughput());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopyVolumesRequest)) {
            return false;
        }
        CopyVolumesRequest other = (CopyVolumesRequest) obj;
        return Objects.equals(sourceVolumeId(), other.sourceVolumeId()) && Objects.equals(iops(), other.iops())
                && Objects.equals(size(), other.size()) && Objects.equals(volumeTypeAsString(), other.volumeTypeAsString())
                && Objects.equals(dryRun(), other.dryRun()) && hasTagSpecifications() == other.hasTagSpecifications()
                && Objects.equals(tagSpecifications(), other.tagSpecifications())
                && Objects.equals(multiAttachEnabled(), other.multiAttachEnabled())
                && Objects.equals(throughput(), other.throughput()) && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CopyVolumesRequest").add("SourceVolumeId", sourceVolumeId()).add("Iops", iops())
                .add("Size", size()).add("VolumeType", volumeTypeAsString()).add("DryRun", dryRun())
                .add("TagSpecifications", hasTagSpecifications() ? tagSpecifications() : null)
                .add("MultiAttachEnabled", multiAttachEnabled()).add("Throughput", throughput())
                .add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceVolumeId":
            return Optional.ofNullable(clazz.cast(sourceVolumeId()));
        case "Iops":
            return Optional.ofNullable(clazz.cast(iops()));
        case "Size":
            return Optional.ofNullable(clazz.cast(size()));
        case "VolumeType":
            return Optional.ofNullable(clazz.cast(volumeTypeAsString()));
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        case "TagSpecifications":
            return Optional.ofNullable(clazz.cast(tagSpecifications()));
        case "MultiAttachEnabled":
            return Optional.ofNullable(clazz.cast(multiAttachEnabled()));
        case "Throughput":
            return Optional.ofNullable(clazz.cast(throughput()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SourceVolumeId", SOURCE_VOLUME_ID_FIELD);
        map.put("Iops", IOPS_FIELD);
        map.put("Size", SIZE_FIELD);
        map.put("VolumeType", VOLUME_TYPE_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("TagSpecification", TAG_SPECIFICATIONS_FIELD);
        map.put("MultiAttachEnabled", MULTI_ATTACH_ENABLED_FIELD);
        map.put("Throughput", THROUGHPUT_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CopyVolumesRequest, T> g) {
        return obj -> g.apply((CopyVolumesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, CopyVolumesRequest> {
        /**
         * <p>
         * The ID of the source EBS volume to copy.
         * </p>
         * 
         * @param sourceVolumeId
         *        The ID of the source EBS volume to copy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceVolumeId(String sourceVolumeId);

        /**
         * <p>
         * The number of I/O operations per second (IOPS) to provision for the volume copy. Required for
         * <code>io1</code> and <code>io2</code> volumes. Optional for <code>gp3</code> volumes. Omit for all other
         * volume types. Full provisioned IOPS performance can be achieved only once the volume copy is fully
         * initialized.
         * </p>
         * <p>
         * Valid ranges:
         * </p>
         * <ul>
         * <li>
         * <p>
         * gp3: <code>3,000 </code>(<i>default</i>)<code> - 80,000</code> IOPS
         * </p>
         * </li>
         * <li>
         * <p>
         * io1: <code>100 - 64,000</code> IOPS
         * </p>
         * </li>
         * <li>
         * <p>
         * io2: <code>100 - 256,000</code> IOPS
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * <a href="https://docs.aws.amazon.com/ec2/latest/instancetypes/ec2-nitro-instances.html"> Instances built on
         * the Nitro System</a> can support up to 256,000 IOPS. Other instances can support up to 32,000 IOPS.
         * </p>
         * </note>
         * 
         * @param iops
         *        The number of I/O operations per second (IOPS) to provision for the volume copy. Required for
         *        <code>io1</code> and <code>io2</code> volumes. Optional for <code>gp3</code> volumes. Omit for all
         *        other volume types. Full provisioned IOPS performance can be achieved only once the volume copy is
         *        fully initialized. </p>
         *        <p>
         *        Valid ranges:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        gp3: <code>3,000 </code>(<i>default</i>)<code> - 80,000</code> IOPS
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        io1: <code>100 - 64,000</code> IOPS
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        io2: <code>100 - 256,000</code> IOPS
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        <a href="https://docs.aws.amazon.com/ec2/latest/instancetypes/ec2-nitro-instances.html"> Instances
         *        built on the Nitro System</a> can support up to 256,000 IOPS. Other instances can support up to 32,000
         *        IOPS.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iops(Integer iops);

        /**
         * <p>
         * The size of the volume copy, in GiBs. The size must be equal to or greater than the size of the source
         * volume. If not specified, the size defaults to the size of the source volume.
         * </p>
         * <p>
         * Maximum supported sizes:
         * </p>
         * <ul>
         * <li>
         * <p>
         * gp2: <code>16,384</code> GiB
         * </p>
         * </li>
         * <li>
         * <p>
         * gp3: <code>65,536</code> GiB
         * </p>
         * </li>
         * <li>
         * <p>
         * io1: <code>16,384</code> GiB
         * </p>
         * </li>
         * <li>
         * <p>
         * io2: <code>65,536</code> GiB
         * </p>
         * </li>
         * <li>
         * <p>
         * st1 and sc1: <code>16,384</code> GiB
         * </p>
         * </li>
         * <li>
         * <p>
         * standard: <code>1024</code> GiB
         * </p>
         * </li>
         * </ul>
         * 
         * @param size
         *        The size of the volume copy, in GiBs. The size must be equal to or greater than the size of the source
         *        volume. If not specified, the size defaults to the size of the source volume.</p>
         *        <p>
         *        Maximum supported sizes:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        gp2: <code>16,384</code> GiB
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        gp3: <code>65,536</code> GiB
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        io1: <code>16,384</code> GiB
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        io2: <code>65,536</code> GiB
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        st1 and sc1: <code>16,384</code> GiB
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        standard: <code>1024</code> GiB
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder size(Integer size);

        /**
         * <p>
         * The volume type for the volume copy. If not specified, the volume type defaults to <code>gp2</code>.
         * </p>
         * 
         * @param volumeType
         *        The volume type for the volume copy. If not specified, the volume type defaults to <code>gp2</code>.
         * @see VolumeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VolumeType
         */
        Builder volumeType(String volumeType);

        /**
         * <p>
         * The volume type for the volume copy. If not specified, the volume type defaults to <code>gp2</code>.
         * </p>
         * 
         * @param volumeType
         *        The volume type for the volume copy. If not specified, the volume type defaults to <code>gp2</code>.
         * @see VolumeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VolumeType
         */
        Builder volumeType(VolumeType volumeType);

        /**
         * <p>
         * Checks whether you have the required permissions for the action, without actually making the request, and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        Checks whether you have the required permissions for the action, without actually making the request,
         *        and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        /**
         * <p>
         * The tags to apply to the volume copy during creation.
         * </p>
         * 
         * @param tagSpecifications
         *        The tags to apply to the volume copy during creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(Collection<TagSpecification> tagSpecifications);

        /**
         * <p>
         * The tags to apply to the volume copy during creation.
         * </p>
         * 
         * @param tagSpecifications
         *        The tags to apply to the volume copy during creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(TagSpecification... tagSpecifications);

        /**
         * <p>
         * The tags to apply to the volume copy during creation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.TagSpecification.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.TagSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.TagSpecification.Builder#build()} is called immediately and
         * its result is passed to {@link #tagSpecifications(List<TagSpecification>)}.
         * 
         * @param tagSpecifications
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.TagSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagSpecifications(java.util.Collection<TagSpecification>)
         */
        Builder tagSpecifications(Consumer<TagSpecification.Builder>... tagSpecifications);

        /**
         * <p>
         * Indicates whether to enable Amazon EBS Multi-Attach for the volume copy. If you enable Multi-Attach, you can
         * attach the volume to up to 16 Nitro instances in the same Availability Zone simultaneously. Supported with
         * <code>io1</code> and <code>io2</code> volumes only. For more information, see <a
         * href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-volumes-multi.html"> Amazon EBS Multi-Attach</a>.
         * </p>
         * 
         * @param multiAttachEnabled
         *        Indicates whether to enable Amazon EBS Multi-Attach for the volume copy. If you enable Multi-Attach,
         *        you can attach the volume to up to 16 Nitro instances in the same Availability Zone simultaneously.
         *        Supported with <code>io1</code> and <code>io2</code> volumes only. For more information, see <a
         *        href="https://docs.aws.amazon.com/ebs/latest/userguide/ebs-volumes-multi.html"> Amazon EBS
         *        Multi-Attach</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiAttachEnabled(Boolean multiAttachEnabled);

        /**
         * <p>
         * The throughput to provision for the volume copy, in MiB/s. Supported for <code>gp3</code> volumes only. Omit
         * for all other volume types. Full provisioned throughput performance can be achieved only once the volume copy
         * is fully initialized.
         * </p>
         * <p>
         * Valid Range: <code>125 - 2000</code> MiB/s
         * </p>
         * <p/>
         * 
         * @param throughput
         *        The throughput to provision for the volume copy, in MiB/s. Supported for <code>gp3</code> volumes
         *        only. Omit for all other volume types. Full provisioned throughput performance can be achieved only
         *        once the volume copy is fully initialized.
         *        </p>
         *        <p>
         *        Valid Range: <code>125 - 2000</code> MiB/s
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder throughput(Integer throughput);

        /**
         * <p>
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
         * information, see <a href="https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html"> Ensure
         * Idempotency</a>.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
         *        information, see <a href="https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html">
         *        Ensure Idempotency</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String sourceVolumeId;

        private Integer iops;

        private Integer size;

        private String volumeType;

        private Boolean dryRun;

        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();

        private Boolean multiAttachEnabled;

        private Integer throughput;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CopyVolumesRequest model) {
            super(model);
            sourceVolumeId(model.sourceVolumeId);
            iops(model.iops);
            size(model.size);
            volumeType(model.volumeType);
            dryRun(model.dryRun);
            tagSpecifications(model.tagSpecifications);
            multiAttachEnabled(model.multiAttachEnabled);
            throughput(model.throughput);
            clientToken(model.clientToken);
        }

        public final String getSourceVolumeId() {
            return sourceVolumeId;
        }

        public final void setSourceVolumeId(String sourceVolumeId) {
            this.sourceVolumeId = sourceVolumeId;
        }

        @Override
        public final Builder sourceVolumeId(String sourceVolumeId) {
            this.sourceVolumeId = sourceVolumeId;
            return this;
        }

        public final Integer getIops() {
            return iops;
        }

        public final void setIops(Integer iops) {
            this.iops = iops;
        }

        @Override
        public final Builder iops(Integer iops) {
            this.iops = iops;
            return this;
        }

        public final Integer getSize() {
            return size;
        }

        public final void setSize(Integer size) {
            this.size = size;
        }

        @Override
        public final Builder size(Integer size) {
            this.size = size;
            return this;
        }

        public final String getVolumeType() {
            return volumeType;
        }

        public final void setVolumeType(String volumeType) {
            this.volumeType = volumeType;
        }

        @Override
        public final Builder volumeType(String volumeType) {
            this.volumeType = volumeType;
            return this;
        }

        @Override
        public final Builder volumeType(VolumeType volumeType) {
            this.volumeType(volumeType == null ? null : volumeType.toString());
            return this;
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final List<TagSpecification.Builder> getTagSpecifications() {
            List<TagSpecification.Builder> result = TagSpecificationListCopier.copyToBuilder(this.tagSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification... tagSpecifications) {
            tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder>... tagSpecifications) {
            tagSpecifications(Stream.of(tagSpecifications).map(c -> TagSpecification.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Boolean getMultiAttachEnabled() {
            return multiAttachEnabled;
        }

        public final void setMultiAttachEnabled(Boolean multiAttachEnabled) {
            this.multiAttachEnabled = multiAttachEnabled;
        }

        @Override
        public final Builder multiAttachEnabled(Boolean multiAttachEnabled) {
            this.multiAttachEnabled = multiAttachEnabled;
            return this;
        }

        public final Integer getThroughput() {
            return throughput;
        }

        public final void setThroughput(Integer throughput) {
            this.throughput = throughput;
        }

        @Override
        public final Builder throughput(Integer throughput) {
            this.throughput = throughput;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CopyVolumesRequest build() {
            return new CopyVolumesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
