/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.CapacityManagerDimension;
import software.amazon.awssdk.services.ec2.model.MetricValue;
import software.amazon.awssdk.services.ec2.model.MetricValueSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MetricDataResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MetricDataResult> {
    private static final SdkField<CapacityManagerDimension> DIMENSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Dimension").getter(MetricDataResult.getter(MetricDataResult::dimension)).setter(MetricDataResult.setter(Builder::dimension)).constructor(CapacityManagerDimension::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dimension").unmarshallLocationName("dimension").build()}).build();
    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("Timestamp").getter(MetricDataResult.getter(MetricDataResult::timestamp)).setter(MetricDataResult.setter(Builder::timestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamp").unmarshallLocationName("timestamp").build()}).build();
    private static final SdkField<List<MetricValue>> METRIC_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MetricValues").getter(MetricDataResult.getter(MetricDataResult::metricValues)).setter(MetricDataResult.setter(Builder::metricValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricValueSet").unmarshallLocationName("metricValueSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MetricValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIMENSION_FIELD, TIMESTAMP_FIELD, METRIC_VALUES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MetricDataResult.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final CapacityManagerDimension dimension;
    private final Instant timestamp;
    private final List<MetricValue> metricValues;

    private MetricDataResult(BuilderImpl builder) {
        this.dimension = builder.dimension;
        this.timestamp = builder.timestamp;
        this.metricValues = builder.metricValues;
    }

    public final CapacityManagerDimension dimension() {
        return this.dimension;
    }

    public final Instant timestamp() {
        return this.timestamp;
    }

    public final boolean hasMetricValues() {
        return this.metricValues != null && !(this.metricValues instanceof SdkAutoConstructList);
    }

    public final List<MetricValue> metricValues() {
        return this.metricValues;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dimension());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetricValues() ? this.metricValues() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricDataResult)) {
            return false;
        }
        MetricDataResult other = (MetricDataResult)obj;
        return Objects.equals(this.dimension(), other.dimension()) && Objects.equals(this.timestamp(), other.timestamp()) && this.hasMetricValues() == other.hasMetricValues() && Objects.equals(this.metricValues(), other.metricValues());
    }

    public final String toString() {
        return ToString.builder((String)"MetricDataResult").add("Dimension", (Object)this.dimension()).add("Timestamp", (Object)this.timestamp()).add("MetricValues", this.hasMetricValues() ? this.metricValues() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Dimension": {
                return Optional.ofNullable(clazz.cast(this.dimension()));
            }
            case "Timestamp": {
                return Optional.ofNullable(clazz.cast(this.timestamp()));
            }
            case "MetricValues": {
                return Optional.ofNullable(clazz.cast(this.metricValues()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Dimension", DIMENSION_FIELD);
        map.put("Timestamp", TIMESTAMP_FIELD);
        map.put("MetricValueSet", METRIC_VALUES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MetricDataResult, T> g) {
        return obj -> g.apply((MetricDataResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private CapacityManagerDimension dimension;
        private Instant timestamp;
        private List<MetricValue> metricValues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MetricDataResult model) {
            this.dimension(model.dimension);
            this.timestamp(model.timestamp);
            this.metricValues(model.metricValues);
        }

        public final CapacityManagerDimension.Builder getDimension() {
            return this.dimension != null ? this.dimension.toBuilder() : null;
        }

        public final void setDimension(CapacityManagerDimension.BuilderImpl dimension) {
            this.dimension = dimension != null ? dimension.build() : null;
        }

        @Override
        public final Builder dimension(CapacityManagerDimension dimension) {
            this.dimension = dimension;
            return this;
        }

        public final Instant getTimestamp() {
            return this.timestamp;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final List<MetricValue.Builder> getMetricValues() {
            List<MetricValue.Builder> result = MetricValueSetCopier.copyToBuilder(this.metricValues);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetricValues(Collection<MetricValue.BuilderImpl> metricValues) {
            this.metricValues = MetricValueSetCopier.copyFromBuilder(metricValues);
        }

        @Override
        public final Builder metricValues(Collection<MetricValue> metricValues) {
            this.metricValues = MetricValueSetCopier.copy(metricValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricValues(MetricValue ... metricValues) {
            this.metricValues(Arrays.asList(metricValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricValues(Consumer<MetricValue.Builder> ... metricValues) {
            this.metricValues(Stream.of(metricValues).map(c -> (MetricValue)((MetricValue.Builder)MetricValue.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public MetricDataResult build() {
            return new MetricDataResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MetricDataResult> {
        public Builder dimension(CapacityManagerDimension var1);

        default public Builder dimension(Consumer<CapacityManagerDimension.Builder> dimension) {
            return this.dimension((CapacityManagerDimension)((CapacityManagerDimension.Builder)CapacityManagerDimension.builder().applyMutation(dimension)).build());
        }

        public Builder timestamp(Instant var1);

        public Builder metricValues(Collection<MetricValue> var1);

        public Builder metricValues(MetricValue ... var1);

        public Builder metricValues(Consumer<MetricValue.Builder> ... var1);
    }
}

