/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RestoreSnapshotTierResponse extends Ec2Response implements
        ToCopyableBuilder<RestoreSnapshotTierResponse.Builder, RestoreSnapshotTierResponse> {
    private static final SdkField<String> SNAPSHOT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SnapshotId")
            .getter(getter(RestoreSnapshotTierResponse::snapshotId))
            .setter(setter(Builder::snapshotId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotId")
                    .unmarshallLocationName("snapshotId").build()).build();

    private static final SdkField<Instant> RESTORE_START_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("RestoreStartTime")
            .getter(getter(RestoreSnapshotTierResponse::restoreStartTime))
            .setter(setter(Builder::restoreStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestoreStartTime")
                    .unmarshallLocationName("restoreStartTime").build()).build();

    private static final SdkField<Integer> RESTORE_DURATION_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("RestoreDuration")
            .getter(getter(RestoreSnapshotTierResponse::restoreDuration))
            .setter(setter(Builder::restoreDuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestoreDuration")
                    .unmarshallLocationName("restoreDuration").build()).build();

    private static final SdkField<Boolean> IS_PERMANENT_RESTORE_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsPermanentRestore")
            .getter(getter(RestoreSnapshotTierResponse::isPermanentRestore))
            .setter(setter(Builder::isPermanentRestore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsPermanentRestore")
                    .unmarshallLocationName("isPermanentRestore").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SNAPSHOT_ID_FIELD,
            RESTORE_START_TIME_FIELD, RESTORE_DURATION_FIELD, IS_PERMANENT_RESTORE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String snapshotId;

    private final Instant restoreStartTime;

    private final Integer restoreDuration;

    private final Boolean isPermanentRestore;

    private RestoreSnapshotTierResponse(BuilderImpl builder) {
        super(builder);
        this.snapshotId = builder.snapshotId;
        this.restoreStartTime = builder.restoreStartTime;
        this.restoreDuration = builder.restoreDuration;
        this.isPermanentRestore = builder.isPermanentRestore;
    }

    /**
     * <p>
     * The ID of the snapshot.
     * </p>
     * 
     * @return The ID of the snapshot.
     */
    public final String snapshotId() {
        return snapshotId;
    }

    /**
     * <p>
     * The date and time when the snapshot restore process started.
     * </p>
     * 
     * @return The date and time when the snapshot restore process started.
     */
    public final Instant restoreStartTime() {
        return restoreStartTime;
    }

    /**
     * <p>
     * For temporary restores only. The number of days for which the archived snapshot is temporarily restored.
     * </p>
     * 
     * @return For temporary restores only. The number of days for which the archived snapshot is temporarily restored.
     */
    public final Integer restoreDuration() {
        return restoreDuration;
    }

    /**
     * <p>
     * Indicates whether the snapshot is permanently restored. <code>true</code> indicates a permanent restore.
     * <code>false</code> indicates a temporary restore.
     * </p>
     * 
     * @return Indicates whether the snapshot is permanently restored. <code>true</code> indicates a permanent restore.
     *         <code>false</code> indicates a temporary restore.
     */
    public final Boolean isPermanentRestore() {
        return isPermanentRestore;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(snapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(restoreStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(restoreDuration());
        hashCode = 31 * hashCode + Objects.hashCode(isPermanentRestore());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestoreSnapshotTierResponse)) {
            return false;
        }
        RestoreSnapshotTierResponse other = (RestoreSnapshotTierResponse) obj;
        return Objects.equals(snapshotId(), other.snapshotId()) && Objects.equals(restoreStartTime(), other.restoreStartTime())
                && Objects.equals(restoreDuration(), other.restoreDuration())
                && Objects.equals(isPermanentRestore(), other.isPermanentRestore());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RestoreSnapshotTierResponse").add("SnapshotId", snapshotId())
                .add("RestoreStartTime", restoreStartTime()).add("RestoreDuration", restoreDuration())
                .add("IsPermanentRestore", isPermanentRestore()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SnapshotId":
            return Optional.ofNullable(clazz.cast(snapshotId()));
        case "RestoreStartTime":
            return Optional.ofNullable(clazz.cast(restoreStartTime()));
        case "RestoreDuration":
            return Optional.ofNullable(clazz.cast(restoreDuration()));
        case "IsPermanentRestore":
            return Optional.ofNullable(clazz.cast(isPermanentRestore()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SnapshotId", SNAPSHOT_ID_FIELD);
        map.put("RestoreStartTime", RESTORE_START_TIME_FIELD);
        map.put("RestoreDuration", RESTORE_DURATION_FIELD);
        map.put("IsPermanentRestore", IS_PERMANENT_RESTORE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RestoreSnapshotTierResponse, T> g) {
        return obj -> g.apply((RestoreSnapshotTierResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, RestoreSnapshotTierResponse> {
        /**
         * <p>
         * The ID of the snapshot.
         * </p>
         * 
         * @param snapshotId
         *        The ID of the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotId(String snapshotId);

        /**
         * <p>
         * The date and time when the snapshot restore process started.
         * </p>
         * 
         * @param restoreStartTime
         *        The date and time when the snapshot restore process started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restoreStartTime(Instant restoreStartTime);

        /**
         * <p>
         * For temporary restores only. The number of days for which the archived snapshot is temporarily restored.
         * </p>
         * 
         * @param restoreDuration
         *        For temporary restores only. The number of days for which the archived snapshot is temporarily
         *        restored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restoreDuration(Integer restoreDuration);

        /**
         * <p>
         * Indicates whether the snapshot is permanently restored. <code>true</code> indicates a permanent restore.
         * <code>false</code> indicates a temporary restore.
         * </p>
         * 
         * @param isPermanentRestore
         *        Indicates whether the snapshot is permanently restored. <code>true</code> indicates a permanent
         *        restore. <code>false</code> indicates a temporary restore.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isPermanentRestore(Boolean isPermanentRestore);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private String snapshotId;

        private Instant restoreStartTime;

        private Integer restoreDuration;

        private Boolean isPermanentRestore;

        private BuilderImpl() {
        }

        private BuilderImpl(RestoreSnapshotTierResponse model) {
            super(model);
            snapshotId(model.snapshotId);
            restoreStartTime(model.restoreStartTime);
            restoreDuration(model.restoreDuration);
            isPermanentRestore(model.isPermanentRestore);
        }

        public final String getSnapshotId() {
            return snapshotId;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final Instant getRestoreStartTime() {
            return restoreStartTime;
        }

        public final void setRestoreStartTime(Instant restoreStartTime) {
            this.restoreStartTime = restoreStartTime;
        }

        @Override
        public final Builder restoreStartTime(Instant restoreStartTime) {
            this.restoreStartTime = restoreStartTime;
            return this;
        }

        public final Integer getRestoreDuration() {
            return restoreDuration;
        }

        public final void setRestoreDuration(Integer restoreDuration) {
            this.restoreDuration = restoreDuration;
        }

        @Override
        public final Builder restoreDuration(Integer restoreDuration) {
            this.restoreDuration = restoreDuration;
            return this;
        }

        public final Boolean getIsPermanentRestore() {
            return isPermanentRestore;
        }

        public final void setIsPermanentRestore(Boolean isPermanentRestore) {
            this.isPermanentRestore = isPermanentRestore;
        }

        @Override
        public final Builder isPermanentRestore(Boolean isPermanentRestore) {
            this.isPermanentRestore = isPermanentRestore;
            return this;
        }

        @Override
        public RestoreSnapshotTierResponse build() {
            return new RestoreSnapshotTierResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
