/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeHostReservationOfferingsRequest extends Ec2Request implements
        ToCopyableBuilder<DescribeHostReservationOfferingsRequest.Builder, DescribeHostReservationOfferingsRequest> {
    private static final SdkField<List<Filter>> FILTER_FIELD = SdkField
            .<List<Filter>> builder(MarshallingType.LIST)
            .memberName("Filter")
            .getter(getter(DescribeHostReservationOfferingsRequest::filter))
            .setter(setter(Builder::filter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter")
                    .unmarshallLocationName("Filter").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Filter")
                            .memberFieldInfo(
                                    SdkField.<Filter> builder(MarshallingType.SDK_POJO)
                                            .constructor(Filter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Filter").unmarshallLocationName("Filter").build()).build())
                            .build()).build();

    private static final SdkField<Integer> MAX_DURATION_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxDuration")
            .getter(getter(DescribeHostReservationOfferingsRequest::maxDuration))
            .setter(setter(Builder::maxDuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxDuration")
                    .unmarshallLocationName("MaxDuration").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults")
            .getter(getter(DescribeHostReservationOfferingsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults")
                    .unmarshallLocationName("MaxResults").build()).build();

    private static final SdkField<Integer> MIN_DURATION_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("MinDuration")
            .getter(getter(DescribeHostReservationOfferingsRequest::minDuration))
            .setter(setter(Builder::minDuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinDuration")
                    .unmarshallLocationName("MinDuration").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(DescribeHostReservationOfferingsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("NextToken").build()).build();

    private static final SdkField<String> OFFERING_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OfferingId")
            .getter(getter(DescribeHostReservationOfferingsRequest::offeringId))
            .setter(setter(Builder::offeringId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OfferingId")
                    .unmarshallLocationName("OfferingId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_FIELD,
            MAX_DURATION_FIELD, MAX_RESULTS_FIELD, MIN_DURATION_FIELD, NEXT_TOKEN_FIELD, OFFERING_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<Filter> filter;

    private final Integer maxDuration;

    private final Integer maxResults;

    private final Integer minDuration;

    private final String nextToken;

    private final String offeringId;

    private DescribeHostReservationOfferingsRequest(BuilderImpl builder) {
        super(builder);
        this.filter = builder.filter;
        this.maxDuration = builder.maxDuration;
        this.maxResults = builder.maxResults;
        this.minDuration = builder.minDuration;
        this.nextToken = builder.nextToken;
        this.offeringId = builder.offeringId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Filter property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilter() {
        return filter != null && !(filter instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The filters.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>instance-family</code> - The instance family of the offering (for example, <code>m4</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>payment-option</code> - The payment option (<code>NoUpfront</code> | <code>PartialUpfront</code> |
     * <code>AllUpfront</code>).
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilter} method.
     * </p>
     * 
     * @return The filters.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>instance-family</code> - The instance family of the offering (for example, <code>m4</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>payment-option</code> - The payment option (<code>NoUpfront</code> | <code>PartialUpfront</code> |
     *         <code>AllUpfront</code>).
     *         </p>
     *         </li>
     */
    public final List<Filter> filter() {
        return filter;
    }

    /**
     * <p>
     * This is the maximum duration of the reservation to purchase, specified in seconds. Reservations are available in
     * one-year and three-year terms. The number of seconds specified must be the number of seconds in a year
     * (365x24x60x60) times one of the supported durations (1 or 3). For example, specify 94608000 for three years.
     * </p>
     * 
     * @return This is the maximum duration of the reservation to purchase, specified in seconds. Reservations are
     *         available in one-year and three-year terms. The number of seconds specified must be the number of seconds
     *         in a year (365x24x60x60) times one of the supported durations (1 or 3). For example, specify 94608000 for
     *         three years.
     */
    public final Integer maxDuration() {
        return maxDuration;
    }

    /**
     * <p>
     * The maximum number of results to return for the request in a single page. The remaining results can be seen by
     * sending another request with the returned <code>nextToken</code> value. This value can be between 5 and 500. If
     * <code>maxResults</code> is given a larger value than 500, you receive an error.
     * </p>
     * 
     * @return The maximum number of results to return for the request in a single page. The remaining results can be
     *         seen by sending another request with the returned <code>nextToken</code> value. This value can be between
     *         5 and 500. If <code>maxResults</code> is given a larger value than 500, you receive an error.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * This is the minimum duration of the reservation you'd like to purchase, specified in seconds. Reservations are
     * available in one-year and three-year terms. The number of seconds specified must be the number of seconds in a
     * year (365x24x60x60) times one of the supported durations (1 or 3). For example, specify 31536000 for one year.
     * </p>
     * 
     * @return This is the minimum duration of the reservation you'd like to purchase, specified in seconds.
     *         Reservations are available in one-year and three-year terms. The number of seconds specified must be the
     *         number of seconds in a year (365x24x60x60) times one of the supported durations (1 or 3). For example,
     *         specify 31536000 for one year.
     */
    public final Integer minDuration() {
        return minDuration;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The ID of the reservation offering.
     * </p>
     * 
     * @return The ID of the reservation offering.
     */
    public final String offeringId() {
        return offeringId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasFilter() ? filter() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxDuration());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(minDuration());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(offeringId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeHostReservationOfferingsRequest)) {
            return false;
        }
        DescribeHostReservationOfferingsRequest other = (DescribeHostReservationOfferingsRequest) obj;
        return hasFilter() == other.hasFilter() && Objects.equals(filter(), other.filter())
                && Objects.equals(maxDuration(), other.maxDuration()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(minDuration(), other.minDuration()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(offeringId(), other.offeringId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeHostReservationOfferingsRequest").add("Filter", hasFilter() ? filter() : null)
                .add("MaxDuration", maxDuration()).add("MaxResults", maxResults()).add("MinDuration", minDuration())
                .add("NextToken", nextToken()).add("OfferingId", offeringId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Filter":
            return Optional.ofNullable(clazz.cast(filter()));
        case "MaxDuration":
            return Optional.ofNullable(clazz.cast(maxDuration()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "MinDuration":
            return Optional.ofNullable(clazz.cast(minDuration()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "OfferingId":
            return Optional.ofNullable(clazz.cast(offeringId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Filter", FILTER_FIELD);
        map.put("MaxDuration", MAX_DURATION_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("MinDuration", MIN_DURATION_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("OfferingId", OFFERING_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeHostReservationOfferingsRequest, T> g) {
        return obj -> g.apply((DescribeHostReservationOfferingsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Ec2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeHostReservationOfferingsRequest> {
        /**
         * <p>
         * The filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>instance-family</code> - The instance family of the offering (for example, <code>m4</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>payment-option</code> - The payment option (<code>NoUpfront</code> | <code>PartialUpfront</code> |
         * <code>AllUpfront</code>).
         * </p>
         * </li>
         * </ul>
         * 
         * @param filter
         *        The filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>instance-family</code> - The instance family of the offering (for example, <code>m4</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>payment-option</code> - The payment option (<code>NoUpfront</code> | <code>PartialUpfront</code>
         *        | <code>AllUpfront</code>).
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filter(Collection<Filter> filter);

        /**
         * <p>
         * The filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>instance-family</code> - The instance family of the offering (for example, <code>m4</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>payment-option</code> - The payment option (<code>NoUpfront</code> | <code>PartialUpfront</code> |
         * <code>AllUpfront</code>).
         * </p>
         * </li>
         * </ul>
         * 
         * @param filter
         *        The filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>instance-family</code> - The instance family of the offering (for example, <code>m4</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>payment-option</code> - The payment option (<code>NoUpfront</code> | <code>PartialUpfront</code>
         *        | <code>AllUpfront</code>).
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filter(Filter... filter);

        /**
         * <p>
         * The filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>instance-family</code> - The instance family of the offering (for example, <code>m4</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>payment-option</code> - The payment option (<code>NoUpfront</code> | <code>PartialUpfront</code> |
         * <code>AllUpfront</code>).
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.Filter.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.Filter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.ec2.model.Filter.Builder#build()}
         * is called immediately and its result is passed to {@link #filter(List<Filter>)}.
         * 
         * @param filter
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.ec2.model.Filter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filter(java.util.Collection<Filter>)
         */
        Builder filter(Consumer<Filter.Builder>... filter);

        /**
         * <p>
         * This is the maximum duration of the reservation to purchase, specified in seconds. Reservations are available
         * in one-year and three-year terms. The number of seconds specified must be the number of seconds in a year
         * (365x24x60x60) times one of the supported durations (1 or 3). For example, specify 94608000 for three years.
         * </p>
         * 
         * @param maxDuration
         *        This is the maximum duration of the reservation to purchase, specified in seconds. Reservations are
         *        available in one-year and three-year terms. The number of seconds specified must be the number of
         *        seconds in a year (365x24x60x60) times one of the supported durations (1 or 3). For example, specify
         *        94608000 for three years.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxDuration(Integer maxDuration);

        /**
         * <p>
         * The maximum number of results to return for the request in a single page. The remaining results can be seen
         * by sending another request with the returned <code>nextToken</code> value. This value can be between 5 and
         * 500. If <code>maxResults</code> is given a larger value than 500, you receive an error.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return for the request in a single page. The remaining results can be
         *        seen by sending another request with the returned <code>nextToken</code> value. This value can be
         *        between 5 and 500. If <code>maxResults</code> is given a larger value than 500, you receive an error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * This is the minimum duration of the reservation you'd like to purchase, specified in seconds. Reservations
         * are available in one-year and three-year terms. The number of seconds specified must be the number of seconds
         * in a year (365x24x60x60) times one of the supported durations (1 or 3). For example, specify 31536000 for one
         * year.
         * </p>
         * 
         * @param minDuration
         *        This is the minimum duration of the reservation you'd like to purchase, specified in seconds.
         *        Reservations are available in one-year and three-year terms. The number of seconds specified must be
         *        the number of seconds in a year (365x24x60x60) times one of the supported durations (1 or 3). For
         *        example, specify 31536000 for one year.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minDuration(Integer minDuration);

        /**
         * <p>
         * The token to use to retrieve the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The ID of the reservation offering.
         * </p>
         * 
         * @param offeringId
         *        The ID of the reservation offering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offeringId(String offeringId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private List<Filter> filter = DefaultSdkAutoConstructList.getInstance();

        private Integer maxDuration;

        private Integer maxResults;

        private Integer minDuration;

        private String nextToken;

        private String offeringId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeHostReservationOfferingsRequest model) {
            super(model);
            filter(model.filter);
            maxDuration(model.maxDuration);
            maxResults(model.maxResults);
            minDuration(model.minDuration);
            nextToken(model.nextToken);
            offeringId(model.offeringId);
        }

        public final List<Filter.Builder> getFilter() {
            List<Filter.Builder> result = FilterListCopier.copyToBuilder(this.filter);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilter(Collection<Filter.BuilderImpl> filter) {
            this.filter = FilterListCopier.copyFromBuilder(filter);
        }

        @Override
        public final Builder filter(Collection<Filter> filter) {
            this.filter = FilterListCopier.copy(filter);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filter(Filter... filter) {
            filter(Arrays.asList(filter));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filter(Consumer<Filter.Builder>... filter) {
            filter(Stream.of(filter).map(c -> Filter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getMaxDuration() {
            return maxDuration;
        }

        public final void setMaxDuration(Integer maxDuration) {
            this.maxDuration = maxDuration;
        }

        @Override
        public final Builder maxDuration(Integer maxDuration) {
            this.maxDuration = maxDuration;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final Integer getMinDuration() {
            return minDuration;
        }

        public final void setMinDuration(Integer minDuration) {
            this.minDuration = minDuration;
        }

        @Override
        public final Builder minDuration(Integer minDuration) {
            this.minDuration = minDuration;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getOfferingId() {
            return offeringId;
        }

        public final void setOfferingId(String offeringId) {
            this.offeringId = offeringId;
        }

        @Override
        public final Builder offeringId(String offeringId) {
            this.offeringId = offeringId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeHostReservationOfferingsRequest build() {
            return new DescribeHostReservationOfferingsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
