/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.ImageRecycleBinInfo;
import software.amazon.awssdk.services.ec2.model.ListImagesInRecycleBinRequest;
import software.amazon.awssdk.services.ec2.model.ListImagesInRecycleBinResponse;

public class ListImagesInRecycleBinIterable
implements SdkIterable<ListImagesInRecycleBinResponse> {
    private final Ec2Client client;
    private final ListImagesInRecycleBinRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListImagesInRecycleBinIterable(Ec2Client client, ListImagesInRecycleBinRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListImagesInRecycleBinResponseFetcher();
    }

    public Iterator<ListImagesInRecycleBinResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ImageRecycleBinInfo> images() {
        Function<ListImagesInRecycleBinResponse, Iterator> getIterator = response -> {
            if (response != null && response.images() != null) {
                return response.images().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListImagesInRecycleBinResponseFetcher
    implements SyncPageFetcher<ListImagesInRecycleBinResponse> {
        private ListImagesInRecycleBinResponseFetcher() {
        }

        public boolean hasNextPage(ListImagesInRecycleBinResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListImagesInRecycleBinResponse nextPage(ListImagesInRecycleBinResponse previousPage) {
            if (previousPage == null) {
                return ListImagesInRecycleBinIterable.this.client.listImagesInRecycleBin(ListImagesInRecycleBinIterable.this.firstRequest);
            }
            return ListImagesInRecycleBinIterable.this.client.listImagesInRecycleBin((ListImagesInRecycleBinRequest)((Object)ListImagesInRecycleBinIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

