/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.CapacityBlockExtension;
import software.amazon.awssdk.services.ec2.model.DescribeCapacityBlockExtensionHistoryRequest;
import software.amazon.awssdk.services.ec2.model.DescribeCapacityBlockExtensionHistoryResponse;

public class DescribeCapacityBlockExtensionHistoryIterable
implements SdkIterable<DescribeCapacityBlockExtensionHistoryResponse> {
    private final Ec2Client client;
    private final DescribeCapacityBlockExtensionHistoryRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeCapacityBlockExtensionHistoryIterable(Ec2Client client, DescribeCapacityBlockExtensionHistoryRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeCapacityBlockExtensionHistoryResponseFetcher();
    }

    public Iterator<DescribeCapacityBlockExtensionHistoryResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<CapacityBlockExtension> capacityBlockExtensions() {
        Function<DescribeCapacityBlockExtensionHistoryResponse, Iterator> getIterator = response -> {
            if (response != null && response.capacityBlockExtensions() != null) {
                return response.capacityBlockExtensions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeCapacityBlockExtensionHistoryResponseFetcher
    implements SyncPageFetcher<DescribeCapacityBlockExtensionHistoryResponse> {
        private DescribeCapacityBlockExtensionHistoryResponseFetcher() {
        }

        public boolean hasNextPage(DescribeCapacityBlockExtensionHistoryResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeCapacityBlockExtensionHistoryResponse nextPage(DescribeCapacityBlockExtensionHistoryResponse previousPage) {
            if (previousPage == null) {
                return DescribeCapacityBlockExtensionHistoryIterable.this.client.describeCapacityBlockExtensionHistory(DescribeCapacityBlockExtensionHistoryIterable.this.firstRequest);
            }
            return DescribeCapacityBlockExtensionHistoryIterable.this.client.describeCapacityBlockExtensionHistory((DescribeCapacityBlockExtensionHistoryRequest)((Object)DescribeCapacityBlockExtensionHistoryIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

