/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.IpamAddressHistoryRecord;
import software.amazon.awssdk.services.ec2.model.IpamAddressHistoryRecordSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetIpamAddressHistoryResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, GetIpamAddressHistoryResponse> {
    private static final SdkField<List<IpamAddressHistoryRecord>> HISTORY_RECORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("HistoryRecords").getter(GetIpamAddressHistoryResponse.getter(GetIpamAddressHistoryResponse::historyRecords)).setter(GetIpamAddressHistoryResponse.setter(Builder::historyRecords)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HistoryRecordSet").unmarshallLocationName("historyRecordSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IpamAddressHistoryRecord::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetIpamAddressHistoryResponse.getter(GetIpamAddressHistoryResponse::nextToken)).setter(GetIpamAddressHistoryResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HISTORY_RECORDS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetIpamAddressHistoryResponse.memberNameToFieldInitializer();
    private final List<IpamAddressHistoryRecord> historyRecords;
    private final String nextToken;

    private GetIpamAddressHistoryResponse(BuilderImpl builder) {
        super(builder);
        this.historyRecords = builder.historyRecords;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasHistoryRecords() {
        return this.historyRecords != null && !(this.historyRecords instanceof SdkAutoConstructList);
    }

    public final List<IpamAddressHistoryRecord> historyRecords() {
        return this.historyRecords;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHistoryRecords() ? this.historyRecords() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIpamAddressHistoryResponse)) {
            return false;
        }
        GetIpamAddressHistoryResponse other = (GetIpamAddressHistoryResponse)((Object)obj);
        return this.hasHistoryRecords() == other.hasHistoryRecords() && Objects.equals(this.historyRecords(), other.historyRecords()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetIpamAddressHistoryResponse").add("HistoryRecords", this.hasHistoryRecords() ? this.historyRecords() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HistoryRecords": {
                return Optional.ofNullable(clazz.cast(this.historyRecords()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("HistoryRecordSet", HISTORY_RECORDS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetIpamAddressHistoryResponse, T> g) {
        return obj -> g.apply((GetIpamAddressHistoryResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<IpamAddressHistoryRecord> historyRecords = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetIpamAddressHistoryResponse model) {
            super(model);
            this.historyRecords(model.historyRecords);
            this.nextToken(model.nextToken);
        }

        public final List<IpamAddressHistoryRecord.Builder> getHistoryRecords() {
            List<IpamAddressHistoryRecord.Builder> result = IpamAddressHistoryRecordSetCopier.copyToBuilder(this.historyRecords);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setHistoryRecords(Collection<IpamAddressHistoryRecord.BuilderImpl> historyRecords) {
            this.historyRecords = IpamAddressHistoryRecordSetCopier.copyFromBuilder(historyRecords);
        }

        @Override
        public final Builder historyRecords(Collection<IpamAddressHistoryRecord> historyRecords) {
            this.historyRecords = IpamAddressHistoryRecordSetCopier.copy(historyRecords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder historyRecords(IpamAddressHistoryRecord ... historyRecords) {
            this.historyRecords(Arrays.asList(historyRecords));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder historyRecords(Consumer<IpamAddressHistoryRecord.Builder> ... historyRecords) {
            this.historyRecords(Stream.of(historyRecords).map(c -> (IpamAddressHistoryRecord)((IpamAddressHistoryRecord.Builder)IpamAddressHistoryRecord.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetIpamAddressHistoryResponse build() {
            return new GetIpamAddressHistoryResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetIpamAddressHistoryResponse> {
        public Builder historyRecords(Collection<IpamAddressHistoryRecord> var1);

        public Builder historyRecords(IpamAddressHistoryRecord ... var1);

        public Builder historyRecords(Consumer<IpamAddressHistoryRecord.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

