/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specify an instance family to use as the baseline reference for CPU performance. All instance types that match your
 * specified attributes will be compared against the CPU performance of the referenced instance family, regardless of
 * CPU manufacturer or architecture.
 * </p>
 * <note>
 * <p>
 * Currently, only one instance family can be specified in the list.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PerformanceFactorReference implements SdkPojo, Serializable,
        ToCopyableBuilder<PerformanceFactorReference.Builder, PerformanceFactorReference> {
    private static final SdkField<String> INSTANCE_FAMILY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InstanceFamily")
            .getter(getter(PerformanceFactorReference::instanceFamily))
            .setter(setter(Builder::instanceFamily))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceFamily")
                    .unmarshallLocationName("instanceFamily").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_FAMILY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String instanceFamily;

    private PerformanceFactorReference(BuilderImpl builder) {
        this.instanceFamily = builder.instanceFamily;
    }

    /**
     * <p>
     * The instance family to use as a baseline reference.
     * </p>
     * <note>
     * <p>
     * Ensure that you specify the correct value for the instance family. The instance family is everything before the
     * period (<code>.</code>) in the instance type name. For example, in the instance type <code>c6i.large</code>, the
     * instance family is <code>c6i</code>, not <code>c6</code>. For more information, see <a
     * href="https://docs.aws.amazon.com/ec2/latest/instancetypes/instance-type-names.html">Amazon EC2 instance type
     * naming conventions</a> in <i>Amazon EC2 Instance Types</i>.
     * </p>
     * </note>
     * <p>
     * The following instance families are <i>not supported</i> for performance protection:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>c1</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>g3</code> | <code>g3s</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>hpc7g</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>m1</code> | <code>m2</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>mac1</code> | <code>mac2</code> | <code>mac2-m1ultra</code> | <code>mac2-m2</code> |
     * <code>mac2-m2pro</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>p3dn</code> | <code>p4d</code> | <code>p5</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>t1</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>u-12tb1</code> | <code>u-18tb1</code> | <code>u-24tb1</code> | <code>u-3tb1</code> | <code>u-6tb1</code> |
     * <code>u-9tb1</code> | <code>u7i-12tb</code> | <code>u7in-16tb</code> | <code>u7in-24tb</code> |
     * <code>u7in-32tb</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you enable performance protection by specifying a supported instance family, the returned instance types will
     * exclude the above unsupported instance families.
     * </p>
     * <p>
     * If you specify an unsupported instance family as a value for baseline performance, the API returns an empty
     * response for <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetInstanceTypesFromInstanceRequirements"
     * >GetInstanceTypesFromInstanceRequirements</a> and an exception for <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateFleet">CreateFleet</a>, <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RequestSpotFleet">RequestSpotFleet</a>, <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyFleet">ModifyFleet</a>, and <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifySpotFleetRequest"
     * >ModifySpotFleetRequest</a>.
     * </p>
     * 
     * @return The instance family to use as a baseline reference.</p> <note>
     *         <p>
     *         Ensure that you specify the correct value for the instance family. The instance family is everything
     *         before the period (<code>.</code>) in the instance type name. For example, in the instance type
     *         <code>c6i.large</code>, the instance family is <code>c6i</code>, not <code>c6</code>. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/ec2/latest/instancetypes/instance-type-names.html">Amazon EC2 instance
     *         type naming conventions</a> in <i>Amazon EC2 Instance Types</i>.
     *         </p>
     *         </note>
     *         <p>
     *         The following instance families are <i>not supported</i> for performance protection:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>c1</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>g3</code> | <code>g3s</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>hpc7g</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>m1</code> | <code>m2</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>mac1</code> | <code>mac2</code> | <code>mac2-m1ultra</code> | <code>mac2-m2</code> |
     *         <code>mac2-m2pro</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>p3dn</code> | <code>p4d</code> | <code>p5</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>t1</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>u-12tb1</code> | <code>u-18tb1</code> | <code>u-24tb1</code> | <code>u-3tb1</code> |
     *         <code>u-6tb1</code> | <code>u-9tb1</code> | <code>u7i-12tb</code> | <code>u7in-16tb</code> |
     *         <code>u7in-24tb</code> | <code>u7in-32tb</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If you enable performance protection by specifying a supported instance family, the returned instance
     *         types will exclude the above unsupported instance families.
     *         </p>
     *         <p>
     *         If you specify an unsupported instance family as a value for baseline performance, the API returns an
     *         empty response for <a href=
     *         "https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetInstanceTypesFromInstanceRequirements"
     *         >GetInstanceTypesFromInstanceRequirements</a> and an exception for <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateFleet">CreateFleet</a>, <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RequestSpotFleet">RequestSpotFleet</a>,
     *         <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyFleet">ModifyFleet</a>, and <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifySpotFleetRequest">
     *         ModifySpotFleetRequest</a>.
     */
    public final String instanceFamily() {
        return instanceFamily;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceFamily());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PerformanceFactorReference)) {
            return false;
        }
        PerformanceFactorReference other = (PerformanceFactorReference) obj;
        return Objects.equals(instanceFamily(), other.instanceFamily());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PerformanceFactorReference").add("InstanceFamily", instanceFamily()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceFamily":
            return Optional.ofNullable(clazz.cast(instanceFamily()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InstanceFamily", INSTANCE_FAMILY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PerformanceFactorReference, T> g) {
        return obj -> g.apply((PerformanceFactorReference) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PerformanceFactorReference> {
        /**
         * <p>
         * The instance family to use as a baseline reference.
         * </p>
         * <note>
         * <p>
         * Ensure that you specify the correct value for the instance family. The instance family is everything before
         * the period (<code>.</code>) in the instance type name. For example, in the instance type
         * <code>c6i.large</code>, the instance family is <code>c6i</code>, not <code>c6</code>. For more information,
         * see <a href="https://docs.aws.amazon.com/ec2/latest/instancetypes/instance-type-names.html">Amazon EC2
         * instance type naming conventions</a> in <i>Amazon EC2 Instance Types</i>.
         * </p>
         * </note>
         * <p>
         * The following instance families are <i>not supported</i> for performance protection:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>c1</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>g3</code> | <code>g3s</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>hpc7g</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>m1</code> | <code>m2</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>mac1</code> | <code>mac2</code> | <code>mac2-m1ultra</code> | <code>mac2-m2</code> |
         * <code>mac2-m2pro</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>p3dn</code> | <code>p4d</code> | <code>p5</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>t1</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>u-12tb1</code> | <code>u-18tb1</code> | <code>u-24tb1</code> | <code>u-3tb1</code> |
         * <code>u-6tb1</code> | <code>u-9tb1</code> | <code>u7i-12tb</code> | <code>u7in-16tb</code> |
         * <code>u7in-24tb</code> | <code>u7in-32tb</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * If you enable performance protection by specifying a supported instance family, the returned instance types
         * will exclude the above unsupported instance families.
         * </p>
         * <p>
         * If you specify an unsupported instance family as a value for baseline performance, the API returns an empty
         * response for <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetInstanceTypesFromInstanceRequirements"
         * >GetInstanceTypesFromInstanceRequirements</a> and an exception for <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateFleet">CreateFleet</a>, <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RequestSpotFleet">RequestSpotFleet</a>, <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyFleet">ModifyFleet</a>, and <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifySpotFleetRequest"
         * >ModifySpotFleetRequest</a>.
         * </p>
         * 
         * @param instanceFamily
         *        The instance family to use as a baseline reference.</p> <note>
         *        <p>
         *        Ensure that you specify the correct value for the instance family. The instance family is everything
         *        before the period (<code>.</code>) in the instance type name. For example, in the instance type
         *        <code>c6i.large</code>, the instance family is <code>c6i</code>, not <code>c6</code>. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/ec2/latest/instancetypes/instance-type-names.html">Amazon EC2
         *        instance type naming conventions</a> in <i>Amazon EC2 Instance Types</i>.
         *        </p>
         *        </note>
         *        <p>
         *        The following instance families are <i>not supported</i> for performance protection:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>c1</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>g3</code> | <code>g3s</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>hpc7g</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>m1</code> | <code>m2</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>mac1</code> | <code>mac2</code> | <code>mac2-m1ultra</code> | <code>mac2-m2</code> |
         *        <code>mac2-m2pro</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>p3dn</code> | <code>p4d</code> | <code>p5</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>t1</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>u-12tb1</code> | <code>u-18tb1</code> | <code>u-24tb1</code> | <code>u-3tb1</code> |
         *        <code>u-6tb1</code> | <code>u-9tb1</code> | <code>u7i-12tb</code> | <code>u7in-16tb</code> |
         *        <code>u7in-24tb</code> | <code>u7in-32tb</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If you enable performance protection by specifying a supported instance family, the returned instance
         *        types will exclude the above unsupported instance families.
         *        </p>
         *        <p>
         *        If you specify an unsupported instance family as a value for baseline performance, the API returns an
         *        empty response for <a href=
         *        "https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetInstanceTypesFromInstanceRequirements"
         *        >GetInstanceTypesFromInstanceRequirements</a> and an exception for <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateFleet">CreateFleet</a>, <a
         *        href=
         *        "https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RequestSpotFleet">RequestSpotFleet</a>, <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyFleet">ModifyFleet</a>, and <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifySpotFleetRequest">
         *        ModifySpotFleetRequest</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceFamily(String instanceFamily);
    }

    static final class BuilderImpl implements Builder {
        private String instanceFamily;

        private BuilderImpl() {
        }

        private BuilderImpl(PerformanceFactorReference model) {
            instanceFamily(model.instanceFamily);
        }

        public final String getInstanceFamily() {
            return instanceFamily;
        }

        public final void setInstanceFamily(String instanceFamily) {
            this.instanceFamily = instanceFamily;
        }

        @Override
        public final Builder instanceFamily(String instanceFamily) {
            this.instanceFamily = instanceFamily;
            return this;
        }

        @Override
        public PerformanceFactorReference build() {
            return new PerformanceFactorReference(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
