/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.InstanceTagKeySetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstanceTagNotificationAttribute
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InstanceTagNotificationAttribute> {
    private static final SdkField<List<String>> INSTANCE_TAG_KEYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InstanceTagKeys").getter(InstanceTagNotificationAttribute.getter(InstanceTagNotificationAttribute::instanceTagKeys)).setter(InstanceTagNotificationAttribute.setter(Builder::instanceTagKeys)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceTagKeySet").unmarshallLocationName("instanceTagKeySet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<Boolean> INCLUDE_ALL_TAGS_OF_INSTANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IncludeAllTagsOfInstance").getter(InstanceTagNotificationAttribute.getter(InstanceTagNotificationAttribute::includeAllTagsOfInstance)).setter(InstanceTagNotificationAttribute.setter(Builder::includeAllTagsOfInstance)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeAllTagsOfInstance").unmarshallLocationName("includeAllTagsOfInstance").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_TAG_KEYS_FIELD, INCLUDE_ALL_TAGS_OF_INSTANCE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InstanceTagNotificationAttribute.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> instanceTagKeys;
    private final Boolean includeAllTagsOfInstance;

    private InstanceTagNotificationAttribute(BuilderImpl builder) {
        this.instanceTagKeys = builder.instanceTagKeys;
        this.includeAllTagsOfInstance = builder.includeAllTagsOfInstance;
    }

    public final boolean hasInstanceTagKeys() {
        return this.instanceTagKeys != null && !(this.instanceTagKeys instanceof SdkAutoConstructList);
    }

    public final List<String> instanceTagKeys() {
        return this.instanceTagKeys;
    }

    public final Boolean includeAllTagsOfInstance() {
        return this.includeAllTagsOfInstance;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstanceTagKeys() ? this.instanceTagKeys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.includeAllTagsOfInstance());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceTagNotificationAttribute)) {
            return false;
        }
        InstanceTagNotificationAttribute other = (InstanceTagNotificationAttribute)obj;
        return this.hasInstanceTagKeys() == other.hasInstanceTagKeys() && Objects.equals(this.instanceTagKeys(), other.instanceTagKeys()) && Objects.equals(this.includeAllTagsOfInstance(), other.includeAllTagsOfInstance());
    }

    public final String toString() {
        return ToString.builder((String)"InstanceTagNotificationAttribute").add("InstanceTagKeys", this.hasInstanceTagKeys() ? this.instanceTagKeys() : null).add("IncludeAllTagsOfInstance", (Object)this.includeAllTagsOfInstance()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceTagKeys": {
                return Optional.ofNullable(clazz.cast(this.instanceTagKeys()));
            }
            case "IncludeAllTagsOfInstance": {
                return Optional.ofNullable(clazz.cast(this.includeAllTagsOfInstance()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("InstanceTagKeySet", INSTANCE_TAG_KEYS_FIELD);
        map.put("IncludeAllTagsOfInstance", INCLUDE_ALL_TAGS_OF_INSTANCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InstanceTagNotificationAttribute, T> g) {
        return obj -> g.apply((InstanceTagNotificationAttribute)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> instanceTagKeys = DefaultSdkAutoConstructList.getInstance();
        private Boolean includeAllTagsOfInstance;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceTagNotificationAttribute model) {
            this.instanceTagKeys(model.instanceTagKeys);
            this.includeAllTagsOfInstance(model.includeAllTagsOfInstance);
        }

        public final Collection<String> getInstanceTagKeys() {
            if (this.instanceTagKeys instanceof SdkAutoConstructList) {
                return null;
            }
            return this.instanceTagKeys;
        }

        public final void setInstanceTagKeys(Collection<String> instanceTagKeys) {
            this.instanceTagKeys = InstanceTagKeySetCopier.copy(instanceTagKeys);
        }

        @Override
        public final Builder instanceTagKeys(Collection<String> instanceTagKeys) {
            this.instanceTagKeys = InstanceTagKeySetCopier.copy(instanceTagKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceTagKeys(String ... instanceTagKeys) {
            this.instanceTagKeys(Arrays.asList(instanceTagKeys));
            return this;
        }

        public final Boolean getIncludeAllTagsOfInstance() {
            return this.includeAllTagsOfInstance;
        }

        public final void setIncludeAllTagsOfInstance(Boolean includeAllTagsOfInstance) {
            this.includeAllTagsOfInstance = includeAllTagsOfInstance;
        }

        @Override
        public final Builder includeAllTagsOfInstance(Boolean includeAllTagsOfInstance) {
            this.includeAllTagsOfInstance = includeAllTagsOfInstance;
            return this;
        }

        public InstanceTagNotificationAttribute build() {
            return new InstanceTagNotificationAttribute(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InstanceTagNotificationAttribute> {
        public Builder instanceTagKeys(Collection<String> var1);

        public Builder instanceTagKeys(String ... var1);

        public Builder includeAllTagsOfInstance(Boolean var1);
    }
}

