/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteKeyPairRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, DeleteKeyPairRequest> {
    private static final SdkField<String> KEY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyName").getter(DeleteKeyPairRequest.getter(DeleteKeyPairRequest::keyName)).setter(DeleteKeyPairRequest.setter(Builder::keyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyName").unmarshallLocationName("KeyName").build()}).build();
    private static final SdkField<String> KEY_PAIR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyPairId").getter(DeleteKeyPairRequest.getter(DeleteKeyPairRequest::keyPairId)).setter(DeleteKeyPairRequest.setter(Builder::keyPairId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyPairId").unmarshallLocationName("KeyPairId").build()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(DeleteKeyPairRequest.getter(DeleteKeyPairRequest::dryRun)).setter(DeleteKeyPairRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("dryRun").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_NAME_FIELD, KEY_PAIR_ID_FIELD, DRY_RUN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeleteKeyPairRequest.memberNameToFieldInitializer();
    private final String keyName;
    private final String keyPairId;
    private final Boolean dryRun;

    private DeleteKeyPairRequest(BuilderImpl builder) {
        super(builder);
        this.keyName = builder.keyName;
        this.keyPairId = builder.keyPairId;
        this.dryRun = builder.dryRun;
    }

    public final String keyName() {
        return this.keyName;
    }

    public final String keyPairId() {
        return this.keyPairId;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.keyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyPairId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteKeyPairRequest)) {
            return false;
        }
        DeleteKeyPairRequest other = (DeleteKeyPairRequest)((Object)obj);
        return Objects.equals(this.keyName(), other.keyName()) && Objects.equals(this.keyPairId(), other.keyPairId()) && Objects.equals(this.dryRun(), other.dryRun());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteKeyPairRequest").add("KeyName", (Object)this.keyName()).add("KeyPairId", (Object)this.keyPairId()).add("DryRun", (Object)this.dryRun()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyName": {
                return Optional.ofNullable(clazz.cast(this.keyName()));
            }
            case "KeyPairId": {
                return Optional.ofNullable(clazz.cast(this.keyPairId()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("KeyName", KEY_NAME_FIELD);
        map.put("KeyPairId", KEY_PAIR_ID_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteKeyPairRequest, T> g) {
        return obj -> g.apply((DeleteKeyPairRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String keyName;
        private String keyPairId;
        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteKeyPairRequest model) {
            super(model);
            this.keyName(model.keyName);
            this.keyPairId(model.keyPairId);
            this.dryRun(model.dryRun);
        }

        public final String getKeyName() {
            return this.keyName;
        }

        public final void setKeyName(String keyName) {
            this.keyName = keyName;
        }

        @Override
        public final Builder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public final String getKeyPairId() {
            return this.keyPairId;
        }

        public final void setKeyPairId(String keyPairId) {
            this.keyPairId = keyPairId;
        }

        @Override
        public final Builder keyPairId(String keyPairId) {
            this.keyPairId = keyPairId;
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteKeyPairRequest build() {
            return new DeleteKeyPairRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteKeyPairRequest> {
        public Builder keyName(String var1);

        public Builder keyPairId(String var1);

        public Builder dryRun(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

