/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.TagSpecification;
import software.amazon.awssdk.services.ec2.model.TagSpecificationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImportKeyPairRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, ImportKeyPairRequest> {
    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagSpecifications").getter(ImportKeyPairRequest.getter(ImportKeyPairRequest::tagSpecifications)).setter(ImportKeyPairRequest.setter(Builder::tagSpecifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification").unmarshallLocationName("TagSpecification").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TagSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(ImportKeyPairRequest.getter(ImportKeyPairRequest::dryRun)).setter(ImportKeyPairRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("dryRun").build()}).build();
    private static final SdkField<String> KEY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyName").getter(ImportKeyPairRequest.getter(ImportKeyPairRequest::keyName)).setter(ImportKeyPairRequest.setter(Builder::keyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyName").unmarshallLocationName("keyName").build()}).build();
    private static final SdkField<SdkBytes> PUBLIC_KEY_MATERIAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("PublicKeyMaterial").getter(ImportKeyPairRequest.getter(ImportKeyPairRequest::publicKeyMaterial)).setter(ImportKeyPairRequest.setter(Builder::publicKeyMaterial)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicKeyMaterial").unmarshallLocationName("publicKeyMaterial").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TAG_SPECIFICATIONS_FIELD, DRY_RUN_FIELD, KEY_NAME_FIELD, PUBLIC_KEY_MATERIAL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ImportKeyPairRequest.memberNameToFieldInitializer();
    private final List<TagSpecification> tagSpecifications;
    private final Boolean dryRun;
    private final String keyName;
    private final SdkBytes publicKeyMaterial;

    private ImportKeyPairRequest(BuilderImpl builder) {
        super(builder);
        this.tagSpecifications = builder.tagSpecifications;
        this.dryRun = builder.dryRun;
        this.keyName = builder.keyName;
        this.publicKeyMaterial = builder.publicKeyMaterial;
    }

    public final boolean hasTagSpecifications() {
        return this.tagSpecifications != null && !(this.tagSpecifications instanceof SdkAutoConstructList);
    }

    public final List<TagSpecification> tagSpecifications() {
        return this.tagSpecifications;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final String keyName() {
        return this.keyName;
    }

    public final SdkBytes publicKeyMaterial() {
        return this.publicKeyMaterial;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagSpecifications() ? this.tagSpecifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicKeyMaterial());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportKeyPairRequest)) {
            return false;
        }
        ImportKeyPairRequest other = (ImportKeyPairRequest)((Object)obj);
        return this.hasTagSpecifications() == other.hasTagSpecifications() && Objects.equals(this.tagSpecifications(), other.tagSpecifications()) && Objects.equals(this.dryRun(), other.dryRun()) && Objects.equals(this.keyName(), other.keyName()) && Objects.equals(this.publicKeyMaterial(), other.publicKeyMaterial());
    }

    public final String toString() {
        return ToString.builder((String)"ImportKeyPairRequest").add("TagSpecifications", this.hasTagSpecifications() ? this.tagSpecifications() : null).add("DryRun", (Object)this.dryRun()).add("KeyName", (Object)this.keyName()).add("PublicKeyMaterial", (Object)this.publicKeyMaterial()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TagSpecifications": {
                return Optional.ofNullable(clazz.cast(this.tagSpecifications()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "KeyName": {
                return Optional.ofNullable(clazz.cast(this.keyName()));
            }
            case "PublicKeyMaterial": {
                return Optional.ofNullable(clazz.cast(this.publicKeyMaterial()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TagSpecification", TAG_SPECIFICATIONS_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("KeyName", KEY_NAME_FIELD);
        map.put("PublicKeyMaterial", PUBLIC_KEY_MATERIAL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ImportKeyPairRequest, T> g) {
        return obj -> g.apply((ImportKeyPairRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();
        private Boolean dryRun;
        private String keyName;
        private SdkBytes publicKeyMaterial;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportKeyPairRequest model) {
            super(model);
            this.tagSpecifications(model.tagSpecifications);
            this.dryRun(model.dryRun);
            this.keyName(model.keyName);
            this.publicKeyMaterial(model.publicKeyMaterial);
        }

        public final List<TagSpecification.Builder> getTagSpecifications() {
            List<TagSpecification.Builder> result = TagSpecificationListCopier.copyToBuilder(this.tagSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification ... tagSpecifications) {
            this.tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder> ... tagSpecifications) {
            this.tagSpecifications(Stream.of(tagSpecifications).map(c -> (TagSpecification)((TagSpecification.Builder)TagSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getKeyName() {
            return this.keyName;
        }

        public final void setKeyName(String keyName) {
            this.keyName = keyName;
        }

        @Override
        public final Builder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public final ByteBuffer getPublicKeyMaterial() {
            return this.publicKeyMaterial == null ? null : this.publicKeyMaterial.asByteBuffer();
        }

        public final void setPublicKeyMaterial(ByteBuffer publicKeyMaterial) {
            this.publicKeyMaterial(publicKeyMaterial == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)publicKeyMaterial));
        }

        @Override
        public final Builder publicKeyMaterial(SdkBytes publicKeyMaterial) {
            this.publicKeyMaterial = publicKeyMaterial;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ImportKeyPairRequest build() {
            return new ImportKeyPairRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ImportKeyPairRequest> {
        public Builder tagSpecifications(Collection<TagSpecification> var1);

        public Builder tagSpecifications(TagSpecification ... var1);

        public Builder tagSpecifications(Consumer<TagSpecification.Builder> ... var1);

        public Builder dryRun(Boolean var1);

        public Builder keyName(String var1);

        public Builder publicKeyMaterial(SdkBytes var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

