/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.IpamScope;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateIpamScopeResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, CreateIpamScopeResponse> {
    private static final SdkField<IpamScope> IPAM_SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("IpamScope").getter(CreateIpamScopeResponse.getter(CreateIpamScopeResponse::ipamScope)).setter(CreateIpamScopeResponse.setter(Builder::ipamScope)).constructor(IpamScope::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamScope").unmarshallLocationName("ipamScope").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IPAM_SCOPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateIpamScopeResponse.memberNameToFieldInitializer();
    private final IpamScope ipamScope;

    private CreateIpamScopeResponse(BuilderImpl builder) {
        super(builder);
        this.ipamScope = builder.ipamScope;
    }

    public final IpamScope ipamScope() {
        return this.ipamScope;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.ipamScope());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateIpamScopeResponse)) {
            return false;
        }
        CreateIpamScopeResponse other = (CreateIpamScopeResponse)((Object)obj);
        return Objects.equals(this.ipamScope(), other.ipamScope());
    }

    public final String toString() {
        return ToString.builder((String)"CreateIpamScopeResponse").add("IpamScope", (Object)this.ipamScope()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IpamScope": {
                return Optional.ofNullable(clazz.cast(this.ipamScope()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<IpamScope>> map = new HashMap<String, SdkField<IpamScope>>();
        map.put("IpamScope", IPAM_SCOPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateIpamScopeResponse, T> g) {
        return obj -> g.apply((CreateIpamScopeResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private IpamScope ipamScope;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateIpamScopeResponse model) {
            super(model);
            this.ipamScope(model.ipamScope);
        }

        public final IpamScope.Builder getIpamScope() {
            return this.ipamScope != null ? this.ipamScope.toBuilder() : null;
        }

        public final void setIpamScope(IpamScope.BuilderImpl ipamScope) {
            this.ipamScope = ipamScope != null ? ipamScope.build() : null;
        }

        @Override
        public final Builder ipamScope(IpamScope ipamScope) {
            this.ipamScope = ipamScope;
            return this;
        }

        @Override
        public CreateIpamScopeResponse build() {
            return new CreateIpamScopeResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateIpamScopeResponse> {
        public Builder ipamScope(IpamScope var1);

        default public Builder ipamScope(Consumer<IpamScope.Builder> ipamScope) {
            return this.ipamScope((IpamScope)((IpamScope.Builder)IpamScope.builder().applyMutation(ipamScope)).build());
        }
    }
}

