/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.InternetGatewayAttachment;
import software.amazon.awssdk.services.ec2.model.InternetGatewayAttachmentListCopier;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InternetGateway
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InternetGateway> {
    private static final SdkField<List<InternetGatewayAttachment>> ATTACHMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Attachments").getter(InternetGateway.getter(InternetGateway::attachments)).setter(InternetGateway.setter(Builder::attachments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachmentSet").unmarshallLocationName("attachmentSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InternetGatewayAttachment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> INTERNET_GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InternetGatewayId").getter(InternetGateway.getter(InternetGateway::internetGatewayId)).setter(InternetGateway.setter(Builder::internetGatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InternetGatewayId").unmarshallLocationName("internetGatewayId").build()}).build();
    private static final SdkField<String> OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnerId").getter(InternetGateway.getter(InternetGateway::ownerId)).setter(InternetGateway.setter(Builder::ownerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId").unmarshallLocationName("ownerId").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(InternetGateway.getter(InternetGateway::tags)).setter(InternetGateway.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet").unmarshallLocationName("tagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTACHMENTS_FIELD, INTERNET_GATEWAY_ID_FIELD, OWNER_ID_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AttachmentSet", ATTACHMENTS_FIELD);
            this.put("InternetGatewayId", INTERNET_GATEWAY_ID_FIELD);
            this.put("OwnerId", OWNER_ID_FIELD);
            this.put("TagSet", TAGS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<InternetGatewayAttachment> attachments;
    private final String internetGatewayId;
    private final String ownerId;
    private final List<Tag> tags;

    private InternetGateway(BuilderImpl builder) {
        this.attachments = builder.attachments;
        this.internetGatewayId = builder.internetGatewayId;
        this.ownerId = builder.ownerId;
        this.tags = builder.tags;
    }

    public final boolean hasAttachments() {
        return this.attachments != null && !(this.attachments instanceof SdkAutoConstructList);
    }

    public final List<InternetGatewayAttachment> attachments() {
        return this.attachments;
    }

    public final String internetGatewayId() {
        return this.internetGatewayId;
    }

    public final String ownerId() {
        return this.ownerId;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttachments() ? this.attachments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.internetGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InternetGateway)) {
            return false;
        }
        InternetGateway other = (InternetGateway)obj;
        return this.hasAttachments() == other.hasAttachments() && Objects.equals(this.attachments(), other.attachments()) && Objects.equals(this.internetGatewayId(), other.internetGatewayId()) && Objects.equals(this.ownerId(), other.ownerId()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"InternetGateway").add("Attachments", this.hasAttachments() ? this.attachments() : null).add("InternetGatewayId", (Object)this.internetGatewayId()).add("OwnerId", (Object)this.ownerId()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Attachments": {
                return Optional.ofNullable(clazz.cast(this.attachments()));
            }
            case "InternetGatewayId": {
                return Optional.ofNullable(clazz.cast(this.internetGatewayId()));
            }
            case "OwnerId": {
                return Optional.ofNullable(clazz.cast(this.ownerId()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<InternetGateway, T> g) {
        return obj -> g.apply((InternetGateway)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<InternetGatewayAttachment> attachments = DefaultSdkAutoConstructList.getInstance();
        private String internetGatewayId;
        private String ownerId;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InternetGateway model) {
            this.attachments(model.attachments);
            this.internetGatewayId(model.internetGatewayId);
            this.ownerId(model.ownerId);
            this.tags(model.tags);
        }

        public final List<InternetGatewayAttachment.Builder> getAttachments() {
            List<InternetGatewayAttachment.Builder> result = InternetGatewayAttachmentListCopier.copyToBuilder(this.attachments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttachments(Collection<InternetGatewayAttachment.BuilderImpl> attachments) {
            this.attachments = InternetGatewayAttachmentListCopier.copyFromBuilder(attachments);
        }

        @Override
        public final Builder attachments(Collection<InternetGatewayAttachment> attachments) {
            this.attachments = InternetGatewayAttachmentListCopier.copy(attachments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachments(InternetGatewayAttachment ... attachments) {
            this.attachments(Arrays.asList(attachments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachments(Consumer<InternetGatewayAttachment.Builder> ... attachments) {
            this.attachments(Stream.of(attachments).map(c -> (InternetGatewayAttachment)((InternetGatewayAttachment.Builder)InternetGatewayAttachment.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getInternetGatewayId() {
            return this.internetGatewayId;
        }

        public final void setInternetGatewayId(String internetGatewayId) {
            this.internetGatewayId = internetGatewayId;
        }

        @Override
        public final Builder internetGatewayId(String internetGatewayId) {
            this.internetGatewayId = internetGatewayId;
            return this;
        }

        public final String getOwnerId() {
            return this.ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public InternetGateway build() {
            return new InternetGateway(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InternetGateway> {
        public Builder attachments(Collection<InternetGatewayAttachment> var1);

        public Builder attachments(InternetGatewayAttachment ... var1);

        public Builder attachments(Consumer<InternetGatewayAttachment.Builder> ... var1);

        public Builder internetGatewayId(String var1);

        public Builder ownerId(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

