/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.SubnetCidrReservation;
import software.amazon.awssdk.services.ec2.model.SubnetCidrReservationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetSubnetCidrReservationsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, GetSubnetCidrReservationsResponse> {
    private static final SdkField<List<SubnetCidrReservation>> SUBNET_IPV4_CIDR_RESERVATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SubnetIpv4CidrReservations").getter(GetSubnetCidrReservationsResponse.getter(GetSubnetCidrReservationsResponse::subnetIpv4CidrReservations)).setter(GetSubnetCidrReservationsResponse.setter(Builder::subnetIpv4CidrReservations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetIpv4CidrReservationSet").unmarshallLocationName("subnetIpv4CidrReservationSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SubnetCidrReservation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<SubnetCidrReservation>> SUBNET_IPV6_CIDR_RESERVATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SubnetIpv6CidrReservations").getter(GetSubnetCidrReservationsResponse.getter(GetSubnetCidrReservationsResponse::subnetIpv6CidrReservations)).setter(GetSubnetCidrReservationsResponse.setter(Builder::subnetIpv6CidrReservations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetIpv6CidrReservationSet").unmarshallLocationName("subnetIpv6CidrReservationSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SubnetCidrReservation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetSubnetCidrReservationsResponse.getter(GetSubnetCidrReservationsResponse::nextToken)).setter(GetSubnetCidrReservationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBNET_IPV4_CIDR_RESERVATIONS_FIELD, SUBNET_IPV6_CIDR_RESERVATIONS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetSubnetCidrReservationsResponse.memberNameToFieldInitializer();
    private final List<SubnetCidrReservation> subnetIpv4CidrReservations;
    private final List<SubnetCidrReservation> subnetIpv6CidrReservations;
    private final String nextToken;

    private GetSubnetCidrReservationsResponse(BuilderImpl builder) {
        super(builder);
        this.subnetIpv4CidrReservations = builder.subnetIpv4CidrReservations;
        this.subnetIpv6CidrReservations = builder.subnetIpv6CidrReservations;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasSubnetIpv4CidrReservations() {
        return this.subnetIpv4CidrReservations != null && !(this.subnetIpv4CidrReservations instanceof SdkAutoConstructList);
    }

    public final List<SubnetCidrReservation> subnetIpv4CidrReservations() {
        return this.subnetIpv4CidrReservations;
    }

    public final boolean hasSubnetIpv6CidrReservations() {
        return this.subnetIpv6CidrReservations != null && !(this.subnetIpv6CidrReservations instanceof SdkAutoConstructList);
    }

    public final List<SubnetCidrReservation> subnetIpv6CidrReservations() {
        return this.subnetIpv6CidrReservations;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubnetIpv4CidrReservations() ? this.subnetIpv4CidrReservations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubnetIpv6CidrReservations() ? this.subnetIpv6CidrReservations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSubnetCidrReservationsResponse)) {
            return false;
        }
        GetSubnetCidrReservationsResponse other = (GetSubnetCidrReservationsResponse)((Object)obj);
        return this.hasSubnetIpv4CidrReservations() == other.hasSubnetIpv4CidrReservations() && Objects.equals(this.subnetIpv4CidrReservations(), other.subnetIpv4CidrReservations()) && this.hasSubnetIpv6CidrReservations() == other.hasSubnetIpv6CidrReservations() && Objects.equals(this.subnetIpv6CidrReservations(), other.subnetIpv6CidrReservations()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetSubnetCidrReservationsResponse").add("SubnetIpv4CidrReservations", this.hasSubnetIpv4CidrReservations() ? this.subnetIpv4CidrReservations() : null).add("SubnetIpv6CidrReservations", this.hasSubnetIpv6CidrReservations() ? this.subnetIpv6CidrReservations() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SubnetIpv4CidrReservations": {
                return Optional.ofNullable(clazz.cast(this.subnetIpv4CidrReservations()));
            }
            case "SubnetIpv6CidrReservations": {
                return Optional.ofNullable(clazz.cast(this.subnetIpv6CidrReservations()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SubnetIpv4CidrReservationSet", SUBNET_IPV4_CIDR_RESERVATIONS_FIELD);
        map.put("SubnetIpv6CidrReservationSet", SUBNET_IPV6_CIDR_RESERVATIONS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetSubnetCidrReservationsResponse, T> g) {
        return obj -> g.apply((GetSubnetCidrReservationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<SubnetCidrReservation> subnetIpv4CidrReservations = DefaultSdkAutoConstructList.getInstance();
        private List<SubnetCidrReservation> subnetIpv6CidrReservations = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSubnetCidrReservationsResponse model) {
            super(model);
            this.subnetIpv4CidrReservations(model.subnetIpv4CidrReservations);
            this.subnetIpv6CidrReservations(model.subnetIpv6CidrReservations);
            this.nextToken(model.nextToken);
        }

        public final List<SubnetCidrReservation.Builder> getSubnetIpv4CidrReservations() {
            List<SubnetCidrReservation.Builder> result = SubnetCidrReservationListCopier.copyToBuilder(this.subnetIpv4CidrReservations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSubnetIpv4CidrReservations(Collection<SubnetCidrReservation.BuilderImpl> subnetIpv4CidrReservations) {
            this.subnetIpv4CidrReservations = SubnetCidrReservationListCopier.copyFromBuilder(subnetIpv4CidrReservations);
        }

        @Override
        public final Builder subnetIpv4CidrReservations(Collection<SubnetCidrReservation> subnetIpv4CidrReservations) {
            this.subnetIpv4CidrReservations = SubnetCidrReservationListCopier.copy(subnetIpv4CidrReservations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIpv4CidrReservations(SubnetCidrReservation ... subnetIpv4CidrReservations) {
            this.subnetIpv4CidrReservations(Arrays.asList(subnetIpv4CidrReservations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIpv4CidrReservations(Consumer<SubnetCidrReservation.Builder> ... subnetIpv4CidrReservations) {
            this.subnetIpv4CidrReservations(Stream.of(subnetIpv4CidrReservations).map(c -> (SubnetCidrReservation)((SubnetCidrReservation.Builder)SubnetCidrReservation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<SubnetCidrReservation.Builder> getSubnetIpv6CidrReservations() {
            List<SubnetCidrReservation.Builder> result = SubnetCidrReservationListCopier.copyToBuilder(this.subnetIpv6CidrReservations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSubnetIpv6CidrReservations(Collection<SubnetCidrReservation.BuilderImpl> subnetIpv6CidrReservations) {
            this.subnetIpv6CidrReservations = SubnetCidrReservationListCopier.copyFromBuilder(subnetIpv6CidrReservations);
        }

        @Override
        public final Builder subnetIpv6CidrReservations(Collection<SubnetCidrReservation> subnetIpv6CidrReservations) {
            this.subnetIpv6CidrReservations = SubnetCidrReservationListCopier.copy(subnetIpv6CidrReservations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIpv6CidrReservations(SubnetCidrReservation ... subnetIpv6CidrReservations) {
            this.subnetIpv6CidrReservations(Arrays.asList(subnetIpv6CidrReservations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIpv6CidrReservations(Consumer<SubnetCidrReservation.Builder> ... subnetIpv6CidrReservations) {
            this.subnetIpv6CidrReservations(Stream.of(subnetIpv6CidrReservations).map(c -> (SubnetCidrReservation)((SubnetCidrReservation.Builder)SubnetCidrReservation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetSubnetCidrReservationsResponse build() {
            return new GetSubnetCidrReservationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetSubnetCidrReservationsResponse> {
        public Builder subnetIpv4CidrReservations(Collection<SubnetCidrReservation> var1);

        public Builder subnetIpv4CidrReservations(SubnetCidrReservation ... var1);

        public Builder subnetIpv4CidrReservations(Consumer<SubnetCidrReservation.Builder> ... var1);

        public Builder subnetIpv6CidrReservations(Collection<SubnetCidrReservation> var1);

        public Builder subnetIpv6CidrReservations(SubnetCidrReservation ... var1);

        public Builder subnetIpv6CidrReservations(Consumer<SubnetCidrReservation.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

