/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.ValueStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDeclarativePoliciesReportsRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, DescribeDeclarativePoliciesReportsRequest> {
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(DescribeDeclarativePoliciesReportsRequest.getter(DescribeDeclarativePoliciesReportsRequest::dryRun)).setter(DescribeDeclarativePoliciesReportsRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("DryRun").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeDeclarativePoliciesReportsRequest.getter(DescribeDeclarativePoliciesReportsRequest::nextToken)).setter(DescribeDeclarativePoliciesReportsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(DescribeDeclarativePoliciesReportsRequest.getter(DescribeDeclarativePoliciesReportsRequest::maxResults)).setter(DescribeDeclarativePoliciesReportsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").unmarshallLocationName("MaxResults").build()}).build();
    private static final SdkField<List<String>> REPORT_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReportIds").getter(DescribeDeclarativePoliciesReportsRequest.getter(DescribeDeclarativePoliciesReportsRequest::reportIds)).setter(DescribeDeclarativePoliciesReportsRequest.setter(Builder::reportIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportId").unmarshallLocationName("ReportId").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DRY_RUN_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, REPORT_IDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DryRun", DRY_RUN_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
            this.put("MaxResults", MAX_RESULTS_FIELD);
            this.put("ReportId", REPORT_IDS_FIELD);
        }
    });
    private final Boolean dryRun;
    private final String nextToken;
    private final Integer maxResults;
    private final List<String> reportIds;

    private DescribeDeclarativePoliciesReportsRequest(BuilderImpl builder) {
        super(builder);
        this.dryRun = builder.dryRun;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.reportIds = builder.reportIds;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final boolean hasReportIds() {
        return this.reportIds != null && !(this.reportIds instanceof SdkAutoConstructList);
    }

    public final List<String> reportIds() {
        return this.reportIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReportIds() ? this.reportIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDeclarativePoliciesReportsRequest)) {
            return false;
        }
        DescribeDeclarativePoliciesReportsRequest other = (DescribeDeclarativePoliciesReportsRequest)((Object)obj);
        return Objects.equals(this.dryRun(), other.dryRun()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && this.hasReportIds() == other.hasReportIds() && Objects.equals(this.reportIds(), other.reportIds());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeDeclarativePoliciesReportsRequest").add("DryRun", (Object)this.dryRun()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("ReportIds", this.hasReportIds() ? this.reportIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "ReportIds": {
                return Optional.ofNullable(clazz.cast(this.reportIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDeclarativePoliciesReportsRequest, T> g) {
        return obj -> g.apply((DescribeDeclarativePoliciesReportsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private Boolean dryRun;
        private String nextToken;
        private Integer maxResults;
        private List<String> reportIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDeclarativePoliciesReportsRequest model) {
            super(model);
            this.dryRun(model.dryRun);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.reportIds(model.reportIds);
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final Collection<String> getReportIds() {
            if (this.reportIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.reportIds;
        }

        public final void setReportIds(Collection<String> reportIds) {
            this.reportIds = ValueStringListCopier.copy(reportIds);
        }

        @Override
        public final Builder reportIds(Collection<String> reportIds) {
            this.reportIds = ValueStringListCopier.copy(reportIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reportIds(String ... reportIds) {
            this.reportIds(Arrays.asList(reportIds));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeDeclarativePoliciesReportsRequest build() {
            return new DescribeDeclarativePoliciesReportsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeDeclarativePoliciesReportsRequest> {
        public Builder dryRun(Boolean var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder reportIds(Collection<String> var1);

        public Builder reportIds(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

