/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.InsideCidrBlocksStringListCopier;
import software.amazon.awssdk.services.ec2.model.ProtocolValue;
import software.amazon.awssdk.services.ec2.model.TransitGatewayAttachmentBgpConfiguration;
import software.amazon.awssdk.services.ec2.model.TransitGatewayAttachmentBgpConfigurationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TransitGatewayConnectPeerConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TransitGatewayConnectPeerConfiguration> {
    private static final SdkField<String> TRANSIT_GATEWAY_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TransitGatewayAddress").getter(TransitGatewayConnectPeerConfiguration.getter(TransitGatewayConnectPeerConfiguration::transitGatewayAddress)).setter(TransitGatewayConnectPeerConfiguration.setter(Builder::transitGatewayAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayAddress").unmarshallLocationName("transitGatewayAddress").build()}).build();
    private static final SdkField<String> PEER_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PeerAddress").getter(TransitGatewayConnectPeerConfiguration.getter(TransitGatewayConnectPeerConfiguration::peerAddress)).setter(TransitGatewayConnectPeerConfiguration.setter(Builder::peerAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeerAddress").unmarshallLocationName("peerAddress").build()}).build();
    private static final SdkField<List<String>> INSIDE_CIDR_BLOCKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InsideCidrBlocks").getter(TransitGatewayConnectPeerConfiguration.getter(TransitGatewayConnectPeerConfiguration::insideCidrBlocks)).setter(TransitGatewayConnectPeerConfiguration.setter(Builder::insideCidrBlocks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InsideCidrBlocks").unmarshallLocationName("insideCidrBlocks").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Protocol").getter(TransitGatewayConnectPeerConfiguration.getter(TransitGatewayConnectPeerConfiguration::protocolAsString)).setter(TransitGatewayConnectPeerConfiguration.setter(Builder::protocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol").unmarshallLocationName("protocol").build()}).build();
    private static final SdkField<List<TransitGatewayAttachmentBgpConfiguration>> BGP_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("BgpConfigurations").getter(TransitGatewayConnectPeerConfiguration.getter(TransitGatewayConnectPeerConfiguration::bgpConfigurations)).setter(TransitGatewayConnectPeerConfiguration.setter(Builder::bgpConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BgpConfigurations").unmarshallLocationName("bgpConfigurations").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TransitGatewayAttachmentBgpConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSIT_GATEWAY_ADDRESS_FIELD, PEER_ADDRESS_FIELD, INSIDE_CIDR_BLOCKS_FIELD, PROTOCOL_FIELD, BGP_CONFIGURATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("TransitGatewayAddress", TRANSIT_GATEWAY_ADDRESS_FIELD);
            this.put("PeerAddress", PEER_ADDRESS_FIELD);
            this.put("InsideCidrBlocks", INSIDE_CIDR_BLOCKS_FIELD);
            this.put("Protocol", PROTOCOL_FIELD);
            this.put("BgpConfigurations", BGP_CONFIGURATIONS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String transitGatewayAddress;
    private final String peerAddress;
    private final List<String> insideCidrBlocks;
    private final String protocol;
    private final List<TransitGatewayAttachmentBgpConfiguration> bgpConfigurations;

    private TransitGatewayConnectPeerConfiguration(BuilderImpl builder) {
        this.transitGatewayAddress = builder.transitGatewayAddress;
        this.peerAddress = builder.peerAddress;
        this.insideCidrBlocks = builder.insideCidrBlocks;
        this.protocol = builder.protocol;
        this.bgpConfigurations = builder.bgpConfigurations;
    }

    public final String transitGatewayAddress() {
        return this.transitGatewayAddress;
    }

    public final String peerAddress() {
        return this.peerAddress;
    }

    public final boolean hasInsideCidrBlocks() {
        return this.insideCidrBlocks != null && !(this.insideCidrBlocks instanceof SdkAutoConstructList);
    }

    public final List<String> insideCidrBlocks() {
        return this.insideCidrBlocks;
    }

    public final ProtocolValue protocol() {
        return ProtocolValue.fromValue(this.protocol);
    }

    public final String protocolAsString() {
        return this.protocol;
    }

    public final boolean hasBgpConfigurations() {
        return this.bgpConfigurations != null && !(this.bgpConfigurations instanceof SdkAutoConstructList);
    }

    public final List<TransitGatewayAttachmentBgpConfiguration> bgpConfigurations() {
        return this.bgpConfigurations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.transitGatewayAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.peerAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInsideCidrBlocks() ? this.insideCidrBlocks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBgpConfigurations() ? this.bgpConfigurations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransitGatewayConnectPeerConfiguration)) {
            return false;
        }
        TransitGatewayConnectPeerConfiguration other = (TransitGatewayConnectPeerConfiguration)obj;
        return Objects.equals(this.transitGatewayAddress(), other.transitGatewayAddress()) && Objects.equals(this.peerAddress(), other.peerAddress()) && this.hasInsideCidrBlocks() == other.hasInsideCidrBlocks() && Objects.equals(this.insideCidrBlocks(), other.insideCidrBlocks()) && Objects.equals(this.protocolAsString(), other.protocolAsString()) && this.hasBgpConfigurations() == other.hasBgpConfigurations() && Objects.equals(this.bgpConfigurations(), other.bgpConfigurations());
    }

    public final String toString() {
        return ToString.builder((String)"TransitGatewayConnectPeerConfiguration").add("TransitGatewayAddress", (Object)this.transitGatewayAddress()).add("PeerAddress", (Object)this.peerAddress()).add("InsideCidrBlocks", this.hasInsideCidrBlocks() ? this.insideCidrBlocks() : null).add("Protocol", (Object)this.protocolAsString()).add("BgpConfigurations", this.hasBgpConfigurations() ? this.bgpConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TransitGatewayAddress": {
                return Optional.ofNullable(clazz.cast(this.transitGatewayAddress()));
            }
            case "PeerAddress": {
                return Optional.ofNullable(clazz.cast(this.peerAddress()));
            }
            case "InsideCidrBlocks": {
                return Optional.ofNullable(clazz.cast(this.insideCidrBlocks()));
            }
            case "Protocol": {
                return Optional.ofNullable(clazz.cast(this.protocolAsString()));
            }
            case "BgpConfigurations": {
                return Optional.ofNullable(clazz.cast(this.bgpConfigurations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TransitGatewayConnectPeerConfiguration, T> g) {
        return obj -> g.apply((TransitGatewayConnectPeerConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String transitGatewayAddress;
        private String peerAddress;
        private List<String> insideCidrBlocks = DefaultSdkAutoConstructList.getInstance();
        private String protocol;
        private List<TransitGatewayAttachmentBgpConfiguration> bgpConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TransitGatewayConnectPeerConfiguration model) {
            this.transitGatewayAddress(model.transitGatewayAddress);
            this.peerAddress(model.peerAddress);
            this.insideCidrBlocks(model.insideCidrBlocks);
            this.protocol(model.protocol);
            this.bgpConfigurations(model.bgpConfigurations);
        }

        public final String getTransitGatewayAddress() {
            return this.transitGatewayAddress;
        }

        public final void setTransitGatewayAddress(String transitGatewayAddress) {
            this.transitGatewayAddress = transitGatewayAddress;
        }

        @Override
        public final Builder transitGatewayAddress(String transitGatewayAddress) {
            this.transitGatewayAddress = transitGatewayAddress;
            return this;
        }

        public final String getPeerAddress() {
            return this.peerAddress;
        }

        public final void setPeerAddress(String peerAddress) {
            this.peerAddress = peerAddress;
        }

        @Override
        public final Builder peerAddress(String peerAddress) {
            this.peerAddress = peerAddress;
            return this;
        }

        public final Collection<String> getInsideCidrBlocks() {
            if (this.insideCidrBlocks instanceof SdkAutoConstructList) {
                return null;
            }
            return this.insideCidrBlocks;
        }

        public final void setInsideCidrBlocks(Collection<String> insideCidrBlocks) {
            this.insideCidrBlocks = InsideCidrBlocksStringListCopier.copy(insideCidrBlocks);
        }

        @Override
        public final Builder insideCidrBlocks(Collection<String> insideCidrBlocks) {
            this.insideCidrBlocks = InsideCidrBlocksStringListCopier.copy(insideCidrBlocks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder insideCidrBlocks(String ... insideCidrBlocks) {
            this.insideCidrBlocks(Arrays.asList(insideCidrBlocks));
            return this;
        }

        public final String getProtocol() {
            return this.protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(ProtocolValue protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public final List<TransitGatewayAttachmentBgpConfiguration.Builder> getBgpConfigurations() {
            List<TransitGatewayAttachmentBgpConfiguration.Builder> result = TransitGatewayAttachmentBgpConfigurationListCopier.copyToBuilder(this.bgpConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBgpConfigurations(Collection<TransitGatewayAttachmentBgpConfiguration.BuilderImpl> bgpConfigurations) {
            this.bgpConfigurations = TransitGatewayAttachmentBgpConfigurationListCopier.copyFromBuilder(bgpConfigurations);
        }

        @Override
        public final Builder bgpConfigurations(Collection<TransitGatewayAttachmentBgpConfiguration> bgpConfigurations) {
            this.bgpConfigurations = TransitGatewayAttachmentBgpConfigurationListCopier.copy(bgpConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bgpConfigurations(TransitGatewayAttachmentBgpConfiguration ... bgpConfigurations) {
            this.bgpConfigurations(Arrays.asList(bgpConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bgpConfigurations(Consumer<TransitGatewayAttachmentBgpConfiguration.Builder> ... bgpConfigurations) {
            this.bgpConfigurations(Stream.of(bgpConfigurations).map(c -> (TransitGatewayAttachmentBgpConfiguration)((TransitGatewayAttachmentBgpConfiguration.Builder)TransitGatewayAttachmentBgpConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public TransitGatewayConnectPeerConfiguration build() {
            return new TransitGatewayConnectPeerConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TransitGatewayConnectPeerConfiguration> {
        public Builder transitGatewayAddress(String var1);

        public Builder peerAddress(String var1);

        public Builder insideCidrBlocks(Collection<String> var1);

        public Builder insideCidrBlocks(String ... var1);

        public Builder protocol(String var1);

        public Builder protocol(ProtocolValue var1);

        public Builder bgpConfigurations(Collection<TransitGatewayAttachmentBgpConfiguration> var1);

        public Builder bgpConfigurations(TransitGatewayAttachmentBgpConfiguration ... var1);

        public Builder bgpConfigurations(Consumer<TransitGatewayAttachmentBgpConfiguration.Builder> ... var1);
    }
}

