/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.BlockPublicAccessStates;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.services.ec2.model.Tenancy;
import software.amazon.awssdk.services.ec2.model.VpcCidrBlockAssociation;
import software.amazon.awssdk.services.ec2.model.VpcCidrBlockAssociationSetCopier;
import software.amazon.awssdk.services.ec2.model.VpcIpv6CidrBlockAssociation;
import software.amazon.awssdk.services.ec2.model.VpcIpv6CidrBlockAssociationSetCopier;
import software.amazon.awssdk.services.ec2.model.VpcState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Vpc
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Vpc> {
    private static final SdkField<String> OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnerId").getter(Vpc.getter(Vpc::ownerId)).setter(Vpc.setter(Builder::ownerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId").unmarshallLocationName("ownerId").build()}).build();
    private static final SdkField<String> INSTANCE_TENANCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceTenancy").getter(Vpc.getter(Vpc::instanceTenancyAsString)).setter(Vpc.setter(Builder::instanceTenancy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceTenancy").unmarshallLocationName("instanceTenancy").build()}).build();
    private static final SdkField<List<VpcIpv6CidrBlockAssociation>> IPV6_CIDR_BLOCK_ASSOCIATION_SET_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Ipv6CidrBlockAssociationSet").getter(Vpc.getter(Vpc::ipv6CidrBlockAssociationSet)).setter(Vpc.setter(Builder::ipv6CidrBlockAssociationSet)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6CidrBlockAssociationSet").unmarshallLocationName("ipv6CidrBlockAssociationSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VpcIpv6CidrBlockAssociation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<VpcCidrBlockAssociation>> CIDR_BLOCK_ASSOCIATION_SET_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CidrBlockAssociationSet").getter(Vpc.getter(Vpc::cidrBlockAssociationSet)).setter(Vpc.setter(Builder::cidrBlockAssociationSet)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CidrBlockAssociationSet").unmarshallLocationName("cidrBlockAssociationSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VpcCidrBlockAssociation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<Boolean> IS_DEFAULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsDefault").getter(Vpc.getter(Vpc::isDefault)).setter(Vpc.setter(Builder::isDefault)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsDefault").unmarshallLocationName("isDefault").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(Vpc.getter(Vpc::tags)).setter(Vpc.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet").unmarshallLocationName("tagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<BlockPublicAccessStates> BLOCK_PUBLIC_ACCESS_STATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BlockPublicAccessStates").getter(Vpc.getter(Vpc::blockPublicAccessStates)).setter(Vpc.setter(Builder::blockPublicAccessStates)).constructor(BlockPublicAccessStates::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockPublicAccessStates").unmarshallLocationName("blockPublicAccessStates").build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcId").getter(Vpc.getter(Vpc::vpcId)).setter(Vpc.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").unmarshallLocationName("vpcId").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(Vpc.getter(Vpc::stateAsString)).setter(Vpc.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").unmarshallLocationName("state").build()}).build();
    private static final SdkField<String> CIDR_BLOCK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CidrBlock").getter(Vpc.getter(Vpc::cidrBlock)).setter(Vpc.setter(Builder::cidrBlock)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CidrBlock").unmarshallLocationName("cidrBlock").build()}).build();
    private static final SdkField<String> DHCP_OPTIONS_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DhcpOptionsId").getter(Vpc.getter(Vpc::dhcpOptionsId)).setter(Vpc.setter(Builder::dhcpOptionsId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DhcpOptionsId").unmarshallLocationName("dhcpOptionsId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OWNER_ID_FIELD, INSTANCE_TENANCY_FIELD, IPV6_CIDR_BLOCK_ASSOCIATION_SET_FIELD, CIDR_BLOCK_ASSOCIATION_SET_FIELD, IS_DEFAULT_FIELD, TAGS_FIELD, BLOCK_PUBLIC_ACCESS_STATES_FIELD, VPC_ID_FIELD, STATE_FIELD, CIDR_BLOCK_FIELD, DHCP_OPTIONS_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("OwnerId", OWNER_ID_FIELD);
            this.put("InstanceTenancy", INSTANCE_TENANCY_FIELD);
            this.put("Ipv6CidrBlockAssociationSet", IPV6_CIDR_BLOCK_ASSOCIATION_SET_FIELD);
            this.put("CidrBlockAssociationSet", CIDR_BLOCK_ASSOCIATION_SET_FIELD);
            this.put("IsDefault", IS_DEFAULT_FIELD);
            this.put("TagSet", TAGS_FIELD);
            this.put("BlockPublicAccessStates", BLOCK_PUBLIC_ACCESS_STATES_FIELD);
            this.put("VpcId", VPC_ID_FIELD);
            this.put("State", STATE_FIELD);
            this.put("CidrBlock", CIDR_BLOCK_FIELD);
            this.put("DhcpOptionsId", DHCP_OPTIONS_ID_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String ownerId;
    private final String instanceTenancy;
    private final List<VpcIpv6CidrBlockAssociation> ipv6CidrBlockAssociationSet;
    private final List<VpcCidrBlockAssociation> cidrBlockAssociationSet;
    private final Boolean isDefault;
    private final List<Tag> tags;
    private final BlockPublicAccessStates blockPublicAccessStates;
    private final String vpcId;
    private final String state;
    private final String cidrBlock;
    private final String dhcpOptionsId;

    private Vpc(BuilderImpl builder) {
        this.ownerId = builder.ownerId;
        this.instanceTenancy = builder.instanceTenancy;
        this.ipv6CidrBlockAssociationSet = builder.ipv6CidrBlockAssociationSet;
        this.cidrBlockAssociationSet = builder.cidrBlockAssociationSet;
        this.isDefault = builder.isDefault;
        this.tags = builder.tags;
        this.blockPublicAccessStates = builder.blockPublicAccessStates;
        this.vpcId = builder.vpcId;
        this.state = builder.state;
        this.cidrBlock = builder.cidrBlock;
        this.dhcpOptionsId = builder.dhcpOptionsId;
    }

    public final String ownerId() {
        return this.ownerId;
    }

    public final Tenancy instanceTenancy() {
        return Tenancy.fromValue(this.instanceTenancy);
    }

    public final String instanceTenancyAsString() {
        return this.instanceTenancy;
    }

    public final boolean hasIpv6CidrBlockAssociationSet() {
        return this.ipv6CidrBlockAssociationSet != null && !(this.ipv6CidrBlockAssociationSet instanceof SdkAutoConstructList);
    }

    public final List<VpcIpv6CidrBlockAssociation> ipv6CidrBlockAssociationSet() {
        return this.ipv6CidrBlockAssociationSet;
    }

    public final boolean hasCidrBlockAssociationSet() {
        return this.cidrBlockAssociationSet != null && !(this.cidrBlockAssociationSet instanceof SdkAutoConstructList);
    }

    public final List<VpcCidrBlockAssociation> cidrBlockAssociationSet() {
        return this.cidrBlockAssociationSet;
    }

    public final Boolean isDefault() {
        return this.isDefault;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final BlockPublicAccessStates blockPublicAccessStates() {
        return this.blockPublicAccessStates;
    }

    public final String vpcId() {
        return this.vpcId;
    }

    public final VpcState state() {
        return VpcState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final String cidrBlock() {
        return this.cidrBlock;
    }

    public final String dhcpOptionsId() {
        return this.dhcpOptionsId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceTenancyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIpv6CidrBlockAssociationSet() ? this.ipv6CidrBlockAssociationSet() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCidrBlockAssociationSet() ? this.cidrBlockAssociationSet() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.isDefault());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.blockPublicAccessStates());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.cidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(this.dhcpOptionsId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Vpc)) {
            return false;
        }
        Vpc other = (Vpc)obj;
        return Objects.equals(this.ownerId(), other.ownerId()) && Objects.equals(this.instanceTenancyAsString(), other.instanceTenancyAsString()) && this.hasIpv6CidrBlockAssociationSet() == other.hasIpv6CidrBlockAssociationSet() && Objects.equals(this.ipv6CidrBlockAssociationSet(), other.ipv6CidrBlockAssociationSet()) && this.hasCidrBlockAssociationSet() == other.hasCidrBlockAssociationSet() && Objects.equals(this.cidrBlockAssociationSet(), other.cidrBlockAssociationSet()) && Objects.equals(this.isDefault(), other.isDefault()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.blockPublicAccessStates(), other.blockPublicAccessStates()) && Objects.equals(this.vpcId(), other.vpcId()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.cidrBlock(), other.cidrBlock()) && Objects.equals(this.dhcpOptionsId(), other.dhcpOptionsId());
    }

    public final String toString() {
        return ToString.builder((String)"Vpc").add("OwnerId", (Object)this.ownerId()).add("InstanceTenancy", (Object)this.instanceTenancyAsString()).add("Ipv6CidrBlockAssociationSet", this.hasIpv6CidrBlockAssociationSet() ? this.ipv6CidrBlockAssociationSet() : null).add("CidrBlockAssociationSet", this.hasCidrBlockAssociationSet() ? this.cidrBlockAssociationSet() : null).add("IsDefault", (Object)this.isDefault()).add("Tags", this.hasTags() ? this.tags() : null).add("BlockPublicAccessStates", (Object)this.blockPublicAccessStates()).add("VpcId", (Object)this.vpcId()).add("State", (Object)this.stateAsString()).add("CidrBlock", (Object)this.cidrBlock()).add("DhcpOptionsId", (Object)this.dhcpOptionsId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OwnerId": {
                return Optional.ofNullable(clazz.cast(this.ownerId()));
            }
            case "InstanceTenancy": {
                return Optional.ofNullable(clazz.cast(this.instanceTenancyAsString()));
            }
            case "Ipv6CidrBlockAssociationSet": {
                return Optional.ofNullable(clazz.cast(this.ipv6CidrBlockAssociationSet()));
            }
            case "CidrBlockAssociationSet": {
                return Optional.ofNullable(clazz.cast(this.cidrBlockAssociationSet()));
            }
            case "IsDefault": {
                return Optional.ofNullable(clazz.cast(this.isDefault()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "BlockPublicAccessStates": {
                return Optional.ofNullable(clazz.cast(this.blockPublicAccessStates()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "CidrBlock": {
                return Optional.ofNullable(clazz.cast(this.cidrBlock()));
            }
            case "DhcpOptionsId": {
                return Optional.ofNullable(clazz.cast(this.dhcpOptionsId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Vpc, T> g) {
        return obj -> g.apply((Vpc)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String ownerId;
        private String instanceTenancy;
        private List<VpcIpv6CidrBlockAssociation> ipv6CidrBlockAssociationSet = DefaultSdkAutoConstructList.getInstance();
        private List<VpcCidrBlockAssociation> cidrBlockAssociationSet = DefaultSdkAutoConstructList.getInstance();
        private Boolean isDefault;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private BlockPublicAccessStates blockPublicAccessStates;
        private String vpcId;
        private String state;
        private String cidrBlock;
        private String dhcpOptionsId;

        private BuilderImpl() {
        }

        private BuilderImpl(Vpc model) {
            this.ownerId(model.ownerId);
            this.instanceTenancy(model.instanceTenancy);
            this.ipv6CidrBlockAssociationSet(model.ipv6CidrBlockAssociationSet);
            this.cidrBlockAssociationSet(model.cidrBlockAssociationSet);
            this.isDefault(model.isDefault);
            this.tags(model.tags);
            this.blockPublicAccessStates(model.blockPublicAccessStates);
            this.vpcId(model.vpcId);
            this.state(model.state);
            this.cidrBlock(model.cidrBlock);
            this.dhcpOptionsId(model.dhcpOptionsId);
        }

        public final String getOwnerId() {
            return this.ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final String getInstanceTenancy() {
            return this.instanceTenancy;
        }

        public final void setInstanceTenancy(String instanceTenancy) {
            this.instanceTenancy = instanceTenancy;
        }

        @Override
        public final Builder instanceTenancy(String instanceTenancy) {
            this.instanceTenancy = instanceTenancy;
            return this;
        }

        @Override
        public final Builder instanceTenancy(Tenancy instanceTenancy) {
            this.instanceTenancy(instanceTenancy == null ? null : instanceTenancy.toString());
            return this;
        }

        public final List<VpcIpv6CidrBlockAssociation.Builder> getIpv6CidrBlockAssociationSet() {
            List<VpcIpv6CidrBlockAssociation.Builder> result = VpcIpv6CidrBlockAssociationSetCopier.copyToBuilder(this.ipv6CidrBlockAssociationSet);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIpv6CidrBlockAssociationSet(Collection<VpcIpv6CidrBlockAssociation.BuilderImpl> ipv6CidrBlockAssociationSet) {
            this.ipv6CidrBlockAssociationSet = VpcIpv6CidrBlockAssociationSetCopier.copyFromBuilder(ipv6CidrBlockAssociationSet);
        }

        @Override
        public final Builder ipv6CidrBlockAssociationSet(Collection<VpcIpv6CidrBlockAssociation> ipv6CidrBlockAssociationSet) {
            this.ipv6CidrBlockAssociationSet = VpcIpv6CidrBlockAssociationSetCopier.copy(ipv6CidrBlockAssociationSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6CidrBlockAssociationSet(VpcIpv6CidrBlockAssociation ... ipv6CidrBlockAssociationSet) {
            this.ipv6CidrBlockAssociationSet(Arrays.asList(ipv6CidrBlockAssociationSet));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6CidrBlockAssociationSet(Consumer<VpcIpv6CidrBlockAssociation.Builder> ... ipv6CidrBlockAssociationSet) {
            this.ipv6CidrBlockAssociationSet(Stream.of(ipv6CidrBlockAssociationSet).map(c -> (VpcIpv6CidrBlockAssociation)((VpcIpv6CidrBlockAssociation.Builder)VpcIpv6CidrBlockAssociation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<VpcCidrBlockAssociation.Builder> getCidrBlockAssociationSet() {
            List<VpcCidrBlockAssociation.Builder> result = VpcCidrBlockAssociationSetCopier.copyToBuilder(this.cidrBlockAssociationSet);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCidrBlockAssociationSet(Collection<VpcCidrBlockAssociation.BuilderImpl> cidrBlockAssociationSet) {
            this.cidrBlockAssociationSet = VpcCidrBlockAssociationSetCopier.copyFromBuilder(cidrBlockAssociationSet);
        }

        @Override
        public final Builder cidrBlockAssociationSet(Collection<VpcCidrBlockAssociation> cidrBlockAssociationSet) {
            this.cidrBlockAssociationSet = VpcCidrBlockAssociationSetCopier.copy(cidrBlockAssociationSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cidrBlockAssociationSet(VpcCidrBlockAssociation ... cidrBlockAssociationSet) {
            this.cidrBlockAssociationSet(Arrays.asList(cidrBlockAssociationSet));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cidrBlockAssociationSet(Consumer<VpcCidrBlockAssociation.Builder> ... cidrBlockAssociationSet) {
            this.cidrBlockAssociationSet(Stream.of(cidrBlockAssociationSet).map(c -> (VpcCidrBlockAssociation)((VpcCidrBlockAssociation.Builder)VpcCidrBlockAssociation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getIsDefault() {
            return this.isDefault;
        }

        public final void setIsDefault(Boolean isDefault) {
            this.isDefault = isDefault;
        }

        @Override
        public final Builder isDefault(Boolean isDefault) {
            this.isDefault = isDefault;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final BlockPublicAccessStates.Builder getBlockPublicAccessStates() {
            return this.blockPublicAccessStates != null ? this.blockPublicAccessStates.toBuilder() : null;
        }

        public final void setBlockPublicAccessStates(BlockPublicAccessStates.BuilderImpl blockPublicAccessStates) {
            this.blockPublicAccessStates = blockPublicAccessStates != null ? blockPublicAccessStates.build() : null;
        }

        @Override
        public final Builder blockPublicAccessStates(BlockPublicAccessStates blockPublicAccessStates) {
            this.blockPublicAccessStates = blockPublicAccessStates;
            return this;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(VpcState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getCidrBlock() {
            return this.cidrBlock;
        }

        public final void setCidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
        }

        @Override
        public final Builder cidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
            return this;
        }

        public final String getDhcpOptionsId() {
            return this.dhcpOptionsId;
        }

        public final void setDhcpOptionsId(String dhcpOptionsId) {
            this.dhcpOptionsId = dhcpOptionsId;
        }

        @Override
        public final Builder dhcpOptionsId(String dhcpOptionsId) {
            this.dhcpOptionsId = dhcpOptionsId;
            return this;
        }

        public Vpc build() {
            return new Vpc(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Vpc> {
        public Builder ownerId(String var1);

        public Builder instanceTenancy(String var1);

        public Builder instanceTenancy(Tenancy var1);

        public Builder ipv6CidrBlockAssociationSet(Collection<VpcIpv6CidrBlockAssociation> var1);

        public Builder ipv6CidrBlockAssociationSet(VpcIpv6CidrBlockAssociation ... var1);

        public Builder ipv6CidrBlockAssociationSet(Consumer<VpcIpv6CidrBlockAssociation.Builder> ... var1);

        public Builder cidrBlockAssociationSet(Collection<VpcCidrBlockAssociation> var1);

        public Builder cidrBlockAssociationSet(VpcCidrBlockAssociation ... var1);

        public Builder cidrBlockAssociationSet(Consumer<VpcCidrBlockAssociation.Builder> ... var1);

        public Builder isDefault(Boolean var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder blockPublicAccessStates(BlockPublicAccessStates var1);

        default public Builder blockPublicAccessStates(Consumer<BlockPublicAccessStates.Builder> blockPublicAccessStates) {
            return this.blockPublicAccessStates((BlockPublicAccessStates)((BlockPublicAccessStates.Builder)BlockPublicAccessStates.builder().applyMutation(blockPublicAccessStates)).build());
        }

        public Builder vpcId(String var1);

        public Builder state(String var1);

        public Builder state(VpcState var1);

        public Builder cidrBlock(String var1);

        public Builder dhcpOptionsId(String var1);
    }
}

