/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DnsEntry
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DnsEntry> {
    private static final SdkField<String> DNS_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DnsName").getter(DnsEntry.getter(DnsEntry::dnsName)).setter(DnsEntry.setter(Builder::dnsName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsName").unmarshallLocationName("dnsName").build()}).build();
    private static final SdkField<String> HOSTED_ZONE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HostedZoneId").getter(DnsEntry.getter(DnsEntry::hostedZoneId)).setter(DnsEntry.setter(Builder::hostedZoneId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostedZoneId").unmarshallLocationName("hostedZoneId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DNS_NAME_FIELD, HOSTED_ZONE_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DnsName", DNS_NAME_FIELD);
            this.put("HostedZoneId", HOSTED_ZONE_ID_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String dnsName;
    private final String hostedZoneId;

    private DnsEntry(BuilderImpl builder) {
        this.dnsName = builder.dnsName;
        this.hostedZoneId = builder.hostedZoneId;
    }

    public final String dnsName() {
        return this.dnsName;
    }

    public final String hostedZoneId() {
        return this.hostedZoneId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dnsName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostedZoneId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DnsEntry)) {
            return false;
        }
        DnsEntry other = (DnsEntry)obj;
        return Objects.equals(this.dnsName(), other.dnsName()) && Objects.equals(this.hostedZoneId(), other.hostedZoneId());
    }

    public final String toString() {
        return ToString.builder((String)"DnsEntry").add("DnsName", (Object)this.dnsName()).add("HostedZoneId", (Object)this.hostedZoneId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DnsName": {
                return Optional.ofNullable(clazz.cast(this.dnsName()));
            }
            case "HostedZoneId": {
                return Optional.ofNullable(clazz.cast(this.hostedZoneId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DnsEntry, T> g) {
        return obj -> g.apply((DnsEntry)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String dnsName;
        private String hostedZoneId;

        private BuilderImpl() {
        }

        private BuilderImpl(DnsEntry model) {
            this.dnsName(model.dnsName);
            this.hostedZoneId(model.hostedZoneId);
        }

        public final String getDnsName() {
            return this.dnsName;
        }

        public final void setDnsName(String dnsName) {
            this.dnsName = dnsName;
        }

        @Override
        public final Builder dnsName(String dnsName) {
            this.dnsName = dnsName;
            return this;
        }

        public final String getHostedZoneId() {
            return this.hostedZoneId;
        }

        public final void setHostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
        }

        @Override
        public final Builder hostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
            return this;
        }

        public DnsEntry build() {
            return new DnsEntry(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DnsEntry> {
        public Builder dnsName(String var1);

        public Builder hostedZoneId(String var1);
    }
}

