/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.DeleteLaunchTemplateVersionsResponseErrorItem;
import software.amazon.awssdk.services.ec2.model.DeleteLaunchTemplateVersionsResponseErrorSetCopier;
import software.amazon.awssdk.services.ec2.model.DeleteLaunchTemplateVersionsResponseSuccessItem;
import software.amazon.awssdk.services.ec2.model.DeleteLaunchTemplateVersionsResponseSuccessSetCopier;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteLaunchTemplateVersionsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DeleteLaunchTemplateVersionsResponse> {
    private static final SdkField<List<DeleteLaunchTemplateVersionsResponseSuccessItem>> SUCCESSFULLY_DELETED_LAUNCH_TEMPLATE_VERSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SuccessfullyDeletedLaunchTemplateVersions").getter(DeleteLaunchTemplateVersionsResponse.getter(DeleteLaunchTemplateVersionsResponse::successfullyDeletedLaunchTemplateVersions)).setter(DeleteLaunchTemplateVersionsResponse.setter(Builder::successfullyDeletedLaunchTemplateVersions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SuccessfullyDeletedLaunchTemplateVersionSet").unmarshallLocationName("successfullyDeletedLaunchTemplateVersionSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DeleteLaunchTemplateVersionsResponseSuccessItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<DeleteLaunchTemplateVersionsResponseErrorItem>> UNSUCCESSFULLY_DELETED_LAUNCH_TEMPLATE_VERSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UnsuccessfullyDeletedLaunchTemplateVersions").getter(DeleteLaunchTemplateVersionsResponse.getter(DeleteLaunchTemplateVersionsResponse::unsuccessfullyDeletedLaunchTemplateVersions)).setter(DeleteLaunchTemplateVersionsResponse.setter(Builder::unsuccessfullyDeletedLaunchTemplateVersions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnsuccessfullyDeletedLaunchTemplateVersionSet").unmarshallLocationName("unsuccessfullyDeletedLaunchTemplateVersionSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DeleteLaunchTemplateVersionsResponseErrorItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUCCESSFULLY_DELETED_LAUNCH_TEMPLATE_VERSIONS_FIELD, UNSUCCESSFULLY_DELETED_LAUNCH_TEMPLATE_VERSIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("SuccessfullyDeletedLaunchTemplateVersionSet", SUCCESSFULLY_DELETED_LAUNCH_TEMPLATE_VERSIONS_FIELD);
            this.put("UnsuccessfullyDeletedLaunchTemplateVersionSet", UNSUCCESSFULLY_DELETED_LAUNCH_TEMPLATE_VERSIONS_FIELD);
        }
    });
    private final List<DeleteLaunchTemplateVersionsResponseSuccessItem> successfullyDeletedLaunchTemplateVersions;
    private final List<DeleteLaunchTemplateVersionsResponseErrorItem> unsuccessfullyDeletedLaunchTemplateVersions;

    private DeleteLaunchTemplateVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.successfullyDeletedLaunchTemplateVersions = builder.successfullyDeletedLaunchTemplateVersions;
        this.unsuccessfullyDeletedLaunchTemplateVersions = builder.unsuccessfullyDeletedLaunchTemplateVersions;
    }

    public final boolean hasSuccessfullyDeletedLaunchTemplateVersions() {
        return this.successfullyDeletedLaunchTemplateVersions != null && !(this.successfullyDeletedLaunchTemplateVersions instanceof SdkAutoConstructList);
    }

    public final List<DeleteLaunchTemplateVersionsResponseSuccessItem> successfullyDeletedLaunchTemplateVersions() {
        return this.successfullyDeletedLaunchTemplateVersions;
    }

    public final boolean hasUnsuccessfullyDeletedLaunchTemplateVersions() {
        return this.unsuccessfullyDeletedLaunchTemplateVersions != null && !(this.unsuccessfullyDeletedLaunchTemplateVersions instanceof SdkAutoConstructList);
    }

    public final List<DeleteLaunchTemplateVersionsResponseErrorItem> unsuccessfullyDeletedLaunchTemplateVersions() {
        return this.unsuccessfullyDeletedLaunchTemplateVersions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSuccessfullyDeletedLaunchTemplateVersions() ? this.successfullyDeletedLaunchTemplateVersions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUnsuccessfullyDeletedLaunchTemplateVersions() ? this.unsuccessfullyDeletedLaunchTemplateVersions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteLaunchTemplateVersionsResponse)) {
            return false;
        }
        DeleteLaunchTemplateVersionsResponse other = (DeleteLaunchTemplateVersionsResponse)((Object)obj);
        return this.hasSuccessfullyDeletedLaunchTemplateVersions() == other.hasSuccessfullyDeletedLaunchTemplateVersions() && Objects.equals(this.successfullyDeletedLaunchTemplateVersions(), other.successfullyDeletedLaunchTemplateVersions()) && this.hasUnsuccessfullyDeletedLaunchTemplateVersions() == other.hasUnsuccessfullyDeletedLaunchTemplateVersions() && Objects.equals(this.unsuccessfullyDeletedLaunchTemplateVersions(), other.unsuccessfullyDeletedLaunchTemplateVersions());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteLaunchTemplateVersionsResponse").add("SuccessfullyDeletedLaunchTemplateVersions", this.hasSuccessfullyDeletedLaunchTemplateVersions() ? this.successfullyDeletedLaunchTemplateVersions() : null).add("UnsuccessfullyDeletedLaunchTemplateVersions", this.hasUnsuccessfullyDeletedLaunchTemplateVersions() ? this.unsuccessfullyDeletedLaunchTemplateVersions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SuccessfullyDeletedLaunchTemplateVersions": {
                return Optional.ofNullable(clazz.cast(this.successfullyDeletedLaunchTemplateVersions()));
            }
            case "UnsuccessfullyDeletedLaunchTemplateVersions": {
                return Optional.ofNullable(clazz.cast(this.unsuccessfullyDeletedLaunchTemplateVersions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DeleteLaunchTemplateVersionsResponse, T> g) {
        return obj -> g.apply((DeleteLaunchTemplateVersionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<DeleteLaunchTemplateVersionsResponseSuccessItem> successfullyDeletedLaunchTemplateVersions = DefaultSdkAutoConstructList.getInstance();
        private List<DeleteLaunchTemplateVersionsResponseErrorItem> unsuccessfullyDeletedLaunchTemplateVersions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteLaunchTemplateVersionsResponse model) {
            super(model);
            this.successfullyDeletedLaunchTemplateVersions(model.successfullyDeletedLaunchTemplateVersions);
            this.unsuccessfullyDeletedLaunchTemplateVersions(model.unsuccessfullyDeletedLaunchTemplateVersions);
        }

        public final List<DeleteLaunchTemplateVersionsResponseSuccessItem.Builder> getSuccessfullyDeletedLaunchTemplateVersions() {
            List<DeleteLaunchTemplateVersionsResponseSuccessItem.Builder> result = DeleteLaunchTemplateVersionsResponseSuccessSetCopier.copyToBuilder(this.successfullyDeletedLaunchTemplateVersions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSuccessfullyDeletedLaunchTemplateVersions(Collection<DeleteLaunchTemplateVersionsResponseSuccessItem.BuilderImpl> successfullyDeletedLaunchTemplateVersions) {
            this.successfullyDeletedLaunchTemplateVersions = DeleteLaunchTemplateVersionsResponseSuccessSetCopier.copyFromBuilder(successfullyDeletedLaunchTemplateVersions);
        }

        @Override
        public final Builder successfullyDeletedLaunchTemplateVersions(Collection<DeleteLaunchTemplateVersionsResponseSuccessItem> successfullyDeletedLaunchTemplateVersions) {
            this.successfullyDeletedLaunchTemplateVersions = DeleteLaunchTemplateVersionsResponseSuccessSetCopier.copy(successfullyDeletedLaunchTemplateVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successfullyDeletedLaunchTemplateVersions(DeleteLaunchTemplateVersionsResponseSuccessItem ... successfullyDeletedLaunchTemplateVersions) {
            this.successfullyDeletedLaunchTemplateVersions(Arrays.asList(successfullyDeletedLaunchTemplateVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successfullyDeletedLaunchTemplateVersions(Consumer<DeleteLaunchTemplateVersionsResponseSuccessItem.Builder> ... successfullyDeletedLaunchTemplateVersions) {
            this.successfullyDeletedLaunchTemplateVersions(Stream.of(successfullyDeletedLaunchTemplateVersions).map(c -> (DeleteLaunchTemplateVersionsResponseSuccessItem)((DeleteLaunchTemplateVersionsResponseSuccessItem.Builder)DeleteLaunchTemplateVersionsResponseSuccessItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<DeleteLaunchTemplateVersionsResponseErrorItem.Builder> getUnsuccessfullyDeletedLaunchTemplateVersions() {
            List<DeleteLaunchTemplateVersionsResponseErrorItem.Builder> result = DeleteLaunchTemplateVersionsResponseErrorSetCopier.copyToBuilder(this.unsuccessfullyDeletedLaunchTemplateVersions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUnsuccessfullyDeletedLaunchTemplateVersions(Collection<DeleteLaunchTemplateVersionsResponseErrorItem.BuilderImpl> unsuccessfullyDeletedLaunchTemplateVersions) {
            this.unsuccessfullyDeletedLaunchTemplateVersions = DeleteLaunchTemplateVersionsResponseErrorSetCopier.copyFromBuilder(unsuccessfullyDeletedLaunchTemplateVersions);
        }

        @Override
        public final Builder unsuccessfullyDeletedLaunchTemplateVersions(Collection<DeleteLaunchTemplateVersionsResponseErrorItem> unsuccessfullyDeletedLaunchTemplateVersions) {
            this.unsuccessfullyDeletedLaunchTemplateVersions = DeleteLaunchTemplateVersionsResponseErrorSetCopier.copy(unsuccessfullyDeletedLaunchTemplateVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unsuccessfullyDeletedLaunchTemplateVersions(DeleteLaunchTemplateVersionsResponseErrorItem ... unsuccessfullyDeletedLaunchTemplateVersions) {
            this.unsuccessfullyDeletedLaunchTemplateVersions(Arrays.asList(unsuccessfullyDeletedLaunchTemplateVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unsuccessfullyDeletedLaunchTemplateVersions(Consumer<DeleteLaunchTemplateVersionsResponseErrorItem.Builder> ... unsuccessfullyDeletedLaunchTemplateVersions) {
            this.unsuccessfullyDeletedLaunchTemplateVersions(Stream.of(unsuccessfullyDeletedLaunchTemplateVersions).map(c -> (DeleteLaunchTemplateVersionsResponseErrorItem)((DeleteLaunchTemplateVersionsResponseErrorItem.Builder)DeleteLaunchTemplateVersionsResponseErrorItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DeleteLaunchTemplateVersionsResponse build() {
            return new DeleteLaunchTemplateVersionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteLaunchTemplateVersionsResponse> {
        public Builder successfullyDeletedLaunchTemplateVersions(Collection<DeleteLaunchTemplateVersionsResponseSuccessItem> var1);

        public Builder successfullyDeletedLaunchTemplateVersions(DeleteLaunchTemplateVersionsResponseSuccessItem ... var1);

        public Builder successfullyDeletedLaunchTemplateVersions(Consumer<DeleteLaunchTemplateVersionsResponseSuccessItem.Builder> ... var1);

        public Builder unsuccessfullyDeletedLaunchTemplateVersions(Collection<DeleteLaunchTemplateVersionsResponseErrorItem> var1);

        public Builder unsuccessfullyDeletedLaunchTemplateVersions(DeleteLaunchTemplateVersionsResponseErrorItem ... var1);

        public Builder unsuccessfullyDeletedLaunchTemplateVersions(Consumer<DeleteLaunchTemplateVersionsResponseErrorItem.Builder> ... var1);
    }
}

