/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a permission for a network interface.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NetworkInterfacePermission implements SdkPojo, Serializable,
        ToCopyableBuilder<NetworkInterfacePermission.Builder, NetworkInterfacePermission> {
    private static final SdkField<String> NETWORK_INTERFACE_PERMISSION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NetworkInterfacePermissionId")
            .getter(getter(NetworkInterfacePermission::networkInterfacePermissionId))
            .setter(setter(Builder::networkInterfacePermissionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfacePermissionId")
                    .unmarshallLocationName("networkInterfacePermissionId").build()).build();

    private static final SdkField<String> NETWORK_INTERFACE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NetworkInterfaceId")
            .getter(getter(NetworkInterfacePermission::networkInterfaceId))
            .setter(setter(Builder::networkInterfaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceId")
                    .unmarshallLocationName("networkInterfaceId").build()).build();

    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AwsAccountId")
            .getter(getter(NetworkInterfacePermission::awsAccountId))
            .setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsAccountId")
                    .unmarshallLocationName("awsAccountId").build()).build();

    private static final SdkField<String> AWS_SERVICE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AwsService")
            .getter(getter(NetworkInterfacePermission::awsService))
            .setter(setter(Builder::awsService))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsService")
                    .unmarshallLocationName("awsService").build()).build();

    private static final SdkField<String> PERMISSION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Permission")
            .getter(getter(NetworkInterfacePermission::permissionAsString))
            .setter(setter(Builder::permission))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Permission")
                    .unmarshallLocationName("permission").build()).build();

    private static final SdkField<NetworkInterfacePermissionState> PERMISSION_STATE_FIELD = SdkField
            .<NetworkInterfacePermissionState> builder(MarshallingType.SDK_POJO)
            .memberName("PermissionState")
            .getter(getter(NetworkInterfacePermission::permissionState))
            .setter(setter(Builder::permissionState))
            .constructor(NetworkInterfacePermissionState::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PermissionState")
                    .unmarshallLocationName("permissionState").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            NETWORK_INTERFACE_PERMISSION_ID_FIELD, NETWORK_INTERFACE_ID_FIELD, AWS_ACCOUNT_ID_FIELD, AWS_SERVICE_FIELD,
            PERMISSION_FIELD, PERMISSION_STATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("NetworkInterfacePermissionId", NETWORK_INTERFACE_PERMISSION_ID_FIELD);
                    put("NetworkInterfaceId", NETWORK_INTERFACE_ID_FIELD);
                    put("AwsAccountId", AWS_ACCOUNT_ID_FIELD);
                    put("AwsService", AWS_SERVICE_FIELD);
                    put("Permission", PERMISSION_FIELD);
                    put("PermissionState", PERMISSION_STATE_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String networkInterfacePermissionId;

    private final String networkInterfaceId;

    private final String awsAccountId;

    private final String awsService;

    private final String permission;

    private final NetworkInterfacePermissionState permissionState;

    private NetworkInterfacePermission(BuilderImpl builder) {
        this.networkInterfacePermissionId = builder.networkInterfacePermissionId;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.awsAccountId = builder.awsAccountId;
        this.awsService = builder.awsService;
        this.permission = builder.permission;
        this.permissionState = builder.permissionState;
    }

    /**
     * <p>
     * The ID of the network interface permission.
     * </p>
     * 
     * @return The ID of the network interface permission.
     */
    public final String networkInterfacePermissionId() {
        return networkInterfacePermissionId;
    }

    /**
     * <p>
     * The ID of the network interface.
     * </p>
     * 
     * @return The ID of the network interface.
     */
    public final String networkInterfaceId() {
        return networkInterfaceId;
    }

    /**
     * <p>
     * The Amazon Web Services account ID.
     * </p>
     * 
     * @return The Amazon Web Services account ID.
     */
    public final String awsAccountId() {
        return awsAccountId;
    }

    /**
     * <p>
     * The Amazon Web Services service.
     * </p>
     * 
     * @return The Amazon Web Services service.
     */
    public final String awsService() {
        return awsService;
    }

    /**
     * <p>
     * The type of permission.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #permission} will
     * return {@link InterfacePermissionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #permissionAsString}.
     * </p>
     * 
     * @return The type of permission.
     * @see InterfacePermissionType
     */
    public final InterfacePermissionType permission() {
        return InterfacePermissionType.fromValue(permission);
    }

    /**
     * <p>
     * The type of permission.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #permission} will
     * return {@link InterfacePermissionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #permissionAsString}.
     * </p>
     * 
     * @return The type of permission.
     * @see InterfacePermissionType
     */
    public final String permissionAsString() {
        return permission;
    }

    /**
     * <p>
     * Information about the state of the permission.
     * </p>
     * 
     * @return Information about the state of the permission.
     */
    public final NetworkInterfacePermissionState permissionState() {
        return permissionState;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(networkInterfacePermissionId());
        hashCode = 31 * hashCode + Objects.hashCode(networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(awsService());
        hashCode = 31 * hashCode + Objects.hashCode(permissionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(permissionState());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkInterfacePermission)) {
            return false;
        }
        NetworkInterfacePermission other = (NetworkInterfacePermission) obj;
        return Objects.equals(networkInterfacePermissionId(), other.networkInterfacePermissionId())
                && Objects.equals(networkInterfaceId(), other.networkInterfaceId())
                && Objects.equals(awsAccountId(), other.awsAccountId()) && Objects.equals(awsService(), other.awsService())
                && Objects.equals(permissionAsString(), other.permissionAsString())
                && Objects.equals(permissionState(), other.permissionState());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NetworkInterfacePermission").add("NetworkInterfacePermissionId", networkInterfacePermissionId())
                .add("NetworkInterfaceId", networkInterfaceId()).add("AwsAccountId", awsAccountId())
                .add("AwsService", awsService()).add("Permission", permissionAsString())
                .add("PermissionState", permissionState()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NetworkInterfacePermissionId":
            return Optional.ofNullable(clazz.cast(networkInterfacePermissionId()));
        case "NetworkInterfaceId":
            return Optional.ofNullable(clazz.cast(networkInterfaceId()));
        case "AwsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "AwsService":
            return Optional.ofNullable(clazz.cast(awsService()));
        case "Permission":
            return Optional.ofNullable(clazz.cast(permissionAsString()));
        case "PermissionState":
            return Optional.ofNullable(clazz.cast(permissionState()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<NetworkInterfacePermission, T> g) {
        return obj -> g.apply((NetworkInterfacePermission) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NetworkInterfacePermission> {
        /**
         * <p>
         * The ID of the network interface permission.
         * </p>
         * 
         * @param networkInterfacePermissionId
         *        The ID of the network interface permission.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfacePermissionId(String networkInterfacePermissionId);

        /**
         * <p>
         * The ID of the network interface.
         * </p>
         * 
         * @param networkInterfaceId
         *        The ID of the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaceId(String networkInterfaceId);

        /**
         * <p>
         * The Amazon Web Services account ID.
         * </p>
         * 
         * @param awsAccountId
         *        The Amazon Web Services account ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * The Amazon Web Services service.
         * </p>
         * 
         * @param awsService
         *        The Amazon Web Services service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsService(String awsService);

        /**
         * <p>
         * The type of permission.
         * </p>
         * 
         * @param permission
         *        The type of permission.
         * @see InterfacePermissionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InterfacePermissionType
         */
        Builder permission(String permission);

        /**
         * <p>
         * The type of permission.
         * </p>
         * 
         * @param permission
         *        The type of permission.
         * @see InterfacePermissionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InterfacePermissionType
         */
        Builder permission(InterfacePermissionType permission);

        /**
         * <p>
         * Information about the state of the permission.
         * </p>
         * 
         * @param permissionState
         *        Information about the state of the permission.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionState(NetworkInterfacePermissionState permissionState);

        /**
         * <p>
         * Information about the state of the permission.
         * </p>
         * This is a convenience method that creates an instance of the {@link NetworkInterfacePermissionState.Builder}
         * avoiding the need to create one manually via {@link NetworkInterfacePermissionState#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NetworkInterfacePermissionState.Builder#build()} is called
         * immediately and its result is passed to {@link #permissionState(NetworkInterfacePermissionState)}.
         * 
         * @param permissionState
         *        a consumer that will call methods on {@link NetworkInterfacePermissionState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #permissionState(NetworkInterfacePermissionState)
         */
        default Builder permissionState(Consumer<NetworkInterfacePermissionState.Builder> permissionState) {
            return permissionState(NetworkInterfacePermissionState.builder().applyMutation(permissionState).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String networkInterfacePermissionId;

        private String networkInterfaceId;

        private String awsAccountId;

        private String awsService;

        private String permission;

        private NetworkInterfacePermissionState permissionState;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkInterfacePermission model) {
            networkInterfacePermissionId(model.networkInterfacePermissionId);
            networkInterfaceId(model.networkInterfaceId);
            awsAccountId(model.awsAccountId);
            awsService(model.awsService);
            permission(model.permission);
            permissionState(model.permissionState);
        }

        public final String getNetworkInterfacePermissionId() {
            return networkInterfacePermissionId;
        }

        public final void setNetworkInterfacePermissionId(String networkInterfacePermissionId) {
            this.networkInterfacePermissionId = networkInterfacePermissionId;
        }

        @Override
        public final Builder networkInterfacePermissionId(String networkInterfacePermissionId) {
            this.networkInterfacePermissionId = networkInterfacePermissionId;
            return this;
        }

        public final String getNetworkInterfaceId() {
            return networkInterfaceId;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getAwsService() {
            return awsService;
        }

        public final void setAwsService(String awsService) {
            this.awsService = awsService;
        }

        @Override
        public final Builder awsService(String awsService) {
            this.awsService = awsService;
            return this;
        }

        public final String getPermission() {
            return permission;
        }

        public final void setPermission(String permission) {
            this.permission = permission;
        }

        @Override
        public final Builder permission(String permission) {
            this.permission = permission;
            return this;
        }

        @Override
        public final Builder permission(InterfacePermissionType permission) {
            this.permission(permission == null ? null : permission.toString());
            return this;
        }

        public final NetworkInterfacePermissionState.Builder getPermissionState() {
            return permissionState != null ? permissionState.toBuilder() : null;
        }

        public final void setPermissionState(NetworkInterfacePermissionState.BuilderImpl permissionState) {
            this.permissionState = permissionState != null ? permissionState.build() : null;
        }

        @Override
        public final Builder permissionState(NetworkInterfacePermissionState permissionState) {
            this.permissionState = permissionState;
            return this;
        }

        @Override
        public NetworkInterfacePermission build() {
            return new NetworkInterfacePermission(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
