/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a launch template and overrides.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LaunchTemplateAndOverridesResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<LaunchTemplateAndOverridesResponse.Builder, LaunchTemplateAndOverridesResponse> {
    private static final SdkField<FleetLaunchTemplateSpecification> LAUNCH_TEMPLATE_SPECIFICATION_FIELD = SdkField
            .<FleetLaunchTemplateSpecification> builder(MarshallingType.SDK_POJO)
            .memberName("LaunchTemplateSpecification")
            .getter(getter(LaunchTemplateAndOverridesResponse::launchTemplateSpecification))
            .setter(setter(Builder::launchTemplateSpecification))
            .constructor(FleetLaunchTemplateSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTemplateSpecification")
                    .unmarshallLocationName("launchTemplateSpecification").build()).build();

    private static final SdkField<FleetLaunchTemplateOverrides> OVERRIDES_FIELD = SdkField
            .<FleetLaunchTemplateOverrides> builder(MarshallingType.SDK_POJO)
            .memberName("Overrides")
            .getter(getter(LaunchTemplateAndOverridesResponse::overrides))
            .setter(setter(Builder::overrides))
            .constructor(FleetLaunchTemplateOverrides::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Overrides")
                    .unmarshallLocationName("overrides").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            LAUNCH_TEMPLATE_SPECIFICATION_FIELD, OVERRIDES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("LaunchTemplateSpecification", LAUNCH_TEMPLATE_SPECIFICATION_FIELD);
                    put("Overrides", OVERRIDES_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final FleetLaunchTemplateSpecification launchTemplateSpecification;

    private final FleetLaunchTemplateOverrides overrides;

    private LaunchTemplateAndOverridesResponse(BuilderImpl builder) {
        this.launchTemplateSpecification = builder.launchTemplateSpecification;
        this.overrides = builder.overrides;
    }

    /**
     * <p>
     * The launch template.
     * </p>
     * 
     * @return The launch template.
     */
    public final FleetLaunchTemplateSpecification launchTemplateSpecification() {
        return launchTemplateSpecification;
    }

    /**
     * <p>
     * Any parameters that you specify override the same parameters in the launch template.
     * </p>
     * 
     * @return Any parameters that you specify override the same parameters in the launch template.
     */
    public final FleetLaunchTemplateOverrides overrides() {
        return overrides;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(launchTemplateSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(overrides());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LaunchTemplateAndOverridesResponse)) {
            return false;
        }
        LaunchTemplateAndOverridesResponse other = (LaunchTemplateAndOverridesResponse) obj;
        return Objects.equals(launchTemplateSpecification(), other.launchTemplateSpecification())
                && Objects.equals(overrides(), other.overrides());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LaunchTemplateAndOverridesResponse")
                .add("LaunchTemplateSpecification", launchTemplateSpecification()).add("Overrides", overrides()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LaunchTemplateSpecification":
            return Optional.ofNullable(clazz.cast(launchTemplateSpecification()));
        case "Overrides":
            return Optional.ofNullable(clazz.cast(overrides()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<LaunchTemplateAndOverridesResponse, T> g) {
        return obj -> g.apply((LaunchTemplateAndOverridesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LaunchTemplateAndOverridesResponse> {
        /**
         * <p>
         * The launch template.
         * </p>
         * 
         * @param launchTemplateSpecification
         *        The launch template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchTemplateSpecification(FleetLaunchTemplateSpecification launchTemplateSpecification);

        /**
         * <p>
         * The launch template.
         * </p>
         * This is a convenience method that creates an instance of the {@link FleetLaunchTemplateSpecification.Builder}
         * avoiding the need to create one manually via {@link FleetLaunchTemplateSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FleetLaunchTemplateSpecification.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #launchTemplateSpecification(FleetLaunchTemplateSpecification)}.
         * 
         * @param launchTemplateSpecification
         *        a consumer that will call methods on {@link FleetLaunchTemplateSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #launchTemplateSpecification(FleetLaunchTemplateSpecification)
         */
        default Builder launchTemplateSpecification(Consumer<FleetLaunchTemplateSpecification.Builder> launchTemplateSpecification) {
            return launchTemplateSpecification(FleetLaunchTemplateSpecification.builder()
                    .applyMutation(launchTemplateSpecification).build());
        }

        /**
         * <p>
         * Any parameters that you specify override the same parameters in the launch template.
         * </p>
         * 
         * @param overrides
         *        Any parameters that you specify override the same parameters in the launch template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder overrides(FleetLaunchTemplateOverrides overrides);

        /**
         * <p>
         * Any parameters that you specify override the same parameters in the launch template.
         * </p>
         * This is a convenience method that creates an instance of the {@link FleetLaunchTemplateOverrides.Builder}
         * avoiding the need to create one manually via {@link FleetLaunchTemplateOverrides#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FleetLaunchTemplateOverrides.Builder#build()} is called
         * immediately and its result is passed to {@link #overrides(FleetLaunchTemplateOverrides)}.
         * 
         * @param overrides
         *        a consumer that will call methods on {@link FleetLaunchTemplateOverrides.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #overrides(FleetLaunchTemplateOverrides)
         */
        default Builder overrides(Consumer<FleetLaunchTemplateOverrides.Builder> overrides) {
            return overrides(FleetLaunchTemplateOverrides.builder().applyMutation(overrides).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private FleetLaunchTemplateSpecification launchTemplateSpecification;

        private FleetLaunchTemplateOverrides overrides;

        private BuilderImpl() {
        }

        private BuilderImpl(LaunchTemplateAndOverridesResponse model) {
            launchTemplateSpecification(model.launchTemplateSpecification);
            overrides(model.overrides);
        }

        public final FleetLaunchTemplateSpecification.Builder getLaunchTemplateSpecification() {
            return launchTemplateSpecification != null ? launchTemplateSpecification.toBuilder() : null;
        }

        public final void setLaunchTemplateSpecification(FleetLaunchTemplateSpecification.BuilderImpl launchTemplateSpecification) {
            this.launchTemplateSpecification = launchTemplateSpecification != null ? launchTemplateSpecification.build() : null;
        }

        @Override
        public final Builder launchTemplateSpecification(FleetLaunchTemplateSpecification launchTemplateSpecification) {
            this.launchTemplateSpecification = launchTemplateSpecification;
            return this;
        }

        public final FleetLaunchTemplateOverrides.Builder getOverrides() {
            return overrides != null ? overrides.toBuilder() : null;
        }

        public final void setOverrides(FleetLaunchTemplateOverrides.BuilderImpl overrides) {
            this.overrides = overrides != null ? overrides.build() : null;
        }

        @Override
        public final Builder overrides(FleetLaunchTemplateOverrides overrides) {
            this.overrides = overrides;
            return this;
        }

        @Override
        public LaunchTemplateAndOverridesResponse build() {
            return new LaunchTemplateAndOverridesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
