/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The event window.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InstanceEventWindow implements SdkPojo, Serializable,
        ToCopyableBuilder<InstanceEventWindow.Builder, InstanceEventWindow> {
    private static final SdkField<String> INSTANCE_EVENT_WINDOW_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InstanceEventWindowId")
            .getter(getter(InstanceEventWindow::instanceEventWindowId))
            .setter(setter(Builder::instanceEventWindowId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceEventWindowId")
                    .unmarshallLocationName("instanceEventWindowId").build()).build();

    private static final SdkField<List<InstanceEventWindowTimeRange>> TIME_RANGES_FIELD = SdkField
            .<List<InstanceEventWindowTimeRange>> builder(MarshallingType.LIST)
            .memberName("TimeRanges")
            .getter(getter(InstanceEventWindow::timeRanges))
            .setter(setter(Builder::timeRanges))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeRangeSet")
                    .unmarshallLocationName("timeRangeSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<InstanceEventWindowTimeRange> builder(MarshallingType.SDK_POJO)
                                            .constructor(InstanceEventWindowTimeRange::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Name")
            .getter(getter(InstanceEventWindow::name))
            .setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name")
                    .unmarshallLocationName("name").build()).build();

    private static final SdkField<String> CRON_EXPRESSION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CronExpression")
            .getter(getter(InstanceEventWindow::cronExpression))
            .setter(setter(Builder::cronExpression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CronExpression")
                    .unmarshallLocationName("cronExpression").build()).build();

    private static final SdkField<InstanceEventWindowAssociationTarget> ASSOCIATION_TARGET_FIELD = SdkField
            .<InstanceEventWindowAssociationTarget> builder(MarshallingType.SDK_POJO)
            .memberName("AssociationTarget")
            .getter(getter(InstanceEventWindow::associationTarget))
            .setter(setter(Builder::associationTarget))
            .constructor(InstanceEventWindowAssociationTarget::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationTarget")
                    .unmarshallLocationName("associationTarget").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("State")
            .getter(getter(InstanceEventWindow::stateAsString))
            .setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State")
                    .unmarshallLocationName("state").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(InstanceEventWindow::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet")
                    .unmarshallLocationName("tagSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            INSTANCE_EVENT_WINDOW_ID_FIELD, TIME_RANGES_FIELD, NAME_FIELD, CRON_EXPRESSION_FIELD, ASSOCIATION_TARGET_FIELD,
            STATE_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("InstanceEventWindowId", INSTANCE_EVENT_WINDOW_ID_FIELD);
                    put("TimeRangeSet", TIME_RANGES_FIELD);
                    put("Name", NAME_FIELD);
                    put("CronExpression", CRON_EXPRESSION_FIELD);
                    put("AssociationTarget", ASSOCIATION_TARGET_FIELD);
                    put("State", STATE_FIELD);
                    put("TagSet", TAGS_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String instanceEventWindowId;

    private final List<InstanceEventWindowTimeRange> timeRanges;

    private final String name;

    private final String cronExpression;

    private final InstanceEventWindowAssociationTarget associationTarget;

    private final String state;

    private final List<Tag> tags;

    private InstanceEventWindow(BuilderImpl builder) {
        this.instanceEventWindowId = builder.instanceEventWindowId;
        this.timeRanges = builder.timeRanges;
        this.name = builder.name;
        this.cronExpression = builder.cronExpression;
        this.associationTarget = builder.associationTarget;
        this.state = builder.state;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The ID of the event window.
     * </p>
     * 
     * @return The ID of the event window.
     */
    public final String instanceEventWindowId() {
        return instanceEventWindowId;
    }

    /**
     * For responses, this returns true if the service returned a value for the TimeRanges property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTimeRanges() {
        return timeRanges != null && !(timeRanges instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more time ranges defined for the event window.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTimeRanges} method.
     * </p>
     * 
     * @return One or more time ranges defined for the event window.
     */
    public final List<InstanceEventWindowTimeRange> timeRanges() {
        return timeRanges;
    }

    /**
     * <p>
     * The name of the event window.
     * </p>
     * 
     * @return The name of the event window.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The cron expression defined for the event window.
     * </p>
     * 
     * @return The cron expression defined for the event window.
     */
    public final String cronExpression() {
        return cronExpression;
    }

    /**
     * <p>
     * One or more targets associated with the event window.
     * </p>
     * 
     * @return One or more targets associated with the event window.
     */
    public final InstanceEventWindowAssociationTarget associationTarget() {
        return associationTarget;
    }

    /**
     * <p>
     * The current state of the event window.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link InstanceEventWindowState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of the event window.
     * @see InstanceEventWindowState
     */
    public final InstanceEventWindowState state() {
        return InstanceEventWindowState.fromValue(state);
    }

    /**
     * <p>
     * The current state of the event window.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link InstanceEventWindowState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of the event window.
     * @see InstanceEventWindowState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The instance tags associated with the event window.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The instance tags associated with the event window.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceEventWindowId());
        hashCode = 31 * hashCode + Objects.hashCode(hasTimeRanges() ? timeRanges() : null);
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(cronExpression());
        hashCode = 31 * hashCode + Objects.hashCode(associationTarget());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceEventWindow)) {
            return false;
        }
        InstanceEventWindow other = (InstanceEventWindow) obj;
        return Objects.equals(instanceEventWindowId(), other.instanceEventWindowId()) && hasTimeRanges() == other.hasTimeRanges()
                && Objects.equals(timeRanges(), other.timeRanges()) && Objects.equals(name(), other.name())
                && Objects.equals(cronExpression(), other.cronExpression())
                && Objects.equals(associationTarget(), other.associationTarget())
                && Objects.equals(stateAsString(), other.stateAsString()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InstanceEventWindow").add("InstanceEventWindowId", instanceEventWindowId())
                .add("TimeRanges", hasTimeRanges() ? timeRanges() : null).add("Name", name())
                .add("CronExpression", cronExpression()).add("AssociationTarget", associationTarget())
                .add("State", stateAsString()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceEventWindowId":
            return Optional.ofNullable(clazz.cast(instanceEventWindowId()));
        case "TimeRanges":
            return Optional.ofNullable(clazz.cast(timeRanges()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "CronExpression":
            return Optional.ofNullable(clazz.cast(cronExpression()));
        case "AssociationTarget":
            return Optional.ofNullable(clazz.cast(associationTarget()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<InstanceEventWindow, T> g) {
        return obj -> g.apply((InstanceEventWindow) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InstanceEventWindow> {
        /**
         * <p>
         * The ID of the event window.
         * </p>
         * 
         * @param instanceEventWindowId
         *        The ID of the event window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceEventWindowId(String instanceEventWindowId);

        /**
         * <p>
         * One or more time ranges defined for the event window.
         * </p>
         * 
         * @param timeRanges
         *        One or more time ranges defined for the event window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeRanges(Collection<InstanceEventWindowTimeRange> timeRanges);

        /**
         * <p>
         * One or more time ranges defined for the event window.
         * </p>
         * 
         * @param timeRanges
         *        One or more time ranges defined for the event window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeRanges(InstanceEventWindowTimeRange... timeRanges);

        /**
         * <p>
         * One or more time ranges defined for the event window.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.InstanceEventWindowTimeRange.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.InstanceEventWindowTimeRange#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.InstanceEventWindowTimeRange.Builder#build()} is called
         * immediately and its result is passed to {@link #timeRanges(List<InstanceEventWindowTimeRange>)}.
         * 
         * @param timeRanges
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.InstanceEventWindowTimeRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timeRanges(java.util.Collection<InstanceEventWindowTimeRange>)
         */
        Builder timeRanges(Consumer<InstanceEventWindowTimeRange.Builder>... timeRanges);

        /**
         * <p>
         * The name of the event window.
         * </p>
         * 
         * @param name
         *        The name of the event window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The cron expression defined for the event window.
         * </p>
         * 
         * @param cronExpression
         *        The cron expression defined for the event window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cronExpression(String cronExpression);

        /**
         * <p>
         * One or more targets associated with the event window.
         * </p>
         * 
         * @param associationTarget
         *        One or more targets associated with the event window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationTarget(InstanceEventWindowAssociationTarget associationTarget);

        /**
         * <p>
         * One or more targets associated with the event window.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link InstanceEventWindowAssociationTarget.Builder} avoiding the need to create one manually via
         * {@link InstanceEventWindowAssociationTarget#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InstanceEventWindowAssociationTarget.Builder#build()} is called
         * immediately and its result is passed to {@link #associationTarget(InstanceEventWindowAssociationTarget)}.
         * 
         * @param associationTarget
         *        a consumer that will call methods on {@link InstanceEventWindowAssociationTarget.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #associationTarget(InstanceEventWindowAssociationTarget)
         */
        default Builder associationTarget(Consumer<InstanceEventWindowAssociationTarget.Builder> associationTarget) {
            return associationTarget(InstanceEventWindowAssociationTarget.builder().applyMutation(associationTarget).build());
        }

        /**
         * <p>
         * The current state of the event window.
         * </p>
         * 
         * @param state
         *        The current state of the event window.
         * @see InstanceEventWindowState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceEventWindowState
         */
        Builder state(String state);

        /**
         * <p>
         * The current state of the event window.
         * </p>
         * 
         * @param state
         *        The current state of the event window.
         * @see InstanceEventWindowState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceEventWindowState
         */
        Builder state(InstanceEventWindowState state);

        /**
         * <p>
         * The instance tags associated with the event window.
         * </p>
         * 
         * @param tags
         *        The instance tags associated with the event window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The instance tags associated with the event window.
         * </p>
         * 
         * @param tags
         *        The instance tags associated with the event window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The instance tags associated with the event window.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.ec2.model.Tag.Builder#build()} is
         * called immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.ec2.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl implements Builder {
        private String instanceEventWindowId;

        private List<InstanceEventWindowTimeRange> timeRanges = DefaultSdkAutoConstructList.getInstance();

        private String name;

        private String cronExpression;

        private InstanceEventWindowAssociationTarget associationTarget;

        private String state;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceEventWindow model) {
            instanceEventWindowId(model.instanceEventWindowId);
            timeRanges(model.timeRanges);
            name(model.name);
            cronExpression(model.cronExpression);
            associationTarget(model.associationTarget);
            state(model.state);
            tags(model.tags);
        }

        public final String getInstanceEventWindowId() {
            return instanceEventWindowId;
        }

        public final void setInstanceEventWindowId(String instanceEventWindowId) {
            this.instanceEventWindowId = instanceEventWindowId;
        }

        @Override
        public final Builder instanceEventWindowId(String instanceEventWindowId) {
            this.instanceEventWindowId = instanceEventWindowId;
            return this;
        }

        public final List<InstanceEventWindowTimeRange.Builder> getTimeRanges() {
            List<InstanceEventWindowTimeRange.Builder> result = InstanceEventWindowTimeRangeListCopier
                    .copyToBuilder(this.timeRanges);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTimeRanges(Collection<InstanceEventWindowTimeRange.BuilderImpl> timeRanges) {
            this.timeRanges = InstanceEventWindowTimeRangeListCopier.copyFromBuilder(timeRanges);
        }

        @Override
        public final Builder timeRanges(Collection<InstanceEventWindowTimeRange> timeRanges) {
            this.timeRanges = InstanceEventWindowTimeRangeListCopier.copy(timeRanges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder timeRanges(InstanceEventWindowTimeRange... timeRanges) {
            timeRanges(Arrays.asList(timeRanges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder timeRanges(Consumer<InstanceEventWindowTimeRange.Builder>... timeRanges) {
            timeRanges(Stream.of(timeRanges).map(c -> InstanceEventWindowTimeRange.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getCronExpression() {
            return cronExpression;
        }

        public final void setCronExpression(String cronExpression) {
            this.cronExpression = cronExpression;
        }

        @Override
        public final Builder cronExpression(String cronExpression) {
            this.cronExpression = cronExpression;
            return this;
        }

        public final InstanceEventWindowAssociationTarget.Builder getAssociationTarget() {
            return associationTarget != null ? associationTarget.toBuilder() : null;
        }

        public final void setAssociationTarget(InstanceEventWindowAssociationTarget.BuilderImpl associationTarget) {
            this.associationTarget = associationTarget != null ? associationTarget.build() : null;
        }

        @Override
        public final Builder associationTarget(InstanceEventWindowAssociationTarget associationTarget) {
            this.associationTarget = associationTarget;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(InstanceEventWindowState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public InstanceEventWindow build() {
            return new InstanceEventWindow(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
