/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes volume attachment details.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AttachVolumeResponse extends Ec2Response implements
        ToCopyableBuilder<AttachVolumeResponse.Builder, AttachVolumeResponse> {
    private static final SdkField<Boolean> DELETE_ON_TERMINATION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DeleteOnTermination")
            .getter(getter(AttachVolumeResponse::deleteOnTermination))
            .setter(setter(Builder::deleteOnTermination))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteOnTermination")
                    .unmarshallLocationName("deleteOnTermination").build()).build();

    private static final SdkField<String> ASSOCIATED_RESOURCE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AssociatedResource")
            .getter(getter(AttachVolumeResponse::associatedResource))
            .setter(setter(Builder::associatedResource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatedResource")
                    .unmarshallLocationName("associatedResource").build()).build();

    private static final SdkField<String> INSTANCE_OWNING_SERVICE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InstanceOwningService")
            .getter(getter(AttachVolumeResponse::instanceOwningService))
            .setter(setter(Builder::instanceOwningService))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceOwningService")
                    .unmarshallLocationName("instanceOwningService").build()).build();

    private static final SdkField<String> VOLUME_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VolumeId")
            .getter(getter(AttachVolumeResponse::volumeId))
            .setter(setter(Builder::volumeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeId")
                    .unmarshallLocationName("volumeId").build()).build();

    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InstanceId")
            .getter(getter(AttachVolumeResponse::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId")
                    .unmarshallLocationName("instanceId").build()).build();

    private static final SdkField<String> DEVICE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Device")
            .getter(getter(AttachVolumeResponse::device))
            .setter(setter(Builder::device))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Device")
                    .unmarshallLocationName("device").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("State")
            .getter(getter(AttachVolumeResponse::stateAsString))
            .setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status")
                    .unmarshallLocationName("status").build()).build();

    private static final SdkField<Instant> ATTACH_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("AttachTime")
            .getter(getter(AttachVolumeResponse::attachTime))
            .setter(setter(Builder::attachTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachTime")
                    .unmarshallLocationName("attachTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELETE_ON_TERMINATION_FIELD,
            ASSOCIATED_RESOURCE_FIELD, INSTANCE_OWNING_SERVICE_FIELD, VOLUME_ID_FIELD, INSTANCE_ID_FIELD, DEVICE_FIELD,
            STATE_FIELD, ATTACH_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("DeleteOnTermination", DELETE_ON_TERMINATION_FIELD);
                    put("AssociatedResource", ASSOCIATED_RESOURCE_FIELD);
                    put("InstanceOwningService", INSTANCE_OWNING_SERVICE_FIELD);
                    put("VolumeId", VOLUME_ID_FIELD);
                    put("InstanceId", INSTANCE_ID_FIELD);
                    put("Device", DEVICE_FIELD);
                    put("Status", STATE_FIELD);
                    put("AttachTime", ATTACH_TIME_FIELD);
                }
            });

    private final Boolean deleteOnTermination;

    private final String associatedResource;

    private final String instanceOwningService;

    private final String volumeId;

    private final String instanceId;

    private final String device;

    private final String state;

    private final Instant attachTime;

    private AttachVolumeResponse(BuilderImpl builder) {
        super(builder);
        this.deleteOnTermination = builder.deleteOnTermination;
        this.associatedResource = builder.associatedResource;
        this.instanceOwningService = builder.instanceOwningService;
        this.volumeId = builder.volumeId;
        this.instanceId = builder.instanceId;
        this.device = builder.device;
        this.state = builder.state;
        this.attachTime = builder.attachTime;
    }

    /**
     * <p>
     * Indicates whether the EBS volume is deleted on instance termination.
     * </p>
     * 
     * @return Indicates whether the EBS volume is deleted on instance termination.
     */
    public final Boolean deleteOnTermination() {
        return deleteOnTermination;
    }

    /**
     * <p>
     * The ARN of the Amazon ECS or Fargate task to which the volume is attached.
     * </p>
     * 
     * @return The ARN of the Amazon ECS or Fargate task to which the volume is attached.
     */
    public final String associatedResource() {
        return associatedResource;
    }

    /**
     * <p>
     * The service principal of Amazon Web Services service that owns the underlying instance to which the volume is
     * attached.
     * </p>
     * <p>
     * This parameter is returned only for volumes that are attached to Fargate tasks.
     * </p>
     * 
     * @return The service principal of Amazon Web Services service that owns the underlying instance to which the
     *         volume is attached.</p>
     *         <p>
     *         This parameter is returned only for volumes that are attached to Fargate tasks.
     */
    public final String instanceOwningService() {
        return instanceOwningService;
    }

    /**
     * <p>
     * The ID of the volume.
     * </p>
     * 
     * @return The ID of the volume.
     */
    public final String volumeId() {
        return volumeId;
    }

    /**
     * <p>
     * The ID of the instance.
     * </p>
     * <p>
     * If the volume is attached to a Fargate task, this parameter returns <code>null</code>.
     * </p>
     * 
     * @return The ID of the instance.</p>
     *         <p>
     *         If the volume is attached to a Fargate task, this parameter returns <code>null</code>.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The device name.
     * </p>
     * <p>
     * If the volume is attached to a Fargate task, this parameter returns <code>null</code>.
     * </p>
     * 
     * @return The device name.</p>
     *         <p>
     *         If the volume is attached to a Fargate task, this parameter returns <code>null</code>.
     */
    public final String device() {
        return device;
    }

    /**
     * <p>
     * The attachment state of the volume.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link VolumeAttachmentState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The attachment state of the volume.
     * @see VolumeAttachmentState
     */
    public final VolumeAttachmentState state() {
        return VolumeAttachmentState.fromValue(state);
    }

    /**
     * <p>
     * The attachment state of the volume.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link VolumeAttachmentState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The attachment state of the volume.
     * @see VolumeAttachmentState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The time stamp when the attachment initiated.
     * </p>
     * 
     * @return The time stamp when the attachment initiated.
     */
    public final Instant attachTime() {
        return attachTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(deleteOnTermination());
        hashCode = 31 * hashCode + Objects.hashCode(associatedResource());
        hashCode = 31 * hashCode + Objects.hashCode(instanceOwningService());
        hashCode = 31 * hashCode + Objects.hashCode(volumeId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(device());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(attachTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttachVolumeResponse)) {
            return false;
        }
        AttachVolumeResponse other = (AttachVolumeResponse) obj;
        return Objects.equals(deleteOnTermination(), other.deleteOnTermination())
                && Objects.equals(associatedResource(), other.associatedResource())
                && Objects.equals(instanceOwningService(), other.instanceOwningService())
                && Objects.equals(volumeId(), other.volumeId()) && Objects.equals(instanceId(), other.instanceId())
                && Objects.equals(device(), other.device()) && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(attachTime(), other.attachTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AttachVolumeResponse").add("DeleteOnTermination", deleteOnTermination())
                .add("AssociatedResource", associatedResource()).add("InstanceOwningService", instanceOwningService())
                .add("VolumeId", volumeId()).add("InstanceId", instanceId()).add("Device", device())
                .add("State", stateAsString()).add("AttachTime", attachTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeleteOnTermination":
            return Optional.ofNullable(clazz.cast(deleteOnTermination()));
        case "AssociatedResource":
            return Optional.ofNullable(clazz.cast(associatedResource()));
        case "InstanceOwningService":
            return Optional.ofNullable(clazz.cast(instanceOwningService()));
        case "VolumeId":
            return Optional.ofNullable(clazz.cast(volumeId()));
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "Device":
            return Optional.ofNullable(clazz.cast(device()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "AttachTime":
            return Optional.ofNullable(clazz.cast(attachTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AttachVolumeResponse, T> g) {
        return obj -> g.apply((AttachVolumeResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, AttachVolumeResponse> {
        /**
         * <p>
         * Indicates whether the EBS volume is deleted on instance termination.
         * </p>
         * 
         * @param deleteOnTermination
         *        Indicates whether the EBS volume is deleted on instance termination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteOnTermination(Boolean deleteOnTermination);

        /**
         * <p>
         * The ARN of the Amazon ECS or Fargate task to which the volume is attached.
         * </p>
         * 
         * @param associatedResource
         *        The ARN of the Amazon ECS or Fargate task to which the volume is attached.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedResource(String associatedResource);

        /**
         * <p>
         * The service principal of Amazon Web Services service that owns the underlying instance to which the volume is
         * attached.
         * </p>
         * <p>
         * This parameter is returned only for volumes that are attached to Fargate tasks.
         * </p>
         * 
         * @param instanceOwningService
         *        The service principal of Amazon Web Services service that owns the underlying instance to which the
         *        volume is attached.</p>
         *        <p>
         *        This parameter is returned only for volumes that are attached to Fargate tasks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceOwningService(String instanceOwningService);

        /**
         * <p>
         * The ID of the volume.
         * </p>
         * 
         * @param volumeId
         *        The ID of the volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeId(String volumeId);

        /**
         * <p>
         * The ID of the instance.
         * </p>
         * <p>
         * If the volume is attached to a Fargate task, this parameter returns <code>null</code>.
         * </p>
         * 
         * @param instanceId
         *        The ID of the instance.</p>
         *        <p>
         *        If the volume is attached to a Fargate task, this parameter returns <code>null</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The device name.
         * </p>
         * <p>
         * If the volume is attached to a Fargate task, this parameter returns <code>null</code>.
         * </p>
         * 
         * @param device
         *        The device name.</p>
         *        <p>
         *        If the volume is attached to a Fargate task, this parameter returns <code>null</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder device(String device);

        /**
         * <p>
         * The attachment state of the volume.
         * </p>
         * 
         * @param state
         *        The attachment state of the volume.
         * @see VolumeAttachmentState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VolumeAttachmentState
         */
        Builder state(String state);

        /**
         * <p>
         * The attachment state of the volume.
         * </p>
         * 
         * @param state
         *        The attachment state of the volume.
         * @see VolumeAttachmentState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VolumeAttachmentState
         */
        Builder state(VolumeAttachmentState state);

        /**
         * <p>
         * The time stamp when the attachment initiated.
         * </p>
         * 
         * @param attachTime
         *        The time stamp when the attachment initiated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachTime(Instant attachTime);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private Boolean deleteOnTermination;

        private String associatedResource;

        private String instanceOwningService;

        private String volumeId;

        private String instanceId;

        private String device;

        private String state;

        private Instant attachTime;

        private BuilderImpl() {
        }

        private BuilderImpl(AttachVolumeResponse model) {
            super(model);
            deleteOnTermination(model.deleteOnTermination);
            associatedResource(model.associatedResource);
            instanceOwningService(model.instanceOwningService);
            volumeId(model.volumeId);
            instanceId(model.instanceId);
            device(model.device);
            state(model.state);
            attachTime(model.attachTime);
        }

        public final Boolean getDeleteOnTermination() {
            return deleteOnTermination;
        }

        public final void setDeleteOnTermination(Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
        }

        @Override
        public final Builder deleteOnTermination(Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
            return this;
        }

        public final String getAssociatedResource() {
            return associatedResource;
        }

        public final void setAssociatedResource(String associatedResource) {
            this.associatedResource = associatedResource;
        }

        @Override
        public final Builder associatedResource(String associatedResource) {
            this.associatedResource = associatedResource;
            return this;
        }

        public final String getInstanceOwningService() {
            return instanceOwningService;
        }

        public final void setInstanceOwningService(String instanceOwningService) {
            this.instanceOwningService = instanceOwningService;
        }

        @Override
        public final Builder instanceOwningService(String instanceOwningService) {
            this.instanceOwningService = instanceOwningService;
            return this;
        }

        public final String getVolumeId() {
            return volumeId;
        }

        public final void setVolumeId(String volumeId) {
            this.volumeId = volumeId;
        }

        @Override
        public final Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getDevice() {
            return device;
        }

        public final void setDevice(String device) {
            this.device = device;
        }

        @Override
        public final Builder device(String device) {
            this.device = device;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(VolumeAttachmentState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Instant getAttachTime() {
            return attachTime;
        }

        public final void setAttachTime(Instant attachTime) {
            this.attachTime = attachTime;
        }

        @Override
        public final Builder attachTime(Instant attachTime) {
            this.attachTime = attachTime;
            return this;
        }

        @Override
        public AttachVolumeResponse build() {
            return new AttachVolumeResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
