/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.DisableFastSnapshotRestoreErrorItem;
import software.amazon.awssdk.services.ec2.model.DisableFastSnapshotRestoreErrorSetCopier;
import software.amazon.awssdk.services.ec2.model.DisableFastSnapshotRestoreSuccessItem;
import software.amazon.awssdk.services.ec2.model.DisableFastSnapshotRestoreSuccessSetCopier;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DisableFastSnapshotRestoresResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DisableFastSnapshotRestoresResponse> {
    private static final SdkField<List<DisableFastSnapshotRestoreSuccessItem>> SUCCESSFUL_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Successful").getter(DisableFastSnapshotRestoresResponse.getter(DisableFastSnapshotRestoresResponse::successful)).setter(DisableFastSnapshotRestoresResponse.setter(Builder::successful)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Successful").unmarshallLocationName("successful").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DisableFastSnapshotRestoreSuccessItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<DisableFastSnapshotRestoreErrorItem>> UNSUCCESSFUL_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Unsuccessful").getter(DisableFastSnapshotRestoresResponse.getter(DisableFastSnapshotRestoresResponse::unsuccessful)).setter(DisableFastSnapshotRestoresResponse.setter(Builder::unsuccessful)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Unsuccessful").unmarshallLocationName("unsuccessful").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DisableFastSnapshotRestoreErrorItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUCCESSFUL_FIELD, UNSUCCESSFUL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Successful", SUCCESSFUL_FIELD);
            this.put("Unsuccessful", UNSUCCESSFUL_FIELD);
        }
    });
    private final List<DisableFastSnapshotRestoreSuccessItem> successful;
    private final List<DisableFastSnapshotRestoreErrorItem> unsuccessful;

    private DisableFastSnapshotRestoresResponse(BuilderImpl builder) {
        super(builder);
        this.successful = builder.successful;
        this.unsuccessful = builder.unsuccessful;
    }

    public final boolean hasSuccessful() {
        return this.successful != null && !(this.successful instanceof SdkAutoConstructList);
    }

    public final List<DisableFastSnapshotRestoreSuccessItem> successful() {
        return this.successful;
    }

    public final boolean hasUnsuccessful() {
        return this.unsuccessful != null && !(this.unsuccessful instanceof SdkAutoConstructList);
    }

    public final List<DisableFastSnapshotRestoreErrorItem> unsuccessful() {
        return this.unsuccessful;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSuccessful() ? this.successful() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUnsuccessful() ? this.unsuccessful() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisableFastSnapshotRestoresResponse)) {
            return false;
        }
        DisableFastSnapshotRestoresResponse other = (DisableFastSnapshotRestoresResponse)((Object)obj);
        return this.hasSuccessful() == other.hasSuccessful() && Objects.equals(this.successful(), other.successful()) && this.hasUnsuccessful() == other.hasUnsuccessful() && Objects.equals(this.unsuccessful(), other.unsuccessful());
    }

    public final String toString() {
        return ToString.builder((String)"DisableFastSnapshotRestoresResponse").add("Successful", this.hasSuccessful() ? this.successful() : null).add("Unsuccessful", this.hasUnsuccessful() ? this.unsuccessful() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Successful": {
                return Optional.ofNullable(clazz.cast(this.successful()));
            }
            case "Unsuccessful": {
                return Optional.ofNullable(clazz.cast(this.unsuccessful()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DisableFastSnapshotRestoresResponse, T> g) {
        return obj -> g.apply((DisableFastSnapshotRestoresResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<DisableFastSnapshotRestoreSuccessItem> successful = DefaultSdkAutoConstructList.getInstance();
        private List<DisableFastSnapshotRestoreErrorItem> unsuccessful = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DisableFastSnapshotRestoresResponse model) {
            super(model);
            this.successful(model.successful);
            this.unsuccessful(model.unsuccessful);
        }

        public final List<DisableFastSnapshotRestoreSuccessItem.Builder> getSuccessful() {
            List<DisableFastSnapshotRestoreSuccessItem.Builder> result = DisableFastSnapshotRestoreSuccessSetCopier.copyToBuilder(this.successful);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSuccessful(Collection<DisableFastSnapshotRestoreSuccessItem.BuilderImpl> successful) {
            this.successful = DisableFastSnapshotRestoreSuccessSetCopier.copyFromBuilder(successful);
        }

        @Override
        public final Builder successful(Collection<DisableFastSnapshotRestoreSuccessItem> successful) {
            this.successful = DisableFastSnapshotRestoreSuccessSetCopier.copy(successful);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successful(DisableFastSnapshotRestoreSuccessItem ... successful) {
            this.successful(Arrays.asList(successful));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successful(Consumer<DisableFastSnapshotRestoreSuccessItem.Builder> ... successful) {
            this.successful(Stream.of(successful).map(c -> (DisableFastSnapshotRestoreSuccessItem)((DisableFastSnapshotRestoreSuccessItem.Builder)DisableFastSnapshotRestoreSuccessItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<DisableFastSnapshotRestoreErrorItem.Builder> getUnsuccessful() {
            List<DisableFastSnapshotRestoreErrorItem.Builder> result = DisableFastSnapshotRestoreErrorSetCopier.copyToBuilder(this.unsuccessful);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUnsuccessful(Collection<DisableFastSnapshotRestoreErrorItem.BuilderImpl> unsuccessful) {
            this.unsuccessful = DisableFastSnapshotRestoreErrorSetCopier.copyFromBuilder(unsuccessful);
        }

        @Override
        public final Builder unsuccessful(Collection<DisableFastSnapshotRestoreErrorItem> unsuccessful) {
            this.unsuccessful = DisableFastSnapshotRestoreErrorSetCopier.copy(unsuccessful);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unsuccessful(DisableFastSnapshotRestoreErrorItem ... unsuccessful) {
            this.unsuccessful(Arrays.asList(unsuccessful));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unsuccessful(Consumer<DisableFastSnapshotRestoreErrorItem.Builder> ... unsuccessful) {
            this.unsuccessful(Stream.of(unsuccessful).map(c -> (DisableFastSnapshotRestoreErrorItem)((DisableFastSnapshotRestoreErrorItem.Builder)DisableFastSnapshotRestoreErrorItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DisableFastSnapshotRestoresResponse build() {
            return new DisableFastSnapshotRestoresResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DisableFastSnapshotRestoresResponse> {
        public Builder successful(Collection<DisableFastSnapshotRestoreSuccessItem> var1);

        public Builder successful(DisableFastSnapshotRestoreSuccessItem ... var1);

        public Builder successful(Consumer<DisableFastSnapshotRestoreSuccessItem.Builder> ... var1);

        public Builder unsuccessful(Collection<DisableFastSnapshotRestoreErrorItem> var1);

        public Builder unsuccessful(DisableFastSnapshotRestoreErrorItem ... var1);

        public Builder unsuccessful(Consumer<DisableFastSnapshotRestoreErrorItem.Builder> ... var1);
    }
}

