/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.CidrBlock;
import software.amazon.awssdk.services.ec2.model.CidrBlockSetCopier;
import software.amazon.awssdk.services.ec2.model.Ipv6CidrBlock;
import software.amazon.awssdk.services.ec2.model.Ipv6CidrBlockSetCopier;
import software.amazon.awssdk.services.ec2.model.VpcPeeringConnectionOptionsDescription;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VpcPeeringConnectionVpcInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VpcPeeringConnectionVpcInfo> {
    private static final SdkField<String> CIDR_BLOCK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CidrBlock").getter(VpcPeeringConnectionVpcInfo.getter(VpcPeeringConnectionVpcInfo::cidrBlock)).setter(VpcPeeringConnectionVpcInfo.setter(Builder::cidrBlock)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CidrBlock").unmarshallLocationName("cidrBlock").build()}).build();
    private static final SdkField<List<Ipv6CidrBlock>> IPV6_CIDR_BLOCK_SET_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Ipv6CidrBlockSet").getter(VpcPeeringConnectionVpcInfo.getter(VpcPeeringConnectionVpcInfo::ipv6CidrBlockSet)).setter(VpcPeeringConnectionVpcInfo.setter(Builder::ipv6CidrBlockSet)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6CidrBlockSet").unmarshallLocationName("ipv6CidrBlockSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Ipv6CidrBlock::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<CidrBlock>> CIDR_BLOCK_SET_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CidrBlockSet").getter(VpcPeeringConnectionVpcInfo.getter(VpcPeeringConnectionVpcInfo::cidrBlockSet)).setter(VpcPeeringConnectionVpcInfo.setter(Builder::cidrBlockSet)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CidrBlockSet").unmarshallLocationName("cidrBlockSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CidrBlock::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnerId").getter(VpcPeeringConnectionVpcInfo.getter(VpcPeeringConnectionVpcInfo::ownerId)).setter(VpcPeeringConnectionVpcInfo.setter(Builder::ownerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId").unmarshallLocationName("ownerId").build()}).build();
    private static final SdkField<VpcPeeringConnectionOptionsDescription> PEERING_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PeeringOptions").getter(VpcPeeringConnectionVpcInfo.getter(VpcPeeringConnectionVpcInfo::peeringOptions)).setter(VpcPeeringConnectionVpcInfo.setter(Builder::peeringOptions)).constructor(VpcPeeringConnectionOptionsDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeeringOptions").unmarshallLocationName("peeringOptions").build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcId").getter(VpcPeeringConnectionVpcInfo.getter(VpcPeeringConnectionVpcInfo::vpcId)).setter(VpcPeeringConnectionVpcInfo.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").unmarshallLocationName("vpcId").build()}).build();
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Region").getter(VpcPeeringConnectionVpcInfo.getter(VpcPeeringConnectionVpcInfo::region)).setter(VpcPeeringConnectionVpcInfo.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").unmarshallLocationName("region").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CIDR_BLOCK_FIELD, IPV6_CIDR_BLOCK_SET_FIELD, CIDR_BLOCK_SET_FIELD, OWNER_ID_FIELD, PEERING_OPTIONS_FIELD, VPC_ID_FIELD, REGION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("CidrBlock", CIDR_BLOCK_FIELD);
            this.put("Ipv6CidrBlockSet", IPV6_CIDR_BLOCK_SET_FIELD);
            this.put("CidrBlockSet", CIDR_BLOCK_SET_FIELD);
            this.put("OwnerId", OWNER_ID_FIELD);
            this.put("PeeringOptions", PEERING_OPTIONS_FIELD);
            this.put("VpcId", VPC_ID_FIELD);
            this.put("Region", REGION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String cidrBlock;
    private final List<Ipv6CidrBlock> ipv6CidrBlockSet;
    private final List<CidrBlock> cidrBlockSet;
    private final String ownerId;
    private final VpcPeeringConnectionOptionsDescription peeringOptions;
    private final String vpcId;
    private final String region;

    private VpcPeeringConnectionVpcInfo(BuilderImpl builder) {
        this.cidrBlock = builder.cidrBlock;
        this.ipv6CidrBlockSet = builder.ipv6CidrBlockSet;
        this.cidrBlockSet = builder.cidrBlockSet;
        this.ownerId = builder.ownerId;
        this.peeringOptions = builder.peeringOptions;
        this.vpcId = builder.vpcId;
        this.region = builder.region;
    }

    public final String cidrBlock() {
        return this.cidrBlock;
    }

    public final boolean hasIpv6CidrBlockSet() {
        return this.ipv6CidrBlockSet != null && !(this.ipv6CidrBlockSet instanceof SdkAutoConstructList);
    }

    public final List<Ipv6CidrBlock> ipv6CidrBlockSet() {
        return this.ipv6CidrBlockSet;
    }

    public final boolean hasCidrBlockSet() {
        return this.cidrBlockSet != null && !(this.cidrBlockSet instanceof SdkAutoConstructList);
    }

    public final List<CidrBlock> cidrBlockSet() {
        return this.cidrBlockSet;
    }

    public final String ownerId() {
        return this.ownerId;
    }

    public final VpcPeeringConnectionOptionsDescription peeringOptions() {
        return this.peeringOptions;
    }

    public final String vpcId() {
        return this.vpcId;
    }

    public final String region() {
        return this.region;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIpv6CidrBlockSet() ? this.ipv6CidrBlockSet() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCidrBlockSet() ? this.cidrBlockSet() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.peeringOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcPeeringConnectionVpcInfo)) {
            return false;
        }
        VpcPeeringConnectionVpcInfo other = (VpcPeeringConnectionVpcInfo)obj;
        return Objects.equals(this.cidrBlock(), other.cidrBlock()) && this.hasIpv6CidrBlockSet() == other.hasIpv6CidrBlockSet() && Objects.equals(this.ipv6CidrBlockSet(), other.ipv6CidrBlockSet()) && this.hasCidrBlockSet() == other.hasCidrBlockSet() && Objects.equals(this.cidrBlockSet(), other.cidrBlockSet()) && Objects.equals(this.ownerId(), other.ownerId()) && Objects.equals(this.peeringOptions(), other.peeringOptions()) && Objects.equals(this.vpcId(), other.vpcId()) && Objects.equals(this.region(), other.region());
    }

    public final String toString() {
        return ToString.builder((String)"VpcPeeringConnectionVpcInfo").add("CidrBlock", (Object)this.cidrBlock()).add("Ipv6CidrBlockSet", this.hasIpv6CidrBlockSet() ? this.ipv6CidrBlockSet() : null).add("CidrBlockSet", this.hasCidrBlockSet() ? this.cidrBlockSet() : null).add("OwnerId", (Object)this.ownerId()).add("PeeringOptions", (Object)this.peeringOptions()).add("VpcId", (Object)this.vpcId()).add("Region", (Object)this.region()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CidrBlock": {
                return Optional.ofNullable(clazz.cast(this.cidrBlock()));
            }
            case "Ipv6CidrBlockSet": {
                return Optional.ofNullable(clazz.cast(this.ipv6CidrBlockSet()));
            }
            case "CidrBlockSet": {
                return Optional.ofNullable(clazz.cast(this.cidrBlockSet()));
            }
            case "OwnerId": {
                return Optional.ofNullable(clazz.cast(this.ownerId()));
            }
            case "PeeringOptions": {
                return Optional.ofNullable(clazz.cast(this.peeringOptions()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
            case "Region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<VpcPeeringConnectionVpcInfo, T> g) {
        return obj -> g.apply((VpcPeeringConnectionVpcInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String cidrBlock;
        private List<Ipv6CidrBlock> ipv6CidrBlockSet = DefaultSdkAutoConstructList.getInstance();
        private List<CidrBlock> cidrBlockSet = DefaultSdkAutoConstructList.getInstance();
        private String ownerId;
        private VpcPeeringConnectionOptionsDescription peeringOptions;
        private String vpcId;
        private String region;

        private BuilderImpl() {
        }

        private BuilderImpl(VpcPeeringConnectionVpcInfo model) {
            this.cidrBlock(model.cidrBlock);
            this.ipv6CidrBlockSet(model.ipv6CidrBlockSet);
            this.cidrBlockSet(model.cidrBlockSet);
            this.ownerId(model.ownerId);
            this.peeringOptions(model.peeringOptions);
            this.vpcId(model.vpcId);
            this.region(model.region);
        }

        public final String getCidrBlock() {
            return this.cidrBlock;
        }

        public final void setCidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
        }

        @Override
        public final Builder cidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
            return this;
        }

        public final List<Ipv6CidrBlock.Builder> getIpv6CidrBlockSet() {
            List<Ipv6CidrBlock.Builder> result = Ipv6CidrBlockSetCopier.copyToBuilder(this.ipv6CidrBlockSet);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIpv6CidrBlockSet(Collection<Ipv6CidrBlock.BuilderImpl> ipv6CidrBlockSet) {
            this.ipv6CidrBlockSet = Ipv6CidrBlockSetCopier.copyFromBuilder(ipv6CidrBlockSet);
        }

        @Override
        public final Builder ipv6CidrBlockSet(Collection<Ipv6CidrBlock> ipv6CidrBlockSet) {
            this.ipv6CidrBlockSet = Ipv6CidrBlockSetCopier.copy(ipv6CidrBlockSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6CidrBlockSet(Ipv6CidrBlock ... ipv6CidrBlockSet) {
            this.ipv6CidrBlockSet(Arrays.asList(ipv6CidrBlockSet));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6CidrBlockSet(Consumer<Ipv6CidrBlock.Builder> ... ipv6CidrBlockSet) {
            this.ipv6CidrBlockSet(Stream.of(ipv6CidrBlockSet).map(c -> (Ipv6CidrBlock)((Ipv6CidrBlock.Builder)Ipv6CidrBlock.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<CidrBlock.Builder> getCidrBlockSet() {
            List<CidrBlock.Builder> result = CidrBlockSetCopier.copyToBuilder(this.cidrBlockSet);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCidrBlockSet(Collection<CidrBlock.BuilderImpl> cidrBlockSet) {
            this.cidrBlockSet = CidrBlockSetCopier.copyFromBuilder(cidrBlockSet);
        }

        @Override
        public final Builder cidrBlockSet(Collection<CidrBlock> cidrBlockSet) {
            this.cidrBlockSet = CidrBlockSetCopier.copy(cidrBlockSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cidrBlockSet(CidrBlock ... cidrBlockSet) {
            this.cidrBlockSet(Arrays.asList(cidrBlockSet));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cidrBlockSet(Consumer<CidrBlock.Builder> ... cidrBlockSet) {
            this.cidrBlockSet(Stream.of(cidrBlockSet).map(c -> (CidrBlock)((CidrBlock.Builder)CidrBlock.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getOwnerId() {
            return this.ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final VpcPeeringConnectionOptionsDescription.Builder getPeeringOptions() {
            return this.peeringOptions != null ? this.peeringOptions.toBuilder() : null;
        }

        public final void setPeeringOptions(VpcPeeringConnectionOptionsDescription.BuilderImpl peeringOptions) {
            this.peeringOptions = peeringOptions != null ? peeringOptions.build() : null;
        }

        @Override
        public final Builder peeringOptions(VpcPeeringConnectionOptionsDescription peeringOptions) {
            this.peeringOptions = peeringOptions;
            return this;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final String getRegion() {
            return this.region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public VpcPeeringConnectionVpcInfo build() {
            return new VpcPeeringConnectionVpcInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VpcPeeringConnectionVpcInfo> {
        public Builder cidrBlock(String var1);

        public Builder ipv6CidrBlockSet(Collection<Ipv6CidrBlock> var1);

        public Builder ipv6CidrBlockSet(Ipv6CidrBlock ... var1);

        public Builder ipv6CidrBlockSet(Consumer<Ipv6CidrBlock.Builder> ... var1);

        public Builder cidrBlockSet(Collection<CidrBlock> var1);

        public Builder cidrBlockSet(CidrBlock ... var1);

        public Builder cidrBlockSet(Consumer<CidrBlock.Builder> ... var1);

        public Builder ownerId(String var1);

        public Builder peeringOptions(VpcPeeringConnectionOptionsDescription var1);

        default public Builder peeringOptions(Consumer<VpcPeeringConnectionOptionsDescription.Builder> peeringOptions) {
            return this.peeringOptions((VpcPeeringConnectionOptionsDescription)((VpcPeeringConnectionOptionsDescription.Builder)VpcPeeringConnectionOptionsDescription.builder().applyMutation(peeringOptions)).build());
        }

        public Builder vpcId(String var1);

        public Builder region(String var1);
    }
}

