/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeImportImageTasksRequest;
import software.amazon.awssdk.services.ec2.model.DescribeImportImageTasksResponse;
import software.amazon.awssdk.services.ec2.model.ImportImageTask;

public class DescribeImportImageTasksIterable
implements SdkIterable<DescribeImportImageTasksResponse> {
    private final Ec2Client client;
    private final DescribeImportImageTasksRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeImportImageTasksIterable(Ec2Client client, DescribeImportImageTasksRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeImportImageTasksResponseFetcher();
    }

    public Iterator<DescribeImportImageTasksResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ImportImageTask> importImageTasks() {
        Function<DescribeImportImageTasksResponse, Iterator> getIterator = response -> {
            if (response != null && response.importImageTasks() != null) {
                return response.importImageTasks().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeImportImageTasksResponseFetcher
    implements SyncPageFetcher<DescribeImportImageTasksResponse> {
        private DescribeImportImageTasksResponseFetcher() {
        }

        public boolean hasNextPage(DescribeImportImageTasksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeImportImageTasksResponse nextPage(DescribeImportImageTasksResponse previousPage) {
            if (previousPage == null) {
                return DescribeImportImageTasksIterable.this.client.describeImportImageTasks(DescribeImportImageTasksIterable.this.firstRequest);
            }
            return DescribeImportImageTasksIterable.this.client.describeImportImageTasks((DescribeImportImageTasksRequest)((Object)DescribeImportImageTasksIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

