/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProvisionPublicIpv4PoolCidrRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, ProvisionPublicIpv4PoolCidrRequest> {
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(ProvisionPublicIpv4PoolCidrRequest.getter(ProvisionPublicIpv4PoolCidrRequest::dryRun)).setter(ProvisionPublicIpv4PoolCidrRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("DryRun").build()}).build();
    private static final SdkField<String> IPAM_POOL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpamPoolId").getter(ProvisionPublicIpv4PoolCidrRequest.getter(ProvisionPublicIpv4PoolCidrRequest::ipamPoolId)).setter(ProvisionPublicIpv4PoolCidrRequest.setter(Builder::ipamPoolId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamPoolId").unmarshallLocationName("IpamPoolId").build()}).build();
    private static final SdkField<String> POOL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PoolId").getter(ProvisionPublicIpv4PoolCidrRequest.getter(ProvisionPublicIpv4PoolCidrRequest::poolId)).setter(ProvisionPublicIpv4PoolCidrRequest.setter(Builder::poolId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolId").unmarshallLocationName("PoolId").build()}).build();
    private static final SdkField<Integer> NETMASK_LENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NetmaskLength").getter(ProvisionPublicIpv4PoolCidrRequest.getter(ProvisionPublicIpv4PoolCidrRequest::netmaskLength)).setter(ProvisionPublicIpv4PoolCidrRequest.setter(Builder::netmaskLength)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetmaskLength").unmarshallLocationName("NetmaskLength").build()}).build();
    private static final SdkField<String> NETWORK_BORDER_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkBorderGroup").getter(ProvisionPublicIpv4PoolCidrRequest.getter(ProvisionPublicIpv4PoolCidrRequest::networkBorderGroup)).setter(ProvisionPublicIpv4PoolCidrRequest.setter(Builder::networkBorderGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkBorderGroup").unmarshallLocationName("NetworkBorderGroup").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DRY_RUN_FIELD, IPAM_POOL_ID_FIELD, POOL_ID_FIELD, NETMASK_LENGTH_FIELD, NETWORK_BORDER_GROUP_FIELD));
    private final Boolean dryRun;
    private final String ipamPoolId;
    private final String poolId;
    private final Integer netmaskLength;
    private final String networkBorderGroup;

    private ProvisionPublicIpv4PoolCidrRequest(BuilderImpl builder) {
        super(builder);
        this.dryRun = builder.dryRun;
        this.ipamPoolId = builder.ipamPoolId;
        this.poolId = builder.poolId;
        this.netmaskLength = builder.netmaskLength;
        this.networkBorderGroup = builder.networkBorderGroup;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final String ipamPoolId() {
        return this.ipamPoolId;
    }

    public final String poolId() {
        return this.poolId;
    }

    public final Integer netmaskLength() {
        return this.netmaskLength;
    }

    public final String networkBorderGroup() {
        return this.networkBorderGroup;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipamPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.poolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.netmaskLength());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkBorderGroup());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProvisionPublicIpv4PoolCidrRequest)) {
            return false;
        }
        ProvisionPublicIpv4PoolCidrRequest other = (ProvisionPublicIpv4PoolCidrRequest)((Object)obj);
        return Objects.equals(this.dryRun(), other.dryRun()) && Objects.equals(this.ipamPoolId(), other.ipamPoolId()) && Objects.equals(this.poolId(), other.poolId()) && Objects.equals(this.netmaskLength(), other.netmaskLength()) && Objects.equals(this.networkBorderGroup(), other.networkBorderGroup());
    }

    public final String toString() {
        return ToString.builder((String)"ProvisionPublicIpv4PoolCidrRequest").add("DryRun", (Object)this.dryRun()).add("IpamPoolId", (Object)this.ipamPoolId()).add("PoolId", (Object)this.poolId()).add("NetmaskLength", (Object)this.netmaskLength()).add("NetworkBorderGroup", (Object)this.networkBorderGroup()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "IpamPoolId": {
                return Optional.ofNullable(clazz.cast(this.ipamPoolId()));
            }
            case "PoolId": {
                return Optional.ofNullable(clazz.cast(this.poolId()));
            }
            case "NetmaskLength": {
                return Optional.ofNullable(clazz.cast(this.netmaskLength()));
            }
            case "NetworkBorderGroup": {
                return Optional.ofNullable(clazz.cast(this.networkBorderGroup()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProvisionPublicIpv4PoolCidrRequest, T> g) {
        return obj -> g.apply((ProvisionPublicIpv4PoolCidrRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private Boolean dryRun;
        private String ipamPoolId;
        private String poolId;
        private Integer netmaskLength;
        private String networkBorderGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(ProvisionPublicIpv4PoolCidrRequest model) {
            super(model);
            this.dryRun(model.dryRun);
            this.ipamPoolId(model.ipamPoolId);
            this.poolId(model.poolId);
            this.netmaskLength(model.netmaskLength);
            this.networkBorderGroup(model.networkBorderGroup);
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getIpamPoolId() {
            return this.ipamPoolId;
        }

        public final void setIpamPoolId(String ipamPoolId) {
            this.ipamPoolId = ipamPoolId;
        }

        @Override
        public final Builder ipamPoolId(String ipamPoolId) {
            this.ipamPoolId = ipamPoolId;
            return this;
        }

        public final String getPoolId() {
            return this.poolId;
        }

        public final void setPoolId(String poolId) {
            this.poolId = poolId;
        }

        @Override
        public final Builder poolId(String poolId) {
            this.poolId = poolId;
            return this;
        }

        public final Integer getNetmaskLength() {
            return this.netmaskLength;
        }

        public final void setNetmaskLength(Integer netmaskLength) {
            this.netmaskLength = netmaskLength;
        }

        @Override
        public final Builder netmaskLength(Integer netmaskLength) {
            this.netmaskLength = netmaskLength;
            return this;
        }

        public final String getNetworkBorderGroup() {
            return this.networkBorderGroup;
        }

        public final void setNetworkBorderGroup(String networkBorderGroup) {
            this.networkBorderGroup = networkBorderGroup;
        }

        @Override
        public final Builder networkBorderGroup(String networkBorderGroup) {
            this.networkBorderGroup = networkBorderGroup;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ProvisionPublicIpv4PoolCidrRequest build() {
            return new ProvisionPublicIpv4PoolCidrRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ProvisionPublicIpv4PoolCidrRequest> {
        public Builder dryRun(Boolean var1);

        public Builder ipamPoolId(String var1);

        public Builder poolId(String var1);

        public Builder netmaskLength(Integer var1);

        public Builder networkBorderGroup(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

