/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.SpotFleetRequestIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeSpotFleetRequestsRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, DescribeSpotFleetRequestsRequest> {
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(DescribeSpotFleetRequestsRequest.getter(DescribeSpotFleetRequestsRequest::dryRun)).setter(DescribeSpotFleetRequestsRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("dryRun").build()}).build();
    private static final SdkField<List<String>> SPOT_FLEET_REQUEST_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SpotFleetRequestIds").getter(DescribeSpotFleetRequestsRequest.getter(DescribeSpotFleetRequestsRequest::spotFleetRequestIds)).setter(DescribeSpotFleetRequestsRequest.setter(Builder::spotFleetRequestIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpotFleetRequestId").unmarshallLocationName("spotFleetRequestId").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeSpotFleetRequestsRequest.getter(DescribeSpotFleetRequestsRequest::nextToken)).setter(DescribeSpotFleetRequestsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(DescribeSpotFleetRequestsRequest.getter(DescribeSpotFleetRequestsRequest::maxResults)).setter(DescribeSpotFleetRequestsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").unmarshallLocationName("maxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DRY_RUN_FIELD, SPOT_FLEET_REQUEST_IDS_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private final Boolean dryRun;
    private final List<String> spotFleetRequestIds;
    private final String nextToken;
    private final Integer maxResults;

    private DescribeSpotFleetRequestsRequest(BuilderImpl builder) {
        super(builder);
        this.dryRun = builder.dryRun;
        this.spotFleetRequestIds = builder.spotFleetRequestIds;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final boolean hasSpotFleetRequestIds() {
        return this.spotFleetRequestIds != null && !(this.spotFleetRequestIds instanceof SdkAutoConstructList);
    }

    public final List<String> spotFleetRequestIds() {
        return this.spotFleetRequestIds;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSpotFleetRequestIds() ? this.spotFleetRequestIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSpotFleetRequestsRequest)) {
            return false;
        }
        DescribeSpotFleetRequestsRequest other = (DescribeSpotFleetRequestsRequest)((Object)obj);
        return Objects.equals(this.dryRun(), other.dryRun()) && this.hasSpotFleetRequestIds() == other.hasSpotFleetRequestIds() && Objects.equals(this.spotFleetRequestIds(), other.spotFleetRequestIds()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeSpotFleetRequestsRequest").add("DryRun", (Object)this.dryRun()).add("SpotFleetRequestIds", this.hasSpotFleetRequestIds() ? this.spotFleetRequestIds() : null).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "SpotFleetRequestIds": {
                return Optional.ofNullable(clazz.cast(this.spotFleetRequestIds()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeSpotFleetRequestsRequest, T> g) {
        return obj -> g.apply((DescribeSpotFleetRequestsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private Boolean dryRun;
        private List<String> spotFleetRequestIds = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSpotFleetRequestsRequest model) {
            super(model);
            this.dryRun(model.dryRun);
            this.spotFleetRequestIds(model.spotFleetRequestIds);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final Collection<String> getSpotFleetRequestIds() {
            if (this.spotFleetRequestIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.spotFleetRequestIds;
        }

        public final void setSpotFleetRequestIds(Collection<String> spotFleetRequestIds) {
            this.spotFleetRequestIds = SpotFleetRequestIdListCopier.copy(spotFleetRequestIds);
        }

        @Override
        public final Builder spotFleetRequestIds(Collection<String> spotFleetRequestIds) {
            this.spotFleetRequestIds = SpotFleetRequestIdListCopier.copy(spotFleetRequestIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder spotFleetRequestIds(String ... spotFleetRequestIds) {
            this.spotFleetRequestIds(Arrays.asList(spotFleetRequestIds));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeSpotFleetRequestsRequest build() {
            return new DescribeSpotFleetRequestsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeSpotFleetRequestsRequest> {
        public Builder dryRun(Boolean var1);

        public Builder spotFleetRequestIds(Collection<String> var1);

        public Builder spotFleetRequestIds(String ... var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

