/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.VerifiedAccessLogDeliveryStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VerifiedAccessLogKinesisDataFirehoseDestination
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VerifiedAccessLogKinesisDataFirehoseDestination> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Enabled").getter(VerifiedAccessLogKinesisDataFirehoseDestination.getter(VerifiedAccessLogKinesisDataFirehoseDestination::enabled)).setter(VerifiedAccessLogKinesisDataFirehoseDestination.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").unmarshallLocationName("enabled").build()}).build();
    private static final SdkField<VerifiedAccessLogDeliveryStatus> DELIVERY_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DeliveryStatus").getter(VerifiedAccessLogKinesisDataFirehoseDestination.getter(VerifiedAccessLogKinesisDataFirehoseDestination::deliveryStatus)).setter(VerifiedAccessLogKinesisDataFirehoseDestination.setter(Builder::deliveryStatus)).constructor(VerifiedAccessLogDeliveryStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryStatus").unmarshallLocationName("deliveryStatus").build()}).build();
    private static final SdkField<String> DELIVERY_STREAM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeliveryStream").getter(VerifiedAccessLogKinesisDataFirehoseDestination.getter(VerifiedAccessLogKinesisDataFirehoseDestination::deliveryStream)).setter(VerifiedAccessLogKinesisDataFirehoseDestination.setter(Builder::deliveryStream)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryStream").unmarshallLocationName("deliveryStream").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD, DELIVERY_STATUS_FIELD, DELIVERY_STREAM_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean enabled;
    private final VerifiedAccessLogDeliveryStatus deliveryStatus;
    private final String deliveryStream;

    private VerifiedAccessLogKinesisDataFirehoseDestination(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.deliveryStatus = builder.deliveryStatus;
        this.deliveryStream = builder.deliveryStream;
    }

    public final Boolean enabled() {
        return this.enabled;
    }

    public final VerifiedAccessLogDeliveryStatus deliveryStatus() {
        return this.deliveryStatus;
    }

    public final String deliveryStream() {
        return this.deliveryStream;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.deliveryStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.deliveryStream());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VerifiedAccessLogKinesisDataFirehoseDestination)) {
            return false;
        }
        VerifiedAccessLogKinesisDataFirehoseDestination other = (VerifiedAccessLogKinesisDataFirehoseDestination)obj;
        return Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.deliveryStatus(), other.deliveryStatus()) && Objects.equals(this.deliveryStream(), other.deliveryStream());
    }

    public final String toString() {
        return ToString.builder((String)"VerifiedAccessLogKinesisDataFirehoseDestination").add("Enabled", (Object)this.enabled()).add("DeliveryStatus", (Object)this.deliveryStatus()).add("DeliveryStream", (Object)this.deliveryStream()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "DeliveryStatus": {
                return Optional.ofNullable(clazz.cast(this.deliveryStatus()));
            }
            case "DeliveryStream": {
                return Optional.ofNullable(clazz.cast(this.deliveryStream()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VerifiedAccessLogKinesisDataFirehoseDestination, T> g) {
        return obj -> g.apply((VerifiedAccessLogKinesisDataFirehoseDestination)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean enabled;
        private VerifiedAccessLogDeliveryStatus deliveryStatus;
        private String deliveryStream;

        private BuilderImpl() {
        }

        private BuilderImpl(VerifiedAccessLogKinesisDataFirehoseDestination model) {
            this.enabled(model.enabled);
            this.deliveryStatus(model.deliveryStatus);
            this.deliveryStream(model.deliveryStream);
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final VerifiedAccessLogDeliveryStatus.Builder getDeliveryStatus() {
            return this.deliveryStatus != null ? this.deliveryStatus.toBuilder() : null;
        }

        public final void setDeliveryStatus(VerifiedAccessLogDeliveryStatus.BuilderImpl deliveryStatus) {
            this.deliveryStatus = deliveryStatus != null ? deliveryStatus.build() : null;
        }

        @Override
        public final Builder deliveryStatus(VerifiedAccessLogDeliveryStatus deliveryStatus) {
            this.deliveryStatus = deliveryStatus;
            return this;
        }

        public final String getDeliveryStream() {
            return this.deliveryStream;
        }

        public final void setDeliveryStream(String deliveryStream) {
            this.deliveryStream = deliveryStream;
        }

        @Override
        public final Builder deliveryStream(String deliveryStream) {
            this.deliveryStream = deliveryStream;
            return this;
        }

        public VerifiedAccessLogKinesisDataFirehoseDestination build() {
            return new VerifiedAccessLogKinesisDataFirehoseDestination(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VerifiedAccessLogKinesisDataFirehoseDestination> {
        public Builder enabled(Boolean var1);

        public Builder deliveryStatus(VerifiedAccessLogDeliveryStatus var1);

        default public Builder deliveryStatus(Consumer<VerifiedAccessLogDeliveryStatus.Builder> deliveryStatus) {
            return this.deliveryStatus((VerifiedAccessLogDeliveryStatus)((VerifiedAccessLogDeliveryStatus.Builder)VerifiedAccessLogDeliveryStatus.builder().applyMutation(deliveryStatus)).build());
        }

        public Builder deliveryStream(String var1);
    }
}

