/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a security group rule.
 * </p>
 * <p>
 * You must specify exactly one of the following parameters, based on the rule type:
 * </p>
 * <ul>
 * <li>
 * <p>
 * CidrIpv4
 * </p>
 * </li>
 * <li>
 * <p>
 * CidrIpv6
 * </p>
 * </li>
 * <li>
 * <p>
 * PrefixListId
 * </p>
 * </li>
 * <li>
 * <p>
 * ReferencedGroupId
 * </p>
 * </li>
 * </ul>
 * <p>
 * When you modify a rule, you cannot change the rule type. For example, if the rule uses an IPv4 address range, you
 * must use <code>CidrIpv4</code> to specify a new IPv4 address range.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SecurityGroupRuleRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<SecurityGroupRuleRequest.Builder, SecurityGroupRuleRequest> {
    private static final SdkField<String> IP_PROTOCOL_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("IpProtocol")
            .getter(getter(SecurityGroupRuleRequest::ipProtocol))
            .setter(setter(Builder::ipProtocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpProtocol")
                    .unmarshallLocationName("IpProtocol").build()).build();

    private static final SdkField<Integer> FROM_PORT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("FromPort")
            .getter(getter(SecurityGroupRuleRequest::fromPort))
            .setter(setter(Builder::fromPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FromPort")
                    .unmarshallLocationName("FromPort").build()).build();

    private static final SdkField<Integer> TO_PORT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("ToPort")
            .getter(getter(SecurityGroupRuleRequest::toPort))
            .setter(setter(Builder::toPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ToPort")
                    .unmarshallLocationName("ToPort").build()).build();

    private static final SdkField<String> CIDR_IPV4_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CidrIpv4")
            .getter(getter(SecurityGroupRuleRequest::cidrIpv4))
            .setter(setter(Builder::cidrIpv4))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CidrIpv4")
                    .unmarshallLocationName("CidrIpv4").build()).build();

    private static final SdkField<String> CIDR_IPV6_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CidrIpv6")
            .getter(getter(SecurityGroupRuleRequest::cidrIpv6))
            .setter(setter(Builder::cidrIpv6))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CidrIpv6")
                    .unmarshallLocationName("CidrIpv6").build()).build();

    private static final SdkField<String> PREFIX_LIST_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PrefixListId")
            .getter(getter(SecurityGroupRuleRequest::prefixListId))
            .setter(setter(Builder::prefixListId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrefixListId")
                    .unmarshallLocationName("PrefixListId").build()).build();

    private static final SdkField<String> REFERENCED_GROUP_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ReferencedGroupId")
            .getter(getter(SecurityGroupRuleRequest::referencedGroupId))
            .setter(setter(Builder::referencedGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReferencedGroupId")
                    .unmarshallLocationName("ReferencedGroupId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Description")
            .getter(getter(SecurityGroupRuleRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description")
                    .unmarshallLocationName("Description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IP_PROTOCOL_FIELD,
            FROM_PORT_FIELD, TO_PORT_FIELD, CIDR_IPV4_FIELD, CIDR_IPV6_FIELD, PREFIX_LIST_ID_FIELD, REFERENCED_GROUP_ID_FIELD,
            DESCRIPTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String ipProtocol;

    private final Integer fromPort;

    private final Integer toPort;

    private final String cidrIpv4;

    private final String cidrIpv6;

    private final String prefixListId;

    private final String referencedGroupId;

    private final String description;

    private SecurityGroupRuleRequest(BuilderImpl builder) {
        this.ipProtocol = builder.ipProtocol;
        this.fromPort = builder.fromPort;
        this.toPort = builder.toPort;
        this.cidrIpv4 = builder.cidrIpv4;
        this.cidrIpv6 = builder.cidrIpv6;
        this.prefixListId = builder.prefixListId;
        this.referencedGroupId = builder.referencedGroupId;
        this.description = builder.description;
    }

    /**
     * <p>
     * The IP protocol name (<code>tcp</code>, <code>udp</code>, <code>icmp</code>, <code>icmpv6</code>) or number (see
     * <a href="http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml">Protocol Numbers</a>).
     * </p>
     * <p>
     * Use <code>-1</code> to specify all protocols.
     * </p>
     * 
     * @return The IP protocol name (<code>tcp</code>, <code>udp</code>, <code>icmp</code>, <code>icmpv6</code>) or
     *         number (see <a href="http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml">Protocol
     *         Numbers</a>). </p>
     *         <p>
     *         Use <code>-1</code> to specify all protocols.
     */
    public final String ipProtocol() {
        return ipProtocol;
    }

    /**
     * <p>
     * If the protocol is TCP or UDP, this is the start of the port range. If the protocol is ICMP or ICMPv6, this is
     * the ICMP type or -1 (all ICMP types).
     * </p>
     * 
     * @return If the protocol is TCP or UDP, this is the start of the port range. If the protocol is ICMP or ICMPv6,
     *         this is the ICMP type or -1 (all ICMP types).
     */
    public final Integer fromPort() {
        return fromPort;
    }

    /**
     * <p>
     * If the protocol is TCP or UDP, this is the end of the port range. If the protocol is ICMP or ICMPv6, this is the
     * ICMP code or -1 (all ICMP codes). If the start port is -1 (all ICMP types), then the end port must be -1 (all
     * ICMP codes).
     * </p>
     * 
     * @return If the protocol is TCP or UDP, this is the end of the port range. If the protocol is ICMP or ICMPv6, this
     *         is the ICMP code or -1 (all ICMP codes). If the start port is -1 (all ICMP types), then the end port must
     *         be -1 (all ICMP codes).
     */
    public final Integer toPort() {
        return toPort;
    }

    /**
     * <p>
     * The IPv4 CIDR range. To specify a single IPv4 address, use the /32 prefix length.
     * </p>
     * 
     * @return The IPv4 CIDR range. To specify a single IPv4 address, use the /32 prefix length.
     */
    public final String cidrIpv4() {
        return cidrIpv4;
    }

    /**
     * <p>
     * The IPv6 CIDR range. To specify a single IPv6 address, use the /128 prefix length.
     * </p>
     * 
     * @return The IPv6 CIDR range. To specify a single IPv6 address, use the /128 prefix length.
     */
    public final String cidrIpv6() {
        return cidrIpv6;
    }

    /**
     * <p>
     * The ID of the prefix list.
     * </p>
     * 
     * @return The ID of the prefix list.
     */
    public final String prefixListId() {
        return prefixListId;
    }

    /**
     * <p>
     * The ID of the security group that is referenced in the security group rule.
     * </p>
     * 
     * @return The ID of the security group that is referenced in the security group rule.
     */
    public final String referencedGroupId() {
        return referencedGroupId;
    }

    /**
     * <p>
     * The description of the security group rule.
     * </p>
     * 
     * @return The description of the security group rule.
     */
    public final String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ipProtocol());
        hashCode = 31 * hashCode + Objects.hashCode(fromPort());
        hashCode = 31 * hashCode + Objects.hashCode(toPort());
        hashCode = 31 * hashCode + Objects.hashCode(cidrIpv4());
        hashCode = 31 * hashCode + Objects.hashCode(cidrIpv6());
        hashCode = 31 * hashCode + Objects.hashCode(prefixListId());
        hashCode = 31 * hashCode + Objects.hashCode(referencedGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SecurityGroupRuleRequest)) {
            return false;
        }
        SecurityGroupRuleRequest other = (SecurityGroupRuleRequest) obj;
        return Objects.equals(ipProtocol(), other.ipProtocol()) && Objects.equals(fromPort(), other.fromPort())
                && Objects.equals(toPort(), other.toPort()) && Objects.equals(cidrIpv4(), other.cidrIpv4())
                && Objects.equals(cidrIpv6(), other.cidrIpv6()) && Objects.equals(prefixListId(), other.prefixListId())
                && Objects.equals(referencedGroupId(), other.referencedGroupId())
                && Objects.equals(description(), other.description());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SecurityGroupRuleRequest").add("IpProtocol", ipProtocol()).add("FromPort", fromPort())
                .add("ToPort", toPort()).add("CidrIpv4", cidrIpv4()).add("CidrIpv6", cidrIpv6())
                .add("PrefixListId", prefixListId()).add("ReferencedGroupId", referencedGroupId())
                .add("Description", description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IpProtocol":
            return Optional.ofNullable(clazz.cast(ipProtocol()));
        case "FromPort":
            return Optional.ofNullable(clazz.cast(fromPort()));
        case "ToPort":
            return Optional.ofNullable(clazz.cast(toPort()));
        case "CidrIpv4":
            return Optional.ofNullable(clazz.cast(cidrIpv4()));
        case "CidrIpv6":
            return Optional.ofNullable(clazz.cast(cidrIpv6()));
        case "PrefixListId":
            return Optional.ofNullable(clazz.cast(prefixListId()));
        case "ReferencedGroupId":
            return Optional.ofNullable(clazz.cast(referencedGroupId()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SecurityGroupRuleRequest, T> g) {
        return obj -> g.apply((SecurityGroupRuleRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SecurityGroupRuleRequest> {
        /**
         * <p>
         * The IP protocol name (<code>tcp</code>, <code>udp</code>, <code>icmp</code>, <code>icmpv6</code>) or number
         * (see <a href="http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml">Protocol Numbers</a>).
         * </p>
         * <p>
         * Use <code>-1</code> to specify all protocols.
         * </p>
         * 
         * @param ipProtocol
         *        The IP protocol name (<code>tcp</code>, <code>udp</code>, <code>icmp</code>, <code>icmpv6</code>) or
         *        number (see <a href="http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml">Protocol
         *        Numbers</a>). </p>
         *        <p>
         *        Use <code>-1</code> to specify all protocols.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipProtocol(String ipProtocol);

        /**
         * <p>
         * If the protocol is TCP or UDP, this is the start of the port range. If the protocol is ICMP or ICMPv6, this
         * is the ICMP type or -1 (all ICMP types).
         * </p>
         * 
         * @param fromPort
         *        If the protocol is TCP or UDP, this is the start of the port range. If the protocol is ICMP or ICMPv6,
         *        this is the ICMP type or -1 (all ICMP types).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fromPort(Integer fromPort);

        /**
         * <p>
         * If the protocol is TCP or UDP, this is the end of the port range. If the protocol is ICMP or ICMPv6, this is
         * the ICMP code or -1 (all ICMP codes). If the start port is -1 (all ICMP types), then the end port must be -1
         * (all ICMP codes).
         * </p>
         * 
         * @param toPort
         *        If the protocol is TCP or UDP, this is the end of the port range. If the protocol is ICMP or ICMPv6,
         *        this is the ICMP code or -1 (all ICMP codes). If the start port is -1 (all ICMP types), then the end
         *        port must be -1 (all ICMP codes).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder toPort(Integer toPort);

        /**
         * <p>
         * The IPv4 CIDR range. To specify a single IPv4 address, use the /32 prefix length.
         * </p>
         * 
         * @param cidrIpv4
         *        The IPv4 CIDR range. To specify a single IPv4 address, use the /32 prefix length.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrIpv4(String cidrIpv4);

        /**
         * <p>
         * The IPv6 CIDR range. To specify a single IPv6 address, use the /128 prefix length.
         * </p>
         * 
         * @param cidrIpv6
         *        The IPv6 CIDR range. To specify a single IPv6 address, use the /128 prefix length.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrIpv6(String cidrIpv6);

        /**
         * <p>
         * The ID of the prefix list.
         * </p>
         * 
         * @param prefixListId
         *        The ID of the prefix list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefixListId(String prefixListId);

        /**
         * <p>
         * The ID of the security group that is referenced in the security group rule.
         * </p>
         * 
         * @param referencedGroupId
         *        The ID of the security group that is referenced in the security group rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder referencedGroupId(String referencedGroupId);

        /**
         * <p>
         * The description of the security group rule.
         * </p>
         * 
         * @param description
         *        The description of the security group rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);
    }

    static final class BuilderImpl implements Builder {
        private String ipProtocol;

        private Integer fromPort;

        private Integer toPort;

        private String cidrIpv4;

        private String cidrIpv6;

        private String prefixListId;

        private String referencedGroupId;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(SecurityGroupRuleRequest model) {
            ipProtocol(model.ipProtocol);
            fromPort(model.fromPort);
            toPort(model.toPort);
            cidrIpv4(model.cidrIpv4);
            cidrIpv6(model.cidrIpv6);
            prefixListId(model.prefixListId);
            referencedGroupId(model.referencedGroupId);
            description(model.description);
        }

        public final String getIpProtocol() {
            return ipProtocol;
        }

        public final void setIpProtocol(String ipProtocol) {
            this.ipProtocol = ipProtocol;
        }

        @Override
        public final Builder ipProtocol(String ipProtocol) {
            this.ipProtocol = ipProtocol;
            return this;
        }

        public final Integer getFromPort() {
            return fromPort;
        }

        public final void setFromPort(Integer fromPort) {
            this.fromPort = fromPort;
        }

        @Override
        public final Builder fromPort(Integer fromPort) {
            this.fromPort = fromPort;
            return this;
        }

        public final Integer getToPort() {
            return toPort;
        }

        public final void setToPort(Integer toPort) {
            this.toPort = toPort;
        }

        @Override
        public final Builder toPort(Integer toPort) {
            this.toPort = toPort;
            return this;
        }

        public final String getCidrIpv4() {
            return cidrIpv4;
        }

        public final void setCidrIpv4(String cidrIpv4) {
            this.cidrIpv4 = cidrIpv4;
        }

        @Override
        public final Builder cidrIpv4(String cidrIpv4) {
            this.cidrIpv4 = cidrIpv4;
            return this;
        }

        public final String getCidrIpv6() {
            return cidrIpv6;
        }

        public final void setCidrIpv6(String cidrIpv6) {
            this.cidrIpv6 = cidrIpv6;
        }

        @Override
        public final Builder cidrIpv6(String cidrIpv6) {
            this.cidrIpv6 = cidrIpv6;
            return this;
        }

        public final String getPrefixListId() {
            return prefixListId;
        }

        public final void setPrefixListId(String prefixListId) {
            this.prefixListId = prefixListId;
        }

        @Override
        public final Builder prefixListId(String prefixListId) {
            this.prefixListId = prefixListId;
            return this;
        }

        public final String getReferencedGroupId() {
            return referencedGroupId;
        }

        public final void setReferencedGroupId(String referencedGroupId) {
            this.referencedGroupId = referencedGroupId;
        }

        @Override
        public final Builder referencedGroupId(String referencedGroupId) {
            this.referencedGroupId = referencedGroupId;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public SecurityGroupRuleRequest build() {
            return new SecurityGroupRuleRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
