/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The default instance metadata service (IMDS) settings that were set at the account level in the specified Amazon Web
 * Services&#x2028; Region.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InstanceMetadataDefaultsResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<InstanceMetadataDefaultsResponse.Builder, InstanceMetadataDefaultsResponse> {
    private static final SdkField<String> HTTP_TOKENS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("HttpTokens")
            .getter(getter(InstanceMetadataDefaultsResponse::httpTokensAsString))
            .setter(setter(Builder::httpTokens))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpTokens")
                    .unmarshallLocationName("httpTokens").build()).build();

    private static final SdkField<Integer> HTTP_PUT_RESPONSE_HOP_LIMIT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("HttpPutResponseHopLimit")
            .getter(getter(InstanceMetadataDefaultsResponse::httpPutResponseHopLimit))
            .setter(setter(Builder::httpPutResponseHopLimit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpPutResponseHopLimit")
                    .unmarshallLocationName("httpPutResponseHopLimit").build()).build();

    private static final SdkField<String> HTTP_ENDPOINT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("HttpEndpoint")
            .getter(getter(InstanceMetadataDefaultsResponse::httpEndpointAsString))
            .setter(setter(Builder::httpEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpEndpoint")
                    .unmarshallLocationName("httpEndpoint").build()).build();

    private static final SdkField<String> INSTANCE_METADATA_TAGS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InstanceMetadataTags")
            .getter(getter(InstanceMetadataDefaultsResponse::instanceMetadataTagsAsString))
            .setter(setter(Builder::instanceMetadataTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceMetadataTags")
                    .unmarshallLocationName("instanceMetadataTags").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HTTP_TOKENS_FIELD,
            HTTP_PUT_RESPONSE_HOP_LIMIT_FIELD, HTTP_ENDPOINT_FIELD, INSTANCE_METADATA_TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String httpTokens;

    private final Integer httpPutResponseHopLimit;

    private final String httpEndpoint;

    private final String instanceMetadataTags;

    private InstanceMetadataDefaultsResponse(BuilderImpl builder) {
        this.httpTokens = builder.httpTokens;
        this.httpPutResponseHopLimit = builder.httpPutResponseHopLimit;
        this.httpEndpoint = builder.httpEndpoint;
        this.instanceMetadataTags = builder.instanceMetadataTags;
    }

    /**
     * <p>
     * Indicates whether IMDSv2 is required.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>optional</code> – IMDSv2 is optional, which means that you can use either IMDSv2 or IMDSv1.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>required</code> – IMDSv2 is required, which means that IMDSv1 is disabled, and you must use IMDSv2.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #httpTokens} will
     * return {@link HttpTokensState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #httpTokensAsString}.
     * </p>
     * 
     * @return Indicates whether IMDSv2 is required.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>optional</code> – IMDSv2 is optional, which means that you can use either IMDSv2 or IMDSv1.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>required</code> – IMDSv2 is required, which means that IMDSv1 is disabled, and you must use IMDSv2.
     *         </p>
     *         </li>
     * @see HttpTokensState
     */
    public final HttpTokensState httpTokens() {
        return HttpTokensState.fromValue(httpTokens);
    }

    /**
     * <p>
     * Indicates whether IMDSv2 is required.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>optional</code> – IMDSv2 is optional, which means that you can use either IMDSv2 or IMDSv1.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>required</code> – IMDSv2 is required, which means that IMDSv1 is disabled, and you must use IMDSv2.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #httpTokens} will
     * return {@link HttpTokensState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #httpTokensAsString}.
     * </p>
     * 
     * @return Indicates whether IMDSv2 is required.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>optional</code> – IMDSv2 is optional, which means that you can use either IMDSv2 or IMDSv1.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>required</code> – IMDSv2 is required, which means that IMDSv1 is disabled, and you must use IMDSv2.
     *         </p>
     *         </li>
     * @see HttpTokensState
     */
    public final String httpTokensAsString() {
        return httpTokens;
    }

    /**
     * <p>
     * The maximum number of hops that the metadata token can travel.
     * </p>
     * 
     * @return The maximum number of hops that the metadata token can travel.
     */
    public final Integer httpPutResponseHopLimit() {
        return httpPutResponseHopLimit;
    }

    /**
     * <p>
     * Indicates whether the IMDS endpoint for an instance is enabled or disabled. When disabled, the instance metadata
     * can't be accessed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #httpEndpoint} will
     * return {@link InstanceMetadataEndpointState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #httpEndpointAsString}.
     * </p>
     * 
     * @return Indicates whether the IMDS endpoint for an instance is enabled or disabled. When disabled, the instance
     *         metadata can't be accessed.
     * @see InstanceMetadataEndpointState
     */
    public final InstanceMetadataEndpointState httpEndpoint() {
        return InstanceMetadataEndpointState.fromValue(httpEndpoint);
    }

    /**
     * <p>
     * Indicates whether the IMDS endpoint for an instance is enabled or disabled. When disabled, the instance metadata
     * can't be accessed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #httpEndpoint} will
     * return {@link InstanceMetadataEndpointState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #httpEndpointAsString}.
     * </p>
     * 
     * @return Indicates whether the IMDS endpoint for an instance is enabled or disabled. When disabled, the instance
     *         metadata can't be accessed.
     * @see InstanceMetadataEndpointState
     */
    public final String httpEndpointAsString() {
        return httpEndpoint;
    }

    /**
     * <p>
     * Indicates whether access to instance tags from the instance metadata is enabled or disabled. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html#work-with-tags-in-IMDS">Work with
     * instance tags using the instance metadata</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #instanceMetadataTags} will return {@link InstanceMetadataTagsState#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #instanceMetadataTagsAsString}.
     * </p>
     * 
     * @return Indicates whether access to instance tags from the instance metadata is enabled or disabled. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html#work-with-tags-in-IMDS">Work
     *         with instance tags using the instance metadata</a> in the <i>Amazon EC2 User Guide</i>.
     * @see InstanceMetadataTagsState
     */
    public final InstanceMetadataTagsState instanceMetadataTags() {
        return InstanceMetadataTagsState.fromValue(instanceMetadataTags);
    }

    /**
     * <p>
     * Indicates whether access to instance tags from the instance metadata is enabled or disabled. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html#work-with-tags-in-IMDS">Work with
     * instance tags using the instance metadata</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #instanceMetadataTags} will return {@link InstanceMetadataTagsState#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #instanceMetadataTagsAsString}.
     * </p>
     * 
     * @return Indicates whether access to instance tags from the instance metadata is enabled or disabled. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html#work-with-tags-in-IMDS">Work
     *         with instance tags using the instance metadata</a> in the <i>Amazon EC2 User Guide</i>.
     * @see InstanceMetadataTagsState
     */
    public final String instanceMetadataTagsAsString() {
        return instanceMetadataTags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(httpTokensAsString());
        hashCode = 31 * hashCode + Objects.hashCode(httpPutResponseHopLimit());
        hashCode = 31 * hashCode + Objects.hashCode(httpEndpointAsString());
        hashCode = 31 * hashCode + Objects.hashCode(instanceMetadataTagsAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceMetadataDefaultsResponse)) {
            return false;
        }
        InstanceMetadataDefaultsResponse other = (InstanceMetadataDefaultsResponse) obj;
        return Objects.equals(httpTokensAsString(), other.httpTokensAsString())
                && Objects.equals(httpPutResponseHopLimit(), other.httpPutResponseHopLimit())
                && Objects.equals(httpEndpointAsString(), other.httpEndpointAsString())
                && Objects.equals(instanceMetadataTagsAsString(), other.instanceMetadataTagsAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InstanceMetadataDefaultsResponse").add("HttpTokens", httpTokensAsString())
                .add("HttpPutResponseHopLimit", httpPutResponseHopLimit()).add("HttpEndpoint", httpEndpointAsString())
                .add("InstanceMetadataTags", instanceMetadataTagsAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HttpTokens":
            return Optional.ofNullable(clazz.cast(httpTokensAsString()));
        case "HttpPutResponseHopLimit":
            return Optional.ofNullable(clazz.cast(httpPutResponseHopLimit()));
        case "HttpEndpoint":
            return Optional.ofNullable(clazz.cast(httpEndpointAsString()));
        case "InstanceMetadataTags":
            return Optional.ofNullable(clazz.cast(instanceMetadataTagsAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceMetadataDefaultsResponse, T> g) {
        return obj -> g.apply((InstanceMetadataDefaultsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InstanceMetadataDefaultsResponse> {
        /**
         * <p>
         * Indicates whether IMDSv2 is required.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>optional</code> – IMDSv2 is optional, which means that you can use either IMDSv2 or IMDSv1.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>required</code> – IMDSv2 is required, which means that IMDSv1 is disabled, and you must use IMDSv2.
         * </p>
         * </li>
         * </ul>
         * 
         * @param httpTokens
         *        Indicates whether IMDSv2 is required.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>optional</code> – IMDSv2 is optional, which means that you can use either IMDSv2 or IMDSv1.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>required</code> – IMDSv2 is required, which means that IMDSv1 is disabled, and you must use
         *        IMDSv2.
         *        </p>
         *        </li>
         * @see HttpTokensState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HttpTokensState
         */
        Builder httpTokens(String httpTokens);

        /**
         * <p>
         * Indicates whether IMDSv2 is required.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>optional</code> – IMDSv2 is optional, which means that you can use either IMDSv2 or IMDSv1.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>required</code> – IMDSv2 is required, which means that IMDSv1 is disabled, and you must use IMDSv2.
         * </p>
         * </li>
         * </ul>
         * 
         * @param httpTokens
         *        Indicates whether IMDSv2 is required.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>optional</code> – IMDSv2 is optional, which means that you can use either IMDSv2 or IMDSv1.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>required</code> – IMDSv2 is required, which means that IMDSv1 is disabled, and you must use
         *        IMDSv2.
         *        </p>
         *        </li>
         * @see HttpTokensState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HttpTokensState
         */
        Builder httpTokens(HttpTokensState httpTokens);

        /**
         * <p>
         * The maximum number of hops that the metadata token can travel.
         * </p>
         * 
         * @param httpPutResponseHopLimit
         *        The maximum number of hops that the metadata token can travel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder httpPutResponseHopLimit(Integer httpPutResponseHopLimit);

        /**
         * <p>
         * Indicates whether the IMDS endpoint for an instance is enabled or disabled. When disabled, the instance
         * metadata can't be accessed.
         * </p>
         * 
         * @param httpEndpoint
         *        Indicates whether the IMDS endpoint for an instance is enabled or disabled. When disabled, the
         *        instance metadata can't be accessed.
         * @see InstanceMetadataEndpointState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceMetadataEndpointState
         */
        Builder httpEndpoint(String httpEndpoint);

        /**
         * <p>
         * Indicates whether the IMDS endpoint for an instance is enabled or disabled. When disabled, the instance
         * metadata can't be accessed.
         * </p>
         * 
         * @param httpEndpoint
         *        Indicates whether the IMDS endpoint for an instance is enabled or disabled. When disabled, the
         *        instance metadata can't be accessed.
         * @see InstanceMetadataEndpointState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceMetadataEndpointState
         */
        Builder httpEndpoint(InstanceMetadataEndpointState httpEndpoint);

        /**
         * <p>
         * Indicates whether access to instance tags from the instance metadata is enabled or disabled. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html#work-with-tags-in-IMDS">Work with
         * instance tags using the instance metadata</a> in the <i>Amazon EC2 User Guide</i>.
         * </p>
         * 
         * @param instanceMetadataTags
         *        Indicates whether access to instance tags from the instance metadata is enabled or disabled. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html#work-with-tags-in-IMDS">Work
         *        with instance tags using the instance metadata</a> in the <i>Amazon EC2 User Guide</i>.
         * @see InstanceMetadataTagsState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceMetadataTagsState
         */
        Builder instanceMetadataTags(String instanceMetadataTags);

        /**
         * <p>
         * Indicates whether access to instance tags from the instance metadata is enabled or disabled. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html#work-with-tags-in-IMDS">Work with
         * instance tags using the instance metadata</a> in the <i>Amazon EC2 User Guide</i>.
         * </p>
         * 
         * @param instanceMetadataTags
         *        Indicates whether access to instance tags from the instance metadata is enabled or disabled. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html#work-with-tags-in-IMDS">Work
         *        with instance tags using the instance metadata</a> in the <i>Amazon EC2 User Guide</i>.
         * @see InstanceMetadataTagsState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceMetadataTagsState
         */
        Builder instanceMetadataTags(InstanceMetadataTagsState instanceMetadataTags);
    }

    static final class BuilderImpl implements Builder {
        private String httpTokens;

        private Integer httpPutResponseHopLimit;

        private String httpEndpoint;

        private String instanceMetadataTags;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceMetadataDefaultsResponse model) {
            httpTokens(model.httpTokens);
            httpPutResponseHopLimit(model.httpPutResponseHopLimit);
            httpEndpoint(model.httpEndpoint);
            instanceMetadataTags(model.instanceMetadataTags);
        }

        public final String getHttpTokens() {
            return httpTokens;
        }

        public final void setHttpTokens(String httpTokens) {
            this.httpTokens = httpTokens;
        }

        @Override
        public final Builder httpTokens(String httpTokens) {
            this.httpTokens = httpTokens;
            return this;
        }

        @Override
        public final Builder httpTokens(HttpTokensState httpTokens) {
            this.httpTokens(httpTokens == null ? null : httpTokens.toString());
            return this;
        }

        public final Integer getHttpPutResponseHopLimit() {
            return httpPutResponseHopLimit;
        }

        public final void setHttpPutResponseHopLimit(Integer httpPutResponseHopLimit) {
            this.httpPutResponseHopLimit = httpPutResponseHopLimit;
        }

        @Override
        public final Builder httpPutResponseHopLimit(Integer httpPutResponseHopLimit) {
            this.httpPutResponseHopLimit = httpPutResponseHopLimit;
            return this;
        }

        public final String getHttpEndpoint() {
            return httpEndpoint;
        }

        public final void setHttpEndpoint(String httpEndpoint) {
            this.httpEndpoint = httpEndpoint;
        }

        @Override
        public final Builder httpEndpoint(String httpEndpoint) {
            this.httpEndpoint = httpEndpoint;
            return this;
        }

        @Override
        public final Builder httpEndpoint(InstanceMetadataEndpointState httpEndpoint) {
            this.httpEndpoint(httpEndpoint == null ? null : httpEndpoint.toString());
            return this;
        }

        public final String getInstanceMetadataTags() {
            return instanceMetadataTags;
        }

        public final void setInstanceMetadataTags(String instanceMetadataTags) {
            this.instanceMetadataTags = instanceMetadataTags;
        }

        @Override
        public final Builder instanceMetadataTags(String instanceMetadataTags) {
            this.instanceMetadataTags = instanceMetadataTags;
            return this;
        }

        @Override
        public final Builder instanceMetadataTags(InstanceMetadataTagsState instanceMetadataTags) {
            this.instanceMetadataTags(instanceMetadataTags == null ? null : instanceMetadataTags.toString());
            return this;
        }

        @Override
        public InstanceMetadataDefaultsResponse build() {
            return new InstanceMetadataDefaultsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
