/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.IpamResourceTag;
import software.amazon.awssdk.services.ec2.model.IpamResourceTagListCopier;
import software.amazon.awssdk.services.ec2.model.IpamResourceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IpamDiscoveredResourceCidr
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IpamDiscoveredResourceCidr> {
    private static final SdkField<String> IPAM_RESOURCE_DISCOVERY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpamResourceDiscoveryId").getter(IpamDiscoveredResourceCidr.getter(IpamDiscoveredResourceCidr::ipamResourceDiscoveryId)).setter(IpamDiscoveredResourceCidr.setter(Builder::ipamResourceDiscoveryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamResourceDiscoveryId").unmarshallLocationName("ipamResourceDiscoveryId").build()}).build();
    private static final SdkField<String> RESOURCE_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceRegion").getter(IpamDiscoveredResourceCidr.getter(IpamDiscoveredResourceCidr::resourceRegion)).setter(IpamDiscoveredResourceCidr.setter(Builder::resourceRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceRegion").unmarshallLocationName("resourceRegion").build()}).build();
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceId").getter(IpamDiscoveredResourceCidr.getter(IpamDiscoveredResourceCidr::resourceId)).setter(IpamDiscoveredResourceCidr.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").unmarshallLocationName("resourceId").build()}).build();
    private static final SdkField<String> RESOURCE_OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceOwnerId").getter(IpamDiscoveredResourceCidr.getter(IpamDiscoveredResourceCidr::resourceOwnerId)).setter(IpamDiscoveredResourceCidr.setter(Builder::resourceOwnerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceOwnerId").unmarshallLocationName("resourceOwnerId").build()}).build();
    private static final SdkField<String> RESOURCE_CIDR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceCidr").getter(IpamDiscoveredResourceCidr.getter(IpamDiscoveredResourceCidr::resourceCidr)).setter(IpamDiscoveredResourceCidr.setter(Builder::resourceCidr)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceCidr").unmarshallLocationName("resourceCidr").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(IpamDiscoveredResourceCidr.getter(IpamDiscoveredResourceCidr::resourceTypeAsString)).setter(IpamDiscoveredResourceCidr.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").unmarshallLocationName("resourceType").build()}).build();
    private static final SdkField<List<IpamResourceTag>> RESOURCE_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResourceTags").getter(IpamDiscoveredResourceCidr.getter(IpamDiscoveredResourceCidr::resourceTags)).setter(IpamDiscoveredResourceCidr.setter(Builder::resourceTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceTagSet").unmarshallLocationName("resourceTagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IpamResourceTag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<Double> IP_USAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("IpUsage").getter(IpamDiscoveredResourceCidr.getter(IpamDiscoveredResourceCidr::ipUsage)).setter(IpamDiscoveredResourceCidr.setter(Builder::ipUsage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpUsage").unmarshallLocationName("ipUsage").build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcId").getter(IpamDiscoveredResourceCidr.getter(IpamDiscoveredResourceCidr::vpcId)).setter(IpamDiscoveredResourceCidr.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").unmarshallLocationName("vpcId").build()}).build();
    private static final SdkField<Instant> SAMPLE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("SampleTime").getter(IpamDiscoveredResourceCidr.getter(IpamDiscoveredResourceCidr::sampleTime)).setter(IpamDiscoveredResourceCidr.setter(Builder::sampleTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SampleTime").unmarshallLocationName("sampleTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IPAM_RESOURCE_DISCOVERY_ID_FIELD, RESOURCE_REGION_FIELD, RESOURCE_ID_FIELD, RESOURCE_OWNER_ID_FIELD, RESOURCE_CIDR_FIELD, RESOURCE_TYPE_FIELD, RESOURCE_TAGS_FIELD, IP_USAGE_FIELD, VPC_ID_FIELD, SAMPLE_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String ipamResourceDiscoveryId;
    private final String resourceRegion;
    private final String resourceId;
    private final String resourceOwnerId;
    private final String resourceCidr;
    private final String resourceType;
    private final List<IpamResourceTag> resourceTags;
    private final Double ipUsage;
    private final String vpcId;
    private final Instant sampleTime;

    private IpamDiscoveredResourceCidr(BuilderImpl builder) {
        this.ipamResourceDiscoveryId = builder.ipamResourceDiscoveryId;
        this.resourceRegion = builder.resourceRegion;
        this.resourceId = builder.resourceId;
        this.resourceOwnerId = builder.resourceOwnerId;
        this.resourceCidr = builder.resourceCidr;
        this.resourceType = builder.resourceType;
        this.resourceTags = builder.resourceTags;
        this.ipUsage = builder.ipUsage;
        this.vpcId = builder.vpcId;
        this.sampleTime = builder.sampleTime;
    }

    public final String ipamResourceDiscoveryId() {
        return this.ipamResourceDiscoveryId;
    }

    public final String resourceRegion() {
        return this.resourceRegion;
    }

    public final String resourceId() {
        return this.resourceId;
    }

    public final String resourceOwnerId() {
        return this.resourceOwnerId;
    }

    public final String resourceCidr() {
        return this.resourceCidr;
    }

    public final IpamResourceType resourceType() {
        return IpamResourceType.fromValue(this.resourceType);
    }

    public final String resourceTypeAsString() {
        return this.resourceType;
    }

    public final boolean hasResourceTags() {
        return this.resourceTags != null && !(this.resourceTags instanceof SdkAutoConstructList);
    }

    public final List<IpamResourceTag> resourceTags() {
        return this.resourceTags;
    }

    public final Double ipUsage() {
        return this.ipUsage;
    }

    public final String vpcId() {
        return this.vpcId;
    }

    public final Instant sampleTime() {
        return this.sampleTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ipamResourceDiscoveryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceOwnerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceCidr());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceTags() ? this.resourceTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.ipUsage());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sampleTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IpamDiscoveredResourceCidr)) {
            return false;
        }
        IpamDiscoveredResourceCidr other = (IpamDiscoveredResourceCidr)obj;
        return Objects.equals(this.ipamResourceDiscoveryId(), other.ipamResourceDiscoveryId()) && Objects.equals(this.resourceRegion(), other.resourceRegion()) && Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.resourceOwnerId(), other.resourceOwnerId()) && Objects.equals(this.resourceCidr(), other.resourceCidr()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && this.hasResourceTags() == other.hasResourceTags() && Objects.equals(this.resourceTags(), other.resourceTags()) && Objects.equals(this.ipUsage(), other.ipUsage()) && Objects.equals(this.vpcId(), other.vpcId()) && Objects.equals(this.sampleTime(), other.sampleTime());
    }

    public final String toString() {
        return ToString.builder((String)"IpamDiscoveredResourceCidr").add("IpamResourceDiscoveryId", (Object)this.ipamResourceDiscoveryId()).add("ResourceRegion", (Object)this.resourceRegion()).add("ResourceId", (Object)this.resourceId()).add("ResourceOwnerId", (Object)this.resourceOwnerId()).add("ResourceCidr", (Object)this.resourceCidr()).add("ResourceType", (Object)this.resourceTypeAsString()).add("ResourceTags", this.hasResourceTags() ? this.resourceTags() : null).add("IpUsage", (Object)this.ipUsage()).add("VpcId", (Object)this.vpcId()).add("SampleTime", (Object)this.sampleTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IpamResourceDiscoveryId": {
                return Optional.ofNullable(clazz.cast(this.ipamResourceDiscoveryId()));
            }
            case "ResourceRegion": {
                return Optional.ofNullable(clazz.cast(this.resourceRegion()));
            }
            case "ResourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "ResourceOwnerId": {
                return Optional.ofNullable(clazz.cast(this.resourceOwnerId()));
            }
            case "ResourceCidr": {
                return Optional.ofNullable(clazz.cast(this.resourceCidr()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "ResourceTags": {
                return Optional.ofNullable(clazz.cast(this.resourceTags()));
            }
            case "IpUsage": {
                return Optional.ofNullable(clazz.cast(this.ipUsage()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
            case "SampleTime": {
                return Optional.ofNullable(clazz.cast(this.sampleTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IpamDiscoveredResourceCidr, T> g) {
        return obj -> g.apply((IpamDiscoveredResourceCidr)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String ipamResourceDiscoveryId;
        private String resourceRegion;
        private String resourceId;
        private String resourceOwnerId;
        private String resourceCidr;
        private String resourceType;
        private List<IpamResourceTag> resourceTags = DefaultSdkAutoConstructList.getInstance();
        private Double ipUsage;
        private String vpcId;
        private Instant sampleTime;

        private BuilderImpl() {
        }

        private BuilderImpl(IpamDiscoveredResourceCidr model) {
            this.ipamResourceDiscoveryId(model.ipamResourceDiscoveryId);
            this.resourceRegion(model.resourceRegion);
            this.resourceId(model.resourceId);
            this.resourceOwnerId(model.resourceOwnerId);
            this.resourceCidr(model.resourceCidr);
            this.resourceType(model.resourceType);
            this.resourceTags(model.resourceTags);
            this.ipUsage(model.ipUsage);
            this.vpcId(model.vpcId);
            this.sampleTime(model.sampleTime);
        }

        public final String getIpamResourceDiscoveryId() {
            return this.ipamResourceDiscoveryId;
        }

        public final void setIpamResourceDiscoveryId(String ipamResourceDiscoveryId) {
            this.ipamResourceDiscoveryId = ipamResourceDiscoveryId;
        }

        @Override
        public final Builder ipamResourceDiscoveryId(String ipamResourceDiscoveryId) {
            this.ipamResourceDiscoveryId = ipamResourceDiscoveryId;
            return this;
        }

        public final String getResourceRegion() {
            return this.resourceRegion;
        }

        public final void setResourceRegion(String resourceRegion) {
            this.resourceRegion = resourceRegion;
        }

        @Override
        public final Builder resourceRegion(String resourceRegion) {
            this.resourceRegion = resourceRegion;
            return this;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getResourceOwnerId() {
            return this.resourceOwnerId;
        }

        public final void setResourceOwnerId(String resourceOwnerId) {
            this.resourceOwnerId = resourceOwnerId;
        }

        @Override
        public final Builder resourceOwnerId(String resourceOwnerId) {
            this.resourceOwnerId = resourceOwnerId;
            return this;
        }

        public final String getResourceCidr() {
            return this.resourceCidr;
        }

        public final void setResourceCidr(String resourceCidr) {
            this.resourceCidr = resourceCidr;
        }

        @Override
        public final Builder resourceCidr(String resourceCidr) {
            this.resourceCidr = resourceCidr;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(IpamResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final List<IpamResourceTag.Builder> getResourceTags() {
            List<IpamResourceTag.Builder> result = IpamResourceTagListCopier.copyToBuilder(this.resourceTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceTags(Collection<IpamResourceTag.BuilderImpl> resourceTags) {
            this.resourceTags = IpamResourceTagListCopier.copyFromBuilder(resourceTags);
        }

        @Override
        public final Builder resourceTags(Collection<IpamResourceTag> resourceTags) {
            this.resourceTags = IpamResourceTagListCopier.copy(resourceTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTags(IpamResourceTag ... resourceTags) {
            this.resourceTags(Arrays.asList(resourceTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTags(Consumer<IpamResourceTag.Builder> ... resourceTags) {
            this.resourceTags(Stream.of(resourceTags).map(c -> (IpamResourceTag)((IpamResourceTag.Builder)IpamResourceTag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Double getIpUsage() {
            return this.ipUsage;
        }

        public final void setIpUsage(Double ipUsage) {
            this.ipUsage = ipUsage;
        }

        @Override
        public final Builder ipUsage(Double ipUsage) {
            this.ipUsage = ipUsage;
            return this;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final Instant getSampleTime() {
            return this.sampleTime;
        }

        public final void setSampleTime(Instant sampleTime) {
            this.sampleTime = sampleTime;
        }

        @Override
        public final Builder sampleTime(Instant sampleTime) {
            this.sampleTime = sampleTime;
            return this;
        }

        public IpamDiscoveredResourceCidr build() {
            return new IpamDiscoveredResourceCidr(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IpamDiscoveredResourceCidr> {
        public Builder ipamResourceDiscoveryId(String var1);

        public Builder resourceRegion(String var1);

        public Builder resourceId(String var1);

        public Builder resourceOwnerId(String var1);

        public Builder resourceCidr(String var1);

        public Builder resourceType(String var1);

        public Builder resourceType(IpamResourceType var1);

        public Builder resourceTags(Collection<IpamResourceTag> var1);

        public Builder resourceTags(IpamResourceTag ... var1);

        public Builder resourceTags(Consumer<IpamResourceTag.Builder> ... var1);

        public Builder ipUsage(Double var1);

        public Builder vpcId(String var1);

        public Builder sampleTime(Instant var1);
    }
}

