/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.AddressFamily;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.IpamPoolAwsService;
import software.amazon.awssdk.services.ec2.model.IpamPoolPublicIpSource;
import software.amazon.awssdk.services.ec2.model.RequestIpamResourceTag;
import software.amazon.awssdk.services.ec2.model.RequestIpamResourceTagListCopier;
import software.amazon.awssdk.services.ec2.model.TagSpecification;
import software.amazon.awssdk.services.ec2.model.TagSpecificationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateIpamPoolRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, CreateIpamPoolRequest> {
    private static final SdkField<String> IPAM_SCOPE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpamScopeId").getter(CreateIpamPoolRequest.getter(CreateIpamPoolRequest::ipamScopeId)).setter(CreateIpamPoolRequest.setter(Builder::ipamScopeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamScopeId").unmarshallLocationName("IpamScopeId").build()}).build();
    private static final SdkField<String> LOCALE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Locale").getter(CreateIpamPoolRequest.getter(CreateIpamPoolRequest::locale)).setter(CreateIpamPoolRequest.setter(Builder::locale)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Locale").unmarshallLocationName("Locale").build()}).build();
    private static final SdkField<String> SOURCE_IPAM_POOL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceIpamPoolId").getter(CreateIpamPoolRequest.getter(CreateIpamPoolRequest::sourceIpamPoolId)).setter(CreateIpamPoolRequest.setter(Builder::sourceIpamPoolId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceIpamPoolId").unmarshallLocationName("SourceIpamPoolId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateIpamPoolRequest.getter(CreateIpamPoolRequest::description)).setter(CreateIpamPoolRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("Description").build()}).build();
    private static final SdkField<String> ADDRESS_FAMILY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AddressFamily").getter(CreateIpamPoolRequest.getter(CreateIpamPoolRequest::addressFamilyAsString)).setter(CreateIpamPoolRequest.setter(Builder::addressFamily)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddressFamily").unmarshallLocationName("AddressFamily").build()}).build();
    private static final SdkField<Boolean> AUTO_IMPORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AutoImport").getter(CreateIpamPoolRequest.getter(CreateIpamPoolRequest::autoImport)).setter(CreateIpamPoolRequest.setter(Builder::autoImport)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoImport").unmarshallLocationName("AutoImport").build()}).build();
    private static final SdkField<Boolean> PUBLICLY_ADVERTISABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("PubliclyAdvertisable").getter(CreateIpamPoolRequest.getter(CreateIpamPoolRequest::publiclyAdvertisable)).setter(CreateIpamPoolRequest.setter(Builder::publiclyAdvertisable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PubliclyAdvertisable").unmarshallLocationName("PubliclyAdvertisable").build()}).build();
    private static final SdkField<Integer> ALLOCATION_MIN_NETMASK_LENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("AllocationMinNetmaskLength").getter(CreateIpamPoolRequest.getter(CreateIpamPoolRequest::allocationMinNetmaskLength)).setter(CreateIpamPoolRequest.setter(Builder::allocationMinNetmaskLength)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocationMinNetmaskLength").unmarshallLocationName("AllocationMinNetmaskLength").build()}).build();
    private static final SdkField<Integer> ALLOCATION_MAX_NETMASK_LENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("AllocationMaxNetmaskLength").getter(CreateIpamPoolRequest.getter(CreateIpamPoolRequest::allocationMaxNetmaskLength)).setter(CreateIpamPoolRequest.setter(Builder::allocationMaxNetmaskLength)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocationMaxNetmaskLength").unmarshallLocationName("AllocationMaxNetmaskLength").build()}).build();
    private static final SdkField<Integer> ALLOCATION_DEFAULT_NETMASK_LENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("AllocationDefaultNetmaskLength").getter(CreateIpamPoolRequest.getter(CreateIpamPoolRequest::allocationDefaultNetmaskLength)).setter(CreateIpamPoolRequest.setter(Builder::allocationDefaultNetmaskLength)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocationDefaultNetmaskLength").unmarshallLocationName("AllocationDefaultNetmaskLength").build()}).build();
    private static final SdkField<List<RequestIpamResourceTag>> ALLOCATION_RESOURCE_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AllocationResourceTags").getter(CreateIpamPoolRequest.getter(CreateIpamPoolRequest::allocationResourceTags)).setter(CreateIpamPoolRequest.setter(Builder::allocationResourceTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocationResourceTag").unmarshallLocationName("AllocationResourceTag").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RequestIpamResourceTag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagSpecifications").getter(CreateIpamPoolRequest.getter(CreateIpamPoolRequest::tagSpecifications)).setter(CreateIpamPoolRequest.setter(Builder::tagSpecifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification").unmarshallLocationName("TagSpecification").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TagSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateIpamPoolRequest.getter(CreateIpamPoolRequest::clientToken)).setter(CreateIpamPoolRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").unmarshallLocationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> AWS_SERVICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AwsService").getter(CreateIpamPoolRequest.getter(CreateIpamPoolRequest::awsServiceAsString)).setter(CreateIpamPoolRequest.setter(Builder::awsService)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsService").unmarshallLocationName("AwsService").build()}).build();
    private static final SdkField<String> PUBLIC_IP_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PublicIpSource").getter(CreateIpamPoolRequest.getter(CreateIpamPoolRequest::publicIpSourceAsString)).setter(CreateIpamPoolRequest.setter(Builder::publicIpSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicIpSource").unmarshallLocationName("PublicIpSource").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IPAM_SCOPE_ID_FIELD, LOCALE_FIELD, SOURCE_IPAM_POOL_ID_FIELD, DESCRIPTION_FIELD, ADDRESS_FAMILY_FIELD, AUTO_IMPORT_FIELD, PUBLICLY_ADVERTISABLE_FIELD, ALLOCATION_MIN_NETMASK_LENGTH_FIELD, ALLOCATION_MAX_NETMASK_LENGTH_FIELD, ALLOCATION_DEFAULT_NETMASK_LENGTH_FIELD, ALLOCATION_RESOURCE_TAGS_FIELD, TAG_SPECIFICATIONS_FIELD, CLIENT_TOKEN_FIELD, AWS_SERVICE_FIELD, PUBLIC_IP_SOURCE_FIELD));
    private final String ipamScopeId;
    private final String locale;
    private final String sourceIpamPoolId;
    private final String description;
    private final String addressFamily;
    private final Boolean autoImport;
    private final Boolean publiclyAdvertisable;
    private final Integer allocationMinNetmaskLength;
    private final Integer allocationMaxNetmaskLength;
    private final Integer allocationDefaultNetmaskLength;
    private final List<RequestIpamResourceTag> allocationResourceTags;
    private final List<TagSpecification> tagSpecifications;
    private final String clientToken;
    private final String awsService;
    private final String publicIpSource;

    private CreateIpamPoolRequest(BuilderImpl builder) {
        super(builder);
        this.ipamScopeId = builder.ipamScopeId;
        this.locale = builder.locale;
        this.sourceIpamPoolId = builder.sourceIpamPoolId;
        this.description = builder.description;
        this.addressFamily = builder.addressFamily;
        this.autoImport = builder.autoImport;
        this.publiclyAdvertisable = builder.publiclyAdvertisable;
        this.allocationMinNetmaskLength = builder.allocationMinNetmaskLength;
        this.allocationMaxNetmaskLength = builder.allocationMaxNetmaskLength;
        this.allocationDefaultNetmaskLength = builder.allocationDefaultNetmaskLength;
        this.allocationResourceTags = builder.allocationResourceTags;
        this.tagSpecifications = builder.tagSpecifications;
        this.clientToken = builder.clientToken;
        this.awsService = builder.awsService;
        this.publicIpSource = builder.publicIpSource;
    }

    public final String ipamScopeId() {
        return this.ipamScopeId;
    }

    public final String locale() {
        return this.locale;
    }

    public final String sourceIpamPoolId() {
        return this.sourceIpamPoolId;
    }

    public final String description() {
        return this.description;
    }

    public final AddressFamily addressFamily() {
        return AddressFamily.fromValue(this.addressFamily);
    }

    public final String addressFamilyAsString() {
        return this.addressFamily;
    }

    public final Boolean autoImport() {
        return this.autoImport;
    }

    public final Boolean publiclyAdvertisable() {
        return this.publiclyAdvertisable;
    }

    public final Integer allocationMinNetmaskLength() {
        return this.allocationMinNetmaskLength;
    }

    public final Integer allocationMaxNetmaskLength() {
        return this.allocationMaxNetmaskLength;
    }

    public final Integer allocationDefaultNetmaskLength() {
        return this.allocationDefaultNetmaskLength;
    }

    public final boolean hasAllocationResourceTags() {
        return this.allocationResourceTags != null && !(this.allocationResourceTags instanceof SdkAutoConstructList);
    }

    public final List<RequestIpamResourceTag> allocationResourceTags() {
        return this.allocationResourceTags;
    }

    public final boolean hasTagSpecifications() {
        return this.tagSpecifications != null && !(this.tagSpecifications instanceof SdkAutoConstructList);
    }

    public final List<TagSpecification> tagSpecifications() {
        return this.tagSpecifications;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final IpamPoolAwsService awsService() {
        return IpamPoolAwsService.fromValue(this.awsService);
    }

    public final String awsServiceAsString() {
        return this.awsService;
    }

    public final IpamPoolPublicIpSource publicIpSource() {
        return IpamPoolPublicIpSource.fromValue(this.publicIpSource);
    }

    public final String publicIpSourceAsString() {
        return this.publicIpSource;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.ipamScopeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.locale());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceIpamPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.addressFamilyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoImport());
        hashCode = 31 * hashCode + Objects.hashCode(this.publiclyAdvertisable());
        hashCode = 31 * hashCode + Objects.hashCode(this.allocationMinNetmaskLength());
        hashCode = 31 * hashCode + Objects.hashCode(this.allocationMaxNetmaskLength());
        hashCode = 31 * hashCode + Objects.hashCode(this.allocationDefaultNetmaskLength());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAllocationResourceTags() ? this.allocationResourceTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagSpecifications() ? this.tagSpecifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsServiceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicIpSourceAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateIpamPoolRequest)) {
            return false;
        }
        CreateIpamPoolRequest other = (CreateIpamPoolRequest)((Object)obj);
        return Objects.equals(this.ipamScopeId(), other.ipamScopeId()) && Objects.equals(this.locale(), other.locale()) && Objects.equals(this.sourceIpamPoolId(), other.sourceIpamPoolId()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.addressFamilyAsString(), other.addressFamilyAsString()) && Objects.equals(this.autoImport(), other.autoImport()) && Objects.equals(this.publiclyAdvertisable(), other.publiclyAdvertisable()) && Objects.equals(this.allocationMinNetmaskLength(), other.allocationMinNetmaskLength()) && Objects.equals(this.allocationMaxNetmaskLength(), other.allocationMaxNetmaskLength()) && Objects.equals(this.allocationDefaultNetmaskLength(), other.allocationDefaultNetmaskLength()) && this.hasAllocationResourceTags() == other.hasAllocationResourceTags() && Objects.equals(this.allocationResourceTags(), other.allocationResourceTags()) && this.hasTagSpecifications() == other.hasTagSpecifications() && Objects.equals(this.tagSpecifications(), other.tagSpecifications()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.awsServiceAsString(), other.awsServiceAsString()) && Objects.equals(this.publicIpSourceAsString(), other.publicIpSourceAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CreateIpamPoolRequest").add("IpamScopeId", (Object)this.ipamScopeId()).add("Locale", (Object)this.locale()).add("SourceIpamPoolId", (Object)this.sourceIpamPoolId()).add("Description", (Object)this.description()).add("AddressFamily", (Object)this.addressFamilyAsString()).add("AutoImport", (Object)this.autoImport()).add("PubliclyAdvertisable", (Object)this.publiclyAdvertisable()).add("AllocationMinNetmaskLength", (Object)this.allocationMinNetmaskLength()).add("AllocationMaxNetmaskLength", (Object)this.allocationMaxNetmaskLength()).add("AllocationDefaultNetmaskLength", (Object)this.allocationDefaultNetmaskLength()).add("AllocationResourceTags", this.hasAllocationResourceTags() ? this.allocationResourceTags() : null).add("TagSpecifications", this.hasTagSpecifications() ? this.tagSpecifications() : null).add("ClientToken", (Object)this.clientToken()).add("AwsService", (Object)this.awsServiceAsString()).add("PublicIpSource", (Object)this.publicIpSourceAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IpamScopeId": {
                return Optional.ofNullable(clazz.cast(this.ipamScopeId()));
            }
            case "Locale": {
                return Optional.ofNullable(clazz.cast(this.locale()));
            }
            case "SourceIpamPoolId": {
                return Optional.ofNullable(clazz.cast(this.sourceIpamPoolId()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "AddressFamily": {
                return Optional.ofNullable(clazz.cast(this.addressFamilyAsString()));
            }
            case "AutoImport": {
                return Optional.ofNullable(clazz.cast(this.autoImport()));
            }
            case "PubliclyAdvertisable": {
                return Optional.ofNullable(clazz.cast(this.publiclyAdvertisable()));
            }
            case "AllocationMinNetmaskLength": {
                return Optional.ofNullable(clazz.cast(this.allocationMinNetmaskLength()));
            }
            case "AllocationMaxNetmaskLength": {
                return Optional.ofNullable(clazz.cast(this.allocationMaxNetmaskLength()));
            }
            case "AllocationDefaultNetmaskLength": {
                return Optional.ofNullable(clazz.cast(this.allocationDefaultNetmaskLength()));
            }
            case "AllocationResourceTags": {
                return Optional.ofNullable(clazz.cast(this.allocationResourceTags()));
            }
            case "TagSpecifications": {
                return Optional.ofNullable(clazz.cast(this.tagSpecifications()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "AwsService": {
                return Optional.ofNullable(clazz.cast(this.awsServiceAsString()));
            }
            case "PublicIpSource": {
                return Optional.ofNullable(clazz.cast(this.publicIpSourceAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateIpamPoolRequest, T> g) {
        return obj -> g.apply((CreateIpamPoolRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String ipamScopeId;
        private String locale;
        private String sourceIpamPoolId;
        private String description;
        private String addressFamily;
        private Boolean autoImport;
        private Boolean publiclyAdvertisable;
        private Integer allocationMinNetmaskLength;
        private Integer allocationMaxNetmaskLength;
        private Integer allocationDefaultNetmaskLength;
        private List<RequestIpamResourceTag> allocationResourceTags = DefaultSdkAutoConstructList.getInstance();
        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();
        private String clientToken;
        private String awsService;
        private String publicIpSource;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateIpamPoolRequest model) {
            super(model);
            this.ipamScopeId(model.ipamScopeId);
            this.locale(model.locale);
            this.sourceIpamPoolId(model.sourceIpamPoolId);
            this.description(model.description);
            this.addressFamily(model.addressFamily);
            this.autoImport(model.autoImport);
            this.publiclyAdvertisable(model.publiclyAdvertisable);
            this.allocationMinNetmaskLength(model.allocationMinNetmaskLength);
            this.allocationMaxNetmaskLength(model.allocationMaxNetmaskLength);
            this.allocationDefaultNetmaskLength(model.allocationDefaultNetmaskLength);
            this.allocationResourceTags(model.allocationResourceTags);
            this.tagSpecifications(model.tagSpecifications);
            this.clientToken(model.clientToken);
            this.awsService(model.awsService);
            this.publicIpSource(model.publicIpSource);
        }

        public final String getIpamScopeId() {
            return this.ipamScopeId;
        }

        public final void setIpamScopeId(String ipamScopeId) {
            this.ipamScopeId = ipamScopeId;
        }

        @Override
        public final Builder ipamScopeId(String ipamScopeId) {
            this.ipamScopeId = ipamScopeId;
            return this;
        }

        public final String getLocale() {
            return this.locale;
        }

        public final void setLocale(String locale) {
            this.locale = locale;
        }

        @Override
        public final Builder locale(String locale) {
            this.locale = locale;
            return this;
        }

        public final String getSourceIpamPoolId() {
            return this.sourceIpamPoolId;
        }

        public final void setSourceIpamPoolId(String sourceIpamPoolId) {
            this.sourceIpamPoolId = sourceIpamPoolId;
        }

        @Override
        public final Builder sourceIpamPoolId(String sourceIpamPoolId) {
            this.sourceIpamPoolId = sourceIpamPoolId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getAddressFamily() {
            return this.addressFamily;
        }

        public final void setAddressFamily(String addressFamily) {
            this.addressFamily = addressFamily;
        }

        @Override
        public final Builder addressFamily(String addressFamily) {
            this.addressFamily = addressFamily;
            return this;
        }

        @Override
        public final Builder addressFamily(AddressFamily addressFamily) {
            this.addressFamily(addressFamily == null ? null : addressFamily.toString());
            return this;
        }

        public final Boolean getAutoImport() {
            return this.autoImport;
        }

        public final void setAutoImport(Boolean autoImport) {
            this.autoImport = autoImport;
        }

        @Override
        public final Builder autoImport(Boolean autoImport) {
            this.autoImport = autoImport;
            return this;
        }

        public final Boolean getPubliclyAdvertisable() {
            return this.publiclyAdvertisable;
        }

        public final void setPubliclyAdvertisable(Boolean publiclyAdvertisable) {
            this.publiclyAdvertisable = publiclyAdvertisable;
        }

        @Override
        public final Builder publiclyAdvertisable(Boolean publiclyAdvertisable) {
            this.publiclyAdvertisable = publiclyAdvertisable;
            return this;
        }

        public final Integer getAllocationMinNetmaskLength() {
            return this.allocationMinNetmaskLength;
        }

        public final void setAllocationMinNetmaskLength(Integer allocationMinNetmaskLength) {
            this.allocationMinNetmaskLength = allocationMinNetmaskLength;
        }

        @Override
        public final Builder allocationMinNetmaskLength(Integer allocationMinNetmaskLength) {
            this.allocationMinNetmaskLength = allocationMinNetmaskLength;
            return this;
        }

        public final Integer getAllocationMaxNetmaskLength() {
            return this.allocationMaxNetmaskLength;
        }

        public final void setAllocationMaxNetmaskLength(Integer allocationMaxNetmaskLength) {
            this.allocationMaxNetmaskLength = allocationMaxNetmaskLength;
        }

        @Override
        public final Builder allocationMaxNetmaskLength(Integer allocationMaxNetmaskLength) {
            this.allocationMaxNetmaskLength = allocationMaxNetmaskLength;
            return this;
        }

        public final Integer getAllocationDefaultNetmaskLength() {
            return this.allocationDefaultNetmaskLength;
        }

        public final void setAllocationDefaultNetmaskLength(Integer allocationDefaultNetmaskLength) {
            this.allocationDefaultNetmaskLength = allocationDefaultNetmaskLength;
        }

        @Override
        public final Builder allocationDefaultNetmaskLength(Integer allocationDefaultNetmaskLength) {
            this.allocationDefaultNetmaskLength = allocationDefaultNetmaskLength;
            return this;
        }

        public final List<RequestIpamResourceTag.Builder> getAllocationResourceTags() {
            List<RequestIpamResourceTag.Builder> result = RequestIpamResourceTagListCopier.copyToBuilder(this.allocationResourceTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAllocationResourceTags(Collection<RequestIpamResourceTag.BuilderImpl> allocationResourceTags) {
            this.allocationResourceTags = RequestIpamResourceTagListCopier.copyFromBuilder(allocationResourceTags);
        }

        @Override
        public final Builder allocationResourceTags(Collection<RequestIpamResourceTag> allocationResourceTags) {
            this.allocationResourceTags = RequestIpamResourceTagListCopier.copy(allocationResourceTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allocationResourceTags(RequestIpamResourceTag ... allocationResourceTags) {
            this.allocationResourceTags(Arrays.asList(allocationResourceTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allocationResourceTags(Consumer<RequestIpamResourceTag.Builder> ... allocationResourceTags) {
            this.allocationResourceTags(Stream.of(allocationResourceTags).map(c -> (RequestIpamResourceTag)((RequestIpamResourceTag.Builder)RequestIpamResourceTag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<TagSpecification.Builder> getTagSpecifications() {
            List<TagSpecification.Builder> result = TagSpecificationListCopier.copyToBuilder(this.tagSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification ... tagSpecifications) {
            this.tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder> ... tagSpecifications) {
            this.tagSpecifications(Stream.of(tagSpecifications).map(c -> (TagSpecification)((TagSpecification.Builder)TagSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getAwsService() {
            return this.awsService;
        }

        public final void setAwsService(String awsService) {
            this.awsService = awsService;
        }

        @Override
        public final Builder awsService(String awsService) {
            this.awsService = awsService;
            return this;
        }

        @Override
        public final Builder awsService(IpamPoolAwsService awsService) {
            this.awsService(awsService == null ? null : awsService.toString());
            return this;
        }

        public final String getPublicIpSource() {
            return this.publicIpSource;
        }

        public final void setPublicIpSource(String publicIpSource) {
            this.publicIpSource = publicIpSource;
        }

        @Override
        public final Builder publicIpSource(String publicIpSource) {
            this.publicIpSource = publicIpSource;
            return this;
        }

        @Override
        public final Builder publicIpSource(IpamPoolPublicIpSource publicIpSource) {
            this.publicIpSource(publicIpSource == null ? null : publicIpSource.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateIpamPoolRequest build() {
            return new CreateIpamPoolRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateIpamPoolRequest> {
        public Builder ipamScopeId(String var1);

        public Builder locale(String var1);

        public Builder sourceIpamPoolId(String var1);

        public Builder description(String var1);

        public Builder addressFamily(String var1);

        public Builder addressFamily(AddressFamily var1);

        public Builder autoImport(Boolean var1);

        public Builder publiclyAdvertisable(Boolean var1);

        public Builder allocationMinNetmaskLength(Integer var1);

        public Builder allocationMaxNetmaskLength(Integer var1);

        public Builder allocationDefaultNetmaskLength(Integer var1);

        public Builder allocationResourceTags(Collection<RequestIpamResourceTag> var1);

        public Builder allocationResourceTags(RequestIpamResourceTag ... var1);

        public Builder allocationResourceTags(Consumer<RequestIpamResourceTag.Builder> ... var1);

        public Builder tagSpecifications(Collection<TagSpecification> var1);

        public Builder tagSpecifications(TagSpecification ... var1);

        public Builder tagSpecifications(Consumer<TagSpecification.Builder> ... var1);

        public Builder clientToken(String var1);

        public Builder awsService(String var1);

        public Builder awsService(IpamPoolAwsService var1);

        public Builder publicIpSource(String var1);

        public Builder publicIpSource(IpamPoolPublicIpSource var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

