/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.model.DescribeVerifiedAccessGroupsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVerifiedAccessGroupsResponse;
import software.amazon.awssdk.services.ec2.model.VerifiedAccessGroup;

public class DescribeVerifiedAccessGroupsPublisher
implements SdkPublisher<DescribeVerifiedAccessGroupsResponse> {
    private final Ec2AsyncClient client;
    private final DescribeVerifiedAccessGroupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeVerifiedAccessGroupsPublisher(Ec2AsyncClient client, DescribeVerifiedAccessGroupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeVerifiedAccessGroupsPublisher(Ec2AsyncClient client, DescribeVerifiedAccessGroupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeVerifiedAccessGroupsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeVerifiedAccessGroupsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<VerifiedAccessGroup> verifiedAccessGroups() {
        Function<DescribeVerifiedAccessGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.verifiedAccessGroups() != null) {
                return response.verifiedAccessGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeVerifiedAccessGroupsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeVerifiedAccessGroupsResponseFetcher
    implements AsyncPageFetcher<DescribeVerifiedAccessGroupsResponse> {
        private DescribeVerifiedAccessGroupsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeVerifiedAccessGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeVerifiedAccessGroupsResponse> nextPage(DescribeVerifiedAccessGroupsResponse previousPage) {
            if (previousPage == null) {
                return DescribeVerifiedAccessGroupsPublisher.this.client.describeVerifiedAccessGroups(DescribeVerifiedAccessGroupsPublisher.this.firstRequest);
            }
            return DescribeVerifiedAccessGroupsPublisher.this.client.describeVerifiedAccessGroups((DescribeVerifiedAccessGroupsRequest)((Object)DescribeVerifiedAccessGroupsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

