/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.services.ec2.model.FilterListCopier;
import software.amazon.awssdk.services.ec2.model.VersionStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeLaunchTemplateVersionsRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, DescribeLaunchTemplateVersionsRequest> {
    private static final SdkField<String> LAUNCH_TEMPLATE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LaunchTemplateId").getter(DescribeLaunchTemplateVersionsRequest.getter(DescribeLaunchTemplateVersionsRequest::launchTemplateId)).setter(DescribeLaunchTemplateVersionsRequest.setter(Builder::launchTemplateId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTemplateId").unmarshallLocationName("LaunchTemplateId").build()}).build();
    private static final SdkField<String> LAUNCH_TEMPLATE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LaunchTemplateName").getter(DescribeLaunchTemplateVersionsRequest.getter(DescribeLaunchTemplateVersionsRequest::launchTemplateName)).setter(DescribeLaunchTemplateVersionsRequest.setter(Builder::launchTemplateName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTemplateName").unmarshallLocationName("LaunchTemplateName").build()}).build();
    private static final SdkField<List<String>> VERSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Versions").getter(DescribeLaunchTemplateVersionsRequest.getter(DescribeLaunchTemplateVersionsRequest::versions)).setter(DescribeLaunchTemplateVersionsRequest.setter(Builder::versions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTemplateVersion").unmarshallLocationName("LaunchTemplateVersion").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> MIN_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MinVersion").getter(DescribeLaunchTemplateVersionsRequest.getter(DescribeLaunchTemplateVersionsRequest::minVersion)).setter(DescribeLaunchTemplateVersionsRequest.setter(Builder::minVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinVersion").unmarshallLocationName("MinVersion").build()}).build();
    private static final SdkField<String> MAX_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MaxVersion").getter(DescribeLaunchTemplateVersionsRequest.getter(DescribeLaunchTemplateVersionsRequest::maxVersion)).setter(DescribeLaunchTemplateVersionsRequest.setter(Builder::maxVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxVersion").unmarshallLocationName("MaxVersion").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeLaunchTemplateVersionsRequest.getter(DescribeLaunchTemplateVersionsRequest::nextToken)).setter(DescribeLaunchTemplateVersionsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(DescribeLaunchTemplateVersionsRequest.getter(DescribeLaunchTemplateVersionsRequest::maxResults)).setter(DescribeLaunchTemplateVersionsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").unmarshallLocationName("MaxResults").build()}).build();
    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Filters").getter(DescribeLaunchTemplateVersionsRequest.getter(DescribeLaunchTemplateVersionsRequest::filters)).setter(DescribeLaunchTemplateVersionsRequest.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").unmarshallLocationName("Filter").build(), ListTrait.builder().memberLocationName("Filter").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Filter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").unmarshallLocationName("Filter").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAUNCH_TEMPLATE_ID_FIELD, LAUNCH_TEMPLATE_NAME_FIELD, VERSIONS_FIELD, MIN_VERSION_FIELD, MAX_VERSION_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, FILTERS_FIELD));
    private final String launchTemplateId;
    private final String launchTemplateName;
    private final List<String> versions;
    private final String minVersion;
    private final String maxVersion;
    private final String nextToken;
    private final Integer maxResults;
    private final List<Filter> filters;

    private DescribeLaunchTemplateVersionsRequest(BuilderImpl builder) {
        super(builder);
        this.launchTemplateId = builder.launchTemplateId;
        this.launchTemplateName = builder.launchTemplateName;
        this.versions = builder.versions;
        this.minVersion = builder.minVersion;
        this.maxVersion = builder.maxVersion;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.filters = builder.filters;
    }

    public final String launchTemplateId() {
        return this.launchTemplateId;
    }

    public final String launchTemplateName() {
        return this.launchTemplateName;
    }

    public final boolean hasVersions() {
        return this.versions != null && !(this.versions instanceof SdkAutoConstructList);
    }

    public final List<String> versions() {
        return this.versions;
    }

    public final String minVersion() {
        return this.minVersion;
    }

    public final String maxVersion() {
        return this.maxVersion;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final boolean hasFilters() {
        return this.filters != null && !(this.filters instanceof SdkAutoConstructList);
    }

    public final List<Filter> filters() {
        return this.filters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.launchTemplateId());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchTemplateName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVersions() ? this.versions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.minVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilters() ? this.filters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLaunchTemplateVersionsRequest)) {
            return false;
        }
        DescribeLaunchTemplateVersionsRequest other = (DescribeLaunchTemplateVersionsRequest)((Object)obj);
        return Objects.equals(this.launchTemplateId(), other.launchTemplateId()) && Objects.equals(this.launchTemplateName(), other.launchTemplateName()) && this.hasVersions() == other.hasVersions() && Objects.equals(this.versions(), other.versions()) && Objects.equals(this.minVersion(), other.minVersion()) && Objects.equals(this.maxVersion(), other.maxVersion()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && this.hasFilters() == other.hasFilters() && Objects.equals(this.filters(), other.filters());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeLaunchTemplateVersionsRequest").add("LaunchTemplateId", (Object)this.launchTemplateId()).add("LaunchTemplateName", (Object)this.launchTemplateName()).add("Versions", this.hasVersions() ? this.versions() : null).add("MinVersion", (Object)this.minVersion()).add("MaxVersion", (Object)this.maxVersion()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("Filters", this.hasFilters() ? this.filters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LaunchTemplateId": {
                return Optional.ofNullable(clazz.cast(this.launchTemplateId()));
            }
            case "LaunchTemplateName": {
                return Optional.ofNullable(clazz.cast(this.launchTemplateName()));
            }
            case "Versions": {
                return Optional.ofNullable(clazz.cast(this.versions()));
            }
            case "MinVersion": {
                return Optional.ofNullable(clazz.cast(this.minVersion()));
            }
            case "MaxVersion": {
                return Optional.ofNullable(clazz.cast(this.maxVersion()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeLaunchTemplateVersionsRequest, T> g) {
        return obj -> g.apply((DescribeLaunchTemplateVersionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String launchTemplateId;
        private String launchTemplateName;
        private List<String> versions = DefaultSdkAutoConstructList.getInstance();
        private String minVersion;
        private String maxVersion;
        private String nextToken;
        private Integer maxResults;
        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLaunchTemplateVersionsRequest model) {
            super(model);
            this.launchTemplateId(model.launchTemplateId);
            this.launchTemplateName(model.launchTemplateName);
            this.versions(model.versions);
            this.minVersion(model.minVersion);
            this.maxVersion(model.maxVersion);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.filters(model.filters);
        }

        public final String getLaunchTemplateId() {
            return this.launchTemplateId;
        }

        public final void setLaunchTemplateId(String launchTemplateId) {
            this.launchTemplateId = launchTemplateId;
        }

        @Override
        @Transient
        public final Builder launchTemplateId(String launchTemplateId) {
            this.launchTemplateId = launchTemplateId;
            return this;
        }

        public final String getLaunchTemplateName() {
            return this.launchTemplateName;
        }

        public final void setLaunchTemplateName(String launchTemplateName) {
            this.launchTemplateName = launchTemplateName;
        }

        @Override
        @Transient
        public final Builder launchTemplateName(String launchTemplateName) {
            this.launchTemplateName = launchTemplateName;
            return this;
        }

        public final Collection<String> getVersions() {
            if (this.versions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.versions;
        }

        public final void setVersions(Collection<String> versions) {
            this.versions = VersionStringListCopier.copy(versions);
        }

        @Override
        @Transient
        public final Builder versions(Collection<String> versions) {
            this.versions = VersionStringListCopier.copy(versions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder versions(String ... versions) {
            this.versions(Arrays.asList(versions));
            return this;
        }

        public final String getMinVersion() {
            return this.minVersion;
        }

        public final void setMinVersion(String minVersion) {
            this.minVersion = minVersion;
        }

        @Override
        @Transient
        public final Builder minVersion(String minVersion) {
            this.minVersion = minVersion;
            return this;
        }

        public final String getMaxVersion() {
            return this.maxVersion;
        }

        public final void setMaxVersion(String maxVersion) {
            this.maxVersion = maxVersion;
        }

        @Override
        @Transient
        public final Builder maxVersion(String maxVersion) {
            this.maxVersion = maxVersion;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        @Transient
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final List<Filter.Builder> getFilters() {
            List<Filter.Builder> result = FilterListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        @Override
        @Transient
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder filters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (Filter)((Filter.Builder)Filter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeLaunchTemplateVersionsRequest build() {
            return new DescribeLaunchTemplateVersionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeLaunchTemplateVersionsRequest> {
        public Builder launchTemplateId(String var1);

        public Builder launchTemplateName(String var1);

        public Builder versions(Collection<String> var1);

        public Builder versions(String ... var1);

        public Builder minVersion(String var1);

        public Builder maxVersion(String var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder filters(Collection<Filter> var1);

        public Builder filters(Filter ... var1);

        public Builder filters(Consumer<Filter.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

