/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ArchitectureValues {
    I386("i386"),
    X86_64("x86_64"),
    ARM64("arm64"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ArchitectureValues> VALUE_MAP;
    private final String value;

    private ArchitectureValues(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ArchitectureValues fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ArchitectureValues> knownValues() {
        EnumSet<ArchitectureValues> knownValues = EnumSet.allOf(ArchitectureValues.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ArchitectureValues.class, ArchitectureValues::toString);
    }
}

