/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.EndDateType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyCapacityReservationRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, ModifyCapacityReservationRequest> {
    private static final SdkField<String> CAPACITY_RESERVATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CapacityReservationId").getter(ModifyCapacityReservationRequest.getter(ModifyCapacityReservationRequest::capacityReservationId)).setter(ModifyCapacityReservationRequest.setter(Builder::capacityReservationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityReservationId").unmarshallLocationName("CapacityReservationId").build()}).build();
    private static final SdkField<Integer> INSTANCE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("InstanceCount").getter(ModifyCapacityReservationRequest.getter(ModifyCapacityReservationRequest::instanceCount)).setter(ModifyCapacityReservationRequest.setter(Builder::instanceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceCount").unmarshallLocationName("InstanceCount").build()}).build();
    private static final SdkField<Instant> END_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndDate").getter(ModifyCapacityReservationRequest.getter(ModifyCapacityReservationRequest::endDate)).setter(ModifyCapacityReservationRequest.setter(Builder::endDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndDate").unmarshallLocationName("EndDate").build()}).build();
    private static final SdkField<String> END_DATE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndDateType").getter(ModifyCapacityReservationRequest.getter(ModifyCapacityReservationRequest::endDateTypeAsString)).setter(ModifyCapacityReservationRequest.setter(Builder::endDateType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndDateType").unmarshallLocationName("EndDateType").build()}).build();
    private static final SdkField<Boolean> ACCEPT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Accept").getter(ModifyCapacityReservationRequest.getter(ModifyCapacityReservationRequest::accept)).setter(ModifyCapacityReservationRequest.setter(Builder::accept)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Accept").unmarshallLocationName("Accept").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPACITY_RESERVATION_ID_FIELD, INSTANCE_COUNT_FIELD, END_DATE_FIELD, END_DATE_TYPE_FIELD, ACCEPT_FIELD));
    private final String capacityReservationId;
    private final Integer instanceCount;
    private final Instant endDate;
    private final String endDateType;
    private final Boolean accept;

    private ModifyCapacityReservationRequest(BuilderImpl builder) {
        super(builder);
        this.capacityReservationId = builder.capacityReservationId;
        this.instanceCount = builder.instanceCount;
        this.endDate = builder.endDate;
        this.endDateType = builder.endDateType;
        this.accept = builder.accept;
    }

    public final String capacityReservationId() {
        return this.capacityReservationId;
    }

    public final Integer instanceCount() {
        return this.instanceCount;
    }

    public final Instant endDate() {
        return this.endDate;
    }

    public final EndDateType endDateType() {
        return EndDateType.fromValue(this.endDateType);
    }

    public final String endDateTypeAsString() {
        return this.endDateType;
    }

    public final Boolean accept() {
        return this.accept;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.capacityReservationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.endDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.endDateTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.accept());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyCapacityReservationRequest)) {
            return false;
        }
        ModifyCapacityReservationRequest other = (ModifyCapacityReservationRequest)((Object)obj);
        return Objects.equals(this.capacityReservationId(), other.capacityReservationId()) && Objects.equals(this.instanceCount(), other.instanceCount()) && Objects.equals(this.endDate(), other.endDate()) && Objects.equals(this.endDateTypeAsString(), other.endDateTypeAsString()) && Objects.equals(this.accept(), other.accept());
    }

    public final String toString() {
        return ToString.builder((String)"ModifyCapacityReservationRequest").add("CapacityReservationId", (Object)this.capacityReservationId()).add("InstanceCount", (Object)this.instanceCount()).add("EndDate", (Object)this.endDate()).add("EndDateType", (Object)this.endDateTypeAsString()).add("Accept", (Object)this.accept()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CapacityReservationId": {
                return Optional.ofNullable(clazz.cast(this.capacityReservationId()));
            }
            case "InstanceCount": {
                return Optional.ofNullable(clazz.cast(this.instanceCount()));
            }
            case "EndDate": {
                return Optional.ofNullable(clazz.cast(this.endDate()));
            }
            case "EndDateType": {
                return Optional.ofNullable(clazz.cast(this.endDateTypeAsString()));
            }
            case "Accept": {
                return Optional.ofNullable(clazz.cast(this.accept()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyCapacityReservationRequest, T> g) {
        return obj -> g.apply((ModifyCapacityReservationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String capacityReservationId;
        private Integer instanceCount;
        private Instant endDate;
        private String endDateType;
        private Boolean accept;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyCapacityReservationRequest model) {
            super(model);
            this.capacityReservationId(model.capacityReservationId);
            this.instanceCount(model.instanceCount);
            this.endDate(model.endDate);
            this.endDateType(model.endDateType);
            this.accept(model.accept);
        }

        public final String getCapacityReservationId() {
            return this.capacityReservationId;
        }

        public final void setCapacityReservationId(String capacityReservationId) {
            this.capacityReservationId = capacityReservationId;
        }

        @Override
        @Transient
        public final Builder capacityReservationId(String capacityReservationId) {
            this.capacityReservationId = capacityReservationId;
            return this;
        }

        public final Integer getInstanceCount() {
            return this.instanceCount;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        @Override
        @Transient
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final Instant getEndDate() {
            return this.endDate;
        }

        public final void setEndDate(Instant endDate) {
            this.endDate = endDate;
        }

        @Override
        @Transient
        public final Builder endDate(Instant endDate) {
            this.endDate = endDate;
            return this;
        }

        public final String getEndDateType() {
            return this.endDateType;
        }

        public final void setEndDateType(String endDateType) {
            this.endDateType = endDateType;
        }

        @Override
        @Transient
        public final Builder endDateType(String endDateType) {
            this.endDateType = endDateType;
            return this;
        }

        @Override
        @Transient
        public final Builder endDateType(EndDateType endDateType) {
            this.endDateType(endDateType == null ? null : endDateType.toString());
            return this;
        }

        public final Boolean getAccept() {
            return this.accept;
        }

        public final void setAccept(Boolean accept) {
            this.accept = accept;
        }

        @Override
        @Transient
        public final Builder accept(Boolean accept) {
            this.accept = accept;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyCapacityReservationRequest build() {
            return new ModifyCapacityReservationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyCapacityReservationRequest> {
        public Builder capacityReservationId(String var1);

        public Builder instanceCount(Integer var1);

        public Builder endDate(Instant var1);

        public Builder endDateType(String var1);

        public Builder endDateType(EndDateType var1);

        public Builder accept(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

