/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.TagSpecification;
import software.amazon.awssdk.services.ec2.model.TagSpecificationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateTrafficMirrorTargetRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, CreateTrafficMirrorTargetRequest> {
    private static final SdkField<String> NETWORK_INTERFACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkInterfaceId").getter(CreateTrafficMirrorTargetRequest.getter(CreateTrafficMirrorTargetRequest::networkInterfaceId)).setter(CreateTrafficMirrorTargetRequest.setter(Builder::networkInterfaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceId").unmarshallLocationName("NetworkInterfaceId").build()}).build();
    private static final SdkField<String> NETWORK_LOAD_BALANCER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkLoadBalancerArn").getter(CreateTrafficMirrorTargetRequest.getter(CreateTrafficMirrorTargetRequest::networkLoadBalancerArn)).setter(CreateTrafficMirrorTargetRequest.setter(Builder::networkLoadBalancerArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkLoadBalancerArn").unmarshallLocationName("NetworkLoadBalancerArn").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateTrafficMirrorTargetRequest.getter(CreateTrafficMirrorTargetRequest::description)).setter(CreateTrafficMirrorTargetRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("Description").build()}).build();
    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagSpecifications").getter(CreateTrafficMirrorTargetRequest.getter(CreateTrafficMirrorTargetRequest::tagSpecifications)).setter(CreateTrafficMirrorTargetRequest.setter(Builder::tagSpecifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification").unmarshallLocationName("TagSpecification").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TagSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateTrafficMirrorTargetRequest.getter(CreateTrafficMirrorTargetRequest::clientToken)).setter(CreateTrafficMirrorTargetRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").unmarshallLocationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> GATEWAY_LOAD_BALANCER_ENDPOINT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GatewayLoadBalancerEndpointId").getter(CreateTrafficMirrorTargetRequest.getter(CreateTrafficMirrorTargetRequest::gatewayLoadBalancerEndpointId)).setter(CreateTrafficMirrorTargetRequest.setter(Builder::gatewayLoadBalancerEndpointId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayLoadBalancerEndpointId").unmarshallLocationName("GatewayLoadBalancerEndpointId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_INTERFACE_ID_FIELD, NETWORK_LOAD_BALANCER_ARN_FIELD, DESCRIPTION_FIELD, TAG_SPECIFICATIONS_FIELD, CLIENT_TOKEN_FIELD, GATEWAY_LOAD_BALANCER_ENDPOINT_ID_FIELD));
    private final String networkInterfaceId;
    private final String networkLoadBalancerArn;
    private final String description;
    private final List<TagSpecification> tagSpecifications;
    private final String clientToken;
    private final String gatewayLoadBalancerEndpointId;

    private CreateTrafficMirrorTargetRequest(BuilderImpl builder) {
        super(builder);
        this.networkInterfaceId = builder.networkInterfaceId;
        this.networkLoadBalancerArn = builder.networkLoadBalancerArn;
        this.description = builder.description;
        this.tagSpecifications = builder.tagSpecifications;
        this.clientToken = builder.clientToken;
        this.gatewayLoadBalancerEndpointId = builder.gatewayLoadBalancerEndpointId;
    }

    public final String networkInterfaceId() {
        return this.networkInterfaceId;
    }

    public final String networkLoadBalancerArn() {
        return this.networkLoadBalancerArn;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasTagSpecifications() {
        return this.tagSpecifications != null && !(this.tagSpecifications instanceof SdkAutoConstructList);
    }

    public final List<TagSpecification> tagSpecifications() {
        return this.tagSpecifications;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String gatewayLoadBalancerEndpointId() {
        return this.gatewayLoadBalancerEndpointId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkLoadBalancerArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagSpecifications() ? this.tagSpecifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayLoadBalancerEndpointId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTrafficMirrorTargetRequest)) {
            return false;
        }
        CreateTrafficMirrorTargetRequest other = (CreateTrafficMirrorTargetRequest)((Object)obj);
        return Objects.equals(this.networkInterfaceId(), other.networkInterfaceId()) && Objects.equals(this.networkLoadBalancerArn(), other.networkLoadBalancerArn()) && Objects.equals(this.description(), other.description()) && this.hasTagSpecifications() == other.hasTagSpecifications() && Objects.equals(this.tagSpecifications(), other.tagSpecifications()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.gatewayLoadBalancerEndpointId(), other.gatewayLoadBalancerEndpointId());
    }

    public final String toString() {
        return ToString.builder((String)"CreateTrafficMirrorTargetRequest").add("NetworkInterfaceId", (Object)this.networkInterfaceId()).add("NetworkLoadBalancerArn", (Object)this.networkLoadBalancerArn()).add("Description", (Object)this.description()).add("TagSpecifications", this.hasTagSpecifications() ? this.tagSpecifications() : null).add("ClientToken", (Object)this.clientToken()).add("GatewayLoadBalancerEndpointId", (Object)this.gatewayLoadBalancerEndpointId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NetworkInterfaceId": {
                return Optional.ofNullable(clazz.cast(this.networkInterfaceId()));
            }
            case "NetworkLoadBalancerArn": {
                return Optional.ofNullable(clazz.cast(this.networkLoadBalancerArn()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "TagSpecifications": {
                return Optional.ofNullable(clazz.cast(this.tagSpecifications()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "GatewayLoadBalancerEndpointId": {
                return Optional.ofNullable(clazz.cast(this.gatewayLoadBalancerEndpointId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateTrafficMirrorTargetRequest, T> g) {
        return obj -> g.apply((CreateTrafficMirrorTargetRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String networkInterfaceId;
        private String networkLoadBalancerArn;
        private String description;
        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();
        private String clientToken;
        private String gatewayLoadBalancerEndpointId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTrafficMirrorTargetRequest model) {
            super(model);
            this.networkInterfaceId(model.networkInterfaceId);
            this.networkLoadBalancerArn(model.networkLoadBalancerArn);
            this.description(model.description);
            this.tagSpecifications(model.tagSpecifications);
            this.clientToken(model.clientToken);
            this.gatewayLoadBalancerEndpointId(model.gatewayLoadBalancerEndpointId);
        }

        public final String getNetworkInterfaceId() {
            return this.networkInterfaceId;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final String getNetworkLoadBalancerArn() {
            return this.networkLoadBalancerArn;
        }

        public final void setNetworkLoadBalancerArn(String networkLoadBalancerArn) {
            this.networkLoadBalancerArn = networkLoadBalancerArn;
        }

        @Override
        public final Builder networkLoadBalancerArn(String networkLoadBalancerArn) {
            this.networkLoadBalancerArn = networkLoadBalancerArn;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<TagSpecification.Builder> getTagSpecifications() {
            List<TagSpecification.Builder> result = TagSpecificationListCopier.copyToBuilder(this.tagSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification ... tagSpecifications) {
            this.tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder> ... tagSpecifications) {
            this.tagSpecifications(Stream.of(tagSpecifications).map(c -> (TagSpecification)((TagSpecification.Builder)TagSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getGatewayLoadBalancerEndpointId() {
            return this.gatewayLoadBalancerEndpointId;
        }

        public final void setGatewayLoadBalancerEndpointId(String gatewayLoadBalancerEndpointId) {
            this.gatewayLoadBalancerEndpointId = gatewayLoadBalancerEndpointId;
        }

        @Override
        public final Builder gatewayLoadBalancerEndpointId(String gatewayLoadBalancerEndpointId) {
            this.gatewayLoadBalancerEndpointId = gatewayLoadBalancerEndpointId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTrafficMirrorTargetRequest build() {
            return new CreateTrafficMirrorTargetRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateTrafficMirrorTargetRequest> {
        public Builder networkInterfaceId(String var1);

        public Builder networkLoadBalancerArn(String var1);

        public Builder description(String var1);

        public Builder tagSpecifications(Collection<TagSpecification> var1);

        public Builder tagSpecifications(TagSpecification ... var1);

        public Builder tagSpecifications(Consumer<TagSpecification.Builder> ... var1);

        public Builder clientToken(String var1);

        public Builder gatewayLoadBalancerEndpointId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

