/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum NetworkInterfaceStatus {
    AVAILABLE("available"),
    ASSOCIATED("associated"),
    ATTACHING("attaching"),
    IN_USE("in-use"),
    DETACHING("detaching"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private NetworkInterfaceStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static NetworkInterfaceStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(NetworkInterfaceStatus.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<NetworkInterfaceStatus> knownValues() {
        return Stream.of(NetworkInterfaceStatus.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

