/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.ModifyTransitGatewayVpcAttachmentRequestOptions;
import software.amazon.awssdk.services.ec2.model.TransitGatewaySubnetIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyTransitGatewayVpcAttachmentRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, ModifyTransitGatewayVpcAttachmentRequest> {
    private static final SdkField<String> TRANSIT_GATEWAY_ATTACHMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TransitGatewayAttachmentId").getter(ModifyTransitGatewayVpcAttachmentRequest.getter(ModifyTransitGatewayVpcAttachmentRequest::transitGatewayAttachmentId)).setter(ModifyTransitGatewayVpcAttachmentRequest.setter(Builder::transitGatewayAttachmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayAttachmentId").unmarshallLocationName("TransitGatewayAttachmentId").build()}).build();
    private static final SdkField<List<String>> ADD_SUBNET_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AddSubnetIds").getter(ModifyTransitGatewayVpcAttachmentRequest.getter(ModifyTransitGatewayVpcAttachmentRequest::addSubnetIds)).setter(ModifyTransitGatewayVpcAttachmentRequest.setter(Builder::addSubnetIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddSubnetIds").unmarshallLocationName("AddSubnetIds").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<String>> REMOVE_SUBNET_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RemoveSubnetIds").getter(ModifyTransitGatewayVpcAttachmentRequest.getter(ModifyTransitGatewayVpcAttachmentRequest::removeSubnetIds)).setter(ModifyTransitGatewayVpcAttachmentRequest.setter(Builder::removeSubnetIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveSubnetIds").unmarshallLocationName("RemoveSubnetIds").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<ModifyTransitGatewayVpcAttachmentRequestOptions> OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Options").getter(ModifyTransitGatewayVpcAttachmentRequest.getter(ModifyTransitGatewayVpcAttachmentRequest::options)).setter(ModifyTransitGatewayVpcAttachmentRequest.setter(Builder::options)).constructor(ModifyTransitGatewayVpcAttachmentRequestOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Options").unmarshallLocationName("Options").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSIT_GATEWAY_ATTACHMENT_ID_FIELD, ADD_SUBNET_IDS_FIELD, REMOVE_SUBNET_IDS_FIELD, OPTIONS_FIELD));
    private final String transitGatewayAttachmentId;
    private final List<String> addSubnetIds;
    private final List<String> removeSubnetIds;
    private final ModifyTransitGatewayVpcAttachmentRequestOptions options;

    private ModifyTransitGatewayVpcAttachmentRequest(BuilderImpl builder) {
        super(builder);
        this.transitGatewayAttachmentId = builder.transitGatewayAttachmentId;
        this.addSubnetIds = builder.addSubnetIds;
        this.removeSubnetIds = builder.removeSubnetIds;
        this.options = builder.options;
    }

    public final String transitGatewayAttachmentId() {
        return this.transitGatewayAttachmentId;
    }

    public final boolean hasAddSubnetIds() {
        return this.addSubnetIds != null && !(this.addSubnetIds instanceof SdkAutoConstructList);
    }

    public final List<String> addSubnetIds() {
        return this.addSubnetIds;
    }

    public final boolean hasRemoveSubnetIds() {
        return this.removeSubnetIds != null && !(this.removeSubnetIds instanceof SdkAutoConstructList);
    }

    public final List<String> removeSubnetIds() {
        return this.removeSubnetIds;
    }

    public final ModifyTransitGatewayVpcAttachmentRequestOptions options() {
        return this.options;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.transitGatewayAttachmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAddSubnetIds() ? this.addSubnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRemoveSubnetIds() ? this.removeSubnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.options());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyTransitGatewayVpcAttachmentRequest)) {
            return false;
        }
        ModifyTransitGatewayVpcAttachmentRequest other = (ModifyTransitGatewayVpcAttachmentRequest)((Object)obj);
        return Objects.equals(this.transitGatewayAttachmentId(), other.transitGatewayAttachmentId()) && this.hasAddSubnetIds() == other.hasAddSubnetIds() && Objects.equals(this.addSubnetIds(), other.addSubnetIds()) && this.hasRemoveSubnetIds() == other.hasRemoveSubnetIds() && Objects.equals(this.removeSubnetIds(), other.removeSubnetIds()) && Objects.equals(this.options(), other.options());
    }

    public final String toString() {
        return ToString.builder((String)"ModifyTransitGatewayVpcAttachmentRequest").add("TransitGatewayAttachmentId", (Object)this.transitGatewayAttachmentId()).add("AddSubnetIds", this.hasAddSubnetIds() ? this.addSubnetIds() : null).add("RemoveSubnetIds", this.hasRemoveSubnetIds() ? this.removeSubnetIds() : null).add("Options", (Object)this.options()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TransitGatewayAttachmentId": {
                return Optional.ofNullable(clazz.cast(this.transitGatewayAttachmentId()));
            }
            case "AddSubnetIds": {
                return Optional.ofNullable(clazz.cast(this.addSubnetIds()));
            }
            case "RemoveSubnetIds": {
                return Optional.ofNullable(clazz.cast(this.removeSubnetIds()));
            }
            case "Options": {
                return Optional.ofNullable(clazz.cast(this.options()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyTransitGatewayVpcAttachmentRequest, T> g) {
        return obj -> g.apply((ModifyTransitGatewayVpcAttachmentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String transitGatewayAttachmentId;
        private List<String> addSubnetIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> removeSubnetIds = DefaultSdkAutoConstructList.getInstance();
        private ModifyTransitGatewayVpcAttachmentRequestOptions options;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyTransitGatewayVpcAttachmentRequest model) {
            super(model);
            this.transitGatewayAttachmentId(model.transitGatewayAttachmentId);
            this.addSubnetIds(model.addSubnetIds);
            this.removeSubnetIds(model.removeSubnetIds);
            this.options(model.options);
        }

        public final String getTransitGatewayAttachmentId() {
            return this.transitGatewayAttachmentId;
        }

        public final void setTransitGatewayAttachmentId(String transitGatewayAttachmentId) {
            this.transitGatewayAttachmentId = transitGatewayAttachmentId;
        }

        @Override
        @Transient
        public final Builder transitGatewayAttachmentId(String transitGatewayAttachmentId) {
            this.transitGatewayAttachmentId = transitGatewayAttachmentId;
            return this;
        }

        public final Collection<String> getAddSubnetIds() {
            if (this.addSubnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.addSubnetIds;
        }

        public final void setAddSubnetIds(Collection<String> addSubnetIds) {
            this.addSubnetIds = TransitGatewaySubnetIdListCopier.copy(addSubnetIds);
        }

        @Override
        @Transient
        public final Builder addSubnetIds(Collection<String> addSubnetIds) {
            this.addSubnetIds = TransitGatewaySubnetIdListCopier.copy(addSubnetIds);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder addSubnetIds(String ... addSubnetIds) {
            this.addSubnetIds(Arrays.asList(addSubnetIds));
            return this;
        }

        public final Collection<String> getRemoveSubnetIds() {
            if (this.removeSubnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.removeSubnetIds;
        }

        public final void setRemoveSubnetIds(Collection<String> removeSubnetIds) {
            this.removeSubnetIds = TransitGatewaySubnetIdListCopier.copy(removeSubnetIds);
        }

        @Override
        @Transient
        public final Builder removeSubnetIds(Collection<String> removeSubnetIds) {
            this.removeSubnetIds = TransitGatewaySubnetIdListCopier.copy(removeSubnetIds);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder removeSubnetIds(String ... removeSubnetIds) {
            this.removeSubnetIds(Arrays.asList(removeSubnetIds));
            return this;
        }

        public final ModifyTransitGatewayVpcAttachmentRequestOptions.Builder getOptions() {
            return this.options != null ? this.options.toBuilder() : null;
        }

        public final void setOptions(ModifyTransitGatewayVpcAttachmentRequestOptions.BuilderImpl options) {
            this.options = options != null ? options.build() : null;
        }

        @Override
        @Transient
        public final Builder options(ModifyTransitGatewayVpcAttachmentRequestOptions options) {
            this.options = options;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyTransitGatewayVpcAttachmentRequest build() {
            return new ModifyTransitGatewayVpcAttachmentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyTransitGatewayVpcAttachmentRequest> {
        public Builder transitGatewayAttachmentId(String var1);

        public Builder addSubnetIds(Collection<String> var1);

        public Builder addSubnetIds(String ... var1);

        public Builder removeSubnetIds(Collection<String> var1);

        public Builder removeSubnetIds(String ... var1);

        public Builder options(ModifyTransitGatewayVpcAttachmentRequestOptions var1);

        default public Builder options(Consumer<ModifyTransitGatewayVpcAttachmentRequestOptions.Builder> options) {
            return this.options((ModifyTransitGatewayVpcAttachmentRequestOptions)((ModifyTransitGatewayVpcAttachmentRequestOptions.Builder)ModifyTransitGatewayVpcAttachmentRequestOptions.builder().applyMutation(options)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

