/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.ReferencedSecurityGroup;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SecurityGroupRule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SecurityGroupRule> {
    private static final SdkField<String> SECURITY_GROUP_RULE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecurityGroupRuleId").getter(SecurityGroupRule.getter(SecurityGroupRule::securityGroupRuleId)).setter(SecurityGroupRule.setter(Builder::securityGroupRuleId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupRuleId").unmarshallLocationName("securityGroupRuleId").build()}).build();
    private static final SdkField<String> GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GroupId").getter(SecurityGroupRule.getter(SecurityGroupRule::groupId)).setter(SecurityGroupRule.setter(Builder::groupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupId").unmarshallLocationName("groupId").build()}).build();
    private static final SdkField<String> GROUP_OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GroupOwnerId").getter(SecurityGroupRule.getter(SecurityGroupRule::groupOwnerId)).setter(SecurityGroupRule.setter(Builder::groupOwnerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupOwnerId").unmarshallLocationName("groupOwnerId").build()}).build();
    private static final SdkField<Boolean> IS_EGRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsEgress").getter(SecurityGroupRule.getter(SecurityGroupRule::isEgress)).setter(SecurityGroupRule.setter(Builder::isEgress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsEgress").unmarshallLocationName("isEgress").build()}).build();
    private static final SdkField<String> IP_PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpProtocol").getter(SecurityGroupRule.getter(SecurityGroupRule::ipProtocol)).setter(SecurityGroupRule.setter(Builder::ipProtocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpProtocol").unmarshallLocationName("ipProtocol").build()}).build();
    private static final SdkField<Integer> FROM_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("FromPort").getter(SecurityGroupRule.getter(SecurityGroupRule::fromPort)).setter(SecurityGroupRule.setter(Builder::fromPort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FromPort").unmarshallLocationName("fromPort").build()}).build();
    private static final SdkField<Integer> TO_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ToPort").getter(SecurityGroupRule.getter(SecurityGroupRule::toPort)).setter(SecurityGroupRule.setter(Builder::toPort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ToPort").unmarshallLocationName("toPort").build()}).build();
    private static final SdkField<String> CIDR_IPV4_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CidrIpv4").getter(SecurityGroupRule.getter(SecurityGroupRule::cidrIpv4)).setter(SecurityGroupRule.setter(Builder::cidrIpv4)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CidrIpv4").unmarshallLocationName("cidrIpv4").build()}).build();
    private static final SdkField<String> CIDR_IPV6_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CidrIpv6").getter(SecurityGroupRule.getter(SecurityGroupRule::cidrIpv6)).setter(SecurityGroupRule.setter(Builder::cidrIpv6)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CidrIpv6").unmarshallLocationName("cidrIpv6").build()}).build();
    private static final SdkField<String> PREFIX_LIST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrefixListId").getter(SecurityGroupRule.getter(SecurityGroupRule::prefixListId)).setter(SecurityGroupRule.setter(Builder::prefixListId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrefixListId").unmarshallLocationName("prefixListId").build()}).build();
    private static final SdkField<ReferencedSecurityGroup> REFERENCED_GROUP_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ReferencedGroupInfo").getter(SecurityGroupRule.getter(SecurityGroupRule::referencedGroupInfo)).setter(SecurityGroupRule.setter(Builder::referencedGroupInfo)).constructor(ReferencedSecurityGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReferencedGroupInfo").unmarshallLocationName("referencedGroupInfo").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(SecurityGroupRule.getter(SecurityGroupRule::description)).setter(SecurityGroupRule.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("description").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(SecurityGroupRule.getter(SecurityGroupRule::tags)).setter(SecurityGroupRule.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet").unmarshallLocationName("tagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECURITY_GROUP_RULE_ID_FIELD, GROUP_ID_FIELD, GROUP_OWNER_ID_FIELD, IS_EGRESS_FIELD, IP_PROTOCOL_FIELD, FROM_PORT_FIELD, TO_PORT_FIELD, CIDR_IPV4_FIELD, CIDR_IPV6_FIELD, PREFIX_LIST_ID_FIELD, REFERENCED_GROUP_INFO_FIELD, DESCRIPTION_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String securityGroupRuleId;
    private final String groupId;
    private final String groupOwnerId;
    private final Boolean isEgress;
    private final String ipProtocol;
    private final Integer fromPort;
    private final Integer toPort;
    private final String cidrIpv4;
    private final String cidrIpv6;
    private final String prefixListId;
    private final ReferencedSecurityGroup referencedGroupInfo;
    private final String description;
    private final List<Tag> tags;

    private SecurityGroupRule(BuilderImpl builder) {
        this.securityGroupRuleId = builder.securityGroupRuleId;
        this.groupId = builder.groupId;
        this.groupOwnerId = builder.groupOwnerId;
        this.isEgress = builder.isEgress;
        this.ipProtocol = builder.ipProtocol;
        this.fromPort = builder.fromPort;
        this.toPort = builder.toPort;
        this.cidrIpv4 = builder.cidrIpv4;
        this.cidrIpv6 = builder.cidrIpv6;
        this.prefixListId = builder.prefixListId;
        this.referencedGroupInfo = builder.referencedGroupInfo;
        this.description = builder.description;
        this.tags = builder.tags;
    }

    public final String securityGroupRuleId() {
        return this.securityGroupRuleId;
    }

    public final String groupId() {
        return this.groupId;
    }

    public final String groupOwnerId() {
        return this.groupOwnerId;
    }

    public final Boolean isEgress() {
        return this.isEgress;
    }

    public final String ipProtocol() {
        return this.ipProtocol;
    }

    public final Integer fromPort() {
        return this.fromPort;
    }

    public final Integer toPort() {
        return this.toPort;
    }

    public final String cidrIpv4() {
        return this.cidrIpv4;
    }

    public final String cidrIpv6() {
        return this.cidrIpv6;
    }

    public final String prefixListId() {
        return this.prefixListId;
    }

    public final ReferencedSecurityGroup referencedGroupInfo() {
        return this.referencedGroupInfo;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.securityGroupRuleId());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupOwnerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.isEgress());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipProtocol());
        hashCode = 31 * hashCode + Objects.hashCode(this.fromPort());
        hashCode = 31 * hashCode + Objects.hashCode(this.toPort());
        hashCode = 31 * hashCode + Objects.hashCode(this.cidrIpv4());
        hashCode = 31 * hashCode + Objects.hashCode(this.cidrIpv6());
        hashCode = 31 * hashCode + Objects.hashCode(this.prefixListId());
        hashCode = 31 * hashCode + Objects.hashCode(this.referencedGroupInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SecurityGroupRule)) {
            return false;
        }
        SecurityGroupRule other = (SecurityGroupRule)obj;
        return Objects.equals(this.securityGroupRuleId(), other.securityGroupRuleId()) && Objects.equals(this.groupId(), other.groupId()) && Objects.equals(this.groupOwnerId(), other.groupOwnerId()) && Objects.equals(this.isEgress(), other.isEgress()) && Objects.equals(this.ipProtocol(), other.ipProtocol()) && Objects.equals(this.fromPort(), other.fromPort()) && Objects.equals(this.toPort(), other.toPort()) && Objects.equals(this.cidrIpv4(), other.cidrIpv4()) && Objects.equals(this.cidrIpv6(), other.cidrIpv6()) && Objects.equals(this.prefixListId(), other.prefixListId()) && Objects.equals(this.referencedGroupInfo(), other.referencedGroupInfo()) && Objects.equals(this.description(), other.description()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"SecurityGroupRule").add("SecurityGroupRuleId", (Object)this.securityGroupRuleId()).add("GroupId", (Object)this.groupId()).add("GroupOwnerId", (Object)this.groupOwnerId()).add("IsEgress", (Object)this.isEgress()).add("IpProtocol", (Object)this.ipProtocol()).add("FromPort", (Object)this.fromPort()).add("ToPort", (Object)this.toPort()).add("CidrIpv4", (Object)this.cidrIpv4()).add("CidrIpv6", (Object)this.cidrIpv6()).add("PrefixListId", (Object)this.prefixListId()).add("ReferencedGroupInfo", (Object)this.referencedGroupInfo()).add("Description", (Object)this.description()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SecurityGroupRuleId": {
                return Optional.ofNullable(clazz.cast(this.securityGroupRuleId()));
            }
            case "GroupId": {
                return Optional.ofNullable(clazz.cast(this.groupId()));
            }
            case "GroupOwnerId": {
                return Optional.ofNullable(clazz.cast(this.groupOwnerId()));
            }
            case "IsEgress": {
                return Optional.ofNullable(clazz.cast(this.isEgress()));
            }
            case "IpProtocol": {
                return Optional.ofNullable(clazz.cast(this.ipProtocol()));
            }
            case "FromPort": {
                return Optional.ofNullable(clazz.cast(this.fromPort()));
            }
            case "ToPort": {
                return Optional.ofNullable(clazz.cast(this.toPort()));
            }
            case "CidrIpv4": {
                return Optional.ofNullable(clazz.cast(this.cidrIpv4()));
            }
            case "CidrIpv6": {
                return Optional.ofNullable(clazz.cast(this.cidrIpv6()));
            }
            case "PrefixListId": {
                return Optional.ofNullable(clazz.cast(this.prefixListId()));
            }
            case "ReferencedGroupInfo": {
                return Optional.ofNullable(clazz.cast(this.referencedGroupInfo()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SecurityGroupRule, T> g) {
        return obj -> g.apply((SecurityGroupRule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String securityGroupRuleId;
        private String groupId;
        private String groupOwnerId;
        private Boolean isEgress;
        private String ipProtocol;
        private Integer fromPort;
        private Integer toPort;
        private String cidrIpv4;
        private String cidrIpv6;
        private String prefixListId;
        private ReferencedSecurityGroup referencedGroupInfo;
        private String description;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SecurityGroupRule model) {
            this.securityGroupRuleId(model.securityGroupRuleId);
            this.groupId(model.groupId);
            this.groupOwnerId(model.groupOwnerId);
            this.isEgress(model.isEgress);
            this.ipProtocol(model.ipProtocol);
            this.fromPort(model.fromPort);
            this.toPort(model.toPort);
            this.cidrIpv4(model.cidrIpv4);
            this.cidrIpv6(model.cidrIpv6);
            this.prefixListId(model.prefixListId);
            this.referencedGroupInfo(model.referencedGroupInfo);
            this.description(model.description);
            this.tags(model.tags);
        }

        public final String getSecurityGroupRuleId() {
            return this.securityGroupRuleId;
        }

        @Override
        public final Builder securityGroupRuleId(String securityGroupRuleId) {
            this.securityGroupRuleId = securityGroupRuleId;
            return this;
        }

        public final void setSecurityGroupRuleId(String securityGroupRuleId) {
            this.securityGroupRuleId = securityGroupRuleId;
        }

        public final String getGroupId() {
            return this.groupId;
        }

        @Override
        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public final void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        public final String getGroupOwnerId() {
            return this.groupOwnerId;
        }

        @Override
        public final Builder groupOwnerId(String groupOwnerId) {
            this.groupOwnerId = groupOwnerId;
            return this;
        }

        public final void setGroupOwnerId(String groupOwnerId) {
            this.groupOwnerId = groupOwnerId;
        }

        public final Boolean getIsEgress() {
            return this.isEgress;
        }

        @Override
        public final Builder isEgress(Boolean isEgress) {
            this.isEgress = isEgress;
            return this;
        }

        public final void setIsEgress(Boolean isEgress) {
            this.isEgress = isEgress;
        }

        public final String getIpProtocol() {
            return this.ipProtocol;
        }

        @Override
        public final Builder ipProtocol(String ipProtocol) {
            this.ipProtocol = ipProtocol;
            return this;
        }

        public final void setIpProtocol(String ipProtocol) {
            this.ipProtocol = ipProtocol;
        }

        public final Integer getFromPort() {
            return this.fromPort;
        }

        @Override
        public final Builder fromPort(Integer fromPort) {
            this.fromPort = fromPort;
            return this;
        }

        public final void setFromPort(Integer fromPort) {
            this.fromPort = fromPort;
        }

        public final Integer getToPort() {
            return this.toPort;
        }

        @Override
        public final Builder toPort(Integer toPort) {
            this.toPort = toPort;
            return this;
        }

        public final void setToPort(Integer toPort) {
            this.toPort = toPort;
        }

        public final String getCidrIpv4() {
            return this.cidrIpv4;
        }

        @Override
        public final Builder cidrIpv4(String cidrIpv4) {
            this.cidrIpv4 = cidrIpv4;
            return this;
        }

        public final void setCidrIpv4(String cidrIpv4) {
            this.cidrIpv4 = cidrIpv4;
        }

        public final String getCidrIpv6() {
            return this.cidrIpv6;
        }

        @Override
        public final Builder cidrIpv6(String cidrIpv6) {
            this.cidrIpv6 = cidrIpv6;
            return this;
        }

        public final void setCidrIpv6(String cidrIpv6) {
            this.cidrIpv6 = cidrIpv6;
        }

        public final String getPrefixListId() {
            return this.prefixListId;
        }

        @Override
        public final Builder prefixListId(String prefixListId) {
            this.prefixListId = prefixListId;
            return this;
        }

        public final void setPrefixListId(String prefixListId) {
            this.prefixListId = prefixListId;
        }

        public final ReferencedSecurityGroup.Builder getReferencedGroupInfo() {
            return this.referencedGroupInfo != null ? this.referencedGroupInfo.toBuilder() : null;
        }

        @Override
        public final Builder referencedGroupInfo(ReferencedSecurityGroup referencedGroupInfo) {
            this.referencedGroupInfo = referencedGroupInfo;
            return this;
        }

        public final void setReferencedGroupInfo(ReferencedSecurityGroup.BuilderImpl referencedGroupInfo) {
            this.referencedGroupInfo = referencedGroupInfo != null ? referencedGroupInfo.build() : null;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public SecurityGroupRule build() {
            return new SecurityGroupRule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SecurityGroupRule> {
        public Builder securityGroupRuleId(String var1);

        public Builder groupId(String var1);

        public Builder groupOwnerId(String var1);

        public Builder isEgress(Boolean var1);

        public Builder ipProtocol(String var1);

        public Builder fromPort(Integer var1);

        public Builder toPort(Integer var1);

        public Builder cidrIpv4(String var1);

        public Builder cidrIpv6(String var1);

        public Builder prefixListId(String var1);

        public Builder referencedGroupInfo(ReferencedSecurityGroup var1);

        default public Builder referencedGroupInfo(Consumer<ReferencedSecurityGroup.Builder> referencedGroupInfo) {
            return this.referencedGroupInfo((ReferencedSecurityGroup)((ReferencedSecurityGroup.Builder)ReferencedSecurityGroup.builder().applyMutation(referencedGroupInfo)).build());
        }

        public Builder description(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

