/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.services.ec2.model.FilterListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeHostReservationOfferingsRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, DescribeHostReservationOfferingsRequest> {
    private static final SdkField<List<Filter>> FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Filter").getter(DescribeHostReservationOfferingsRequest.getter(DescribeHostReservationOfferingsRequest::filter)).setter(DescribeHostReservationOfferingsRequest.setter(Builder::filter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").unmarshallLocationName("Filter").build(), ListTrait.builder().memberLocationName("Filter").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Filter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").unmarshallLocationName("Filter").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxDuration").getter(DescribeHostReservationOfferingsRequest.getter(DescribeHostReservationOfferingsRequest::maxDuration)).setter(DescribeHostReservationOfferingsRequest.setter(Builder::maxDuration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxDuration").unmarshallLocationName("MaxDuration").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(DescribeHostReservationOfferingsRequest.getter(DescribeHostReservationOfferingsRequest::maxResults)).setter(DescribeHostReservationOfferingsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").unmarshallLocationName("MaxResults").build()}).build();
    private static final SdkField<Integer> MIN_DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MinDuration").getter(DescribeHostReservationOfferingsRequest.getter(DescribeHostReservationOfferingsRequest::minDuration)).setter(DescribeHostReservationOfferingsRequest.setter(Builder::minDuration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinDuration").unmarshallLocationName("MinDuration").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeHostReservationOfferingsRequest.getter(DescribeHostReservationOfferingsRequest::nextToken)).setter(DescribeHostReservationOfferingsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("NextToken").build()}).build();
    private static final SdkField<String> OFFERING_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OfferingId").getter(DescribeHostReservationOfferingsRequest.getter(DescribeHostReservationOfferingsRequest::offeringId)).setter(DescribeHostReservationOfferingsRequest.setter(Builder::offeringId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OfferingId").unmarshallLocationName("OfferingId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_FIELD, MAX_DURATION_FIELD, MAX_RESULTS_FIELD, MIN_DURATION_FIELD, NEXT_TOKEN_FIELD, OFFERING_ID_FIELD));
    private final List<Filter> filter;
    private final Integer maxDuration;
    private final Integer maxResults;
    private final Integer minDuration;
    private final String nextToken;
    private final String offeringId;

    private DescribeHostReservationOfferingsRequest(BuilderImpl builder) {
        super(builder);
        this.filter = builder.filter;
        this.maxDuration = builder.maxDuration;
        this.maxResults = builder.maxResults;
        this.minDuration = builder.minDuration;
        this.nextToken = builder.nextToken;
        this.offeringId = builder.offeringId;
    }

    public final boolean hasFilter() {
        return this.filter != null && !(this.filter instanceof SdkAutoConstructList);
    }

    public final List<Filter> filter() {
        return this.filter;
    }

    public final Integer maxDuration() {
        return this.maxDuration;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final Integer minDuration() {
        return this.minDuration;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final String offeringId() {
        return this.offeringId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilter() ? this.filter() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxDuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.minDuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.offeringId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeHostReservationOfferingsRequest)) {
            return false;
        }
        DescribeHostReservationOfferingsRequest other = (DescribeHostReservationOfferingsRequest)((Object)obj);
        return this.hasFilter() == other.hasFilter() && Objects.equals(this.filter(), other.filter()) && Objects.equals(this.maxDuration(), other.maxDuration()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.minDuration(), other.minDuration()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.offeringId(), other.offeringId());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeHostReservationOfferingsRequest").add("Filter", this.hasFilter() ? this.filter() : null).add("MaxDuration", (Object)this.maxDuration()).add("MaxResults", (Object)this.maxResults()).add("MinDuration", (Object)this.minDuration()).add("NextToken", (Object)this.nextToken()).add("OfferingId", (Object)this.offeringId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Filter": {
                return Optional.ofNullable(clazz.cast(this.filter()));
            }
            case "MaxDuration": {
                return Optional.ofNullable(clazz.cast(this.maxDuration()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "MinDuration": {
                return Optional.ofNullable(clazz.cast(this.minDuration()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "OfferingId": {
                return Optional.ofNullable(clazz.cast(this.offeringId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeHostReservationOfferingsRequest, T> g) {
        return obj -> g.apply((DescribeHostReservationOfferingsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private List<Filter> filter = DefaultSdkAutoConstructList.getInstance();
        private Integer maxDuration;
        private Integer maxResults;
        private Integer minDuration;
        private String nextToken;
        private String offeringId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeHostReservationOfferingsRequest model) {
            super(model);
            this.filter(model.filter);
            this.maxDuration(model.maxDuration);
            this.maxResults(model.maxResults);
            this.minDuration(model.minDuration);
            this.nextToken(model.nextToken);
            this.offeringId(model.offeringId);
        }

        public final List<Filter.Builder> getFilter() {
            List<Filter.Builder> result = FilterListCopier.copyToBuilder(this.filter);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder filter(Collection<Filter> filter) {
            this.filter = FilterListCopier.copy(filter);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filter(Filter ... filter) {
            this.filter(Arrays.asList(filter));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filter(Consumer<Filter.Builder> ... filter) {
            this.filter(Stream.of(filter).map(c -> (Filter)((Filter.Builder)Filter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilter(Collection<Filter.BuilderImpl> filter) {
            this.filter = FilterListCopier.copyFromBuilder(filter);
        }

        public final Integer getMaxDuration() {
            return this.maxDuration;
        }

        @Override
        public final Builder maxDuration(Integer maxDuration) {
            this.maxDuration = maxDuration;
            return this;
        }

        public final void setMaxDuration(Integer maxDuration) {
            this.maxDuration = maxDuration;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final Integer getMinDuration() {
            return this.minDuration;
        }

        @Override
        public final Builder minDuration(Integer minDuration) {
            this.minDuration = minDuration;
            return this;
        }

        public final void setMinDuration(Integer minDuration) {
            this.minDuration = minDuration;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final String getOfferingId() {
            return this.offeringId;
        }

        @Override
        public final Builder offeringId(String offeringId) {
            this.offeringId = offeringId;
            return this;
        }

        public final void setOfferingId(String offeringId) {
            this.offeringId = offeringId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeHostReservationOfferingsRequest build() {
            return new DescribeHostReservationOfferingsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeHostReservationOfferingsRequest> {
        public Builder filter(Collection<Filter> var1);

        public Builder filter(Filter ... var1);

        public Builder filter(Consumer<Filter.Builder> ... var1);

        public Builder maxDuration(Integer var1);

        public Builder maxResults(Integer var1);

        public Builder minDuration(Integer var1);

        public Builder nextToken(String var1);

        public Builder offeringId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

