/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.FpgaImage;
import software.amazon.awssdk.services.ec2.model.FpgaImageListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeFpgaImagesResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeFpgaImagesResponse> {
    private static final SdkField<List<FpgaImage>> FPGA_IMAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FpgaImages").getter(DescribeFpgaImagesResponse.getter(DescribeFpgaImagesResponse::fpgaImages)).setter(DescribeFpgaImagesResponse.setter(Builder::fpgaImages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FpgaImageSet").unmarshallLocationName("fpgaImageSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FpgaImage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeFpgaImagesResponse.getter(DescribeFpgaImagesResponse::nextToken)).setter(DescribeFpgaImagesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FPGA_IMAGES_FIELD, NEXT_TOKEN_FIELD));
    private final List<FpgaImage> fpgaImages;
    private final String nextToken;

    private DescribeFpgaImagesResponse(BuilderImpl builder) {
        super(builder);
        this.fpgaImages = builder.fpgaImages;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasFpgaImages() {
        return this.fpgaImages != null && !(this.fpgaImages instanceof SdkAutoConstructList);
    }

    public final List<FpgaImage> fpgaImages() {
        return this.fpgaImages;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFpgaImages() ? this.fpgaImages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFpgaImagesResponse)) {
            return false;
        }
        DescribeFpgaImagesResponse other = (DescribeFpgaImagesResponse)((Object)obj);
        return this.hasFpgaImages() == other.hasFpgaImages() && Objects.equals(this.fpgaImages(), other.fpgaImages()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeFpgaImagesResponse").add("FpgaImages", this.hasFpgaImages() ? this.fpgaImages() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FpgaImages": {
                return Optional.ofNullable(clazz.cast(this.fpgaImages()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeFpgaImagesResponse, T> g) {
        return obj -> g.apply((DescribeFpgaImagesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<FpgaImage> fpgaImages = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFpgaImagesResponse model) {
            super(model);
            this.fpgaImages(model.fpgaImages);
            this.nextToken(model.nextToken);
        }

        public final Collection<FpgaImage.Builder> getFpgaImages() {
            if (this.fpgaImages instanceof SdkAutoConstructList) {
                return null;
            }
            return this.fpgaImages != null ? (Collection)this.fpgaImages.stream().map(FpgaImage::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder fpgaImages(Collection<FpgaImage> fpgaImages) {
            this.fpgaImages = FpgaImageListCopier.copy(fpgaImages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fpgaImages(FpgaImage ... fpgaImages) {
            this.fpgaImages(Arrays.asList(fpgaImages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fpgaImages(Consumer<FpgaImage.Builder> ... fpgaImages) {
            this.fpgaImages(Stream.of(fpgaImages).map(c -> (FpgaImage)((FpgaImage.Builder)FpgaImage.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFpgaImages(Collection<FpgaImage.BuilderImpl> fpgaImages) {
            this.fpgaImages = FpgaImageListCopier.copyFromBuilder(fpgaImages);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeFpgaImagesResponse build() {
            return new DescribeFpgaImagesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeFpgaImagesResponse> {
        public Builder fpgaImages(Collection<FpgaImage> var1);

        public Builder fpgaImages(FpgaImage ... var1);

        public Builder fpgaImages(Consumer<FpgaImage.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

