/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.SubnetIpv6CidrBlockAssociation;
import software.amazon.awssdk.services.ec2.model.SubnetIpv6CidrBlockAssociationSetCopier;
import software.amazon.awssdk.services.ec2.model.SubnetState;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Subnet
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Subnet> {
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZone").getter(Subnet.getter(Subnet::availabilityZone)).setter(Subnet.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").unmarshallLocationName("availabilityZone").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZoneId").getter(Subnet.getter(Subnet::availabilityZoneId)).setter(Subnet.setter(Builder::availabilityZoneId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZoneId").unmarshallLocationName("availabilityZoneId").build()}).build();
    private static final SdkField<Integer> AVAILABLE_IP_ADDRESS_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("AvailableIpAddressCount").getter(Subnet.getter(Subnet::availableIpAddressCount)).setter(Subnet.setter(Builder::availableIpAddressCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailableIpAddressCount").unmarshallLocationName("availableIpAddressCount").build()}).build();
    private static final SdkField<String> CIDR_BLOCK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CidrBlock").getter(Subnet.getter(Subnet::cidrBlock)).setter(Subnet.setter(Builder::cidrBlock)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CidrBlock").unmarshallLocationName("cidrBlock").build()}).build();
    private static final SdkField<Boolean> DEFAULT_FOR_AZ_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DefaultForAz").getter(Subnet.getter(Subnet::defaultForAz)).setter(Subnet.setter(Builder::defaultForAz)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultForAz").unmarshallLocationName("defaultForAz").build()}).build();
    private static final SdkField<Boolean> MAP_PUBLIC_IP_ON_LAUNCH_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("MapPublicIpOnLaunch").getter(Subnet.getter(Subnet::mapPublicIpOnLaunch)).setter(Subnet.setter(Builder::mapPublicIpOnLaunch)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MapPublicIpOnLaunch").unmarshallLocationName("mapPublicIpOnLaunch").build()}).build();
    private static final SdkField<Boolean> MAP_CUSTOMER_OWNED_IP_ON_LAUNCH_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("MapCustomerOwnedIpOnLaunch").getter(Subnet.getter(Subnet::mapCustomerOwnedIpOnLaunch)).setter(Subnet.setter(Builder::mapCustomerOwnedIpOnLaunch)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MapCustomerOwnedIpOnLaunch").unmarshallLocationName("mapCustomerOwnedIpOnLaunch").build()}).build();
    private static final SdkField<String> CUSTOMER_OWNED_IPV4_POOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CustomerOwnedIpv4Pool").getter(Subnet.getter(Subnet::customerOwnedIpv4Pool)).setter(Subnet.setter(Builder::customerOwnedIpv4Pool)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerOwnedIpv4Pool").unmarshallLocationName("customerOwnedIpv4Pool").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(Subnet.getter(Subnet::stateAsString)).setter(Subnet.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").unmarshallLocationName("state").build()}).build();
    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubnetId").getter(Subnet.getter(Subnet::subnetId)).setter(Subnet.setter(Builder::subnetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").unmarshallLocationName("subnetId").build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcId").getter(Subnet.getter(Subnet::vpcId)).setter(Subnet.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").unmarshallLocationName("vpcId").build()}).build();
    private static final SdkField<String> OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnerId").getter(Subnet.getter(Subnet::ownerId)).setter(Subnet.setter(Builder::ownerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId").unmarshallLocationName("ownerId").build()}).build();
    private static final SdkField<Boolean> ASSIGN_IPV6_ADDRESS_ON_CREATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AssignIpv6AddressOnCreation").getter(Subnet.getter(Subnet::assignIpv6AddressOnCreation)).setter(Subnet.setter(Builder::assignIpv6AddressOnCreation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssignIpv6AddressOnCreation").unmarshallLocationName("assignIpv6AddressOnCreation").build()}).build();
    private static final SdkField<List<SubnetIpv6CidrBlockAssociation>> IPV6_CIDR_BLOCK_ASSOCIATION_SET_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Ipv6CidrBlockAssociationSet").getter(Subnet.getter(Subnet::ipv6CidrBlockAssociationSet)).setter(Subnet.setter(Builder::ipv6CidrBlockAssociationSet)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6CidrBlockAssociationSet").unmarshallLocationName("ipv6CidrBlockAssociationSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SubnetIpv6CidrBlockAssociation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(Subnet.getter(Subnet::tags)).setter(Subnet.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet").unmarshallLocationName("tagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> SUBNET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubnetArn").getter(Subnet.getter(Subnet::subnetArn)).setter(Subnet.setter(Builder::subnetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetArn").unmarshallLocationName("subnetArn").build()}).build();
    private static final SdkField<String> OUTPOST_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutpostArn").getter(Subnet.getter(Subnet::outpostArn)).setter(Subnet.setter(Builder::outpostArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutpostArn").unmarshallLocationName("outpostArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAILABILITY_ZONE_FIELD, AVAILABILITY_ZONE_ID_FIELD, AVAILABLE_IP_ADDRESS_COUNT_FIELD, CIDR_BLOCK_FIELD, DEFAULT_FOR_AZ_FIELD, MAP_PUBLIC_IP_ON_LAUNCH_FIELD, MAP_CUSTOMER_OWNED_IP_ON_LAUNCH_FIELD, CUSTOMER_OWNED_IPV4_POOL_FIELD, STATE_FIELD, SUBNET_ID_FIELD, VPC_ID_FIELD, OWNER_ID_FIELD, ASSIGN_IPV6_ADDRESS_ON_CREATION_FIELD, IPV6_CIDR_BLOCK_ASSOCIATION_SET_FIELD, TAGS_FIELD, SUBNET_ARN_FIELD, OUTPOST_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String availabilityZone;
    private final String availabilityZoneId;
    private final Integer availableIpAddressCount;
    private final String cidrBlock;
    private final Boolean defaultForAz;
    private final Boolean mapPublicIpOnLaunch;
    private final Boolean mapCustomerOwnedIpOnLaunch;
    private final String customerOwnedIpv4Pool;
    private final String state;
    private final String subnetId;
    private final String vpcId;
    private final String ownerId;
    private final Boolean assignIpv6AddressOnCreation;
    private final List<SubnetIpv6CidrBlockAssociation> ipv6CidrBlockAssociationSet;
    private final List<Tag> tags;
    private final String subnetArn;
    private final String outpostArn;

    private Subnet(BuilderImpl builder) {
        this.availabilityZone = builder.availabilityZone;
        this.availabilityZoneId = builder.availabilityZoneId;
        this.availableIpAddressCount = builder.availableIpAddressCount;
        this.cidrBlock = builder.cidrBlock;
        this.defaultForAz = builder.defaultForAz;
        this.mapPublicIpOnLaunch = builder.mapPublicIpOnLaunch;
        this.mapCustomerOwnedIpOnLaunch = builder.mapCustomerOwnedIpOnLaunch;
        this.customerOwnedIpv4Pool = builder.customerOwnedIpv4Pool;
        this.state = builder.state;
        this.subnetId = builder.subnetId;
        this.vpcId = builder.vpcId;
        this.ownerId = builder.ownerId;
        this.assignIpv6AddressOnCreation = builder.assignIpv6AddressOnCreation;
        this.ipv6CidrBlockAssociationSet = builder.ipv6CidrBlockAssociationSet;
        this.tags = builder.tags;
        this.subnetArn = builder.subnetArn;
        this.outpostArn = builder.outpostArn;
    }

    public final String availabilityZone() {
        return this.availabilityZone;
    }

    public final String availabilityZoneId() {
        return this.availabilityZoneId;
    }

    public final Integer availableIpAddressCount() {
        return this.availableIpAddressCount;
    }

    public final String cidrBlock() {
        return this.cidrBlock;
    }

    public final Boolean defaultForAz() {
        return this.defaultForAz;
    }

    public final Boolean mapPublicIpOnLaunch() {
        return this.mapPublicIpOnLaunch;
    }

    public final Boolean mapCustomerOwnedIpOnLaunch() {
        return this.mapCustomerOwnedIpOnLaunch;
    }

    public final String customerOwnedIpv4Pool() {
        return this.customerOwnedIpv4Pool;
    }

    public final SubnetState state() {
        return SubnetState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final String subnetId() {
        return this.subnetId;
    }

    public final String vpcId() {
        return this.vpcId;
    }

    public final String ownerId() {
        return this.ownerId;
    }

    public final Boolean assignIpv6AddressOnCreation() {
        return this.assignIpv6AddressOnCreation;
    }

    public final boolean hasIpv6CidrBlockAssociationSet() {
        return this.ipv6CidrBlockAssociationSet != null && !(this.ipv6CidrBlockAssociationSet instanceof SdkAutoConstructList);
    }

    public final List<SubnetIpv6CidrBlockAssociation> ipv6CidrBlockAssociationSet() {
        return this.ipv6CidrBlockAssociationSet;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final String subnetArn() {
        return this.subnetArn;
    }

    public final String outpostArn() {
        return this.outpostArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(this.availableIpAddressCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.cidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultForAz());
        hashCode = 31 * hashCode + Objects.hashCode(this.mapPublicIpOnLaunch());
        hashCode = 31 * hashCode + Objects.hashCode(this.mapCustomerOwnedIpOnLaunch());
        hashCode = 31 * hashCode + Objects.hashCode(this.customerOwnedIpv4Pool());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.assignIpv6AddressOnCreation());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIpv6CidrBlockAssociationSet() ? this.ipv6CidrBlockAssociationSet() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.outpostArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Subnet)) {
            return false;
        }
        Subnet other = (Subnet)obj;
        return Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.availabilityZoneId(), other.availabilityZoneId()) && Objects.equals(this.availableIpAddressCount(), other.availableIpAddressCount()) && Objects.equals(this.cidrBlock(), other.cidrBlock()) && Objects.equals(this.defaultForAz(), other.defaultForAz()) && Objects.equals(this.mapPublicIpOnLaunch(), other.mapPublicIpOnLaunch()) && Objects.equals(this.mapCustomerOwnedIpOnLaunch(), other.mapCustomerOwnedIpOnLaunch()) && Objects.equals(this.customerOwnedIpv4Pool(), other.customerOwnedIpv4Pool()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.subnetId(), other.subnetId()) && Objects.equals(this.vpcId(), other.vpcId()) && Objects.equals(this.ownerId(), other.ownerId()) && Objects.equals(this.assignIpv6AddressOnCreation(), other.assignIpv6AddressOnCreation()) && this.hasIpv6CidrBlockAssociationSet() == other.hasIpv6CidrBlockAssociationSet() && Objects.equals(this.ipv6CidrBlockAssociationSet(), other.ipv6CidrBlockAssociationSet()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.subnetArn(), other.subnetArn()) && Objects.equals(this.outpostArn(), other.outpostArn());
    }

    public final String toString() {
        return ToString.builder((String)"Subnet").add("AvailabilityZone", (Object)this.availabilityZone()).add("AvailabilityZoneId", (Object)this.availabilityZoneId()).add("AvailableIpAddressCount", (Object)this.availableIpAddressCount()).add("CidrBlock", (Object)this.cidrBlock()).add("DefaultForAz", (Object)this.defaultForAz()).add("MapPublicIpOnLaunch", (Object)this.mapPublicIpOnLaunch()).add("MapCustomerOwnedIpOnLaunch", (Object)this.mapCustomerOwnedIpOnLaunch()).add("CustomerOwnedIpv4Pool", (Object)this.customerOwnedIpv4Pool()).add("State", (Object)this.stateAsString()).add("SubnetId", (Object)this.subnetId()).add("VpcId", (Object)this.vpcId()).add("OwnerId", (Object)this.ownerId()).add("AssignIpv6AddressOnCreation", (Object)this.assignIpv6AddressOnCreation()).add("Ipv6CidrBlockAssociationSet", this.hasIpv6CidrBlockAssociationSet() ? this.ipv6CidrBlockAssociationSet() : null).add("Tags", this.hasTags() ? this.tags() : null).add("SubnetArn", (Object)this.subnetArn()).add("OutpostArn", (Object)this.outpostArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "AvailabilityZoneId": {
                return Optional.ofNullable(clazz.cast(this.availabilityZoneId()));
            }
            case "AvailableIpAddressCount": {
                return Optional.ofNullable(clazz.cast(this.availableIpAddressCount()));
            }
            case "CidrBlock": {
                return Optional.ofNullable(clazz.cast(this.cidrBlock()));
            }
            case "DefaultForAz": {
                return Optional.ofNullable(clazz.cast(this.defaultForAz()));
            }
            case "MapPublicIpOnLaunch": {
                return Optional.ofNullable(clazz.cast(this.mapPublicIpOnLaunch()));
            }
            case "MapCustomerOwnedIpOnLaunch": {
                return Optional.ofNullable(clazz.cast(this.mapCustomerOwnedIpOnLaunch()));
            }
            case "CustomerOwnedIpv4Pool": {
                return Optional.ofNullable(clazz.cast(this.customerOwnedIpv4Pool()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "SubnetId": {
                return Optional.ofNullable(clazz.cast(this.subnetId()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
            case "OwnerId": {
                return Optional.ofNullable(clazz.cast(this.ownerId()));
            }
            case "AssignIpv6AddressOnCreation": {
                return Optional.ofNullable(clazz.cast(this.assignIpv6AddressOnCreation()));
            }
            case "Ipv6CidrBlockAssociationSet": {
                return Optional.ofNullable(clazz.cast(this.ipv6CidrBlockAssociationSet()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "SubnetArn": {
                return Optional.ofNullable(clazz.cast(this.subnetArn()));
            }
            case "OutpostArn": {
                return Optional.ofNullable(clazz.cast(this.outpostArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Subnet, T> g) {
        return obj -> g.apply((Subnet)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String availabilityZone;
        private String availabilityZoneId;
        private Integer availableIpAddressCount;
        private String cidrBlock;
        private Boolean defaultForAz;
        private Boolean mapPublicIpOnLaunch;
        private Boolean mapCustomerOwnedIpOnLaunch;
        private String customerOwnedIpv4Pool;
        private String state;
        private String subnetId;
        private String vpcId;
        private String ownerId;
        private Boolean assignIpv6AddressOnCreation;
        private List<SubnetIpv6CidrBlockAssociation> ipv6CidrBlockAssociationSet = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String subnetArn;
        private String outpostArn;

        private BuilderImpl() {
        }

        private BuilderImpl(Subnet model) {
            this.availabilityZone(model.availabilityZone);
            this.availabilityZoneId(model.availabilityZoneId);
            this.availableIpAddressCount(model.availableIpAddressCount);
            this.cidrBlock(model.cidrBlock);
            this.defaultForAz(model.defaultForAz);
            this.mapPublicIpOnLaunch(model.mapPublicIpOnLaunch);
            this.mapCustomerOwnedIpOnLaunch(model.mapCustomerOwnedIpOnLaunch);
            this.customerOwnedIpv4Pool(model.customerOwnedIpv4Pool);
            this.state(model.state);
            this.subnetId(model.subnetId);
            this.vpcId(model.vpcId);
            this.ownerId(model.ownerId);
            this.assignIpv6AddressOnCreation(model.assignIpv6AddressOnCreation);
            this.ipv6CidrBlockAssociationSet(model.ipv6CidrBlockAssociationSet);
            this.tags(model.tags);
            this.subnetArn(model.subnetArn);
            this.outpostArn(model.outpostArn);
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final String getAvailabilityZoneId() {
            return this.availabilityZoneId;
        }

        @Override
        public final Builder availabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
            return this;
        }

        public final void setAvailabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
        }

        public final Integer getAvailableIpAddressCount() {
            return this.availableIpAddressCount;
        }

        @Override
        public final Builder availableIpAddressCount(Integer availableIpAddressCount) {
            this.availableIpAddressCount = availableIpAddressCount;
            return this;
        }

        public final void setAvailableIpAddressCount(Integer availableIpAddressCount) {
            this.availableIpAddressCount = availableIpAddressCount;
        }

        public final String getCidrBlock() {
            return this.cidrBlock;
        }

        @Override
        public final Builder cidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
            return this;
        }

        public final void setCidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
        }

        public final Boolean getDefaultForAz() {
            return this.defaultForAz;
        }

        @Override
        public final Builder defaultForAz(Boolean defaultForAz) {
            this.defaultForAz = defaultForAz;
            return this;
        }

        public final void setDefaultForAz(Boolean defaultForAz) {
            this.defaultForAz = defaultForAz;
        }

        public final Boolean getMapPublicIpOnLaunch() {
            return this.mapPublicIpOnLaunch;
        }

        @Override
        public final Builder mapPublicIpOnLaunch(Boolean mapPublicIpOnLaunch) {
            this.mapPublicIpOnLaunch = mapPublicIpOnLaunch;
            return this;
        }

        public final void setMapPublicIpOnLaunch(Boolean mapPublicIpOnLaunch) {
            this.mapPublicIpOnLaunch = mapPublicIpOnLaunch;
        }

        public final Boolean getMapCustomerOwnedIpOnLaunch() {
            return this.mapCustomerOwnedIpOnLaunch;
        }

        @Override
        public final Builder mapCustomerOwnedIpOnLaunch(Boolean mapCustomerOwnedIpOnLaunch) {
            this.mapCustomerOwnedIpOnLaunch = mapCustomerOwnedIpOnLaunch;
            return this;
        }

        public final void setMapCustomerOwnedIpOnLaunch(Boolean mapCustomerOwnedIpOnLaunch) {
            this.mapCustomerOwnedIpOnLaunch = mapCustomerOwnedIpOnLaunch;
        }

        public final String getCustomerOwnedIpv4Pool() {
            return this.customerOwnedIpv4Pool;
        }

        @Override
        public final Builder customerOwnedIpv4Pool(String customerOwnedIpv4Pool) {
            this.customerOwnedIpv4Pool = customerOwnedIpv4Pool;
            return this;
        }

        public final void setCustomerOwnedIpv4Pool(String customerOwnedIpv4Pool) {
            this.customerOwnedIpv4Pool = customerOwnedIpv4Pool;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(SubnetState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final String getOwnerId() {
            return this.ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        public final Boolean getAssignIpv6AddressOnCreation() {
            return this.assignIpv6AddressOnCreation;
        }

        @Override
        public final Builder assignIpv6AddressOnCreation(Boolean assignIpv6AddressOnCreation) {
            this.assignIpv6AddressOnCreation = assignIpv6AddressOnCreation;
            return this;
        }

        public final void setAssignIpv6AddressOnCreation(Boolean assignIpv6AddressOnCreation) {
            this.assignIpv6AddressOnCreation = assignIpv6AddressOnCreation;
        }

        public final List<SubnetIpv6CidrBlockAssociation.Builder> getIpv6CidrBlockAssociationSet() {
            List<SubnetIpv6CidrBlockAssociation.Builder> result = SubnetIpv6CidrBlockAssociationSetCopier.copyToBuilder(this.ipv6CidrBlockAssociationSet);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder ipv6CidrBlockAssociationSet(Collection<SubnetIpv6CidrBlockAssociation> ipv6CidrBlockAssociationSet) {
            this.ipv6CidrBlockAssociationSet = SubnetIpv6CidrBlockAssociationSetCopier.copy(ipv6CidrBlockAssociationSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6CidrBlockAssociationSet(SubnetIpv6CidrBlockAssociation ... ipv6CidrBlockAssociationSet) {
            this.ipv6CidrBlockAssociationSet(Arrays.asList(ipv6CidrBlockAssociationSet));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6CidrBlockAssociationSet(Consumer<SubnetIpv6CidrBlockAssociation.Builder> ... ipv6CidrBlockAssociationSet) {
            this.ipv6CidrBlockAssociationSet(Stream.of(ipv6CidrBlockAssociationSet).map(c -> (SubnetIpv6CidrBlockAssociation)((SubnetIpv6CidrBlockAssociation.Builder)SubnetIpv6CidrBlockAssociation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setIpv6CidrBlockAssociationSet(Collection<SubnetIpv6CidrBlockAssociation.BuilderImpl> ipv6CidrBlockAssociationSet) {
            this.ipv6CidrBlockAssociationSet = SubnetIpv6CidrBlockAssociationSetCopier.copyFromBuilder(ipv6CidrBlockAssociationSet);
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final String getSubnetArn() {
            return this.subnetArn;
        }

        @Override
        public final Builder subnetArn(String subnetArn) {
            this.subnetArn = subnetArn;
            return this;
        }

        public final void setSubnetArn(String subnetArn) {
            this.subnetArn = subnetArn;
        }

        public final String getOutpostArn() {
            return this.outpostArn;
        }

        @Override
        public final Builder outpostArn(String outpostArn) {
            this.outpostArn = outpostArn;
            return this;
        }

        public final void setOutpostArn(String outpostArn) {
            this.outpostArn = outpostArn;
        }

        public Subnet build() {
            return new Subnet(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Subnet> {
        public Builder availabilityZone(String var1);

        public Builder availabilityZoneId(String var1);

        public Builder availableIpAddressCount(Integer var1);

        public Builder cidrBlock(String var1);

        public Builder defaultForAz(Boolean var1);

        public Builder mapPublicIpOnLaunch(Boolean var1);

        public Builder mapCustomerOwnedIpOnLaunch(Boolean var1);

        public Builder customerOwnedIpv4Pool(String var1);

        public Builder state(String var1);

        public Builder state(SubnetState var1);

        public Builder subnetId(String var1);

        public Builder vpcId(String var1);

        public Builder ownerId(String var1);

        public Builder assignIpv6AddressOnCreation(Boolean var1);

        public Builder ipv6CidrBlockAssociationSet(Collection<SubnetIpv6CidrBlockAssociation> var1);

        public Builder ipv6CidrBlockAssociationSet(SubnetIpv6CidrBlockAssociation ... var1);

        public Builder ipv6CidrBlockAssociationSet(Consumer<SubnetIpv6CidrBlockAssociation.Builder> ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder subnetArn(String var1);

        public Builder outpostArn(String var1);
    }
}

