/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum SpotAllocationStrategy {
    LOWEST_PRICE("lowest-price"),
    DIVERSIFIED("diversified"),
    CAPACITY_OPTIMIZED("capacity-optimized"),
    CAPACITY_OPTIMIZED_PRIORITIZED("capacity-optimized-prioritized"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private SpotAllocationStrategy(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SpotAllocationStrategy fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(SpotAllocationStrategy.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SpotAllocationStrategy> knownValues() {
        return Stream.of(SpotAllocationStrategy.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

